create or replace package plpdf_util is
-- v2.9.0
---------------------------------------------------------------------------------------------------
function to_str(
  p_num number,
  p_length number
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function is_string(
  p_string varchar2
  ) return boolean;
---------------------------------------------------------------------------------------------------
--v2.3.1
function is_number(
  p_string varchar2
  ) return boolean;
---------------------------------------------------------------------------------------------------
procedure exec_proc(
  p_proc_name varchar2
  );
--v2.9.0
procedure exec_proc5(
  p_proc_name varchar2,
  p_1 varchar2 default null,
  p_2 varchar2 default null,
  p_3 varchar2 default null,
  p_4 varchar2 default null,
  p_5 varchar2 default null
  );
---------------------------------------------------------------------------------------------------
function to_dec(
  p_str in varchar2,
  p_from_base in number default 16
  ) return number;
---------------------------------------------------------------------------------------------------
function to_hex(
  p_dec in number
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function shiftraw(
  p_raw raw,
  p_shift number,
  p_orient varchar2
  ) return raw;
---------------------------------------------------------------------------------------------------
function minusraw(
  p_1 raw,
  p_2 raw
  ) return raw;
---------------------------------------------------------------------------------------------------
function raw_bitand(
  p_1 raw,
  p_2 raw
  ) return raw;
---------------------------------------------------------------------------------------------------
function raw_bitor(
  p_1 raw,
  p_2 raw
  ) return raw;
---------------------------------------------------------------------------------------------------
function raw_bitxor(
  p_1 raw,
  p_2 raw
  ) return raw;
---------------------------------------------------------------------------------------------------
function bitor(
  p_dec1 number,
  p_dec2 number
  ) return number;
---------------------------------------------------------------------------------------------------
function bitxor(
  p_dec1 number,
  p_dec2 number
  ) return number;
---------------------------------------------------------------------------------------------------
function substr_count(
  p_txt varchar2,
  p_char varchar2
  ) return number;
---------------------------------------------------------------------------------------------------
-- mod: v1.1.6
function set_color(
  p_r number,
  p_g number,
  p_b number
  ) return plpdf_type.t_color;
---------------------------------------------------------------------------------------------------
-- mod: v1.1.7
function set_pageformat(
  p_w number,
  p_h number
  ) return plpdf_type.t_pageformat;
---------------------------------------------------------------------------------------------------
-- mod: v1.4.0
function color_is_notnull(
  p_color plpdf_type.t_color
  ) return boolean;
---------------------------------------------------------------------------------------------------
-- mod: v2.6.0
function color_is_null(p_color plpdf_type.t_color)
  return boolean;
---------------------------------------------------------------------------------------------------
-- mod: v1.4.0
function RemoveCRLF(
  p_text varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
-- mod: v1.4.0
function explode(
  p_text varchar2,
  p_sep varchar2 default ' '
  ) return plpdf_type.t_text_array;
---------------------------------------------------------------------------------------------------
-- mod: v1.5.1
function to_bin(
  p_dec in number
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v2.1.0
function boolean2switch(
  p_boolean boolean
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v2.1.1
function shiftleft(
  p_number number,
  p_pos number
  ) return number;
---------------------------------------------------------------------------------------------------
--v2.1.1
function shiftright(
  p_number number,
  p_pos number
  ) return number;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xbitand(
  p_left number,
  p_right number
  ) return number;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xbitor(
  p_left number,
  p_right number
  ) return number;
---------------------------------------------------------------------------------------------------
--v2.1.1
function reverse(
  p_string_in varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xshiftright(
  p_int pls_integer,
  p_shift pls_integer
  ) return pls_integer;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xcomp2_2byte(
  p_int pls_integer
  ) return pls_integer;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xshiftleft(
  p_int pls_integer,
  p_shift pls_integer
  ) return pls_integer;
---------------------------------------------------------------------------------------------------
--v2.1.1
function xcomp2_1byte(
  p_int pls_integer
  ) return pls_integer;
---------------------------------------------------------------------------------------------------
-- v2.3.0
function colors_equal(
  p_color1 plpdf_type.t_color,
  p_color2 plpdf_type.t_color
  ) return boolean;
-- v2.6.0
function color_nvl(
  p_color plpdf_type.t_color,
  p_nvl_color plpdf_type.t_color default null
  ) return plpdf_type.t_color;
---------------------------------------------------------------------------------------------------
--v2.4.0
function GetColorString(
  p_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetLinewidthString(
  p_linewidth number
  ) return varchar2;
--v2.4.0
function GetEllipseString(
  p_x number,
  p_y number,
  p_rx number,
  p_ry number,
  p_style varchar2 default 'D',
  p_h number,
  p_linewidth number,
  p_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetLineString(
  p_x1 number,
  p_y1 number,
  p_x2 number,
  p_y2 number,
  p_h number,
  p_linewidth number,
  p_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetRectString(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_style varchar2 default null,
  p_box_h number,
  p_linewidth number,
  p_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetRGBArrayString(
  p_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetRectArrayString(
  p_1 number,
  p_2 number,
  p_3 number,
  p_4 number
  ) return varchar2;
--v2.4.0
function GetRBOffStream(
  p_height number,
  p_fill_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetRBOnStream(
  p_height number,
  p_fill_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetCBOffStream(
  p_height number,
  p_fill_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function GetCBYesStream(
  p_height number,
  p_fill_color plpdf_type.t_color
  ) return varchar2;
--v2.4.0
function CurrFontIsJ( -- Japanese
  p_fontname varchar2
  ) return boolean;
--v2.4.0
function CurrFontIsCK( -- Chinese, Korean
  p_fontname varchar2
  ) return boolean;
--v2.4.0
function GetQuadding(
  p_justification varchar2
  ) return number;
--v2.4.0
function GetSubmitformFlags(
  p_IncludeNoValueFields boolean default false,
  p_ExportFormat boolean default false,
  p_GetMethod boolean default false,
  p_SubmitCoordinates boolean default false
  ) return number;
--v2.4.0
function Acroform_CrFlag(
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_multiline boolean default false,
  p_password boolean default false,
  p_NoToggleToOff boolean default false,
  p_radiobutton boolean default false,
  p_pushbutton boolean default false,
  p_combo boolean default false,
  p_edit boolean default false,
  p_sort boolean default false
  ) return number;
--v2.4.0
function Annot_CrFlag(
  p_print boolean default false
  ) return number;

--v2.6.0
/* Escape sequences change to corresponding ASCII/UNICODE chars */
function escape_resolver(
  p_txt varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
--v2.7.0
function page2type(
  p_pageformat varchar2
  ) return plpdf_type.t_pageformat;
--
function unit2factor(
  p_unit varchar2
  ) return number;
--
function rawescape(
  p_raw raw
  ) return raw;
--
function md5raw(
  p_string raw
  ) return raw;
--
function objectkey(
  p_encryption_key raw,
  p_n number
  ) return raw;
--
function RC4crypto(
  p_key raw,
  p_text blob )
  return blob;
--
function getCW(
  p_cw /*in out nocopy*/ plpdf_type.t_cw, --v2.9.0
  p_num number
  ) return number;
--
function CharIsSep(
  p_c varchar2,
  p_fonttype varchar2,
  p_fontname varchar2
  ) return boolean;
--
function GetCharLength(
  p_c varchar2,
  p_cw /*in out nocopy*/ Plpdf_Type.t_cw, --v2.9.0
  p_fonttype varchar2,
  p_fontname varchar2
  ) return number;
--
--v2.1.0
function JSline(
  p_js varchar2
  ) return varchar2;
--
end plpdf_util;
/

