create or replace package plpdf_type is
--v2.8.0

--v2.6.0
subtype v2max is varchar2(32767 char);
--v2.7.0
subtype v2long is varchar2(4000 char);
subtype v2avg is varchar2(255 char);
--v2.8.0
subtype v2one is varchar2(1 char);
--
--plsql tables
--v2.8.0
type t_v2avgs is table of v2avg index by pls_integer;
type t_v2longs is table of v2long index by pls_integer;
type t_numbers is table of number index by pls_integer;
type t_blobs is table of blob index by pls_integer;
type t_booleans is table of boolean index by pls_integer;
--
---------------------------------------------------------------------------------------------------
type t_row_widths is table of number index by pls_integer;
type t_row_aligns is table of varchar2(10 char) index by pls_integer;
--v2.7.0
type t_row_datas is table of v2long index by pls_integer;
type t_row_maxlines is table of number index by pls_integer;
type t_row_borders is table of varchar2(10 char) index by pls_integer;
type t_row_styles is table of varchar2(10 char) index by pls_integer;
--v2.7.0
type t_row_links is table of v2avg index by pls_integer;

--v2.7.0
type t_row_font is record (
  family v2avg,
  style varchar2(3 char),
  fsize number
  );
--v1.7.0
type t_row_fonts is table of t_row_font index by pls_integer;
---------------------------------------------------------------------------------------------------
--v1.1.8
type t_cw is table of number index by pls_integer;
type t_fontbbox is record (
  v1 number,
  v2 number,
  v3 number,
  v4 number
  );

type t_fd is record (
  ascent number,
  descent number,
  capheight number,
  flags number,
  fontbbox t_fontbbox,
  italicangle number,
  stemv number,
  missingwidth number
  );

--v2.7.0
type t_addfont is record (
  name v2avg,
  type v2avg,
  desc1 t_fd,
  up v2avg,
  ut v2avg,
  cw t_cw,
  enc v2avg,
  file v2avg,
  diff v2long,
  file_data blob,
  originalsize number,
  ctg v2avg,
  ctg_data blob,
  tounicode_data blob
  );
---------------------------------------------------------------------------------------------------
--v2.7.0
type t_charwidths is table of t_cw index by v2avg;
---------------------------------------------------------------------------------------------------
--v2.7.0
type t_imageprops is record (
  contentformat v2avg,
  mimetype v2avg,
  width number,
  height number
  );
---------------------------------------------------------------------------------------------------
--v1.1.6
type t_color is record (
  r number,
  g number,
  b number
  );
---------------------------------------------------------------------------------------------------
--v1.1.7
type t_point is record (
  x number,
  y number
  );
---------------------------------------------------------------------------------------------------
--v1.1.7
type t_points is table of t_point index by pls_integer;
---------------------------------------------------------------------------------------------------
--v1.1.7
type t_pageformat is record (
  w number,
  h number
  );
---------------------------------------------------------------------------------------------------
--v2.0.0
type t_trns is table of number index by pls_integer;

-- parsed image
--v2.7.0
type t_pdfimage is record(
  name             v2avg,
  type             v2avg,
  subtype          v2avg,
  width            pls_integer,
  height           pls_integer,
  mask             v2avg,
  length           pls_integer,
  bitspercomponent pls_integer,
  filter           v2avg,
  decodeparms      v2avg,
  colorspace       v2max,
  decode           v2avg,
  stream_data      blob,
  dpiX             pls_integer, --v2.8.0
  dpiY             pls_integer  --v2.8.0
  );

--v2.1.1
type tr_image_info is record (
  i pls_integer,
  n pls_integer,
  img t_pdfimage
  );
---------------------------------------------------------------------------------------------------
--v2.7.0
type tr_toc is record (
  text v2avg, -- label text
  level_num number, -- level
  y_pos number, -- Y position in the page
  link_id number, -- link id
  pagenum number, -- internal page number
  calc_pagenum number -- calculated page number
  );
type t_toc is table of tr_toc index by pls_integer;
---------------------------------------------------------------------------------------------------
--v1.4.0
type t_row_filles is table of t_color index by pls_integer;
---------------------------------------------------------------------------------------------------
--v2.7.0
-- Template
type t_text_array is table of v2avg index by pls_integer;

type t_obj_ref is record (obj number, gen number);

type t_d_obj_refs is table of t_obj_ref index by pls_integer;

--v2.7.0
type t_obj_val is record (
  id number,
  parent_id number,
  val_type varchar2(10 char), -- HEX, BOOLEAN, NUMBER, DICT, TEXT, OBJREF, NAME
  val_store varchar2(1 char), -- C: char, R: raw, B: blob
  val_char  v2max,
  val_raw raw(32000),
  val_blob blob
  );

type t_obj_vals is table of t_obj_val index by pls_integer;

type t_obj_vals_g is table of t_obj_vals index by pls_integer;

type t_obj_vals_i is table of t_obj_vals_g index by pls_integer;

--v2.7.0
type tr_tpl_data is record (
    stream_filter v2avg,
    stream_blob blob,
    box_char v2avg,
    res number,
    stream_length number,
    x number,
    y number,
    w number,
    h number ,
    res_obj_obj number,
    res_obj_gen number,
    res_obj_id number,
    d_obj_refs t_d_obj_refs,
    obj_vals t_obj_vals_i
    );
---------------------------------------------------------------------------------------------------
--v2.7.0
type t_opt_array is table of v2avg index by pls_integer;

--v2.7.0
type t_radiobutton is record (
  value v2avg,
  label v2avg,
  x number,
  y number
  );

type t_radiobutton_array is table of t_radiobutton index by pls_integer;
---------------------------------------------------------------------------------------------------
--v2.7.0
type t_opt_val is record ( -- a value in a value set (radiobutton, choice)
  value v2long, -- original value
  value_conv v2long -- converted value if original is hexadecimal
  );

type t_opt_vals is table of t_opt_val index by pls_integer; -- values of a value set

--v2.7.0
  type t_form_field is record ( -- properties of a field
    obj number, -- PDF object ID (for internal use)
    gen number, -- PDF object generation (for internal use)
    parent_obj number, -- parant object ID (for internal use)
    parent_gen number, -- parent object generation (for internal use)
    name v2avg, -- name of object
    field_subtype varchar2(20 char), -- type of field (text, radiobutton, checkbox, choice, pushbutton)
    value_type varchar2(10 char), -- type of value implementation (HEX, BOOLEAN, NUMBER, DICT, TEXT, OBJREF, NAME) (for internal use)
    value_char v2long, -- value of field
    value_conv v2long, -- if value_type = 'HEX' then converted to text
    value_exist boolean, -- does field have a value?
    tx_maxlen number, -- if field_subtype='text' then maximum length of field
    read_only boolean, -- is field read only?
    required boolean, -- is field required
    flag number, -- flag of field (for internal use)
    opt_vals t_opt_vals -- value set of field
    );

   type t_form_fields is table of t_form_field index by pls_integer; -- fields of a PDF
---------------------------------------------------------------------------------------------------
--v2.7.0
-- prepared form
  type t_prepform_obj is record (
    obj number,
    gen number,
    field_name v2avg,
    field_subtype varchar2(20 char),
    value_type varchar2(10 char),
    orig_value v2max,
    orig_read_only boolean,
    new_value v2max,
    new_read_only boolean,
    orig_flag number,
    value_ref number,
    flag_ref number
    );

  type t_prepform_objs is table of t_prepform_obj index by pls_integer;

  type t_prepform_xref is table of number index by pls_integer;

  type t_prepform is record (
    pdf_blob blob,
    last_obj_end number,
    xref t_prepform_xref,
    objs t_prepform_objs,
    root_ref t_obj_ref,
    info_ref t_obj_ref
    );
---------------------------------------------------------------------------------------------------
--v2.7.0
-- font properties by fontkey
type t_font_info is record (
  font_type v2avg,
  font_name v2avg,
  cw t_cw
  );
---------------------------------------------------------------------------------------------------
--v2.7.0
type t_text_line is record(
  text v2long,
  text_width number
  );

type t_text_lines is table of t_text_line index by pls_integer;
---------------------------------------------------------------------------------------------------
--v2.3.0
type t_ttfsubset_list is table of pls_integer index by pls_integer;
---------------------------------------------------------------------------------------------------
--v2.6.0
-- Line Dash Pattern
 type t_line_style is record (
   line number,
   noline number
   );
---------------------------------------------------------------------------------------------------
end;
/

