create or replace package plpdf_row_print is
/**
 <config>
  <pck-name>PL/PDF Row Print</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v2.9.0</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>Types</h1>
*/

/**
 <name>t_cell</name>
 <type>record</type>
 <desc>Contains all properties of the cells.</desc>
 <version>v2.3.0</version>
 <fields>
  <field>
   <field-def>width number</field-def>
   <field-desc>Cell width, default: null: minimum cell width.</field-desc>
  </field>
  <field>
   <field-def>height number</field-def>
   <field-desc>Cell height, default: null: minimum cell height.</field-desc>
  </field>
  <field>
   <field-def>text varchar2</field-def>
   <field-desc>Text, required.</field-desc>
  </field>
  <field>
   <field-def>border varchar2</field-def>
   <field-desc>Border, default: null: no border.</field-desc>
  </field>
  <field>
   <field-def>border_color plpdf_type.t_color</field-def>
   <field-desc>Border color, default: null: current line color.</field-desc>
   </field>
  <field>
   <field-def>border_width number</field-def>
   <field-desc>Border width, default: null: curent line width.</field-desc>
  </field>
  <field>
   <field-def>align varchar2</field-def>
   <field-desc>Alignment, default: null: 'L'.</field-desc>
  </field>
  <field>
   <field-def>vert_align_line varchar2</field-def>
   <field-desc>Vertical alignment of text in a line, default: null: 'C'.</field-desc>
  </field>
  <field>
   <field-def>vert_align varchar2</field-def>
   <field-desc>Vertical alignment of text content (lines), default: null: 'T'.</field-desc>
  </field>
  <field>
   <field-def>fill_color plpdf_type.t_color</field-def>
   <field-desc>Filling color, default: null: no fill.</field-desc>
  </field>
  <field>
   <field-def>maxline number</field-def>
   <field-desc>Maximum number of lines, default: null: no max line.</field-desc>
  </field>
  <field>
   <field-def>link varchar2</field-def>
   <field-desc>Link, default: null: no link.</field-desc>
  </field>
  <field>
   <field-def>clipping number</field-def>
   <field-desc>Clipping mode, default: null: no clipping.</field-desc>
  </field>
  <field>
   <field-def>min_height number</field-def>
   <field-desc>Minimum height, default: null: no min height.</field-desc>
  </field>
  <field>
   <field-def>font_family varchar2</field-def>
   <field-desc>Font type, default: null: current font family.</field-desc>
  </field>
  <field>
   <field-def>font_style varchar2</field-def>
   <field-desc>Font style, default: null: current font style.</field-desc>
  </field>
  <field>
   <field-def>font_size number</field-def>
   <field-desc>Font size, default: null: current font size.</field-desc>
  </field>
  <field>
   <field-def>font_color plpdf_type.t_color</field-def>
   <field-desc>Font color, default: null: current font color.</field-desc>
  </field>
  <field>
   <field-def>rotate90 boolean</field-def>
   <field-desc>Rotate cell with 90 degree</field-desc>
  </field>
 </fields>
 <br/>
*/
  type t_cell is record(
    width           number,
    height          number,
    text            varchar2(4000 char),
    border          varchar2(4 char),
    border_color    plpdf_type.t_color,
    border_width    number,
    align           varchar2(1 char),
    vert_align_line varchar2(1 char),
    vert_align      varchar2(1 char),
    fill_color      plpdf_type.t_color,
    maxline         number,
    link            varchar2(255 char),
    clipping        number,
    min_height      number,
    font_family     varchar2(255 char),
    font_style      varchar2(3 char),
    font_size       number,
    font_color      plpdf_type.t_color,
    rotate90        boolean
    );

/**
 <name>t_row</name>
 <type>record</type>
 <desc>Contains all properties of the parsed cells.</desc>
 <version>v2.5.0</version>
*/
  type t_row is table of t_cell index by pls_integer;

/**
 <name>t_pcell</name>
 <type>record</type>
 <desc>Array of t_pcells.</desc>
 <version>v2.5.0</version>
*/
type t_pcell is record(
      cell       t_cell,
      cell_lines plpdf_type.t_text_lines,
      h_1 number --v2.3.0
      );

/**
 <name>t_prow</name>
 <type>record</type>
 <desc>Array of t_pcells.</desc>
 <version>v2.2.1</version>
*/

  type t_prow is table of t_pcell index by pls_integer;
/**
 <newpage/>
 <h1>Procedures</h1>
*/

/**
 <name>SetCellWidth</name>
 <type>Procedure</type>
 <desc>
  Initialize the array of the cells.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure InitRow(p_row in out t_row);
/**
 <name>SetCell</name>
 <type>Procedure</type>
 <desc>
  Sets the cell into the indexed place.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_cell t_cell</param-def>
   <param-desc>Cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCell(p_row        in out t_row,
                    p_cell_index pls_integer,
                    p_cell       t_cell);
/**
 <name>SetCellWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the width of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Width of the cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellWidth(p_row        in out t_row,
                         p_cell_index pls_integer,
                         p_width      number);
/**
 <name>SetCellHeight</name>
 <type>Procedure</type>
 <desc>
  Sets the height of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>Height of the cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellHeight(p_row        in out t_row,
                          p_cell_index pls_integer,
                          p_height     number);
/**
 <name>SetCellText</name>
 <type>Procedure</type>
 <desc>
  Sets the text of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_text varchar2</param-def>
   <param-desc>Text.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellText(p_row        in out t_row,
                        p_cell_index pls_integer,
                        p_text       varchar2);
/**
 <name>SetCellBorder</name>
 <type>Procedure</type>
 <desc>
  Sets the border of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_border varchar2</param-def>
   <param-desc>Border.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellBorder(p_row        in out t_row,
                          p_cell_index pls_integer,
                          p_border     varchar2);
/**
 <name>SetCellBorderColor</name>
 <type>Procedure</type>
 <desc>
  Sets the border color of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color</param-def>
   <param-desc>Border color.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellBorderColor(p_row          in out t_row,
                               p_cell_index   pls_integer,
                               p_border_color plpdf_type.t_color);
/**
 <name>SetCellBorderWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the border width of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_border_width number</param-def>
   <param-desc>Border width.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellBorderWidth(p_row          in out t_row,
                               p_cell_index   pls_integer,
                               p_border_width number);
/**
 <name>SetCellAlign</name>
 <type>Procedure</type>
 <desc>
  Sets the alingment of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2</param-def>
   <param-desc>Alignment of the cell.</param-desc>
   <param-ul>
     <param-li>L: left (default)</param-li>
     <param-li>R: right</param-li>
     <param-li>C: center</param-li>
     <param-li>J: justified</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellAlign(p_row        in out t_row,
                         p_cell_index pls_integer,
                         p_align      varchar2);
/**
 <name>SetCellVerticalAlignLine</name>
 <type>Procedure</type>
 <desc>
  Sets the vertical alingment of the indexed cell text in lines.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_vert_align_line varchar2</param-def>
   <param-desc>Vertical alignment of the cell's line.</param-desc>
   <param-ul>
     <param-li>C: center (default)</param-li>
     <param-li>T: top</param-li>
     <param-li>B: bottom</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure SetCellVerticalAlignLine(p_row             in out t_row,
                                   p_cell_index      pls_integer,
                                   p_vert_align_line varchar2);
/**
 <name>SetCellVerticalAlign</name>
 <type>Procedure</type>
 <desc>
  Sets the vertical alingment of the indexed cell.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_vert_align_line varchar2</param-def>
   <param-desc>Vertical alignment of the cell's line.</param-desc>
   <param-ul>
     <param-li>T: top (default)</param-li>
     <param-li>C: center</param-li>
     <param-li>B: bottom</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure SetCellVerticalAlign(p_row             in out t_row,
                                   p_cell_index      pls_integer,
                                   p_vert_align varchar2);
/**
 <name>SetCellFillColor</name>
 <type>Procedure</type>
 <desc>
  Sets the fill color of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color</param-def>
   <param-desc>Fill color.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellFillColor(p_row        in out t_row,
                             p_cell_index pls_integer,
                             p_fill_color plpdf_type.t_color);
/**
 <name>SetCellMaxline</name>
 <type>Procedure</type>
 <desc>
  Sets the maximum number of lines in the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_maxline number</param-def>
   <param-desc>Maximum number of lines in a multi-line cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellMaxline(p_row        in out t_row,
                           p_cell_index pls_integer,
                           p_maxline    number);
/**
 <name>SetCellLink</name>
 <type>Procedure</type>
 <desc>
  Sets the link of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2</param-def>
   <param-desc>Link of the cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellLink(p_row        in out t_row,
                        p_cell_index pls_integer,
                        p_link       varchar2);
/**
 <name>SetCellClipping</name>
 <type>Procedure</type>
 <desc>
  Sets the clipping mode of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_clipping number</param-def>
   <param-desc>Clipping text.</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellClipping(p_row        in out t_row,
                            p_cell_index pls_integer,
                            p_clipping   number);
/**
 <name>SetCellMinheight</name>
 <type>Procedure</type>
 <desc>
  Sets the minimum height of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_min_height number</param-def>
   <param-desc>Minimum height.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellMinheight(p_row        in out t_row,
                             p_cell_index pls_integer,
                             p_min_height number);
/**
 <name>SetCellFontFamily</name>
 <type>Procedure</type>
 <desc>
  Sets the font type of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_font_family varchar2</param-def>
   <param-desc>Font family.</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellFontFamily(p_row         in out t_row,
                              p_cell_index  pls_integer,
                              p_font_family varchar2);
/**
 <name>SetCellFontStyle</name>
 <type>Procedure</type>
 <desc>
  Sets the font style of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_font_style varchar2</param-def>
   <param-desc>Font style.</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellFontStyle(p_row        in out t_row,
                             p_cell_index pls_integer,
                             p_font_style varchar2);
/**
 <name>SetCellFontSize</name>
 <type>Procedure</type>
 <desc>
  Sets the font size of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_font_size number</param-def>
   <param-desc>Font size.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellFontSize(p_row        in out t_row,
                            p_cell_index pls_integer,
                            p_font_size  number);
/**
 <name>SetCellFontColor</name>
 <type>Procedure</type>
 <desc>
  Sets the font color of the indexed cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
  <param>
   <param-def>p_font_color plpdf_type.t_color</param-def>
   <param-desc>Font color.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure SetCellFontColor(p_row        in out t_row,
                             p_cell_index pls_integer,
                             p_font_color plpdf_type.t_color);
/**
 <name>SetCellRotate</name>
 <type>Procedure</type>
 <desc>
  Sets the rotate (90 degree) of the indexed cell.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_cell_index pls_integer</param-def>
   <param-desc>Index of the cell.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure SetCellRotate(p_row        in out t_row,
                        p_cell_index pls_integer);


/**
 <name>ParseRow</name>
 <type>Function</type>
 <desc>
  Parse a row and calculate dimension of a row for PDF printing.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_h in out number</param-def>
   <param-desc>Return maximum height's value</param-desc>
  </param>
 </params>
 <return>parsed row</return>
*/
function ParseRow(
    p_row t_row,
    p_h in out number
    ) return t_prow;

/**
 <name>PrintParsedRow</name>
 <type>Procedure</type>
 <desc>
  Print a parsed row, see <link>ParseRow</link>.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_prow t_prow</param-def>
   <param-desc>Parsed row properties</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>maximum height</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintParsedRow(
    p_prow t_prow,
    p_h number
    );

/**
 <name>SaveCurrentValues</name>
 <type>Procedure</type>
 <desc>
  Save all text printing settings
 </desc>
 <version>v2.5.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure SaveCurrentValues;

/**
 <name>RestoreValues</name>
 <type>Procedure</type>
 <desc>
  Restore all text printing settings
 </desc>
 <version>v2.5.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure RestoreValues;

/**
 <name>Print</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
  This procedure sequence of: SaveCurrentValues, ParseRow, CheckPageBreak, PrintParsedRow, RestoreValues.
 </desc>
 <version>v2.9.0</version>
 <params>
  <param>
   <param-def>p_row t_row</param-def>
   <param-desc>All properties of the row.</param-desc>
  </param>
  <param>
   <param-def>p_CheckPageBreak boolean default true</param-def>
   <param-desc>Issues CheckPageBreak procedure or not</param-desc>
  </param>
 </params>
 <return>-</return>
*/
  procedure Print(
    p_row t_row,
    p_CheckPageBreak boolean default true
    );

/**
 <name>Row_Print</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print(p_data       Plpdf_Type.t_row_datas,
                      p_width      Plpdf_Type.t_row_widths,
                      p_align      Plpdf_Type.t_row_aligns,
                      p_h          number default 5,
                      p_fill       number default 0,
                      p_min_height number default 0,
                      p_clipping   number default 0);

/**
 <name>Row_Print2</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print2(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_style      Plpdf_Type.t_row_styles,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_h          number default 5,
                       p_fill       number default 0,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print2</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill colors</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print2(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_style      Plpdf_Type.t_row_styles,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_h          number default 5,
                       p_fill       Plpdf_Type.t_row_filles,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print3</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print3(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_style      Plpdf_Type.t_row_styles,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_links      plpdf_type.t_row_links,
                       p_h          number default 5,
                       p_fill       number default 0,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print3</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
   </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill color</param-desc></param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print3(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_style      Plpdf_Type.t_row_styles,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_links      plpdf_type.t_row_links,
                       p_h          number default 5,
                       p_fill       Plpdf_Type.t_row_filles,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print4(p_data       Plpdf_Type.t_row_datas,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_font       plpdf_type.t_row_fonts,
                       p_h          number default 5,
                       p_fill       number default 0,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print4(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_font       Plpdf_Type.t_row_fonts,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_h          number default 5,
                       p_fill       number default 0,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print4(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_font       Plpdf_Type.t_row_fonts,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_links      plpdf_type.t_row_links,
                       p_h          number default 5,
                       p_fill       number default 0,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
   </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill color</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print4(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_font       Plpdf_Type.t_row_fonts,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_h          number default 5,
                       p_fill       Plpdf_Type.t_row_filles,
                       p_min_height number default 0,
                       p_clipping   number default 0);
/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.2.1</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill colors</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
  procedure Row_Print4(p_data       Plpdf_Type.t_row_datas,
                       p_border     Plpdf_Type.t_row_borders,
                       p_width      Plpdf_Type.t_row_widths,
                       p_align      Plpdf_Type.t_row_aligns,
                       p_font       Plpdf_Type.t_row_fonts,
                       p_maxline    Plpdf_Type.t_row_maxlines,
                       p_links      plpdf_type.t_row_links,
                       p_h          number default 5,
                       p_fill       Plpdf_Type.t_row_filles,
                       p_min_height number default 0,
                       p_clipping   number default 0);
  --
end plpdf_row_print;
/

