create or replace package plpdf_xhtml as

/**
 <config>
  <pck-name>PL/PDF XHTML</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v2.7.0</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>15</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>Introdution</h1>
 <br/>
 <p>
  The PL/PDF XHTML package can convert XHTML files into PDF document. It supports a many tags over the "must know list",
  CSS attributes and values. This package is an extension for PL/PDF, so it can work only with PL/PDF v2.1.4 or higher.
  The complete XHTML reference is available at:                                 <br/>
  <a>http://xhtml.com</a></p>
*/

/**
<newpage/>
<h1>Image Handling</h1>
<p>
  <br/>
 The PL/PDF XHTML package don't need to have access to the file system for using
 images in an XHTML document. It needs only one function, which is recognize the content of
 the src attribute and return with the corredponding blob.
<br/>
</p>
<p>
For example:                                                                    <br/>
<br/>
- Construct table for images                                                    <br/>
CREATE TABLE STORE_XHTML_IMG(                                                   <br/>
  ID NUMBER PRIMARY KEY,                                                        <br/>
  SRC VARCHAR2(4000 CHAR) UNIQUE,                                               <br/>
  IMAGE_FILE BLOB )                                                             <br/>
</p>
<p>
- Create image handler function                                                 <br/>
CREATE OR REPLACE FUNCTION GET_IMG(P_SRC VARCHAR2) RETURN BLOB IS               <br/>
L_IMAGE BLOB;                                                                   <br/>
BEGIN                                                                           <br/>
SELECT IMAGE_FILE INTO L_IMAGE FROM STORE_XHTML_IMG WHERE SRC=P_SRC;            <br/>
RETURN L_IMAGE;                                                                 <br/>
END;                                                                            <br/>
</p>
<p>- Insert image file into STORE_XHTML_IMG and set the value of the SRC field  <br/>
(Eg. 'images\test.jpg').                                                        </p>
<p>- Set the image getter function to GET_IMG, it is available only             <br/>
as initialization parameter:                                                    <br/>
PLPDF_XHTML.CONFIG([default_ppi],[default_font_size],'GET_IMG');                </p>
<p>- Now the XHTML document can be referencing for this image with the value of <br/>
the SRC field. (Eg. &lt;img alt='sample image' src='images\test.jpg' /&gt;)     </p>
*/

/**
<br/><br/>
<h1>Page break</h1>
<p>
PLPDF_XHTML provides an easy way to make page break:                            <br/>
&lt;br style="page-break-after: always" /&gt;                                   </p>
*/

/**
 <newpage/>
 <h1>Procedures And Functions</h1>
 <name>config</name>
 <type>Procedure</type>
 <desc>
  Initializes generator program variables.                           </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_ppi number number default 72</param-def>
   <param-desc>Default resolution. It is useful to convert
   the pixel value into milimeters.                    </param-desc>
  </param>
  <param>
   <param-def>p_font_size number default 12</param-def>
   <param-desc> The base font size.(pt)                 </param-desc>
  </param>
  <param>
   <param-def>p_noraise boolean default false</param-def>
   <param-desc>Raise error or skip when unsupported tag in source</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure config(
 p_ppi number default 72,
 p_font_size number default 12,
 p_noraise boolean default false
 );

/**
 <name>config</name>
 <type>Procedure</type>
 <desc>
  Initializes generator program variables.                           </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_ppi number number default 72</param-def>
   <param-desc>Default resolution. It is useful to convert
   the pixel value into milimeters.                    </param-desc>
  </param>
  <param>
   <param-def>p_font_size number default 12</param-def>
   <param-desc> The base font size.(pt)                 </param-desc>
  </param>
  <param>
   <param-def>p_img_proc varchar2</param-def>
   <param-desc>Image handler process.                         </param-desc>
  </param>
  <param>
   <param-def>p_noraise boolean default false</param-def>
   <param-desc>Raise error or skip when unsupported tag in source</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure config(
 p_ppi number default 72,
 p_font_size number default 12,
 p_img_proc varchar2,
 p_noraise boolean default false
 );

/**
 <name>xhtml_to_pdf</name>
 <type>Function</type>
 <desc>
  Converts XHTML file into PDF format and returns with the closed PDF document.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_src clob</param-def>
   <param-desc> The XHTML file.                                           </param-desc>
  </param>
 </params>
 <return>
  <return-def>blob</return-def>
  <return-desc>The PDF document.                                                </return-desc>
 </return>
*/
function xhtml_to_pdf(
 p_src clob
 ) return blob;

/**
 <name>xhtml_to_pdf</name>
 <type>Procedure</type>
 <desc>
  Converts XHTML file into PDF and append to the current PDF document.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_src clob</param-def>
   <param-desc> The XHTML file.                                           </param-desc>
  </param>
 </params>
 <return> - </return>
*/
procedure xhtml_to_pdf(
 p_src clob
 );

/**
<newpage/>
<h1>Supported Elements</h1>
<h2>a</h2>
<p>attributes: href, id, style.                                                 </p>

<h2>abbr</h2>
<p>attributes: id, title, style.                                                </p>

<h2>acronym</h2>
<p>attributes: id, title, style.                                                </p>

<h2>address</h2>
<p>attributes: id, style.                                                       </p>

<h2>b</h2>
<p>attributes: id, style.                                                       </p>

<h2>base</h2>
<p>attribute: href                                                              </p>

<h2>big</h2>
<p>attributes: id, style.                                                       </p>

<h2>blockquote</h2>
<p>attributes: id, style.                                                       </p>

<h2>body</h2>
<p>attribute: style                                                             </p>

<h2>br</h2>
<p>attributes:                                                                  <br/>
- id                                                                            <br/>
- style="page-break-after: always"                                              </p>

<h2>caption</h2>
<p>attributes: id, style.                                                       </p>

<h2>cite</h2>
<p>attributes: id, style.                                                       </p>

<h2>code</h2>
<p>attributes: id, style.                                                       </p>

<h2>col</h2>
<p>attribute: width. Required!                                                  </p>

<h2>dd</h2>
<p>attributes: id, style.                                                       </p>

<h2>dfn</h2>
<p>attributes: id, style.                                                       </p>

<h2>dl</h2>
<p>attributes: id, style.                                                       </p>

<h2>dt</h2>
<p>attributes: id, style.                                                       </p>

<h2>em</h2>
<p>attributes: id, style.                                                       </p>

<h2>h1</h2>
<p>attributes: id, style.                                                       </p>

<h2>h2</h2>
<p>attributes: id, style.                                                       </p>

<h2>h3</h2>
<p>attributes: id, style.                                                       </p>

<h2>h4</h2>
<p>attributes: id, style.                                                       </p>

<h2>h5</h2>
<p>attributes: id, style.                                                       </p>

<h2>h6</h2>
<p>attributes: id, style.                                                       </p>

<h2>head</h2>
<p>attribute: -                                                                 </p>

<h2>hr</h2>
<p>attribute: id                                                                </p>

<h2>html</h2>
<p>attribute: -                                                                 </p>

<h2>i</h2>
<p>attributes: id, style.                                                       </p>

<h2>img</h2>
<p>attributes:                                                                  <br/>
- alt: alternate text for image. Default: src                                   <br/>
- height: height of the image. (px)                                             <br/>
- id                                                                            <br/>
- src: name of the source. Required!                                            <br/>
- style                                                                         <br/>
- width: width of the image.                                                    </p>

<h2>ins</h2>
<p>attributes: id, style.                                                       </p>

<h2>kbd</h2>
<p>attributes: id, style.                                                       </p>

<h2>li</h2>
<p>attributes: id, style.                                                       </p>

<h2>meta</h2>
<p>attributes:                                                                  <br/>
- http-equiv                                                                    <br/>
- name                                                                          <br/>
- name/author                                                                   <br/>
- name/description                                                              <br/>
- name/keywords                                                                 </p>

<h2>noscript</h2>
<p>attributes: id, style.                                                       </p>

<h2>ol</h2>
<p>attributes: id, style (list-style-type).                                     </p>

<h2>p</h2>
<p>attributes: id, style.                                                       </p>

<h2>q</h2>
<p>attributes: id, style.                                                       </p>

<h2>samp</h2>
<p>attributes: id, style.                                                       </p>

<h2>script</h2>
<p>attributes:                                                                  <br/>
- id                                                                            <br/>
- style                                                                         <br/>
- type: only "text/javascript". See PLPDF.setJs                                 </p>

<h2>small</h2>
<p>attributes: id, style.                                                       </p>

<h2>span</h2>
<p>attributes: id, style.                                                       </p>

<h2>strong</h2>
<p>attributes: id, style.                                                       </p>

<h2>style</h2>
<p>attribute: -                                                                 </p>

<newpage/>

<h2>table</h2>
<p>attributes:                                                                  <br/>
- border: border of the table                                                   <br/>
- id                                                                            <br/>
- style                                                                         <br/>
- width: width of the table                                                     <br/>
- cellspacing: space between cells. Default is 1                                <br/>
- celpadding: space inside the cell. Default is 1                               </p>

<h2>title</h2>
<p>attributes: -                                                                </p>

<h2>td</h2>
<p>attributes: id, style.                                                        </p>

<h2>th</h2>
<p>attributes: id, style.                                                        </p>

<h2>tr</h2>
<p>attributes: id, style.                                                        </p>

<h2>td</h2>
<p>attributes: id, style.                                                        </p>

<h2>tt</h2>
<p>attributes: id, style.                                                        </p>

<h2>ul</h2>
<p>attributes: id, style (list-style-type).                                      </p>

<h2>var</h2>
<p>attributes: id, style.                                                        </p>

<h2>Common attributes</h2>
<p> - id: ID of the element.                                                    <br/>
- style: Specifies formatting style information.                                </p>

<newpage/>
<h1>CSS support</h1>
<h2>
Supported attributes
</h2>
<p> o font-family : Arial | Courier | Helvetica | Symbol | Times | ZapfDingbats </p>
<p> o font-size: [ xx-large | x-large | large | medium | small | x-small |      <br/>
xx-small ] | [ larger | smaller ] | [size {px|pt|cm|mm}]                  </p>
<p> o font-style: normal | italic | oblique                                     </p>
<p> o font-weight: bold | normal                                                </p>
<p> o color: #rrggbb,rgb(r,g,b),(color_constant)                                </p>
<p> o text-align: left | right | center | justify                               </p>
<p> o text-indent: indent_size {px|mm|cm} (available only in: p,td,th)          </p>
<p> o text-decoration: underline | none                                         </p>
<p> o text-transform: uppercase | lowercase | capitalize | normal               </p>

<h2>Color constants</h2>
<p>
  Alice_blue, Antique_white, Aquamarine, Azure, Beige, Bisque, Black, Blanche_dalmond,
  Blue, Blue_violet, Brown, Burlywood, Cadet_blue, Chartreuse, Chocolate, Coral,
  Cornflower_blue, Cornsilk, Crimson, Cyan, Dark_blue, Dark_cyan, Dark_goldenrod,
  Dark_gray, Dark_green, Dark_khaki, Dark_magenta, Dark_olive_green, Dark_orange,
  Dark_orchid, Dark_red, Dark_salmon, Dark_seagreen, Dark_slate_blue, Dark_slate_gray,
  Dark_turquoise, Dark_violet, Deep_pink, Deep_sky_blue, Dim_gray, Dodger_blue,
  Firebrick, Floral_white, Forest_green, Gainsboro, Ghost_white, Gold, Goldenrod,
  Gray, Green, Green_yellow, Honeydew, Hot_pink, Indian_red, Indigo, Ivory, Khaki,
  Lavender, Lavender_blush, Lawngreen, Lemon_chiffon, Light_blue, Light_coral,
  Light_cyan, Light_goldenrod_yellow, Light_green, Light_grey, Light_pink,
  Light_salmon, Light_seagreen, Light_sky_blue, Light_slate_gray, Light_steel_blue,
  Light_yellow, Lime, Lime_green, Linen, Magenta, Maroon, Medium_aquamarine,
  Medium_blue, Medium_orchid, Medium_purple, Medium_sea_green, Medium_slate_blue,
  Medium_spring_green, Medium_turquoise, Medium_violet_red, Midnight_blue, Mint_cream,
  Misty_rose, Moccasin, Navajo_white, Navy, Old_lace, Olive_drab, Orange, Orange_red,
  Orchid, Pale_goldenrod, Pale_green, Pale_turquoise, Pale_violet_red, Papaya_whip,
  Peach_puff, Peru, Pink, Plum, Powder_blue, Purple, Red, Rosy_brown, Royal_blue,
  Saddle_brown, Salmon, Sandy_brown, Sea_green, Sea_shell, Sienna, Silver, Sky_blue,
  Slate_blue, Snow, Spring_green, Steelblue, Tan, Teal, Thistle, Tomato, Turquoise,
  Violet, Wheat, White, Whitesmoke, Yellow, Yellow_green
</p>

<newpage/>
<h1>Limitations</h1>
<p>The following tags are not supported:                                        </p>
<p>area, bdo, button, colgroup, del, div, fieldset, form, input, label, legend,
   link, map, object, optgroup, option, param, pre, select, sub, sup, tbody,
    textarea, tfoot, thead.                                                     </p>

<newpage/>
<h1>XHTML Version History</h1>
<h2>11-07-2009, v2.1.4</h2>
<p>
- Fixed a bug: table size calculation                                           <br/>
- Fixed a bug: ol,ul style handling                                             <br/>
- New feature: Direct pagebreak with br                                         <br/>
- New feature: XHTML_TO_PDF procedure                                           <br/>
- Fixed a bug: inline images handling                                           <br/>
- New feature: automatic alt value                                              <br/>
- Fixed a bug: correct linebreaks after images                                  <br/>
- Revised table handling                                                        <br/>
- New supported element: col                                                    <br/>
- New supported property: cellspadding                                          <br/>
- New supported property: cellspacing                                           <br/>
- New feature: table size in percent                                            <br/>
- Revised text-indent                                                           <br/>
- Fixed a bug: handling different font size in one row                          <br/>
</p>

<h2>05-03-2010, v2.2.1a</h2>
<p>
- Fixed a bug: string to number conversion                                      <br/>
</p>

<h2>20-09-2010, v2.3.1</h2>
<p>
- Support list-style-type property in ol and ul                                  <br/>
</p>

<h2>06-01-2011, v2.5.0</h2>
<p>
- Handling unsupported tags                                                      <br/>
</p>
*/



end plpdf_xhtml;
/

