create or replace
procedure xhtml_demo as
  -- Create source CLOB.(it is able also to select from arbitrary table)
  l_src clob := 
 '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" ' ||
 '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
 '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
  '<head>' ||
   '<meta name="author" content="PL/PDF" />' ||
   '<title>PL/PDF XHTML Examples - Demo </title>' ||
  '</head>' ||
  '<body>' ||
   '<h1>XHTML Example</h1>' ||
   '<h2>XHTML Example</h2>' ||
   '<h3>XHTML Example</h3>' ||
   '<h4>XHTML Example</h4>' ||
   '<h5>XHTML Example</h5>' ||
   '<h6>XHTML Example</h6>' ||
   '<hr />' ||
   '<p>' ||
    'Font settings:  <br />' ||
    '<big>big</big>  <br />' ||
    '<small>small</small> <br />' ||
    '<b>bold</b> <br />' ||
    '<i>italic</i> <br />' ||
   '</p>' ||
   '<hr />' ||
   '<p>' ||
    '<img alt="img001" src="logo01.jpg" />' ||
   '</p>' ||
   '<hr />' ||
   '<table border="1" >' ||
    '<caption>Table Example</caption>' ||
    '<tr>' ||
     '<th>Logo:</th>' ||
     '<th><img alt="img002" src="logo01.jpg" /></th>' ||
    '</tr>' ||
    '<tr>' ||
     '<td style="text-align: center;font-weight: bold" >Purpose:</td>' ||
     '<td>' || 
      'PL/PDF is a PL/SQL based PDF document generator' ||
      'from Oracle databases. Use ' ||
      'PL/PDF to quickly and easily develop applications with dynamic content but also' ||
      'quality presentation and printing capabilities.' || 
     '</td>' ||
    '</tr>' ||
    '<tr>' ||
     '<td>' ||
      '<table border="1">' ||
       '<tr>' ||
        '<td style="text-align: center;font-weight: bold;">Documentation:</td>' ||
       '</tr>' ||
       '<tr>' ||
        '<td  style="text-align: center;font-weight: bold;">Examples:</td>' ||
       '</tr>' ||
      '</table>' ||
     '</td>' ||
     '<td>' ||
      '<a href="http://www.plpdf.com/23-927.html">http://www.plpdf.com/23-927.html</a>' ||
      '<a href="http://www.plpdf.com/23-926.html">http://www.plpdf.com/23-926.html</a>' ||
     '</td>' ||
    '</tr>' ||
   '</table>' ||
   '<hr />' ||
   '<h3>Ordered list</h3>' ||
   '<ol>' ||
    '<li>item1</li>' ||
    '<li>item2</li>' ||
    '<li>' ||
     '<ol>' ||
      '<li>item3-1</li>' ||
      '<li>item3-2</li>' ||
      '<li>item3-3</li>' ||
     '</ol>' ||
    '</li>' ||
   '</ol>' ||
   '<hr />' ||
   '<h3>Unsorted List</h3>' ||
   '<ul>' ||
    '<li>item1</li>' ||
    '<li>item2</li>' ||
    '<li>' ||
     '<ul>' ||
      '<li>item3-1</li>' ||
      '<li>item3-2</li>' ||
      '<li>item3-3</li>' ||
     '</ul>' ||
    '</li>' ||
   '</ul>' ||
   '<hr />' ||
   '<h3>Detailed List</h3>' ||
   '<dl>' ||
    '<dt>title 1</dt>' ||
     '<dd>data 1</dd>' ||
    '<dt>title 2</dt>' ||
     '<dd>data 2</dd>' ||
    '<dt>title 3</dt>' ||
     '<dd>data 3</dd>' ||
    '<dt>title 4</dt>' ||
     '<dd>data 4</dd>' ||
   '</dl>' ||
   '<hr />' ||
   '<h3>Abbrevation and Acronym</h3>' ||
   '<p>' ||
    '<abbr title="abbreviation">abbr.</abbr>' ||
   '<br/>' ||
    '<acronym title="eXtensible HiperText Markup Language">XHTML</acronym>' ||
   '</p>' ||
   '<hr />' ||
   '<h3>Text Formatting and Special Contents</h3>' ||
   '<address>contact: <a href="mailto:info@plpdf.com">PL/PDF</a></address>' ||
   '<blockquote>' ||
    '<p>' ||
     'This is a long quotation. This is a long quotation. This is a long quotation. This is a long quotation. This is a long quotation.' ||
    '</p>' ||
   '</blockquote>' ||
   '<p>' ||
    '<q>This is a short quotation.</q>' ||
   '</p>' ||
   '<p>' ||
    '<code style="color:#aaaaaa">' ||
     '-- This is a computer code<br />' ||
     'create or replace<br />' ||
     'procedure <var>xhtml_demo </var> as<br />' ||
     '<var>l_src </var> clob := ''...''; <br />' ||
     '<var>v_out </var> blob; <br />' ||
     'begin <br />' ||
     '...' ||
    '</code>' ||
   '</p>' ||
   '<hr />' ||
   '<script type="text/javascript" >' ||
    'this.print(true);' ||
   '</script>' ||
   '<noscript>' ||
    '<p style="color:red"> Printing failed!</p>' ||
   '</noscript>' ||
  '</body>' ||
 '</html>';
  v_out blob; -- the output
begin
  -- initilaize package variables
  plpdf.init(); 
  -- create new page
  plpdf.newpage();
  -- configuring if the xhtml processor
  plpdf_xhtml.config(
    p_ppi=> 96,
    p_font_size=> 10,       -- default font size(pt)
    p_img_proc => 'get_img' -- name of the image getter process
    );
  -- call the xhtml processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- store blob
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_demo;
