create or replace
procedure xhtml_text as
  -- create source CLOB
  l_src clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" ' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
   '<head>' ||
    '<style>' ||
     'p   {color: gray; font-family: Arial; font-size: 9 pt} ' ||
     'ul  {color: gray; font-family: Arial; font-size: 9 pt} ' ||
     'a   {color: olive_drab; font-family: Arial; font-size: 9 pt} ' ||
    '</style>' ||
    '<meta name="author" content="PL/PDF" />' ||
    '<title>PL/PDF XHTML Examples - Text</title>' ||
   '</head>' ||
   '<body>' ||
    '<h1 style="color: olive_drab; font-family: Arial; font-size: 16 pt">' ||
     'PL/SQL + PDF = PL/PDF' ||
    '</h1>' ||
    '<table>' ||
     '<tr>' ||
      '<td style="color: gray; font-family: Arial; font-size: 9 pt">' ||
       'Generate dynamic PDF ' || 
       'documents from data stored in Oracle databases using the PL/PDF program ' ||
       'package. PL/PDF is written exclusively in PL/SQL. It is able to either ' ||
       'store the generated PDF document in the database or provide the results ' ||
       'directly to a browser using MOD_PLSQL. No third-party software is ' ||
       'needed; PL/PDF only uses tools provided by the installation package of ' ||
       'an Oracle Database (PL/SQL, MOD_PLSQL). Use PL/PDF to quickly and ' ||
       'easily develop applications with dynamic content but also quality ' ||
       'presentation and printing capabilities.' ||
      '</td>' ||
      '<td>' ||
       '<img src="523.jpg" alt="523" />' ||
      '</td>' ||
     '</tr>' ||
    '</table>' ||
    '<p>' ||
     'If you wish to order PL/PDF, please proceed to the ' ||
     '<a href="http://www.plpdf.com/order.html">Order </a> page. The cost of a PL/PDF licence is US$600. ' ||
     'A licence is required per Oracle database. The Trial version of our product is ' ||
     'available on the <a href="http://www.plpdf.com/downloads.html">Downloads </a> page. ' ||
     'The Trial version has two limitations: Only 5 pages per PDF document may be produced; ' ||
     'All pages are watermarked. ' ||
     'Our <a href="http://www.plpdf.com/examples.html">Examples </a> page helps you get started ' ||
     'on how to use PL/PDF. We have around 250 customers from all over the world! ' ||
     'Check out our <a href="http://www.plpdf.com/feedback.html">Feedback </a> and ' ||
     '<a href="http://www.plpdf.com/references.html">Reference </a> pages.' ||
    '</p>' ||
    '<p>' ||
     'PL/PDF is more than a document generator for simple text. It includes:' ||
    '</p>' ||
    '<ul>' ||
     '<li>' ||
      'Character encoding support. The default encoding is cp1252, but all ' ||
      'encodings are supported, including Unicode encodings. Apart from the 5 ' ||
      'standard Adobe fonts (Helvetica (Arial, Sans Serif), Courier, Times ' ||
      '(Serif), Symbol, ZapfDingBats), True Type Fonts may also be ' ||
      'used. All European, CJK (Chinese/Japanese/Korean) and ' ||
      'Arabic/Hebrew (Beta version only!) characters are supported. ' ||
     '</li>' ||
     '<li>' ||
      'Native support for JPG and PNG. All other image formats are passed onto automatic conversion by Oracle Intermedia. ' ||
     '</li>' ||
     '<li>' ||
      'Many linear and 2D barcodes are supported with our ' ||
      '<a href="http://www.plpdf.com/barcode.html">Barcode </a> package. ' ||
     '</li>' ||
     '<li>' ||
      'The <a href="http://www.plpdf.com/chart.html">Chart generator </a> displays complex numbers in simple diagrams. ' ||
     '</li>' ||
     '<li>' ||
      'The <a href="http://www.plpdf.com/encrypt/index.html">Encryption </a> package ' ||
      'provides ways to limit what users can do with generated PDFs. ' ||
     '</li>' ||
     '<li>' ||
      'A Java based and a PL/SQL based LZW compression is available to reduce the size of PDFs. ' ||
     '</li>' ||
     '<li>The <a href="http://www.plpdf.com/template_library.html">Template </a> feature makes it ' || 
      'possible to add new content to an existing PDF document. ' ||
     '</li>' ||
     '<li>' ||
      'Fill out your <a href="http://www.plpdf.com/oo_forms.html">Open Office </a> PDF forms with PL/PDF!' ||
     '</li>' ||
    '</ul>' ||
    '<p>' ||
     'Please find out more information on these features on our <a href="http://www.plpdf.com/faq.html">FAQ </a> page.' ||
    '</p>' ||
    '<p>' ||
     '<strong>NEW!!! PL/PDF Toolkit</strong> is a Java library with PL/SQL ' ||
     'interface for manipulating existing PDF documents. If you wish to order ' ||
     'PL/PDF Toolkit, please proceed to the <a href="http://www.plpdf.com/order.html">Order </a> ' ||
     'page. The cost of a PL/PDF Toolkit licence is US$300. A ' ||
     'licence is required per Oracle database. The Trial version of our ' ||
     'product is available on the <a href="http://www.plpdf.com/downloads.html">Downloads </a> page.' ||
    '</p>' ||
    '<p>' ||
     'The features of this new product are:' ||
    '</p>' ||
    '<ul>' ||
     '<li>' ||
      'PDF Encrpytion/Decryption' ||
     '</li>' ||
     '<li>' ||
      'PDF Metadata manipulation' ||
     '</li>' ||
     '<li>' ||
      'Extraction of text from PDF' ||
     '</li>' ||
     '<li>' ||
      'Merging PDF documents' ||
     '</li>' ||
     '<li>' ||
      'Replacement of URLs in a PDF document ' ||
     '</li>' ||
     '<li>' ||
      'Stamp content or watermark into a PDF document' ||
     '</li>' ||
    '</ul>' ||
   '</body>' ||
  '</html>';
  -- target BLOB
  v_out blob;
begin
  -- initilize the PL/PDF package variables
  plpdf.init();
  -- create a new page
  plpdf.newpage();
  -- configuring of the XHTML processor
  plpdf_xhtml.config(
    p_img_proc => 'get_img' -- set the current image getter process
    );
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_text;
