create or replace procedure XHTML_LIST as
  -- Create source CLOB.(it is able also to select from arbitrary table)
  l_src clob := '
 <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" 
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
 <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">
  <head>
   <meta name="author" content="PL/PDF" />
   <base href="http://" />
   <title>PL/PDF XHTML Examples - List </title>
 </head>
 <body>
 <h2>PL/PDF XHTML Example - List</h2>
 <hr/>
 ';
  v_out blob; -- the output
  CURSOR l_cur is select * from all_users;
  CURSOR l_cur02 is select name from all_source where OWNER='PLPDF' and TYPE='PACKAGE' group by name;
  l_data all_users%rowtype;
  l_sources l_cur02%rowtype;
begin
  -- open new table
  dbms_lob.append(l_src,'<dl>'||
                        '<dt>USERS</dt>'||
                        '<dd><ol>'
                        );
  -- generate table data
  open l_cur;
  loop
    fetch l_cur into l_data;
    exit when l_cur%notfound;
    dbms_lob.append(l_src,' <li>' || l_data.USERNAME || '</li>'); -- USERNAME field with current data
  end loop;
  -- close cursor
  close l_cur;
  dbms_lob.append(l_src,
                  ' </ol>' || 
                  '</dd>' || 
                  '<dt>PL/PDF packages</dt>' || 
                  '<dd>' ||
                  ' <ul>'
                        );
  open l_cur02;
  loop
    fetch l_cur02 into l_sources;
     exit when l_cur02%notfound;
    dbms_lob.append(l_src,' <li>' || l_sources.NAME || '</li>'); -- source name
  end loop;
  -- close cursor
  close l_cur02;
  -- close generated table
  dbms_lob.append(l_src,
                        '    </ul>'||
                        '   </dd>' ||
                        '  </dl>'||
                        ' </body>'||
                        '</html> '
                        );
  -- initilaize package variables
  plpdf.init(); 
  -- create new page
  plpdf.newpage();
  -- configuring if the xhtml processor
  plpdf_xhtml.config(
    p_font_size=> 10,       -- default font size(pt)
    p_img_proc => 'get_img' -- name of the image getter process
    );
  -- call the xhtml processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- store blob
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_list;
/
 