create or replace
procedure xhtml_table as
  -- Create source CLOB.(it is able also to select from arbitrary table)
  l_src clob := '
 <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" 
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
 <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">
  <head>
   <meta name="author" content="PL/PDF" />
   <base href="http://" />
   <title>PL/PDF XHTML Examples - Table </title>
 </head>
 <body>
 <h2>PL/PDF XHTML Example - Table</h2>
 <hr/>
 ';
  v_out blob; -- the output
  CURSOR l_cur is select * from all_users;
  l_data all_users%rowtype;
begin
  -- open new table
  dbms_lob.append(l_src,'<table border="1" width="300">'|| -- new table, border=1, width=100
                        ' <caption>SELECT * FROM ALL_USERS</caption>' ||  -- add query int caption
                        '<col width="50%" />' || -- 50 percent of the width of the table
                        '<col width="60" />' || -- 60 pixels
                        '<col width="30%" />' || -- 30 percent of the width of the table
                        ' <tr>'|| -- header line
                        ' <th>USERNAME</th>' || -- haders
                        ' <th>USER_ID</th>'||
                        ' <th>CREATED</th>'||
                        '</tr>');
  -- generate table data
  open l_cur;
  loop
    
    fetch l_cur into l_data;
    exit when l_cur%notfound;
    dbms_lob.append(l_src,' <tr> '); --fetch and add every rows
    dbms_lob.append(l_src,' <td>' || l_data.USERNAME || '</td>'); -- USERNAME field with current data
    dbms_lob.append(l_src,' <td>' || l_data.USER_ID || '</td>'); -- USER_ID field with current data
    dbms_lob.append(l_src,' <td>' || l_data.CREATED || '</td>'); -- CREATED field with current data
    dbms_lob.append(l_src,' </tr> ');
    
  end loop;
  -- close cursor
  close l_cur;
  -- close generated table
  dbms_lob.append(l_src,'  </table>'||
                        ' </body>'||
                        '</html> '
                        );
  -- initilaize package variables
  plpdf.init(); 
  -- create new page
  plpdf.newpage();
  -- configuring if the xhtml processor
  plpdf_xhtml.config(
    p_font_size=> 10,       -- default font size(pt)
    p_img_proc => 'get_img' -- name of the image getter process
    );
  -- call the xhtml processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- store blob
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_table;
