create or replace procedure test_graph is
l_blob blob;

l_x plpdf_graph.t_points;
l_c0  plpdf_graph.t_points;
l_c1  plpdf_graph.t_points;
l_graphs plpdf_graph.t_graphs;
begin

plpdf_graph.InitPoints(l_x);
plpdf_graph.AddPoint(l_x,-10);  
plpdf_graph.AddPoint(l_x,-7);
plpdf_graph.AddPoint(l_x,0);
plpdf_graph.AddPoint(l_x,7);
plpdf_graph.AddPoint(l_x,10);
plpdf_graph.AddPoint(l_x,20);
plpdf_graph.AddPoint(l_x,25);
plpdf_graph.AddPoint(l_x,35);
plpdf_graph.AddPoint(l_x,40);
plpdf_graph.AddPoint(l_x,50);

plpdf_graph.InitPoints(l_c0);
plpdf_graph.AddPoint(l_c0,-10);
plpdf_graph.AddPoint(l_c0,-5);
plpdf_graph.AddPoint(l_c0,1);
plpdf_graph.AddPoint(l_c0,12);
plpdf_graph.AddPoint(l_c0,-30);
plpdf_graph.AddPoint(l_c0,-25);
plpdf_graph.AddPoint(l_c0,-10);
plpdf_graph.AddPoint(l_c0,2.9);
plpdf_graph.AddPoint(l_c0,4.5);
plpdf_graph.AddPoint(l_c0,4.9);

plpdf_graph.InitGraphs(l_graphs);
plpdf_graph.AddGraph(
  p_graphs => l_graphs,
  p_name => 'Curve0',
  p_points => l_c0,
  p_diagram_color => plpdf_const.Blue
  );

plpdf_graph.InitPoints(l_c1);
plpdf_graph.AddPoint(l_c1,44);
plpdf_graph.AddPoint(l_c1,13.2); 
plpdf_graph.AddPoint(l_c1,6.6); 
plpdf_graph.AddPoint(l_c1,24.5); 
plpdf_graph.AddPoint(l_c1,30); 
plpdf_graph.AddPoint(l_c1,27.1); 
plpdf_graph.AddPoint(l_c1,40); 
plpdf_graph.AddPoint(l_c1,22.5);
plpdf_graph.AddPoint(l_c1,37);
plpdf_graph.AddPoint(l_c1,23.2);
plpdf_graph.AddPoint(l_c1,-19.6);

plpdf_graph.AddGraph(
  p_graphs => l_graphs,
  p_name => 'Curve1',
  p_points => l_c1,
  p_diagram_color => plpdf_const.Red,
  p_diagram_line_width => 0.5
  );

plpdf.init();
plpdf.NewPage;

plpdf_graph.init(
  p_bg_color => plpdf_const.Lime
  );

plpdf_graph.SetLimits(-15, 60, -40, 100);       
plpdf_graph.Draw(
  p_x_points => l_x,
  p_graphs => l_graphs,
  p_x_desc => 'Text for X Coords', 
  p_y_desc => 'Text for Y Coords', 
  p_x => null, 
  p_y => null, 
  p_w => 70, 
  p_h => 50
  );
 

plpdf.SendDoc(l_blob); -- create content


delete from STORE_BLOB;
insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
commit;

        

end;
/
