create or replace package plpdf_graph is
--v2.7.0
/*
Graph creator package
The purpose of the package is to insert graph into PDFs generated by PL/PDF.
The procedures of plpdf_graph create PL/SQL code that will create and arrange graphs according to the specifications supplied by the user.
*/
---------------------------------------------------------------------------------------------------
type t_points is table of number index by pls_integer; -- 0 indexed table

type t_graph is record (
  points t_points,
  diagram_color plpdf_type.t_color, -- optional
  diagram_line_width number, -- optional
  diagram_text_size     number,-- optional
  diagram_text_color    plpdf_type.t_color,-- optional
  diagram_text_font     varchar2(255 char),-- optional
  diagram_text_fonttype varchar2(255 char)-- optional
  );
type t_graphs is table of t_graph index by varchar2(255 char);
---------------------------------------------------------------------------------------------------
/*
Initializes the global parameters of the graph.
*/
procedure Init(
  p_bg_color              plpdf_type.t_color default null, -- background color
  p_border_size           number default null, -- border size
  p_border_color          plpdf_type.t_color default null, -- border color
  p_border_show           boolean default null, -- border show
  p_grid_show             boolean default null, -- grid show
  p_grid_color            plpdf_type.t_color default null, -- grid color
  p_grid_size             number default null, -- grid size
  p_grid_linesx           pls_integer default null, -- count or value of the x grid lines
  p_grid_linesy           pls_integer default null, -- count or value of the y grid lines
  p_grid_lines_by_value   boolean default null, -- grid lines by value or by count, true == value, false == count
  p_grid_text_size        number default null, -- grid text size
  p_grid_text_color       plpdf_type.t_color default null, -- grid text color
  p_grid_text_font        varchar2 default null, -- grid text font
  p_grid_text_fonttype    varchar2 default null, -- grid text font type
  p_graph_text_size       number default null, -- graph text size
  p_graph_text_color      plpdf_type.t_color default null, -- graph text color
  p_graph_text_font       varchar2 default null, -- graph text font
  p_graph_text_fonttype   varchar2 default null, -- grid text font type
  p_graph_text_mwidth     number default null, -- Graph text multicell width
  p_graph_text_mheight    number default null, -- Graph text multicell height
  p_diagram_line_width    number default null, -- graph default line size
  p_diagram_color         plpdf_type.t_color default null, -- graph default color
  p_diagram_text_size     number default null, -- diagram text size
  p_diagram_text_color    plpdf_type.t_color default null, -- diagram text color
  p_diagram_text_font     varchar2 default null, -- diagram text font
  p_diagram_text_fonttype varchar2 default null -- diagram text font type
);
---------------------------------------------------------------------------------------------------
/*
Sets the graph minimum and maximum values.
*/
procedure SetLimits(
  p_xmin number,
  p_xmax number,
  p_ymin number,
  p_ymax number
  );
---------------------------------------------------------------------------------------------------
/*
Draw the graphs.
*/
procedure Draw(
  p_w number,
  p_h number,
  p_x_points t_points,
  p_graphs t_graphs,
  p_x_desc varchar2 default null,
  p_y_desc varchar2 default null,
  p_x number default null,
  p_y number default null
  );
---------------------------------------------------------------------------------------------------
/*
Collection utilities
*/
---------------------------------------------------------------------------------------------------
/*
Initializes the points array.
*/
procedure InitPoints(
  p_points in out t_points
  );
---------------------------------------------------------------------------------------------------
/*
Add a point to an points arrray.
*/
procedure AddPoint(
  p_points in out t_points,
  p_point number
  );
---------------------------------------------------------------------------------------------------
/*
Initializes an graphs data structure.
*/
procedure InitGraphs(
  p_graphs in out t_graphs
  );
---------------------------------------------------------------------------------------------------
/*
Add graph to an graphs data structure.
*/
procedure AddGraph(
  p_graphs in out t_graphs,
  p_name varchar2,
  p_points t_points,
  p_diagram_color plpdf_type.t_color default null,
  p_diagram_line_width number default null,
  p_diagram_text_size     number default null,
  p_diagram_text_color    plpdf_type.t_color default null,
  p_diagram_text_font     varchar2 default null,
  p_diagram_text_fonttype varchar2 default null
  );
---------------------------------------------------------------------------------------------------
end plpdf_graph;
/

