CREATE OR REPLACE PROCEDURE Test_chart_pie IS

  l_data plpdf_chart.t_dg;
  l_blob BLOB;
  l_sum number := 0;
  l_start number := 0;
 BEGIN
    Plpdf.init;
    Plpdf.NewPage;
    Plpdf.SetPrintFont('Arial',NULL,8); -- set font attributes: family: Arial, style: regular, font size: 8

	-- set values of diagram items
    l_data(1).value := 20; l_data(1).label := 'apple'; l_data(1).color := plpdf_const.Dark_turquoise;
    l_data(2).value := 30; l_data(2).label := 'pear'; l_data(2).color := plpdf_const.Indigo;
	l_data(3).value := 12; l_data(3).label := 'plum'; l_data(3).color := plpdf_const.Lime_green;
	l_data(4).value := 37; l_data(4).label := 'banana'; l_data(4).color := plpdf_const.Pink;

	plpdf_chart.Init(
      p_x => 20,  -- X positon of Chart
      p_y => 20,  -- Y positon of Chart
      p_w => 100, -- with of Chart
      p_h => 100, -- height of Chart
	  p_title_position => 'B', -- position of title=Bottom
	  p_frame => true, -- draw frame
	  p_margin => 2 -- margins of Chart
      );

	plpdf_chart.SetArea(45,45);

	for l_i in 1..l_data.count loop
	  l_sum := l_sum + l_data(l_i).value;
	end loop;


	for l_i in 1..l_data.count loop
    plpdf_chart.DrawSector(
      -- p_xc => ,
      -- p_yc => ,
      p_r => 30,
      p_a => l_start * 360,
      p_b => (l_start + l_data(l_i).value / l_sum) * 360,
      p_style => 'F',
      p_legend_position => 'O',
      p_legend => l_data(l_i).label,
      -- p_lw => ,
      -- p_lc => ,
      p_fc => l_data(l_i).color
      -- p_pattern => ,
      );

	  l_start := l_start + l_data(l_i).value / l_sum;
    end loop;

	plpdf_chart.PrintTitle( -- Print title of chart
	  p_text => 'Title of Chart', -- text of title
	  p_align => 'C', -- align: Center
	  p_left => 'M' -- start of cell: Margin
	  );

	plpdf_chart.DrawTitleSeparator; -- Draw separator line between title and Chart-area

    plpdf_chart.EndDiagram; -- close creation

    Plpdf.SendDoc(l_blob); -- create content

	-- or store
	INSERT INTO STORE_BLOB (blob_file, created_date) VALUES (l_blob, SYSDATE);
	COMMIT;
 END;
/
