CREATE OR REPLACE PROCEDURE Test_chart_line IS

  l_data plpdf_type.t_points;
  l_blob BLOB;
 BEGIN
    Plpdf.init;

	plpdf.CrTillingPattern('circlep',4,4);
	plpdf.AddCircle2Pattern('circlep',2,2,2,'F');


    Plpdf.NewPage;
    Plpdf.SetPrintFont('Arial',NULL,8); -- set font attributes: family: Arial, style: regular, font size: 8

	-- set values of diagram items
    l_data(1).x := 10; l_data(1).y := 20;
    l_data(2).x := 20; l_data(2).y := 30;
	l_data(3).x := 30; l_data(3).y := 12;
	l_data(4).x := 40; l_data(4).y := 37;


	plpdf_chart.Init(
      p_x => 20,  -- X positon of Chart
      p_y => 20,  -- Y positon of Chart
      p_w => 95, -- with of Chart
      p_h => 85, -- height of Chart
	  p_title_position => 'B', -- position of title=Bottom
	  p_frame => true, -- draw frame
	  p_margin => 2 -- margins of Chart
      );

	plpdf_chart.SetArea(2+5,2+5,70,0,55,0); -- Set Origo with gap+marign

      plpdf_chart.DrawGrid( -- Draw lines
        p_gap => 10
        );

	 plpdf_chart.DrawLine(
	   p_points => l_data,
       p_lw => 0.5,
       p_lc => plpdf_const.Red,
       p_fc => plpdf_const.Dark_khaki,
        p_pattern => 'circlep',
       p_style => 'DF'
       );

   plpdf_chart.DrawXLegend( -- print label of Y axis
    p_pointer_length => 2, -- length of pointer
    p_gap => 10, -- gap between lines
    p_inc => 10 -- multiplier
    );

  plpdf_chart.DrawYLegend( -- print label of Y axis
    p_pointer_length => 2, -- length of pointer
    p_gap => 10, -- gap between lines
    p_inc => 10 -- multiplier
    );

    plpdf_chart.DrawXAxis( -- draw X axis
	  p_label => 'X axis',  -- label of axis
	  p_lw => 0.5  -- LineWidth
	  );

	plpdf_chart.DrawYAxis( -- draw Y axis
	  p_label => 'Y axis',  -- label of axis
	  p_lw => 0.5  -- LineWidth
	  );

	plpdf_chart.PrintTitle( -- Print title of chart
	  p_text => 'Title of Chart', -- text of title
	  p_align => 'C', -- align: Center
	  p_left => 'M' -- start of cell: Margin
	  );

	plpdf_chart.DrawTitleSeparator; -- Draw separator line between title and Chart-area

    plpdf_chart.EndDiagram; -- close creation

    Plpdf.SendDoc(l_blob); -- create content

	-- or store
	INSERT INTO STORE_BLOB (blob_file, created_date) VALUES (l_blob, SYSDATE);
	COMMIT;
 END;
/
