CREATE OR REPLACE PROCEDURE Test_chart_bar IS

  l_data plpdf_chart.t_dg;
  l_blob BLOB;
 BEGIN
    Plpdf.init;

	plpdf.CrTillingPattern('rectp',4,4);
	plpdf.AddRect2Pattern('rectp',0,0,2,2,'F');
	plpdf.AddRect2Pattern('rectp',2,2,2,2,'D');

    Plpdf.NewPage;
    Plpdf.SetPrintFont('Arial',NULL,8); -- set font attributes: family: Arial, style: regular, font size: 8

	-- set values of diagram items
    l_data(1).value := 20; l_data(1).label := 'apple'; l_data(1).color := plpdf_const.Dark_turquoise; l_data(1).pattern := 'rectp';
    l_data(2).value := 30; l_data(2).label := 'pear'; l_data(2).color := plpdf_const.Indigo;
	l_data(3).value := 12; l_data(3).label := 'plum'; l_data(3).color := plpdf_const.Lime_green;
	l_data(4).value := 37; l_data(4).label := 'banana'; l_data(4).color := plpdf_const.Pink;


	plpdf_chart.Init(
      p_x => 20,  -- X positon of Chart
      p_y => 20,  -- Y positon of Chart
      p_w => 100, -- with of Chart
      p_h => 100, -- height of Chart
	  p_title_position => 'T', -- position of title=Top
	  p_frame => true, -- draw frame
	  p_margin => 2 -- margins of Chart
      );

	plpdf_chart.SetArea(2+5,2+5,70,0,55,0); -- Set Origo with gap+marign

      plpdf_chart.DrawGridY( -- Draw lines
        p_gap => 10,
		p_dash => 2
        );

	 for l_i in 1..l_data.count loop
	 plpdf_chart.DrawBar( -- Draw bars with diagram data
	   p_x_offset => (l_i - 1) * 15,
       p_y_offset => 0,
       p_w => 10,
       p_h => l_data(l_i).value,
       p_style => 'F',
       p_legend_position => 'T',
       p_legend => l_data(l_i).label,
       -- p_lw => ,
       -- p_lc => ,
       p_fc => l_data(l_i).color,
       p_pattern => l_data(l_i).pattern
       );
	 end loop;

  plpdf_chart.DrawYLegend( -- print label of Y axis
    p_pointer_length => 2, -- length of pointer
    p_gap => 10, -- gap between lines
    p_inc => 10 -- multiplier
    );

    plpdf_chart.DrawXAxis( -- draw X axis
	  p_label => 'X axis',  -- label of axis
	  p_lw => 0.5  -- LineWidth
	  );

	plpdf_chart.DrawYAxis( -- draw Y axis
	  p_label => 'Y axis',  -- label of axis
	  p_lw => 0.5  -- LineWidth
	  );

	plpdf_chart.PrintTitle( -- Print title of chart
	  p_text => 'Title of Chart', -- text of title
	  p_align => 'C', -- align: Center
	  p_left => 'M' -- start of cell: Margin
	  );

	plpdf_chart.DrawTitleSeparator; -- Draw separator line between title and Chart-area

  plpdf_chart.PrintLegend1( -- print legend
    p_title => 'Label of colors', -- title
    p_title_position => 'T', -- Top
    p_frame => true, -- draw frame: yes
    p_x_position => 'R', -- Right
    p_y_position => 'T', -- Top
    p_data => l_data -- data
    );

    plpdf_chart.EndDiagram; -- close creation

    Plpdf.SendDoc(l_blob); -- create content

	-- or store
	INSERT INTO STORE_BLOB (blob_file, created_date) VALUES (l_blob, SYSDATE);
	COMMIT;
 END;
/
