create or replace package plpdf_barcode is
/**
  <config>
    <pck-name>PL/PDF Barcode</pck-name>
    <pck-title>User's Guide</pck-title>
    <pck-version>v2.7.0</pck-version>
    <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
    <header-size>10</header-size>
    <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
    <footer-size>10</footer-size>
  </config>
*/

/**
  <h2>Code39</h2>
  <type>Procedure</type>
  <desc>
    Create "Code39" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure Code39(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number,
  p_gap number  default null
  );

/**
  <h2>EAN13</h2>
  <type>Procedure</type>
  <desc>
    Create "EAN13" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure EAN13(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number,
  p_gap number  default null
  );

/**
  <h2>UPC_A</h2>
  <type>Procedure</type>
  <desc>
    Create "UPC-A" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure UPC_A(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number,
  p_gap number  default null
  );

/**
  <h2>b2of5</h2>
  <type>Procedure</type>
  <desc>
    Create "2 of 5 interleaved code" barcodes.
  </desc>
  <version>v1.2.3</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_gap number  default null</param-def>
      <param-desc>gap between barcode and text. null = no print text</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure b2of5(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number,
  p_gap number  default null
  );

/**
  <h2>pdf417</h2>
  <type>Procedure</type>
  <desc>
    Create "PDF417" barcodes.
  </desc>
  <version>v2.3.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
    <param>
      <param-def>p_secu number default -1</param-def>
      <param-desc>The hoped scurity level, -1 = automatic</param-desc>
    </param>
    <param>
      <param-def>p_nbcol number default -1</param-def>
      <param-desc>The hoped number of data MC columns, -1 = automatic</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure pdf417(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number,
  p_secu number default -1,
  p_nbcol number default -1
  );

/**
  <h2>PostNet</h2>
  <type>Procedure</type>
  <desc>
    Create "PostNet" barcodes.
  </desc>
  <version>v1.3.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_zipcode varchar2</param-def>
      <param-desc>zipcode for barcode. Zipcode form is "99999" or "99999-9999"</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure PostNet(
  p_x number,
  p_y number,
  p_zipcode varchar2
  );

/**
  <h2>code128</h2>
  <type>Procedure</type>
  <desc>
    Create "Code128" barcodes. see <link>http://www.adams1.com/pub/russadam/128code.html</link>
  </desc>
  <version>v2.1.1</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_basewidth number</param-def>
      <param-desc>width of a bar</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure code128(
  p_x number,
  p_y number,
  p_code varchar2,
  p_basewidth number,
  p_height number
  );

/**
  <h2>code128w</h2>
  <type>Procedure</type>
  <desc>
    Create "Code128" barcodes. see <link>http://www.adams1.com/pub/russadam/128code.html</link>
  </desc>
  <version>v2.0.0</version>
  <params>
    <param>
      <param-def>p_x number</param-def>
      <param-desc>X coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_y number</param-def>
      <param-desc>Y coordinate for the top left corner of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_code varchar2</param-def>
      <param-desc>value of barcode</param-desc>
    </param>
    <param>
      <param-def>p_width number</param-def>
      <param-desc>width of the barcode</param-desc>
    </param>
    <param>
      <param-def>p_height number</param-def>
      <param-desc>height of a bar</param-desc>
    </param>
  </params>
  <return>-</return>
*/
procedure code128w(
  p_x number,
  p_y number,
  p_code varchar2,
  p_width number,
  p_height number
  );

-- code128 FULL A, B, C
procedure code128ABC(
  p_x         number,
  p_y         number,
  p_code      varchar2,
  p_width     number,
  p_height    number
  );

end;
/

