CREATE OR REPLACE procedure templatepage is
 /* Generates template */

  l_blob blob;
 begin

/* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => 'B',        -- Font style: regular (default)
     p_size => 72            -- Font size: 12 pt
     );
    
    /* Sets the text color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet. */
    plpdf.SetColor4Text(
     p_r => 255,           -- Red component code, can be between 0 and 255
     p_g => 230,            -- Green component code, can be between 0 and 255
     p_b => 230             -- Blue component code, can be between 0 and 255
     );	    
 
    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 25,                 -- X coordinate
     p_y => 10                  -- y coordinate
    );
 
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 160,              -- Rectangle width
     p_h => 50,              -- Rectangle heigth
     p_txt => 'TEMPLATE!' -- Text in rectangle 
     ); 
    
    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 25,                 -- X coordinate
     p_y => 110                  -- y coordinate
    );
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 160,              -- Rectangle width
     p_h => 50,              -- Rectangle heigth
     p_txt => 'TEMPLATE!' -- Text in rectangle 
     ); 
     
     /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 25,                 -- X coordinate
     p_y => 210                  -- y coordinate
    );
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 160,              -- Rectangle width
     p_h => 50,              -- Rectangle heigth
     p_txt => 'TEMPLATE!' -- Text in rectangle 
     ); 
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
    
 end;
/