CREATE OR REPLACE procedure xfooter_toc_2 is
begin
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => 'I',        -- Font style: regular (default)
     p_size => 8            -- Font size: 12 pt
     ); 
    
    /* CurrentPageNumber: Returns the page number of the current page. */
    if plpdf.CurrentPageNumber > 1 then -- If true then cover page
      /*Number of page*/
      /* Draws a rectangle cell with text inside. */
      plpdf.PrintCell(
       p_w => 0,                          -- Rectangle width
       p_h => 10,                         -- Rectangle heigth
       p_txt => To_CHAR(plpdf.CurrentPageNumber -1), -- Text in rectangle 
       p_border => '0',                   -- Without frame
       p_ln => '0',                       -- Cursor position after the cell is printed: Beside the cell  
       p_align => 'C'                     -- Alignment: Center
       ); 
    end if;  
end;
/
