CREATE OR REPLACE procedure toc_coverpage is 
    /* 44. Example: Cover page and table of contents on second page */
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /*Sets the page header procedure name. The program name passed 
      as a parameter executes when the page header is created. */
    plpdf.SetHeaderProcName(
     p_proc_name => 'xheader_toc_1',    -- Page header procedure name
     p_height => 10                     -- Height of header section
     );
    
    /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
    plpdf.SetFooterProcName(
     p_proc_name => 'xfooter_toc_2',    --Page footer procedure name
     p_height => 10                     --Height of footer section
     );
   
    
    /* Cover Page */   
   
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => 'B',                    -- Font style: Bold
     p_size => 14                       -- Font size: 14 pt
     ); 
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Cover Page'              -- Text in rectangle 
     );
   
    
    /* Page 1 */
   
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Add Table of Contents item. */
    plpdf.AddTOCItem(
     p_txt => 'TOC 1'                   -- Label of TOC item
     );
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     ); 
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Page 1'                  -- Text in rectangle 
     );
   
    
    /* Page 2 */
     
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Add Table of Contents item. */
    plpdf.AddTOCItem(
     p_txt => 'TOC 2'                   -- Label of TOC item
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Page 2'                  -- Text in rectangle 
     );
   
   
    /* Page 3 */
     
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Add Table of Contents item. */
    plpdf.AddTOCItem(
     p_txt => 'TOC 3'                   -- Label of TOC item
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Page 3'                  -- Text in rectangle 
     );
    
    /* Construct Table of Contents. */  
    plpdf.AddTOC(
     p_item_height => 10,               -- Height of TOC item cell
     p_title_font_family => 'Courier',  -- Font family of title text
     p_title_font_style => 'BU',        -- Font style of title text
     p_title_font_size => 15,           -- Font size of title text
     p_title_height => 20,              -- Height of title's cell
     p_title_text => 'Table of Contents',  -- Title of TOC
     p_title_body_gap => 20,            -- Gap between title and TOC items
     p_separator => '.',                -- Filler between TOC item and page number
     p_move_to => 2                     -- Move TOC pages to a new page number in PDF
     );
   
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
