CREATE OR REPLACE procedure pagenumber is
    /* 34. Example: Page Number 

   Logical Page | Command | PageNo
   1              -         1/2
   2              end       2/2
   3              -         -
   4              -         -
   5              start     1/4
   6              -         2/4
   7              -         3/3
   8              -         4/4
   9              start     1/2
   10             -         2/2  */ 
  
  l_blob blob;
 begin    
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
	    
    /* Defines the page number alias. 
       Default: {nb} */    
    plpdf.nopAlias;
    
    /*Sets the page header procedure name. The program name passed 
      as a parameter executes when the page header is created. */
    plpdf.SetHeaderProcName(
     p_proc_name => 'xheader',    -- Page header procedure name: xheader
     p_height => 10               -- Height of header section
     );
    
    /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
    plpdf.SetFooterProcName(
     p_proc_name => 'xxfooter',   --Page footer procedure name: xfooter
     p_height => 10               --Height of footer section
     ); 
     
    
    /* Page 1, PageNo. 1/2 */
     
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',         -- Font family: Arial
     p_style => null,             -- Font style: regular (default)
     p_size => 12                 -- Font size: 12 pt
     ); 
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 1'            -- Text in rectangle 
     ); 
	   
           
    
    /* Page 2, PageNo. 2/2 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets end of page numbering to the current page. */
    plpdf.SetPageNoEnd;
	   
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 2'            -- Text in rectangle 
     );



    /* Page 3, PageNo. -- */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
           
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 3'            -- Text in rectangle 
     );
	   
    
    
    /* Page 4, PageNo. -- */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
           
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 4'            -- Text in rectangle 
     );
	   
    
    
    /* Page 5, PageNo. 1/4 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
      
    /* Sets start of page numbering to the current page. */
    plpdf.SetPageNoStart;
         
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 5'            -- Text in rectangle 
     );
          
	   
    
    /* Page 6, PageNo. 2/4 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
           
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 6'            -- Text in rectangle 
     );
    
    
    
    /* Page 7, PageNo. 3/4 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
           
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 7'            -- Text in rectangle 
     );
	   
    
    
    /* Page 8, PageNo. 4/4 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
           
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 8'            -- Text in rectangle 
     );
	   
    
    
    /* Page 9, PageNo. 1/2 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
      
    /* Sets start of page numbering to the current page. */
    plpdf.SetPageNoStart;
         
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 9'            -- Text in rectangle 
     );
	   
    
    
    /* Page 10, PageNo. 2/2 */
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
      
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Page 10'           -- Text in rectangle 
     );
    
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob             -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
end;
/
