CREATE OR REPLACE procedure attachfile is
    /* 33. Example: AttachFile */
 
  l_blob blob;
  l_pdf blob;
 begin
   
    /* Select another PDF into l_pdf */ 
    select blob_file
      into l_pdf
     from store_BLOB
     where rownum < 2;
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Attachs a file to the PDF document. */
    plpdf.AttachFile(
     p_filename => 'test.pdf',        -- Name of file
     p_fileblob => l_pdf              -- BLOB containing the PDF as binary data 
     );
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',             -- Font family: Arial
     p_style => null,                 -- Font style: regular (default)
     p_size => 12                     -- Font size: 12 pt
     ); 
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 80,                       -- Rectangle width
     p_h => 10,                       -- Rectangle heigth
     p_txt => 'Attached File Exmaple' -- Text in rectangle 
     );
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                 -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
