CREATE OR REPLACE procedure pattern is
    /* 32. Example: Pattern */

  l_blob blob;
 begin
   
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Create pattern: line */
    
    /* Starts of define a Tilling Pattern. 
       Tiling patterns consist of a small graphical figure 
       (called a pattern cell) that is replicated at fixed 
       horizontal and vertical intervals to fill the area to
       be painted.*/
    plpdf.CrTillingPattern(
     p_name => 'line',          -- Name of pattern
     p_width => 5,              -- Width of pattern 
     p_height => 5              -- Height of pattern
     );
    
    /* Add a line to the pattern. */   
    plpdf.AddLine2Pattern(
     p_name => 'line',          -- Name of pattern
     p_x1 => 0,                 -- X coordinate for the start of the line 
     p_y1 => 0,                 -- Y coordinate for the start of the line
     p_x2 => 5,                 -- X coordinate for the end of the line
     p_y2 => 5                  -- Y coordinate for the end of the line
     );

    
    
    /* Create pattern: chequer */
  
    /* Starts of define a Tilling Pattern. */
    plpdf.CrTillingPattern(
     p_name => 'chequer',       -- Name of pattern
     p_width => 4,              -- Width of pattern 
     p_height => 4              -- Height of pattern
     );
    
    /* Add a rectangle to the pattern. */ 
    plpdf.AddRect2Pattern(
     p_name => 'chequer',       -- Name of pattern
     p_x => 0,                  -- X coordinate for the top left corner of the rectangle
     p_y => 0,                  -- Y coordinate for the top left corner of the rectangle
     p_w => 2,                  -- The width of the rectangle
     p_h => 2,                  -- The height of the rectangle
     p_style => 'F'             -- Style: Fill
     );
    
    /* Add a rectangle to the pattern. */ 
    plpdf.AddRect2Pattern(
     p_name => 'chequer',       -- Name of pattern
     p_x => 2,                  -- X coordinate for the top left corner of the rectangle
     p_y => 2,                  -- Y coordinate for the top left corner of the rectangle
     p_w => 2,                  -- The width of the rectangle
     p_h => 2,                  -- The height of the rectangle
     p_style => 'F'             -- Style: Fill
     );

    
    
    /* Create pattern: halfchequer */
	  
    /* Starts of define a Tilling Pattern. */
    plpdf.CrTillingPattern(
     p_name => 'halfchequer',   -- Name of pattern
     p_width => 4,              -- Width of pattern 
     p_height => 4              -- Height of pattern
     );      
     
     /* Add a rectangle to the pattern. */ 
    plpdf.AddRect2Pattern(
     p_name => 'halfchequer',   -- Name of pattern
     p_x => 0,                  -- X coordinate for the top left corner of the rectangle
     p_y => 0,                  -- Y coordinate for the top left corner of the rectangle
     p_w => 2,                  -- The width of the rectangle
     p_h => 2,                  -- The height of the rectangle
     p_style => 'F'             -- Style: Fill
     );     

    /* Add a rectangle to the pattern. */ 
    plpdf.AddRect2Pattern(
     p_name => 'halfchequer',   -- Name of pattern
     p_x => 2,                  -- X coordinate for the top left corner of the rectangle
     p_y => 2,                  -- Y coordinate for the top left corner of the rectangle
     p_w => 2,                  -- The width of the rectangle
     p_h => 2,                  -- The height of the rectangle
     p_style => 'D'             -- Style: No fill, border line
     );
     
     
     
    /* Create pattern: circle */

    /* Starts of define a Tilling Pattern. */
    plpdf.CrTillingPattern(
     p_name => 'circle',        -- Name of pattern
     p_width => 5,              -- Width of pattern 
     p_height => 5              -- Height of pattern
     ); 
    
    /* Add a circle to the pattern. */ 
    plpdf.AddCircle2Pattern(
     p_name => 'circle',        -- Name of pattern
     p_x => 5/2,                -- X coordinate of the center of the circle
     p_y => 5/2,                -- Y coordinate of the center of the circle
     p_r => 2,                  -- The radius of the circle
     p_style => 'D'             -- Style: No fill, border line
     );
    
    /* Add a circle to the pattern. */ 
    plpdf.AddCircle2Pattern(
     p_name => 'circle',        -- Name of pattern
     p_x => 0,                  -- X coordinate of the center of the circle
     p_y => 5/2,                -- Y coordinate of the center of the circle
     p_r => 2,                  -- The radius of the circle
     p_style => 'D'             -- Style: No fill, border line
     );
    
    /* Add a circle to the pattern. */ 
    plpdf.AddCircle2Pattern(
     p_name => 'circle',        -- Name of pattern
     p_x => 5,                  -- X coordinate of the center of the circle
     p_y => 5/2,                -- Y coordinate of the center of the circle
     p_r => 2,                  -- The radius of the circle
     p_style => 'D'             -- Style: No fill, border line
     );
	
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',       -- Font family: Arial
     p_style => null,           -- Font style: regular (default)
     p_size => 12               -- Font size: 12 pt
     ); 

    
    
    /* Draw pattern: line*/
    
    /* Sets the fill pattern for objects inserted after this statement. */
    plpdf.SetTillingPattern(
     p_name => 'line',              -- Name of pattern 
     p_color => plpdf_const.Salmon  -- Color of graphical figures
     );
    
    /* Draws a rectangle on the page */  
    plpdf.DrawRect(
     p_x => 10,                 -- X coordinate for the top left corner of the rectangle
     p_y => 10,                 -- Y coordinate for the top left corner of the rectangle
     p_w => 40,                 -- The width of the rectangle
     p_h => 40,                 -- The height of the rectangle
     p_style => 'FD'            -- Style: Fill, border line
     );
    
    /* Draw pattern: chequer */
    
    /* Sets the fill pattern for objects inserted after this statement. */
    plpdf.SetTillingPattern(
     p_name => 'chequer',           -- Name of pattern 
     p_color => plpdf_const.Black   -- Color of graphical figures
     );
    
    /* Draws a rectangle on the page */  
    plpdf.DrawRect(
     p_x => 10,                 -- X coordinate for the top left corner of the rectangle
     p_y => 60,                 -- Y coordinate for the top left corner of the rectangle
     p_w => 40,                 -- The width of the rectangle
     p_h => 40,                 -- The height of the rectangle
     p_style => 'FD'            -- Style: Fill, border line
     );



    /* Draw pattern: halfchequer */
    
    /* Sets the fill pattern for objects inserted after this statement. */
    plpdf.SetTillingPattern(
     p_name => 'halfchequer',           -- Name of pattern 
     p_color => plpdf_const.Royal_blue  -- Color of graphical figures
     );
    
    /* Draws a rectangle on the page */  
    plpdf.DrawRect(
     p_x => 10,                 -- X coordinate for the top left corner of the rectangle
     p_y => 110,                -- Y coordinate for the top left corner of the rectangle
     p_w => 40,                 -- The width of the rectangle
     p_h => 40,                 -- The height of the rectangle
     p_style => 'FD'            -- Style: Fill, border line
     );	
     
     
     
     /* Draw pattern: circle */
    
    /* Sets the fill pattern for objects inserted after this statement. */
    plpdf.SetTillingPattern(
     p_name => 'circle',                  -- Name of pattern 
     p_color => plpdf_const.Yellow_green  -- Color of graphical figures
     );
    
    /* Draws a rectangle on the page */  
    plpdf.DrawRect(
     p_x => 10,                 -- X coordinate for the top left corner of the rectangle
     p_y => 160,                -- Y coordinate for the top left corner of the rectangle
     p_w => 40,                 -- The width of the rectangle
     p_h => 40,                 -- The height of the rectangle
     p_style => 'FD'            -- Style: Fill, border line
     );	

    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 70,                 -- X coordinate
     p_y => 25                  -- y coordinate
    );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and specified fill. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Line pattern'    -- Text in rectangle 
     );       

    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 70,                 -- X coordinate
     p_y => 75                  -- y coordinate
    );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and specified fill. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Chequer pattern' -- Text in rectangle 
     );          

    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 70,                 -- X coordinate
     p_y => 125                 -- y coordinate
    );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and specified fill. */
    plpdf.PrintCell(
     p_w => 50,                       -- Rectangle width
     p_h => 10,                       -- Rectangle heigth
     p_txt => 'Half-chequer pattern'  -- Text in rectangle 
     );	  
	  
    /* Places the cursor at the X and Y coordinate. */
    plpdf.SetCurrentXY(
     p_x => 70,                 -- X coordinate
     p_y => 175                 -- y coordinate
    );
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                 -- Rectangle width
     p_h => 10,                 -- Rectangle heigth
     p_txt => 'Circle pattern'  -- Text in rectangle 
     );	

    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
