CREATE OR REPLACE procedure drawpolygon is
    /* 31. Example: DrawPolygon */

  l_blob blob;
  l_points plpdf_type.t_points;
 begin
    
    for l_i in 1..6 loop
      /* Generates random coordinates */
      l_points(l_i).x := dbms_random.value(10,100);
      l_points(l_i).y := dbms_random.value(10,100);
    end loop;
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Draws a lines (polygon) between the points on the page. */
    plpdf.DrawPolygon(
     p_points => l_points -- set of ordered points
     );
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
