CREATE OR REPLACE procedure dashpattern is
    /* 30. Example: DashPattern */
 
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 20,        -- X coordinate for the start of the line
     p_y1 => 20,        -- Y coordinate for the start of the line
     p_x2 => 100,       -- X coordinate for the end of the line
     p_y2 => 20         -- Y coordinate for the end of the line
     ); 
    
    /* Sets the dash pattern for lines inserted after thisstatement. */
    plpdf.SetDashPattern(
     p_line => 5,       -- Length of dashes
     p_noline => 2      -- length of gaps
     ); 
    
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 20,        -- X coordinate for the start of the line
     p_y1 => 40,        -- Y coordinate for the start of the line
     p_x2 => 100,       -- X coordinate for the end of the line
     p_y2 => 40         -- Y coordinate for the end of the line
     ); 
   
    /* Sets the thickness of lines drawn after this statement. */
    plpdf.SetLineWidth(
     p_width => 1       -- Line thickness: 1mm
     ); 
    
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 20,        -- X coordinate for the start of the line
     p_y1 => 60,        -- Y coordinate for the start of the line
     p_x2 => 100,       -- X coordinate for the end of the line
     p_y2 => 60         -- Y coordinate for the end of the line
     ); 
    
    /* Sets the dash pattern for lines inserted after thisstatement.
       Call the procedure without parameter to restore normal drawing. */
    plpdf.SetDashPattern();
    
    /* Draws a line between the two positions on the page. */
    plpdf.DrawLine(
     p_x1 => 20,        -- X coordinate for the start of the line
     p_y1 => 80,        -- Y coordinate for the start of the line
     p_x2 => 100,       -- X coordinate for the end of the line
     p_y2 => 80         -- Y coordinate for the end of the line
     ); 
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob   -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
