CREATE OR REPLACE procedure imagecell is
    /* 29. Example: ImageCell */
 
  l_blob blob;
  l_image blob;
 begin
    
    /* Select image from a table.
       Needs table IMAGE_BLOB(id number, image_file blob).
       Image_file must contain image. */
    select image_file
       into l_image
      from image_blob
      where id = 1
      for update;
 
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init;
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',                   -- Font family: Arial
     p_style => null,                       -- Font style: regular (default)
     p_size => 12                           -- Font size: 12 pt
     );   
    
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                             -- Rectangle width
     p_h => 10,                             -- Rectangle heigth
     p_txt => 'ImageCell'                   -- Text in rectangle 
     ); 
      
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_color => plpdf_const.Dark_turquoise  -- Color
     ); 
     
   
    /* Print an image with frame. */
    plpdf.PrintImageCell(
     p_w => 50,                             -- Width of frame
     p_h => 50,                             -- Height of frame
     p_name => 'Image4 ',                   -- Name of image
     p_data =>  l_image,                    -- Variable containing the image as binary data
     p_margin =>     5,                     -- Margin size of frame
     p_border => '1',                       -- Rectangle border
     p_ln => 0,                             -- Cursor position after the cell is printed
     p_fill =>   1,                         -- Fill
     p_link => 'http://www.oracle.com'      -- URL 
     );
     
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                       -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
