CREATE OR REPLACE procedure printrow is
    /* 21. Example: Print rows with PLPDF.Row_Print and PLPDF.Row_Print2 */
    
  l_blob      blob;
  l_border    char(1);                    -- Actual border
  l_fill      number;                     -- Filling
  l_datas     plpdf_type.t_row_datas;     -- Array of datas
  l_borders   plpdf_type.t_row_borders;   -- Array of borders
  l_widths    plpdf_type.t_row_widths;    -- Array of widths
  l_aligns    plpdf_type.t_row_aligns;    -- Array of aligns
  l_styles    plpdf_type.t_row_styles;    -- Array of styles
  l_maxlines  plpdf_type.t_row_maxlines;  -- Array of max lines
  
  
 begin
   
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
	 
    /* Set columns widths */
    l_widths(1) := 30;
    l_widths(2) := 40;
    l_widths(3) := 100;
	 
    /* Set columns aligns */
    l_aligns(1) := 'R';          -- Right
    l_aligns(2) := 'C';          -- Center
    l_aligns(3) := 'L';          -- Left
	
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => 'B',             -- Font style: Bold
     p_size => 12                -- Font size: 12 pt
     ); 
     
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 200,                 -- Red component code, can be between 0 and 255
     p_g => 220,                 -- Green component code, can be between 0 and 255
     p_b => 255                  -- Blue component code, can be between 0 and 255
     ); 	
        
    
    
    /* Print rows with PLPDF.Row_Print */
    
    /* Print headers */
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(1),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'ROWNUM',          -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(2),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OWNER',           -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(3),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OBJECT NAME',     -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '1',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
        
         
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: regular (default)
     p_size => 12                -- Font size: 12 pt
     ); 
    
    for f_obj in (select rownum, owner, object_name from all_objects where rownum <= 10) loop
        /* Set datas */
	l_datas(1) := to_char(f_obj.rownum); 
	l_datas(2) := f_obj.owner;
	l_datas(3) := f_obj.object_name;    
       
        /* Print datas*/
        
        /* Prints a full row in the PDF document. 
           The rows consist of multi-line cells. 
           The rows height is set according to the largest cell */
        plpdf.Row_Print(
        p_data => l_datas,       -- Data shown in the cells
        p_width => l_widths,     -- Width of the cells
        p_align => l_aligns      -- Alignment of the cells
        );
    end loop;
	
    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 40                  -- Height of the line break.
     );     
    
    
    
    /* Print rows with PLPDF.Row_Print2 */     
    
    /* Print headers */
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => 'B',             -- Font style: Bold
     p_size => 12                -- Font size: 12 pt
     );
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(1),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'ROWNUM',          -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(2),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OWNER',           -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
     
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(3),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OBJECT NAME',     -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '1',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
     
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 245,                 -- Red component code, can be between 0 and 255
     p_g => 245,                 -- Green component code, can be between 0 and 255
     p_b => 255                  -- Blue component code, can be between 0 and 255
     );   
     
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: regular (default)
     p_size => 12                -- Font size: 12 pt
     );
         
    for f_obj in (select rownum, owner, object_name from all_objects where rownum <= 10) loop
        /* Set datas */
	l_datas(1) := to_char(f_obj.rownum); 
	l_datas(2) := f_obj.owner;
	l_datas(3) := f_obj.object_name;    
        
        
        if mod(f_obj.rownum,2)=1 then
              /* Odd line */
              l_border:='0';
              l_fill:=1;
          else
              /* Even line */
              l_border:='1';
              l_fill:=0;
        end if;
                
        /* Set columns borders */
        l_borders(1) := l_border;       
        l_borders(2) := l_border;
        l_borders(3) := l_border;
       
        /* Print datas*/
        
        /* Prints a full row in the PDF document. 
           The rows consist of multi-line cells. 
           The rows height is set according to the largest cell */
        plpdf.Row_Print2(
         p_data => l_datas,       -- Data shown in the cells
         p_border => l_borders,   -- Border array of the cells
         p_width => l_widths,     -- Width of the cells
         p_align => l_aligns,     -- Alignment of the cells
         p_style => l_styles,     -- Style of the cells
         p_maxline => l_maxlines, -- Maximum number of lines in a multi-line cell
         p_fill => l_fill         -- Fill
         );
    end loop;
	
        
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob            -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
