CREATE OR REPLACE procedure ellipsecircle is
    /* 19. Example: Print ellipse, circle */
  
  l_blob blob;
 begin
   
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     ); 
	/* Draws an ellipse on the current page 
         - style: draw (default) */
        plpdf.DrawEllipse(
        p_x => 50, -- X coordinate of the center of the ellipse
        p_y => 50, -- Y coordinate of the center of the ellipse
        p_rx => 20, -- Horizontal radius of the ellipse
        p_ry => 10 -- Vertical radius of the ellipse
        ); 
        
	--plpdf.SetColor4Filling(0,0,255); -- set color for filling (RGB)	
        /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 0,              -- Red component code, can be between 0 and 255
     p_g => 0,              -- Green component code, can be between 0 and 255
     p_b => 255             -- Blue component code, can be between 0 and 255
     ); 
     
    /* Draws a circle on the current page */
    plpdf.Drawcircle(
    p_x => 100, -- X coordinate of the center of the circle
    p_y => 100, -- Y coordinate of the center of the circle
    p_r => 10,  -- The radius of the circle
    p_style => 'DF' -- Style: Fill and border line
    );					  	
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

