CREATE OR REPLACE procedure drawrect is
    /* 15. Example: Draw rectangle*/
  
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 

    for i in 1..20 loop
      
      /* Sets the line color for objects (line, rectangle, circle etc.) 
         inserted after this statement. */
      plpdf.SetColor4Drawing(
       p_r => i*12,         -- Red component code, can be between 0 and 255
       p_g => 255-(i*12),   -- Green component code, can be between 0 and 255
       p_b => 0             -- Blue component code, can be between 0 and 255
       ); 
	
      /* Draws a rectangle on the page */  
      plpdf.DrawRect(
       p_x => 30-i,         -- X coordinate for the top left corner of the rectangle
       p_y => 30-i,         -- Y coordinate for the top left corner of the rectangle
       p_w => 2*i,          --The width of the rectangle
       p_h => 2*i,          --The height of the rectangle
       p_style => 'D'       -- Style: No fill, border line
       );
       
    end loop;    
	
    /* Sets the line color for objects (line, rectangle, circle etc.) 
       inserted after this statement.
     - p_g: -1 (default)
     - p_b: -1 (default) */
    plpdf.SetColor4Drawing(
     p_r => 0               -- Red component code: 0 (black)
     );    
	
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 0,              -- Red component code, can be between 0 and 255
     p_g => 0,              -- Green component code, can be between 0 and 255
     p_b => 255             -- Blue component code, can be between 0 and 255
     ); 
    
    /* Draws a rectangle on the page */  	
    plpdf.DrawRect(
     p_x => 80,             -- X coordinate for the top left corner of the rectangle
     p_y => 10,             -- Y coordinate for the top left corner of the rectangle
     p_w => 40,             -- The width of the rectangle
     p_h => 40,             -- The height of the rectangle
     p_style => 'DF'        -- Style: fill, border line
     );
	
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob       -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

