CREATE OR REPLACE procedure textwidth is
    /* 13. Example: Get text width */
    
  l_blob blob;
  l_length number;
  l_text varchar2(255);
 begin
   
   /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',  -- Font family: Arial
     p_style => null,      -- Font style: regular (default)
     p_size => 12          -- Font size: 12 pt
     ); 
	
    l_text := 'Hello World!'; 
	
    /* function plpdf.GetTextWidth: 
       Returns the width of the parameter text. 
       The width of the text in the unit of measure specified in plpdf.Init */
    l_length := plpdf.GetTextWidth(
                 p_s => l_text -- Parameter text
                 ); 
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => 80,                -- Rectangle width
     p_h => 10,                -- Rectangle heigth
     p_txt => l_text || ' - text length: ' || to_char(l_length) -- Text 
     ); 

    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

