/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class NumberCommonAccessor
extends Accessor {
    static final boolean GET_XXX_ROUNDS = false;
    int[] digs = new int[27];
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final int LNXEXPMX = 127;
    static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    static final byte MAX_LONG_EXPONENT = 9;
    static final byte MIN_LONG_EXPONENT = 9;
    static final byte MAX_INT_EXPONENT = 4;
    static final byte MIN_INT_EXPONENT = 4;
    static final byte MAX_SHORT_EXPONENT = 2;
    static final byte MIN_SHORT_EXPONENT = 2;
    static final byte MAX_BYTE_EXPONENT = 1;
    static final byte MIN_BYTE_EXPONENT = 1;
    static final int[] MAX_LONG = new int[]{202, 10, 23, 34, 73, 4, 69, 55, 78, 59, 8};
    static int[] MIN_LONG = new int[]{53, 92, 79, 68, 29, 98, 33, 47, 24, 43, 93, 102};
    static int MAX_LONG_length = 11;
    static int MIN_LONG_length = 12;
    static final double[] factorTable = new double[]{1.0E254, 1.0E252, 1.0E250, 1.0E248, 1.0E246, 1.0E244, 1.0E242, 1.0E240, 1.0E238, 1.0E236, 1.0E234, 1.0E232, 1.0E230, 1.0E228, 1.0E226, 1.0E224, 1.0E222, 1.0E220, 1.0E218, 1.0E216, 1.0E214, 1.0E212, 1.0E210, 1.0E208, 1.0E206, 1.0E204, 1.0E202, 1.0E200, 1.0E198, 1.0E196, 1.0E194, 1.0E192, 1.0E190, 1.0E188, 1.0E186, 1.0E184, 1.0E182, 1.0E180, 1.0E178, 1.0E176, 1.0E174, 1.0E172, 1.0E170, 1.0E168, 1.0E166, 1.0E164, 1.0E162, 1.0E160, 1.0E158, 1.0E156, 1.0E154, 1.0E152, 1.0E150, 1.0E148, 1.0E146, 1.0E144, 1.0E142, 1.0E140, 1.0E138, 1.0E136, 1.0E134, 1.0E132, 1.0E130, 1.0E128, 1.0E126, 1.0E124, 1.0E122, 1.0E120, 1.0E118, 1.0E116, 1.0E114, 1.0E112, 1.0E110, 1.0E108, 1.0E106, 1.0E104, 1.0E102, 1.0E100, 1.0E98, 1.0E96, 1.0E94, 1.0E92, 1.0E90, 1.0E88, 1.0E86, 1.0E84, 1.0E82, 1.0E80, 1.0E78, 1.0E76, 1.0E74, 1.0E72, 1.0E70, 1.0E68, 1.0E66, 1.0E64, 1.0E62, 1.0E60, 1.0E58, 1.0E56, 1.0E54, 1.0E52, 1.0E50, 1.0E48, 1.0E46, 1.0E44, 1.0E42, 1.0E40, 1.0E38, 1.0E36, 1.0E34, 1.0E32, 1.0E30, 1.0E28, 1.0E26, 1.0E24, 1.0E22, 1.0E20, 1.0E18, 1.0E16, 1.0E14, 1.0E12, 1.0E10, 1.0E8, 1000000.0, 10000.0, 100.0, 1.0, 0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 1.0E-26, 1.0E-28, 1.0E-30, 1.0E-32, 1.0E-34, 1.0E-36, 1.0E-38, 1.0E-40, 1.0E-42, 1.0E-44, 1.0E-46, 1.0E-48, 1.0E-50, 1.0E-52, 1.0E-54, 1.0E-56, 1.0E-58, 1.0E-60, 1.0E-62, 1.0E-64, 1.0E-66, 1.0E-68, 1.0E-70, 1.0E-72, 1.0E-74, 1.0E-76, 1.0E-78, 1.0E-80, 1.0E-82, 1.0E-84, 1.0E-86, 1.0E-88, 1.0E-90, 1.0E-92, 1.0E-94, 1.0E-96, 1.0E-98, 1.0E-100, 1.0E-102, 1.0E-104, 1.0E-106, 1.0E-108, 1.0E-110, 1.0E-112, 1.0E-114, 1.0E-116, 1.0E-118, 1.0E-120, 1.0E-122, 1.0E-124, 1.0E-126, 1.0E-128, 1.0E-130, 1.0E-132, 1.0E-134, 1.0E-136, 1.0E-138, 1.0E-140, 1.0E-142, 1.0E-144, 1.0E-146, 1.0E-148, 1.0E-150, 1.0E-152, 1.0E-154, 1.0E-156, 1.0E-158, 1.0E-160, 1.0E-162, 1.0E-164, 1.0E-166, 1.0E-168, 1.0E-170, 1.0E-172, 1.0E-174, 1.0E-176, 1.0E-178, 1.0E-180, 1.0E-182, 1.0E-184, 1.0E-186, 1.0E-188, 1.0E-190, 1.0E-192, 1.0E-194, 1.0E-196, 1.0E-198, 1.0E-200, 1.0E-202, 1.0E-204, 1.0E-206, 1.0E-208, 1.0E-210, 1.0E-212, 1.0E-214, 1.0E-216, 1.0E-218, 1.0E-220, 1.0E-222, 1.0E-224, 1.0E-226, 1.0E-228, 1.0E-230, 1.0E-232, 1.0E-234, 1.0E-236, 1.0E-238, 1.0E-240, 1.0E-242, 1.0E-244, 1.0E-246, 1.0E-248, 1.0E-250, 1.0E-252, 1.0E-254};
    static final double[] small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    static final int tablemax = factorTable.length;
    static final double tablemaxexponent = 127.0;
    static final double tableminexponent = 127.0 - (double)(tablemax - 20);
    static final int MANTISSA_SIZE = 53;
    static final int[] expdigs0 = new int[]{25597, 55634, 18440, 18324, 42485, 50370, 56862, 11593, 45703, 57341, 10255, 12549, 59579, 5};
    static final int[] expdigs1 = new int[]{50890, 19916, 24149, 23777, 11324, 41057, 14921, 56274, 30917, 19462, 54968, 47943, 38791, 3872};
    static final int[] expdigs2 = new int[]{24101, 29690, 40218, 29073, 29604, 22037, 27674, 9082, 56670, 55244, 20865, 54874, 47573, 38};
    static final int[] expdigs3 = new int[]{22191, 40873, 1607, 45622, 23883, 24544, 32988, 43530, 61694, 55616, 43150, 32976, 27418, 25379};
    static final int[] expdigs4 = new int[]{55927, 44317, 6569, 54851, 238, 63160, 51447, 12231, 55667, 25459, 5674, 40962, 52047, 253};
    static final int[] expdigs5 = new int[]{56264, 8962, 51839, 64773, 39323, 49783, 15587, 30924, 36601, 56615, 27581, 36454, 35254, 2};
    static final int[] expdigs6 = new int[]{21545, 25466, 59727, 37873, 13099, 7602, 15571, 49963, 37664, 46896, 14328, 59258, 17403, 1663};
    static final int[] expdigs7 = new int[]{12011, 4842, 3874, 57395, 38141, 46606, 49307, 60792, 31833, 21440, 9318, 47123, 41461, 16};
    static final int[] expdigs8 = new int[]{52383, 25023, 56409, 43947, 51036, 17420, 62725, 5735, 53692, 44882, 64439, 36137, 24719, 10900};
    static final int[] expdigs9 = new int[]{65404, 27119, 57580, 26653, 42453, 19179, 26186, 42000, 1847, 62708, 14406, 12813, 247, 109};
    static final int[] expdigs10 = new int[]{36698, 50078, 40552, 35000, 49576, 56552, 261, 49572, 31475, 59609, 45363, 46658, 5900, 1};
    static final int[] expdigs11 = new int[]{33321, 54106, 42443, 60698, 47535, 24088, 45785, 18352, 47026, 40291, 5183, 35843, 24059, 714};
    static final int[] expdigs12 = new int[]{12129, 44450, 22706, 34030, 37175, 8760, 31915, 56544, 23407, 52176, 7260, 41646, 9415, 7};
    static final int[] expdigs13 = new int[]{43054, 17160, 43698, 6780, 36385, 52800, 62346, 52747, 33988, 2855, 31979, 38083, 44325, 4681};
    static final int[] expdigs14 = new int[]{60723, 40803, 16165, 19073, 2985, 9703, 41911, 37227, 41627, 1994, 38986, 27250, 53527, 46};
    static final int[] expdigs15 = new int[]{36481, 57623, 45627, 58488, 53274, 7238, 2063, 31221, 62631, 25319, 35409, 25293, 54667, 30681};
    static final int[] expdigs16 = new int[]{52138, 47106, 3077, 4517, 41165, 38738, 39997, 10142, 13078, 16637, 53438, 54647, 53630, 306};
    static final int[] expdigs17 = new int[]{25425, 24719, 55736, 8564, 12208, 3664, 51518, 17140, 61079, 30312, 2500, 30693, 4468, 3};
    static final int[] expdigs18 = new int[]{58368, 65134, 52675, 3178, 26300, 7986, 11833, 515, 23109, 63525, 29138, 19030, 50114, 2010};
    static final int[] expdigs19 = new int[]{41216, 15724, 12323, 26246, 59245, 58406, 46648, 13767, 11372, 15053, 61895, 48686, 7054, 20};
    static final int[] expdigs20 = new int[]{0, 29248, 62416, 1433, 14025, 43846, 39905, 44375, 137, 47955, 62409, 33386, 48983, 13177};
    static final int[] expdigs21 = new int[]{0, 21264, 53708, 60962, 25043, 64008, 31200, 50906, 9831, 56185, 43877, 36378, 50952, 131};
    static final int[] expdigs22 = new int[]{0, 50020, 25440, 60247, 44814, 39961, 6865, 26068, 34832, 9081, 17478, 44928, 20825, 1};
    static final int[] expdigs23 = new int[]{0, 0, 52929, 10084, 25506, 6346, 61348, 31525, 52689, 61296, 27615, 15903, 40426, 863};
    static final int[] expdigs24 = new int[]{0, 16384, 24122, 53840, 43508, 13170, 51076, 37670, 58198, 31414, 57292, 61762, 41691, 8};
    static final int[] expdigs25 = new int[]{0, 0, 4096, 29077, 42481, 30581, 10617, 59493, 46251, 1892, 5557, 4505, 52391, 5659};
    static final int[] expdigs26 = new int[]{0, 0, 58368, 11431, 1080, 29797, 47947, 36639, 42405, 50481, 29546, 9875, 39190, 56};
    static final int[] expdigs27 = new int[]{0, 0, 0, 57600, 63028, 53094, 12749, 18174, 21993, 48265, 14922, 59933, 4030, 37092};
    static final int[] expdigs28 = new int[]{0, 0, 0, 576, 1941, 35265, 9302, 42780, 50682, 28007, 29640, 28124, 60333, 370};
    static final int[] expdigs29 = new int[]{0, 0, 0, 5904, 8539, 12149, 36793, 43681, 12958, 60573, 21267, 35015, 46478, 3};
    static final int[] expdigs30 = new int[]{0, 0, 0, 0, 7268, 50548, 47962, 3644, 22719, 26999, 41893, 7421, 56711, 2430};
    static final int[] expdigs31 = new int[]{0, 0, 0, 0, 7937, 49002, 60772, 28216, 38893, 55975, 63988, 59711, 20227, 24};
    static final int[] expdigs32 = new int[]{0, 0, 0, 16384, 38090, 63404, 55657, 8801, 62648, 13666, 57656, 60234, 15930};
    static final int[] expdigs33 = new int[]{0, 0, 0, 4096, 37081, 37989, 16940, 55138, 17665, 39458, 9751, 20263, 159};
    static final int[] expdigs34 = new int[]{0, 0, 0, 58368, 35104, 16108, 61773, 14313, 30323, 54789, 57113, 38868, 1};
    static final int[] expdigs35 = new int[]{0, 0, 0, 8448, 18701, 29652, 51080, 65023, 27172, 37903, 3192, 1044};
    static final int[] expdigs36 = new int[]{0, 0, 0, 37440, 63101, 2917, 39177, 50457, 25830, 50186, 28867, 10};
    static final int[] expdigs37 = new int[]{0, 0, 0, 56080, 45850, 37384, 3668, 12301, 38269, 18196, 6842};
    static final int[] expdigs38 = new int[]{0, 0, 0, 46436, 13565, 50181, 34770, 37478, 5625, 27707, 68};
    static final int[] expdigs39 = new int[]{0, 0, 0, 32577, 45355, 38512, 38358, 3651, 36101, 44841};
    static final int[] expdigs40 = new int[]{0, 0, 16384, 28506, 5696, 56746, 15456, 50499, 27230, 448};
    static final int[] expdigs41 = new int[]{0, 0, 4096, 285, 9232, 58239, 57170, 38515, 31729, 4};
    static final int[] expdigs42 = new int[]{0, 0, 58368, 41945, 57108, 12378, 28752, 48226, 2938};
    static final int[] expdigs43 = new int[]{0, 0, 24832, 47605, 49067, 23716, 61891, 25385, 29};
    static final int[] expdigs44 = new int[]{0, 0, 8768, 2442, 50298, 23174, 19624, 19259};
    static final int[] expdigs45 = new int[]{0, 0, 40720, 45899, 1813, 31689, 38862, 192};
    static final int[] expdigs46 = new int[]{0, 0, 36452, 14221, 34752, 48813, 60681, 1};
    static final int[] expdigs47 = new int[]{0, 0, 61313, 34220, 16731, 11629, 1262};
    static final int[] expdigs48 = new int[]{0, 16384, 60906, 18036, 40144, 40748, 12};
    static final int[] expdigs49 = new int[]{0, 4096, 609, 15909, 52830, 8271};
    static final int[] expdigs50 = new int[]{0, 58368, 3282, 56520, 47058, 82};
    static final int[] expdigs51 = new int[]{0, 41216, 52461, 7118, 54210};
    static final int[] expdigs52 = new int[]{0, 45632, 51642, 6624, 542};
    static final int[] expdigs53 = new int[]{0, 25360, 24109, 27591, 5};
    static final int[] expdigs54 = new int[]{0, 42852, 46771, 3552};
    static final int[] expdigs55 = new int[]{0, 28609, 34546, 35};
    static final int[] expdigs56 = new int[]{16384, 4218, 23283};
    static final int[] expdigs57 = new int[]{4096, 54437, 232};
    static final int[] expdigs58 = new int[]{58368, 21515, 2};
    static final int[] expdigs59 = new int[]{57600, 1525};
    static final int[] expdigs60 = new int[]{16960, 15};
    static final int[] expdigs61 = new int[]{10000};
    static final int[] expdigs62 = new int[]{100};
    static final int[] expdigs63 = new int[]{1};
    static final int[] expdigs64 = new int[]{36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 49807, 10485, 36700, 62914, 23592, 655};
    static final int[] expdigs65 = new int[]{14784, 18979, 33659, 19503, 2726, 9542, 629, 2202, 40475, 10590, 4299, 47815, 36280, 6};
    static final int[] expdigs66 = new int[]{16332, 9978, 33613, 31138, 35584, 64252, 13857, 14424, 62281, 46279, 36150, 46573, 63392, 4294};
    static final int[] expdigs67 = new int[]{6716, 24348, 22618, 23904, 21327, 3919, 44703, 19149, 28803, 48959, 6259, 50273, 62237, 42};
    static final int[] expdigs68 = new int[]{8471, 23660, 38254, 26440, 33662, 38879, 9869, 11588, 41479, 23225, 60127, 24310, 32615, 28147};
    static final int[] expdigs69 = new int[]{13191, 6790, 63297, 30410, 12788, 42987, 23691, 28296, 32527, 38898, 41233, 4830, 31128, 281};
    static final int[] expdigs70 = new int[]{4064, 53152, 62236, 29139, 46658, 12881, 31694, 4870, 19986, 24637, 9587, 28884, 53395, 2};
    static final int[] expdigs71 = new int[]{26266, 10526, 16260, 55017, 35680, 40443, 19789, 17356, 30195, 55905, 28426, 63010, 44197, 1844};
    static final int[] expdigs72 = new int[]{38273, 7969, 37518, 26764, 23294, 63974, 18547, 17868, 24550, 41191, 17323, 53714, 29277, 18};
    static final int[] expdigs73 = new int[]{16739, 37738, 38090, 26589, 43521, 1543, 15713, 10671, 11975, 41533, 18106, 9348, 16921, 12089};
    static final int[] expdigs74 = new int[]{14585, 61981, 58707, 16649, 25994, 39992, 28337, 17801, 37475, 22697, 31638, 16477, 58496, 120};
    static final int[] expdigs75 = new int[]{58472, 2585, 40564, 27691, 44824, 27269, 58610, 54572, 35108, 30373, 35050, 10650, 13692, 1};
    static final int[] expdigs76 = new int[]{50392, 58911, 41968, 49557, 29112, 29939, 43526, 63500, 55595, 27220, 25207, 38361, 18456, 792};
    static final int[] expdigs77 = new int[]{26062, 32046, 3696, 45060, 46821, 40931, 50242, 60272, 24148, 20588, 6150, 44948, 60477, 7};
    static final int[] expdigs78 = new int[]{12430, 30407, 320, 41980, 58777, 41755, 41041, 13609, 45167, 13348, 40838, 60354, 19454, 5192};
    static final int[] expdigs79 = new int[]{30926, 26518, 13110, 43018, 54982, 48258, 24658, 15209, 63366, 11929, 20069, 43857, 60487, 51};
    static final int[] expdigs80 = new int[]{51263, 54048, 48761, 48627, 30576, 49046, 4414, 61195, 61755, 48474, 19124, 55906, 15511, 34028};
    static final int[] expdigs81 = new int[]{39834, 11681, 47018, 3107, 64531, 54229, 41331, 41899, 51735, 42427, 59173, 13010, 18505, 340};
    static final int[] expdigs82 = new int[]{27268, 6670, 31272, 9861, 45865, 10372, 12865, 62678, 23454, 35158, 20252, 29621, 26399, 3};
    static final int[] expdigs83 = new int[]{57738, 46147, 66, 48154, 11239, 21430, 55809, 46003, 15044, 25138, 52780, 48043, 4883, 2230};
    static final int[] expdigs84 = new int[]{20893, 62065, 64225, 52254, 59094, 55919, 60195, 5702, 48647, 50058, 7736, 41768, 19709, 22};
    static final int[] expdigs85 = new int[]{37714, 32321, 45840, 36031, 33290, 47121, 5146, 28127, 9887, 25390, 52929, 2698, 1073, 14615};
    static final int[] expdigs86 = new int[]{35111, 8187, 18153, 56721, 40309, 59453, 51824, 4868, 45974, 3530, 43783, 8546, 9841, 146};
    static final int[] expdigs87 = new int[]{23288, 61030, 42779, 19572, 29894, 47780, 45082, 32816, 43713, 33458, 25341, 63655, 30244, 1};
    static final int[] expdigs88 = new int[]{58138, 33000, 62869, 37127, 61799, 298, 46353, 5693, 63898, 62040, 989, 23191, 53065, 957};
    static final int[] expdigs89 = new int[]{42524, 32442, 36673, 15444, 22900, 658, 61412, 32824, 21610, 64190, 1975, 11373, 37886, 9};
    static final int[] expdigs90 = new int[]{26492, 4357, 32437, 10852, 34233, 53968, 55056, 34692, 64553, 38226, 41929, 21646, 6667, 6277};
    static final int[] expdigs91 = new int[]{61213, 698, 16053, 50571, 2963, 50347, 13657, 48188, 46520, 19387, 33187, 25775, 50529, 62};
    static final int[] expdigs92 = new int[]{42864, 54351, 45226, 20476, 23443, 17724, 3780, 44701, 52910, 23402, 28374, 46862, 40234, 41137};
    static final int[] expdigs93 = new int[]{23366, 62147, 58123, 44113, 55284, 39498, 3314, 9622, 9704, 27759, 25187, 43722, 24650, 411};
    static final int[] expdigs94 = new int[]{38899, 44530, 19586, 37141, 1863, 9570, 32801, 31553, 51870, 62536, 51369, 30583, 7455, 4};
    static final int[] expdigs95 = new int[]{10421, 4321, 43699, 3472, 65252, 17057, 13858, 29819, 14733, 21490, 40602, 31315, 65186, 2695};
    static final int[] expdigs96 = new int[]{6002, 54438, 29272, 34113, 17036, 25074, 36183, 953, 25051, 12011, 20722, 4245, 62911, 26};
    static final int[] expdigs97 = new int[]{14718, 45935, 8408, 42891, 21312, 56531, 44159, 45581, 20325, 36295, 35509, 24455, 30844, 17668};
    static final int[] expdigs98 = new int[]{54542, 45023, 23021, 3050, 31015, 20881, 50904, 40432, 33626, 14125, 44264, 60537, 44872, 176};
    static final int[] expdigs99 = new int[]{60183, 8969, 14648, 17725, 11451, 50016, 34587, 46279, 19341, 42084, 16826, 5848, 50256, 1};
    static final int[] expdigs100 = new int[]{64999, 53685, 60382, 19151, 25736, 5357, 31302, 23283, 14225, 52622, 56781, 39489, 60351, 1157};
    static final int[] expdigs101 = new int[]{1305, 4469, 39270, 18541, 63827, 59035, 54707, 16616, 32910, 48367, 64137, 2360, 37959, 11};
    static final int[] expdigs102 = new int[]{45449, 32125, 19705, 56098, 51958, 5225, 18285, 13654, 9341, 25888, 50946, 26855, 36068, 7588};
    static final int[] expdigs103 = new int[]{27324, 53405, 43450, 25464, 3796, 3329, 46058, 53220, 26307, 53998, 33932, 23861, 58032, 75};
    static final int[] expdigs104 = new int[]{63080, 50735, 1844, 21406, 57926, 63607, 24936, 52889, 23469, 64488, 539, 8859, 21210, 49732};
    static final int[] expdigs105 = new int[]{62890, 39828, 3950, 32982, 39245, 21607, 40226, 50991, 18584, 10475, 59643, 40720, 21183, 497};
    static final int[] expdigs106 = new int[]{37329, 64623, 11835, 985, 46923, 48712, 28582, 21481, 28366, 41392, 13703, 49559, 63781, 4};
    static final int[] expdigs107 = new int[]{3316, 60011, 41933, 47959, 54404, 39790, 12283, 941, 46090, 42226, 18108, 38803, 16879, 3259};
    static final int[] expdigs108 = new int[]{46563, 56305, 5006, 45044, 49040, 12849, 778, 6563, 46336, 3043, 7390, 2354, 38835, 32};
    static final int[] expdigs109 = new int[]{28653, 3742, 33331, 2671, 39772, 29981, 56489, 1973, 26280, 26022, 56391, 56434, 57039, 21359};
    static final int[] expdigs110 = new int[]{9461, 17732, 7542, 26241, 8917, 24548, 61513, 13126, 59245, 41547, 1874, 41852, 39236, 213};
    static final int[] expdigs111 = new int[]{36794, 22459, 63645, 14024, 42032, 53329, 25518, 11272, 18287, 20076, 62933, 3039, 8912, 2};
    static final int[] expdigs112 = new int[]{14926, 15441, 32337, 42579, 26354, 35154, 22815, 36955, 12564, 8047, 856, 41917, 55080, 1399};
    static final int[] expdigs113 = new int[]{8668, 50617, 10153, 17465, 1574, 28532, 15301, 58041, 38791, 60373, 663, 29255, 65431, 13};
    static final int[] expdigs114 = new int[]{21589, 32199, 24754, 45321, 9349, 26230, 35019, 37508, 20896, 42986, 31405, 12458, 65173, 9173};
    static final int[] expdigs115 = new int[]{46746, 1632, 61196, 50915, 64318, 41549, 2971, 23968, 59191, 58756, 61917, 779, 48493, 91};
    static final int[] expdigs116 = new int[]{1609, 63382, 15744, 15685, 51627, 56348, 33838, 52458, 44148, 11077, 56293, 41906, 45227, 60122};
    static final int[] expdigs117 = new int[]{19676, 45198, 6055, 38823, 8380, 49060, 17377, 58196, 43039, 21737, 59545, 12870, 14870, 601};
    static final int[] expdigs118 = new int[]{4128, 2418, 28241, 13495, 26298, 3767, 31631, 5169, 8950, 27087, 56956, 4060, 804, 6};
    static final int[] expdigs119 = new int[]{39930, 40673, 19029, 54677, 38145, 23200, 41325, 24564, 24955, 54484, 23863, 52998, 13147, 3940};
    static final int[] expdigs120 = new int[]{3676, 24655, 34924, 27416, 23974, 887, 10899, 4833, 21221, 28725, 19899, 57546, 26345, 39};
    static final int[] expdigs121 = new int[]{28904, 41324, 18596, 42292, 12070, 52013, 30810, 61057, 55753, 32324, 38953, 6752, 32688, 25822};
    static final int[] expdigs122 = new int[]{42232, 26627, 2807, 27948, 50583, 49016, 32420, 64180, 3178, 3600, 21361, 52496, 14744, 258};
    static final int[] expdigs123 = new int[]{2388, 59904, 28863, 7488, 31963, 8354, 47510, 15059, 2653, 58363, 31670, 21496, 38158, 2};
    static final int[] expdigs124 = new int[]{50070, 5266, 26158, 10774, 15148, 6873, 30230, 33898, 63720, 51799, 4515, 50124, 19875, 1692};
    static final int[] expdigs125 = new int[]{54240, 3984, 12058, 2729, 13914, 11865, 38313, 39660, 10467, 20834, 36745, 57517, 60491, 16};
    static final int[] expdigs126 = new int[]{5387, 58214, 9214, 13883, 14445, 34873, 21745, 13490, 23334, 25008, 58535, 19372, 44484, 11090};
    static final int[] expdigs127 = new int[]{27578, 64807, 12543, 794, 13907, 61297, 12013, 64360, 15961, 20566, 24178, 15922, 59427, 110};
    static final int[] expdigs128 = new int[]{49427, 41935, 46000, 59645, 45358, 51075, 15848, 32756, 38170, 14623, 35631, 57175, 7147, 1};
    static final int[] expdigs129 = new int[]{33941, 39160, 55469, 45679, 22878, 60091, 37210, 18508, 1638, 57398, 65026, 41643, 54966, 726};
    static final int[] expdigs130 = new int[]{60632, 24639, 41842, 62060, 20544, 59583, 52800, 1495, 48513, 43827, 10480, 1727, 17589, 7};
    static final int[] expdigs131 = new int[]{5590, 60244, 53985, 26632, 53049, 33628, 58267, 54922, 21641, 62744, 58109, 2070, 26887, 4763};
    static final int[] expdigs132 = new int[]{62970, 37957, 34618, 29757, 24123, 2302, 17622, 58876, 44780, 6525, 33349, 36065, 41556, 47};
    static final int[] expdigs133 = new int[]{1615, 24878, 20040, 11487, 23235, 27766, 59005, 57847, 60881, 11588, 63635, 61281, 31817, 31217};
    static final int[] expdigs134 = new int[]{14434, 2870, 65081, 44023, 40864, 40254, 47120, 6476, 32066, 23053, 17020, 19618, 11459, 312};
    static final int[] expdigs135 = new int[]{43398, 40005, 36695, 8304, 12205, 16131, 42414, 38075, 63890, 2851, 61774, 59833, 7978, 3};
    static final int[] expdigs136 = new int[]{56426, 22060, 15473, 31824, 19088, 38788, 64386, 12875, 35770, 65519, 11824, 19623, 56959, 2045};
    static final int[] expdigs137 = new int[]{16292, 32333, 10640, 47504, 29026, 30534, 23581, 6682, 10188, 24248, 44027, 51969, 30060, 20};
    static final int[] expdigs138 = new int[]{29432, 37518, 55373, 2727, 33243, 22572, 16689, 35625, 34145, 15830, 59880, 32552, 52948, 13407};
    static final int[] expdigs139 = new int[]{61898, 27244, 41841, 33450, 18682, 13988, 24415, 11497, 1652, 34237, 34677, 325, 5117, 134};
    static final int[] expdigs140 = new int[]{16347, 3549, 48915, 22616, 21158, 51913, 32356, 21086, 3293, 8862, 1002, 26873, 22333, 1};
    static final int[] expdigs141 = new int[]{25966, 63733, 28215, 31946, 40858, 58538, 11004, 6877, 6109, 3965, 35478, 37365, 45488, 878};
    static final int[] expdigs142 = new int[]{45479, 34060, 17321, 19980, 1719, 16314, 29601, 8588, 58388, 22321, 14117, 63288, 51572, 8};
    static final int[] expdigs143 = new int[]{46861, 47640, 11481, 23766, 46730, 53756, 8682, 60589, 42028, 27453, 29714, 31598, 39954, 5758};
    static final int[] expdigs144 = new int[]{29304, 58803, 51232, 27762, 60760, 17576, 19092, 26820, 11561, 48771, 6850, 27841, 38410, 57};
    static final int[] expdigs145 = new int[]{2916, 49445, 34666, 46387, 18627, 58279, 60468, 190, 3545, 51889, 51605, 47909, 40910, 37739};
    static final int[] expdigs146 = new int[]{19034, 62098, 15419, 33887, 38852, 53011, 28129, 37357, 11176, 48360, 9035, 9654, 25968, 377};
    static final int[] expdigs147 = new int[]{25094, 10451, 7363, 55389, 57404, 27399, 11422, 39695, 28947, 12935, 61694, 26310, 50722, 3};
    static final int[][] expdigstable = new int[][]{expdigs0, expdigs1, expdigs2, expdigs3, expdigs4, expdigs5, expdigs6, expdigs7, expdigs8, expdigs9, expdigs10, expdigs11, expdigs12, expdigs13, expdigs14, expdigs15, expdigs16, expdigs17, expdigs18, expdigs19, expdigs20, expdigs21, expdigs22, expdigs23, expdigs24, expdigs25, expdigs26, expdigs27, expdigs28, expdigs29, expdigs30, expdigs31, expdigs32, expdigs33, expdigs34, expdigs35, expdigs36, expdigs37, expdigs38, expdigs39, expdigs40, expdigs41, expdigs42, expdigs43, expdigs44, expdigs45, expdigs46, expdigs47, expdigs48, expdigs49, expdigs50, expdigs51, expdigs52, expdigs53, expdigs54, expdigs55, expdigs56, expdigs57, expdigs58, expdigs59, expdigs60, expdigs61, expdigs62, expdigs63, expdigs64, expdigs65, expdigs66, expdigs67, expdigs68, expdigs69, expdigs70, expdigs71, expdigs72, expdigs73, expdigs74, expdigs75, expdigs76, expdigs77, expdigs78, expdigs79, expdigs80, expdigs81, expdigs82, expdigs83, expdigs84, expdigs85, expdigs86, expdigs87, expdigs88, expdigs89, expdigs90, expdigs91, expdigs92, expdigs93, expdigs94, expdigs95, expdigs96, expdigs97, expdigs98, expdigs99, expdigs100, expdigs101, expdigs102, expdigs103, expdigs104, expdigs105, expdigs106, expdigs107, expdigs108, expdigs109, expdigs110, expdigs111, expdigs112, expdigs113, expdigs114, expdigs115, expdigs116, expdigs117, expdigs118, expdigs119, expdigs120, expdigs121, expdigs122, expdigs123, expdigs124, expdigs125, expdigs126, expdigs127, expdigs128, expdigs129, expdigs130, expdigs131, expdigs132, expdigs133, expdigs134, expdigs135, expdigs136, expdigs137, expdigs138, expdigs139, expdigs140, expdigs141, expdigs142, expdigs143, expdigs144, expdigs145, expdigs146, expdigs147};
    static final int[] nexpdigstable = new int[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 12, 12, 11, 11, 10, 10, 10, 9, 9, 8, 8, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 2, 2, 1, 1, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
    static final int[] binexpstable = new int[]{90, 89, 89, 88, 88, 88, 87, 87, 86, 86, 86, 85, 85, 84, 84, 83, 83, 83, 82, 82, 81, 81, 81, 80, 80, 79, 79, 78, 78, 78, 77, 77, 76, 76, 76, 75, 75, 74, 74, 73, 73, 73, 72, 72, 71, 71, 71, 70, 70, 69, 69, 68, 68, 68, 67, 67, 66, 66, 66, 65, 65, 64, 64, 64, 63, 63, 62, 62, 61, 61, 61, 60, 60, 59, 59, 59, 58, 58, 57, 57, 56, 56, 56, 55, 55, 54, 54, 54, 53, 53, 52, 52, 51, 51, 51, 50, 50, 49, 49, 49, 48, 48, 47, 47, 46, 46, 46, 45, 45, 44, 44, 44, 43, 43, 42, 42, 41, 41, 41, 40, 40, 39, 39, 39, 38, 38, 37, 37, 37, 36, 36, 35, 35, 34, 34, 34, 33, 33, 32, 32, 32, 31, 31, 30, 30, 29, 29, 29};

    NumberCommonAccessor() {
    }

    void init(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 6, 6, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    void init(OracleStatement oracleStatement, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s) throws SQLException {
        this.init(oracleStatement, 6, 6, s, false);
        this.initForDescribe(n, n2, bl, n3, n4, n5, n6, n7, s, null);
        this.initForDataAccess(0, n2, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 21;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = this.t_max_length + 1;
    }

    int getInt(int n) throws SQLException {
        int n2 = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n3 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n3 - 1];
            byte by2 = byArray[n3];
            int n4 = 0;
            if ((by2 & 0xFFFFFF80) != 0) {
                byte by3 = (byte)(by - 1);
                byte by4 = (byte)((by2 & 0xFFFFFF7F) - 65);
                int n5 = by3 > by4 + 1 ? by4 + 2 : by3 + 1;
                int n6 = n5 + n3;
                if (by4 >= 4) {
                    int n7;
                    if (by4 > 4) {
                        this.throwOverflow();
                    }
                    long l = 0L;
                    if (n5 > 1) {
                        l = byArray[n3 + 1] - 1;
                        for (n7 = 2 + n3; n7 < n6; ++n7) {
                            l = l * 100L + (long)(byArray[n7] - 1);
                        }
                    }
                    for (n7 = by4 - by3; n7 >= 0; --n7) {
                        l *= 100L;
                    }
                    if (l > Integer.MAX_VALUE) {
                        this.throwOverflow();
                    }
                    n4 = (int)l;
                } else {
                    int n8;
                    if (n5 > 1) {
                        n4 = byArray[n3 + 1] - 1;
                        for (n8 = 2 + n3; n8 < n6; ++n8) {
                            n4 = n4 * 100 + (byArray[n8] - 1);
                        }
                    }
                    for (n8 = by4 - by3; n8 >= 0; --n8) {
                        n4 *= 100;
                    }
                }
            } else {
                byte by5 = (byte)((~by2 & 0xFFFFFF7F) - 65);
                byte by6 = (byte)(by - 1);
                if (by6 != 20 || byArray[n3 + by6] == 102) {
                    by6 = (byte)(by6 - 1);
                }
                int n9 = by6 > by5 + 1 ? by5 + 2 : by6 + 1;
                int n10 = n9 + n3;
                if (by5 >= 4) {
                    int n11;
                    if (by5 > 4) {
                        this.throwOverflow();
                    }
                    long l = 0L;
                    if (n9 > 1) {
                        l = 101 - byArray[n3 + 1];
                        for (n11 = 2 + n3; n11 < n10; ++n11) {
                            l = l * 100L + (long)(101 - byArray[n11]);
                        }
                    }
                    for (n11 = by5 - by6; n11 >= 0; --n11) {
                        l *= 100L;
                    }
                    if ((l = -l) < Integer.MIN_VALUE) {
                        this.throwOverflow();
                    }
                    n4 = (int)l;
                } else {
                    int n12;
                    if (n9 > 1) {
                        n4 = 101 - byArray[n3 + 1];
                        for (n12 = 2 + n3; n12 < n10; ++n12) {
                            n4 = n4 * 100 + (101 - byArray[n12]);
                        }
                    }
                    for (n12 = by5 - by6; n12 >= 0; --n12) {
                        n4 *= 100;
                    }
                    n4 = -n4;
                }
            }
            n2 = n4;
        }
        return n2;
    }

    boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n2 - 1];
            bl = by != 1 || byArray[n2] != -128;
        }
        return bl;
    }

    short getShort(int n) throws SQLException {
        short s = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n2 - 1];
            byte by2 = byArray[n2];
            int n3 = 0;
            if ((by2 & 0xFFFFFF80) != 0) {
                int n4;
                byte by3;
                byte by4 = (byte)((by2 & 0xFFFFFF7F) - 65);
                if (by4 > 2) {
                    this.throwOverflow();
                }
                int n5 = (by3 = (byte)(by - 1)) > by4 + 1 ? by4 + 2 : by3 + 1;
                int n6 = n5 + n2;
                if (n5 > 1) {
                    n3 = byArray[n2 + 1] - 1;
                    for (n4 = 2 + n2; n4 < n6; ++n4) {
                        n3 = n3 * 100 + (byArray[n4] - 1);
                    }
                }
                for (n4 = by4 - by3; n4 >= 0; --n4) {
                    n3 *= 100;
                }
                if (by4 == 2 && n3 > Short.MAX_VALUE) {
                    this.throwOverflow();
                }
            } else {
                int n7;
                byte by5;
                byte by6 = (byte)((~by2 & 0xFFFFFF7F) - 65);
                if (by6 > 2) {
                    this.throwOverflow();
                }
                if ((by5 = (byte)(by - 1)) != 20 || byArray[n2 + by5] == 102) {
                    by5 = (byte)(by5 - 1);
                }
                int n8 = by5 > by6 + 1 ? by6 + 2 : by5 + 1;
                int n9 = n8 + n2;
                if (n8 > 1) {
                    n3 = 101 - byArray[n2 + 1];
                    for (n7 = 2 + n2; n7 < n9; ++n7) {
                        n3 = n3 * 100 + (101 - byArray[n7]);
                    }
                }
                for (n7 = by6 - by5; n7 >= 0; --n7) {
                    n3 *= 100;
                }
                n3 = -n3;
                if (by6 == 2 && n3 < Short.MIN_VALUE) {
                    this.throwOverflow();
                }
            }
            s = (short)n3;
        }
        return s;
    }

    byte getByte(int n) throws SQLException {
        byte by = 0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by2 = byArray[n2 - 1];
            byte by3 = byArray[n2];
            int n3 = 0;
            if ((by3 & 0xFFFFFF80) != 0) {
                byte by4;
                byte by5 = (byte)((by3 & 0xFFFFFF7F) - 65);
                if (by5 > 1) {
                    this.throwOverflow();
                }
                if ((by4 = (byte)(by2 - 1)) > by5 + 1) {
                    switch (by5) {
                        default: {
                            break;
                        }
                        case -1: {
                            break;
                        }
                        case 0: {
                            n3 = byArray[n2 + 1] - 1;
                            break;
                        }
                        case 1: {
                            n3 = (byArray[n2 + 1] - 1) * 100 + (byArray[n2 + 2] - 1);
                            if (n3 > 127) {
                                this.throwOverflow();
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (by4 == 1) {
                    if (by5 == 1) {
                        n3 = (byArray[n2 + 1] - 1) * 100;
                        if (n3 > 127) {
                            this.throwOverflow();
                        }
                    } else {
                        n3 = byArray[n2 + 1] - 1;
                    }
                } else if (by4 == 2 && (n3 = (byArray[n2 + 1] - 1) * 100 + (byArray[n2 + 2] - 1)) > 127) {
                    this.throwOverflow();
                }
            } else {
                byte by6;
                byte by7 = (byte)((~by3 & 0xFFFFFF7F) - 65);
                if (by7 > 1) {
                    this.throwOverflow();
                }
                if ((by6 = (byte)(by2 - 1)) != 20 || byArray[n2 + by6] == 102) {
                    by6 = (byte)(by6 - 1);
                }
                if (by6 > by7 + 1) {
                    switch (by7) {
                        default: {
                            break;
                        }
                        case -1: {
                            break;
                        }
                        case 0: {
                            n3 = -(101 - byArray[n2 + 1]);
                            break;
                        }
                        case 1: {
                            n3 = -((101 - byArray[n2 + 1]) * 100 + (101 - byArray[n2 + 2]));
                            if (n3 < -128) {
                                this.throwOverflow();
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (by6 == 1) {
                    if (by7 == 1) {
                        n3 = -(101 - byArray[n2 + 1]) * 100;
                        if (n3 < -128) {
                            this.throwOverflow();
                        }
                    } else {
                        n3 = -(101 - byArray[n2 + 1]);
                    }
                } else if (by6 == 2 && (n3 = -((101 - byArray[n2 + 1]) * 100 + (101 - byArray[n2 + 2]))) < -128) {
                    this.throwOverflow();
                }
            }
            by = (byte)n3;
        }
        return by;
    }

    long getLong(int n) throws SQLException {
        long l = 0L;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            int n3 = byArray[n2 - 1];
            byte by = byArray[n2];
            long l2 = 0L;
            if ((by & 0xFFFFFF80) != 0) {
                byte by2;
                int n4;
                int n5;
                int n6;
                if (by == -128 && n3 == 1) {
                    return 0L;
                }
                byte by3 = (byte)((by & 0xFFFFFF7F) - 65);
                if (by3 > 9) {
                    this.throwOverflow();
                }
                if (by3 == 9) {
                    n6 = 1;
                    n5 = n3;
                    if (n3 > MAX_LONG_length) {
                        n5 = MAX_LONG_length;
                    }
                    while (n6 < n5) {
                        n4 = byArray[n2 + n6] & 0xFF;
                        int n7 = MAX_LONG[n6];
                        if (n4 != n7) {
                            if (n4 < n7) break;
                            this.throwOverflow();
                        }
                        ++n6;
                    }
                    if (n6 == n5 && n3 > MAX_LONG_length) {
                        this.throwOverflow();
                    }
                }
                n6 = (by2 = (byte)(n3 - 1)) > by3 + 1 ? by3 + 2 : by2 + 1;
                n5 = n6 + n2;
                if (n6 > 1) {
                    l2 = byArray[n2 + 1] - 1;
                    for (n4 = 2 + n2; n4 < n5; ++n4) {
                        l2 = l2 * 100L + (long)(byArray[n4] - 1);
                    }
                }
                for (n4 = by3 - by2; n4 >= 0; --n4) {
                    l2 *= 100L;
                }
            } else {
                byte by4;
                int n8;
                int n9;
                int n10;
                byte by5 = (byte)((~by & 0xFFFFFF7F) - 65);
                if (by5 > 9) {
                    this.throwOverflow();
                }
                if (by5 == 9) {
                    n10 = 1;
                    n9 = n3;
                    if (n3 > MIN_LONG_length) {
                        n9 = MIN_LONG_length;
                    }
                    while (n10 < n9) {
                        n8 = byArray[n2 + n10] & 0xFF;
                        int n11 = MIN_LONG[n10];
                        if (n8 != n11) {
                            if (n8 > n11) break;
                            this.throwOverflow();
                        }
                        ++n10;
                    }
                    if (n10 == n9 && n3 < MIN_LONG_length) {
                        this.throwOverflow();
                    }
                }
                if ((by4 = (byte)(n3 - 1)) != 20 || byArray[n2 + by4] == 102) {
                    by4 = (byte)(by4 - 1);
                }
                n10 = by4 > by5 + 1 ? by5 + 2 : by4 + 1;
                n9 = n10 + n2;
                if (n10 > 1) {
                    l2 = 101 - byArray[n2 + 1];
                    for (n8 = 2 + n2; n8 < n9; ++n8) {
                        l2 = l2 * 100L + (long)(101 - byArray[n8]);
                    }
                }
                for (n8 = by5 - by4; n8 >= 0; --n8) {
                    l2 *= 100L;
                }
                l2 = -l2;
            }
            l = l2;
        }
        return l;
    }

    float getFloat(int n) throws SQLException {
        float f = 0.0f;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n2 - 1];
            byte by2 = byArray[n2];
            double d = 0.0;
            int n3 = n2 + 1;
            if ((by2 & 0xFFFFFF80) != 0) {
                if (by2 == -128 && by == 1) {
                    return 0.0f;
                }
                if (by == 2 && by2 == -1 && byArray[n2 + 1] == 101) {
                    return Float.POSITIVE_INFINITY;
                }
                byte by3 = (byte)((by2 & 0xFFFFFF7F) - 65);
                int n4 = by - 1;
                while (byArray[n3] == 1 && n4 > 0) {
                    ++n3;
                    --n4;
                    by3 = (byte)(by3 - 1);
                }
                int n5 = (int)(127.0 - (double)by3);
                switch (n4) {
                    case 1: {
                        d = (double)(byArray[n3] - 1) * factorTable[n5];
                        break;
                    }
                    case 2: {
                        d = (double)((byArray[n3] - 1) * 100 + (byArray[n3 + 1] - 1)) * factorTable[n5 + 1];
                        break;
                    }
                    case 3: {
                        d = (double)((byArray[n3] - 1) * 10000 + (byArray[n3 + 1] - 1) * 100 + (byArray[n3 + 2] - 1)) * factorTable[n5 + 2];
                        break;
                    }
                    case 4: {
                        d = (double)((byArray[n3] - 1) * 1000000 + (byArray[n3 + 1] - 1) * 10000 + (byArray[n3 + 2] - 1) * 100 + (byArray[n3 + 3] - 1)) * factorTable[n5 + 3];
                        break;
                    }
                    case 5: {
                        d = (double)((byArray[n3 + 1] - 1) * 1000000 + (byArray[n3 + 2] - 1) * 10000 + (byArray[n3 + 3] - 1) * 100 + (byArray[n3 + 4] - 1)) * factorTable[n5 + 4] + (double)(byArray[n3] - 1) * factorTable[n5];
                        break;
                    }
                    case 6: {
                        d = (double)((byArray[n3 + 2] - 1) * 1000000 + (byArray[n3 + 3] - 1) * 10000 + (byArray[n3 + 4] - 1) * 100 + (byArray[n3 + 5] - 1)) * factorTable[n5 + 5] + (double)((byArray[n3] - 1) * 100 + (byArray[n3 + 1] - 1)) * factorTable[n5 + 1];
                        break;
                    }
                    default: {
                        d = (double)((byArray[n3 + 3] - 1) * 1000000 + (byArray[n3 + 4] - 1) * 10000 + (byArray[n3 + 5] - 1) * 100 + (byArray[n3 + 6] - 1)) * factorTable[n5 + 6] + (double)((byArray[n3] - 1) * 10000 + (byArray[n3 + 1] - 1) * 100 + (byArray[n3 + 2] - 1)) * factorTable[n5 + 2];
                        break;
                    }
                }
            } else {
                if (by2 == 0 && by == 1) {
                    return Float.NEGATIVE_INFINITY;
                }
                byte by4 = (byte)((~by2 & 0xFFFFFF7F) - 65);
                int n6 = by - 1;
                if (n6 != 20 || byArray[n2 + n6] == 102) {
                    --n6;
                }
                while (byArray[n3] == 1 && n6 > 0) {
                    ++n3;
                    --n6;
                    by4 = (byte)(by4 - 1);
                }
                int n7 = (int)(127.0 - (double)by4);
                switch (n6) {
                    case 1: {
                        d = (double)(-(101 - byArray[n3])) * factorTable[n7];
                        break;
                    }
                    case 2: {
                        d = (double)(-((101 - byArray[n3]) * 100 + (101 - byArray[n3 + 1]))) * factorTable[n7 + 1];
                        break;
                    }
                    case 3: {
                        d = (double)(-((101 - byArray[n3]) * 10000 + (101 - byArray[n3 + 1]) * 100 + (101 - byArray[n3 + 2]))) * factorTable[n7 + 2];
                        break;
                    }
                    case 4: {
                        d = (double)(-((101 - byArray[n3]) * 1000000 + (101 - byArray[n3 + 1]) * 10000 + (101 - byArray[n3 + 2]) * 100 + (101 - byArray[n3 + 3]))) * factorTable[n7 + 3];
                        break;
                    }
                    case 5: {
                        d = -((double)((101 - byArray[n3 + 1]) * 1000000 + (101 - byArray[n3 + 2]) * 10000 + (101 - byArray[n3 + 3]) * 100 + (101 - byArray[n3 + 4])) * factorTable[n7 + 4] + (double)(101 - byArray[n3]) * factorTable[n7]);
                        break;
                    }
                    case 6: {
                        d = -((double)((101 - byArray[n3 + 2]) * 1000000 + (101 - byArray[n3 + 3]) * 10000 + (101 - byArray[n3 + 4]) * 100 + (101 - byArray[n3 + 5])) * factorTable[n7 + 5] + (double)((101 - byArray[n3]) * 100 + (101 - byArray[n3 + 1])) * factorTable[n7 + 1]);
                        break;
                    }
                    default: {
                        d = -((double)((101 - byArray[n3 + 3]) * 1000000 + (101 - byArray[n3 + 4]) * 10000 + (101 - byArray[n3 + 5]) * 100 + (101 - byArray[n3 + 6])) * factorTable[n7 + 6] + (double)((101 - byArray[n3]) * 10000 + (101 - byArray[n3 + 1]) * 100 + (101 - byArray[n3 + 2])) * factorTable[n7 + 2]);
                    }
                }
            }
            f = (float)d;
        }
        return f;
    }

    double getDouble(int n) throws SQLException {
        double d = 0.0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            double d2;
            int n2;
            boolean bl;
            byte by;
            byte[] byArray = this.rowSpaceByte;
            int n3 = this.columnIndex + this.byteLength * n + 1;
            byte by2 = byArray[n3 - 1];
            byte by3 = byArray[n3];
            int n4 = n3 + 1;
            int n5 = by2 - 1;
            boolean bl2 = true;
            if ((by3 & 0xFFFFFF80) != 0) {
                if (by3 == -128 && by2 == 1) {
                    return 0.0;
                }
                if (by2 == 2 && by3 == -1 && byArray[n3 + 1] == 101) {
                    return Double.POSITIVE_INFINITY;
                }
                by = (byte)((by3 & 0xFFFFFF7F) - 65);
                bl = (byArray[n4 + n5 - 1] - 1) % 10 == 0;
                n2 = byArray[n4] - 1;
            } else {
                bl2 = false;
                if (by3 == 0 && by2 == 1) {
                    return Double.NEGATIVE_INFINITY;
                }
                by = (byte)((~by3 & 0xFFFFFF7F) - 65);
                if (n5 != 20 || byArray[n3 + n5] == 102) {
                    --n5;
                }
                bl = (101 - byArray[n4 + n5 - 1]) % 10 == 0;
                n2 = 101 - byArray[n4];
            }
            int n6 = n5 << 1;
            if (bl) {
                --n6;
            }
            int n7 = (by + 1 << 1) - n6;
            if (n2 < 10) {
                --n6;
            }
            if (n6 <= 15 && (n7 >= 0 && n7 <= 37 - n6 || n7 < 0 && n7 >= -22)) {
                double d3;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                if (bl2) {
                    switch (n5) {
                        default: {
                            n14 = byArray[n4 + 7] - 1;
                        }
                        case 7: {
                            n13 = byArray[n4 + 6] - 1;
                        }
                        case 6: {
                            n12 = byArray[n4 + 5] - 1;
                        }
                        case 5: {
                            n11 = byArray[n4 + 4] - 1;
                        }
                        case 4: {
                            n10 = byArray[n4 + 3] - 1;
                        }
                        case 3: {
                            n9 = byArray[n4 + 2] - 1;
                        }
                        case 2: {
                            n8 = byArray[n4 + 1] - 1;
                        }
                        case 1: 
                    }
                } else {
                    switch (n5) {
                        default: {
                            n14 = 101 - byArray[n4 + 7];
                        }
                        case 7: {
                            n13 = 101 - byArray[n4 + 6];
                        }
                        case 6: {
                            n12 = 101 - byArray[n4 + 5];
                        }
                        case 5: {
                            n11 = 101 - byArray[n4 + 4];
                        }
                        case 4: {
                            n10 = 101 - byArray[n4 + 3];
                        }
                        case 3: {
                            n9 = 101 - byArray[n4 + 2];
                        }
                        case 2: {
                            n8 = 101 - byArray[n4 + 1];
                        }
                        case 1: 
                    }
                }
                if (bl) {
                    switch (n5) {
                        default: {
                            d3 = n2 / 10;
                            break;
                        }
                        case 2: {
                            d3 = n2 * 10 + n8 / 10;
                            break;
                        }
                        case 3: {
                            d3 = n2 * 1000 + n8 * 10 + n9 / 10;
                            break;
                        }
                        case 4: {
                            d3 = n2 * 100000 + n8 * 1000 + n9 * 10 + n10 / 10;
                            break;
                        }
                        case 5: {
                            d3 = n2 * 10000000 + n8 * 100000 + n9 * 1000 + n10 * 10 + n11 / 10;
                            break;
                        }
                        case 6: {
                            int n15 = n8 * 10000000 + n9 * 100000 + n10 * 1000 + n11 * 10 + n12 / 10;
                            d3 = (long)n2 * 1000000000L + (long)n15;
                            break;
                        }
                        case 7: {
                            int n16 = n9 * 10000000 + n10 * 100000 + n11 * 1000 + n12 * 10 + n13 / 10;
                            int n17 = n2 * 100 + n8;
                            d3 = (long)n17 * 1000000000L + (long)n16;
                            break;
                        }
                        case 8: {
                            int n18 = n10 * 10000000 + n11 * 100000 + n12 * 1000 + n13 * 10 + n14 / 10;
                            int n19 = n2 * 10000 + n8 * 100 + n9;
                            d3 = (long)n19 * 1000000000L + (long)n18;
                            break;
                        }
                    }
                } else {
                    switch (n5) {
                        default: {
                            d3 = n2;
                            break;
                        }
                        case 2: {
                            d3 = n2 * 100 + n8;
                            break;
                        }
                        case 3: {
                            d3 = n2 * 10000 + n8 * 100 + n9;
                            break;
                        }
                        case 4: {
                            d3 = n2 * 1000000 + n8 * 10000 + n9 * 100 + n10;
                            break;
                        }
                        case 5: {
                            int n20 = n8 * 1000000 + n9 * 10000 + n10 * 100 + n11;
                            d3 = (long)n2 * 100000000L + (long)n20;
                            break;
                        }
                        case 6: {
                            int n21 = n9 * 1000000 + n10 * 10000 + n11 * 100 + n12;
                            int n22 = n2 * 100 + n8;
                            d3 = (long)n22 * 100000000L + (long)n21;
                            break;
                        }
                        case 7: {
                            int n23 = n10 * 1000000 + n11 * 10000 + n12 * 100 + n13;
                            int n24 = n2 * 10000 + n8 * 100 + n9;
                            d3 = (long)n24 * 100000000L + (long)n23;
                            break;
                        }
                        case 8: {
                            int n25 = n11 * 1000000 + n12 * 10000 + n13 * 100 + n14;
                            int n26 = n2 * 1000000 + n8 * 10000 + n9 * 100 + n10;
                            d3 = (long)n26 * 100000000L + (long)n25;
                        }
                    }
                }
                if (n7 == 0 || d3 == 0.0) {
                    d2 = d3;
                } else if (n7 >= 0) {
                    if (n7 <= 22) {
                        d2 = d3 * small10pow[n7];
                    } else {
                        int n27 = 15 - n6;
                        d2 = (d3 *= small10pow[n27]) * small10pow[n7 - n27];
                    }
                } else {
                    d2 = d3 / small10pow[-n7];
                }
            } else {
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36 = 0;
                int n37 = 0;
                int n38 = 0;
                int n39 = 0;
                int n40 = 0;
                int n41 = 0;
                int n42 = 0;
                int n43 = 0;
                int n44 = 0;
                int n45 = 0;
                int n46 = 0;
                int n47 = 0;
                int n48 = 0;
                int n49 = 0;
                int n50 = 0;
                boolean bl3 = false;
                int n51 = 0;
                if (bl2) {
                    if ((n5 & 1) != 0) {
                        n35 = 2;
                        n36 = n2;
                    } else {
                        n35 = 3;
                        n36 = n2 * 100 + (byArray[n4 + 1] - 1);
                    }
                    while (n35 < n5) {
                        n34 = (byArray[n4 + n35 - 1] - 1) * 100 + (byArray[n4 + n35] - 1) + n36 * 10000;
                        switch (n45) {
                            default: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n43 * 10000;
                                n43 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n44 * 10000;
                                n44 = n34 & 0xFFFF;
                                break;
                            }
                            case 7: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n43 * 10000;
                                n43 = n34 & 0xFFFF;
                                break;
                            }
                            case 6: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                break;
                            }
                            case 5: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                break;
                            }
                            case 4: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                break;
                            }
                            case 3: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                break;
                            }
                            case 2: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                break;
                            }
                            case 1: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                break;
                            }
                            case 0: {
                                n36 = n34 & 0xFFFF;
                            }
                        }
                        n34 = n34 >> 16 & 0xFFFF;
                        if (n34 != 0) {
                            switch (++n45) {
                                case 8: {
                                    n44 = n34;
                                    break;
                                }
                                case 7: {
                                    n43 = n34;
                                    break;
                                }
                                case 6: {
                                    n42 = n34;
                                    break;
                                }
                                case 5: {
                                    n41 = n34;
                                    break;
                                }
                                case 4: {
                                    n40 = n34;
                                    break;
                                }
                                case 3: {
                                    n39 = n34;
                                    break;
                                }
                                case 2: {
                                    n38 = n34;
                                    break;
                                }
                                case 1: {
                                    n37 = n34;
                                    break;
                                }
                            }
                        }
                        n35 += 2;
                    }
                } else {
                    if ((n5 & 1) != 0) {
                        n35 = 2;
                        n36 = n2;
                    } else {
                        n35 = 3;
                        n36 = n2 * 100 + (101 - byArray[n4 + 1]);
                    }
                    while (n35 < n5) {
                        n34 = (101 - byArray[n4 + n35 - 1]) * 100 + (101 - byArray[n4 + n35]) + n36 * 10000;
                        switch (n45) {
                            default: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n43 * 10000;
                                n43 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n44 * 10000;
                                n44 = n34 & 0xFFFF;
                                break;
                            }
                            case 7: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n43 * 10000;
                                n43 = n34 & 0xFFFF;
                                break;
                            }
                            case 6: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n42 * 10000;
                                n42 = n34 & 0xFFFF;
                                break;
                            }
                            case 5: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n41 * 10000;
                                n41 = n34 & 0xFFFF;
                                break;
                            }
                            case 4: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n40 * 10000;
                                n40 = n34 & 0xFFFF;
                                break;
                            }
                            case 3: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n39 * 10000;
                                n39 = n34 & 0xFFFF;
                                break;
                            }
                            case 2: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n38 * 10000;
                                n38 = n34 & 0xFFFF;
                                break;
                            }
                            case 1: {
                                n36 = n34 & 0xFFFF;
                                n34 = (n34 >> 16 & 0xFFFF) + n37 * 10000;
                                n37 = n34 & 0xFFFF;
                                break;
                            }
                            case 0: {
                                n36 = n34 & 0xFFFF;
                            }
                        }
                        n34 = n34 >> 16 & 0xFFFF;
                        if (n34 != 0) {
                            switch (++n45) {
                                case 8: {
                                    n44 = n34;
                                    break;
                                }
                                case 7: {
                                    n43 = n34;
                                    break;
                                }
                                case 6: {
                                    n42 = n34;
                                    break;
                                }
                                case 5: {
                                    n41 = n34;
                                    break;
                                }
                                case 4: {
                                    n40 = n34;
                                    break;
                                }
                                case 3: {
                                    n39 = n34;
                                    break;
                                }
                                case 2: {
                                    n38 = n34;
                                    break;
                                }
                                case 1: {
                                    n37 = n34;
                                    break;
                                }
                            }
                        }
                        n35 += 2;
                    }
                }
                int n52 = n45++;
                int n53 = 62 - by + n5;
                int n54 = nexpdigstable[n53];
                int[] nArray = expdigstable[n53];
                n51 = n45 + 5;
                n34 = 0;
                if (n54 > n51) {
                    n34 = n54 - n51;
                    n54 = n51;
                }
                int n55 = 0;
                int n56 = 0;
                int n57 = n54 - 1 + (n45 - 1) - 4;
                for (n33 = 0; n33 < n57; ++n33) {
                    n32 = n56 & 0xFFFF;
                    n56 = n56 >> 16 & 0xFFFF;
                    n31 = n45 < n33 + 1 ? n45 : n33 + 1;
                    int n58 = n30 = n33 - n54 + 1 > 0 ? n33 - n54 + 1 : 0;
                    while (n30 < n31) {
                        n29 = n34 + n33 - n30;
                        switch (n30) {
                            case 8: {
                                n28 = n44 * nArray[n29];
                                break;
                            }
                            case 7: {
                                n28 = n43 * nArray[n29];
                                break;
                            }
                            case 6: {
                                n28 = n42 * nArray[n29];
                                break;
                            }
                            case 5: {
                                n28 = n41 * nArray[n29];
                                break;
                            }
                            case 4: {
                                n28 = n40 * nArray[n29];
                                break;
                            }
                            case 3: {
                                n28 = n39 * nArray[n29];
                                break;
                            }
                            case 2: {
                                n28 = n38 * nArray[n29];
                                break;
                            }
                            case 1: {
                                n28 = n37 * nArray[n29];
                                break;
                            }
                            default: {
                                n28 = n36 * nArray[n29];
                            }
                        }
                        n32 += n28 & 0xFFFF;
                        n56 += n28 >> 16 & 0xFFFF;
                        ++n30;
                    }
                    bl3 = bl3 || (n32 & 0xFFFF) != 0;
                    n56 += n32 >> 16 & 0xFFFF;
                }
                n57 += 5;
                while (n33 < n57) {
                    n32 = n56 & 0xFFFF;
                    n56 = n56 >> 16 & 0xFFFF;
                    n31 = n45 < n33 + 1 ? n45 : n33 + 1;
                    int n59 = n30 = n33 - n54 + 1 > 0 ? n33 - n54 + 1 : 0;
                    while (n30 < n31) {
                        n29 = n34 + n33 - n30;
                        switch (n30) {
                            case 8: {
                                n28 = n44 * nArray[n29];
                                break;
                            }
                            case 7: {
                                n28 = n43 * nArray[n29];
                                break;
                            }
                            case 6: {
                                n28 = n42 * nArray[n29];
                                break;
                            }
                            case 5: {
                                n28 = n41 * nArray[n29];
                                break;
                            }
                            case 4: {
                                n28 = n40 * nArray[n29];
                                break;
                            }
                            case 3: {
                                n28 = n39 * nArray[n29];
                                break;
                            }
                            case 2: {
                                n28 = n38 * nArray[n29];
                                break;
                            }
                            case 1: {
                                n28 = n37 * nArray[n29];
                                break;
                            }
                            default: {
                                n28 = n36 * nArray[n29];
                            }
                        }
                        n32 += n28 & 0xFFFF;
                        n56 += n28 >> 16 & 0xFFFF;
                        ++n30;
                    }
                    switch (n55++) {
                        case 4: {
                            n50 = n32 & 0xFFFF;
                            break;
                        }
                        case 3: {
                            n49 = n32 & 0xFFFF;
                            break;
                        }
                        case 2: {
                            n48 = n32 & 0xFFFF;
                            break;
                        }
                        case 1: {
                            n47 = n32 & 0xFFFF;
                            break;
                        }
                        default: {
                            n46 = n32 & 0xFFFF;
                        }
                    }
                    n56 += n32 >> 16 & 0xFFFF;
                    ++n33;
                }
                while (n56 != 0) {
                    if (n55 < 5) {
                        switch (n55++) {
                            case 4: {
                                n50 = n56 & 0xFFFF;
                                break;
                            }
                            case 3: {
                                n49 = n56 & 0xFFFF;
                                break;
                            }
                            case 2: {
                                n48 = n56 & 0xFFFF;
                                break;
                            }
                            case 1: {
                                n47 = n56 & 0xFFFF;
                                break;
                            }
                            default: {
                                n46 = n56 & 0xFFFF;
                                break;
                            }
                        }
                    } else {
                        bl3 = bl3 || n46 != 0;
                        n46 = n47;
                        n47 = n48;
                        n48 = n49;
                        n49 = n50;
                        n50 = n56 & 0xFFFF;
                    }
                    n56 = n56 >> 16 & 0xFFFF;
                    ++n52;
                }
                int n60 = (binexpstable[n53] + n52) * 16 - 1;
                switch (n55) {
                    case 5: {
                        n32 = n50;
                        break;
                    }
                    case 4: {
                        n32 = n49;
                        break;
                    }
                    case 3: {
                        n32 = n48;
                        break;
                    }
                    case 2: {
                        n32 = n47;
                        break;
                    }
                    default: {
                        n32 = n46;
                    }
                }
                for (n31 = n32 >> 1; n31 != 0; n31 >>= 1) {
                    ++n60;
                }
                n31 = 5;
                n29 = n32 << 5;
                n28 = 0;
                n56 = 0;
                while ((n29 & 0x100000) == 0) {
                    n29 <<= 1;
                    ++n31;
                }
                switch (n55) {
                    case 5: {
                        if (n31 > 16) {
                            n29 |= n49 << n31 - 16 | n48 >> 32 - n31;
                            n28 = n48 << n31 | n47 << n31 - 16 | n46 >> 32 - n31;
                            n56 = n46 & 1 << 31 - n31;
                            bl3 = bl3 || n46 << n31 + 1 != 0;
                            break;
                        }
                        if (n31 == 16) {
                            n29 |= n49;
                            n28 = n48 << 16 | n47;
                            n56 = n46 & 0x8000;
                            bl3 = bl3 || (n46 & Short.MAX_VALUE) != 0;
                            break;
                        }
                        n29 |= n49 >> 16 - n31;
                        n28 = n49 << 16 + n31 | n48 << n31 | n47 >> 16 - n31;
                        n56 = n47 & 1 << 15 - n31;
                        if (n31 < 15) {
                            bl3 = bl3 || n47 << n31 + 17 != 0;
                        }
                        bl3 = bl3 || n46 != 0;
                        break;
                    }
                    case 4: {
                        if (n31 > 16) {
                            n29 |= n48 << n31 - 16 | n47 >> 32 - n31;
                            n28 = n47 << n31 | n46 << n31 - 16;
                            break;
                        }
                        if (n31 == 16) {
                            n29 |= n48;
                            n28 = n47 << 16 | n46;
                            break;
                        }
                        n29 |= n48 >> 16 - n31;
                        n28 = n48 << 16 + n31 | n47 << n31 | n46 >> 16 - n31;
                        n56 = n46 & 1 << 15 - n31;
                        if (n31 >= 15) break;
                        bl3 = bl3 || n46 << n31 + 17 != 0;
                        break;
                    }
                    case 3: {
                        if (n31 > 16) {
                            n29 |= n47 << n31 - 16 | n46 >> 32 - n31;
                            n28 = n46 << n31;
                            break;
                        }
                        if (n31 == 16) {
                            n29 |= n47;
                            n28 = n46 << 16;
                            break;
                        }
                        n29 |= n47 >> 16 - n31;
                        n28 = n47 << 16 + n31;
                        n28 |= n46 << n31;
                        break;
                    }
                    case 2: {
                        if (n31 > 16) {
                            n29 |= n46 << n31 - 16;
                            break;
                        }
                        if (n31 == 16) {
                            n29 |= n46;
                            break;
                        }
                        n29 |= n46 >> 16 - n31;
                        n28 = n46 << 16 + n31;
                        break;
                    }
                }
                if (n56 != 0 && (bl3 || (n28 & 1) != 0)) {
                    if (n28 == -1) {
                        n28 = 0;
                        if ((++n29 & 0x200000) != 0) {
                            n28 = n28 >> 1 | n29 << 31;
                            n29 >>= 1;
                            ++n60;
                        }
                    } else {
                        ++n28;
                    }
                }
                long l = (long)n60 << 52 | (long)(n29 & 0xFFFFF) << 32 | (long)n28 & 0xFFFFFFFFL;
                d2 = Double.longBitsToDouble(l);
            }
            d = bl2 ? d2 : -d2;
        }
        return d;
    }

    double getDoubleImprecise(int n) throws SQLException {
        double d = 0.0;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n2 - 1];
            byte by2 = byArray[n2];
            double d2 = 0.0;
            int n3 = n2 + 1;
            if ((by2 & 0xFFFFFF80) != 0) {
                if (by2 == -128 && by == 1) {
                    return 0.0;
                }
                if (by == 2 && by2 == -1 && byArray[n2 + 1] == 101) {
                    return Double.POSITIVE_INFINITY;
                }
                byte by3 = (byte)((by2 & 0xFFFFFF7F) - 65);
                int n4 = by - 1;
                int n5 = (int)(127.0 - (double)by3);
                int n6 = n4 % 4;
                switch (n6) {
                    case 1: {
                        d2 = (double)(byArray[n3] - 1) * factorTable[n5];
                        break;
                    }
                    case 2: {
                        d2 = (double)((byArray[n3] - 1) * 100 + (byArray[n3 + 1] - 1)) * factorTable[n5 + 1];
                        break;
                    }
                    case 3: {
                        d2 = (double)((byArray[n3] - 1) * 10000 + (byArray[n3 + 1] - 1) * 100 + (byArray[n3 + 2] - 1)) * factorTable[n5 + 2];
                        break;
                    }
                }
                while (n6 < n4) {
                    d2 += (double)((byArray[n3 + n6] - 1) * 1000000 + (byArray[n3 + n6 + 1] - 1) * 10000 + (byArray[n3 + n6 + 2] - 1) * 100 + (byArray[n3 + n6 + 3] - 1)) * factorTable[n5 + n6 + 3];
                    n6 += 4;
                }
            } else {
                if (by2 == 0 && by == 1) {
                    return Double.NEGATIVE_INFINITY;
                }
                byte by4 = (byte)((~by2 & 0xFFFFFF7F) - 65);
                int n7 = by - 1;
                if (n7 != 20 || byArray[n2 + n7] == 102) {
                    --n7;
                }
                int n8 = (int)(127.0 - (double)by4);
                int n9 = n7 % 4;
                switch (n9) {
                    case 1: {
                        d2 = (double)(101 - byArray[n3]) * factorTable[n8];
                        break;
                    }
                    case 2: {
                        d2 = (double)((101 - byArray[n3]) * 100 + (101 - byArray[n3 + 1])) * factorTable[n8 + 1];
                        break;
                    }
                    case 3: {
                        d2 = (double)((101 - byArray[n3]) * 10000 + (101 - byArray[n3 + 1]) * 100 + (101 - byArray[n3 + 2])) * factorTable[n8 + 2];
                        break;
                    }
                }
                while (n9 < n7) {
                    d2 += (double)((101 - byArray[n3 + n9]) * 1000000 + (101 - byArray[n3 + n9 + 1]) * 10000 + (101 - byArray[n3 + n9 + 2]) * 100 + (101 - byArray[n3 + n9 + 3])) * factorTable[n8 + n9 + 3];
                    n9 += 4;
                }
                d2 = -d2;
            }
            d = d2;
        }
        return d;
    }

    /*
     * Opcode count of 17589 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray;
            int n2;
            int n3;
            int n4;
            byte by;
            int n5;
            byte[] byArray2 = this.rowSpaceByte;
            int n6 = this.columnIndex + this.byteLength * n + 1;
            byte by2 = byArray2[n6 - 1];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            int n29 = 0;
            int n30 = 0;
            int n31 = 0;
            int n32 = 0;
            int n33 = 0;
            int n34 = 1;
            int n35 = 26;
            int n36 = 0;
            byte by3 = byArray2[n6];
            boolean bl = false;
            if ((by3 & 0xFFFFFF80) != 0) {
                if (by3 == -128 && by2 == 1) {
                    return BIGDEC_ZERO;
                }
                if (by2 == 2 && by3 == -1 && byArray2[n6 + 1] == 101) {
                    this.throwOverflow();
                }
                n5 = 1;
                by = (byte)((by3 & 0xFFFFFF7F) - 65);
                n4 = by2 - 1;
                n3 = n4 - 1;
                n2 = by - n4 + 1 << 1;
                if (n2 > 0) {
                    n2 = 0;
                    n3 = by;
                } else if (n2 < 0) {
                    bl = (byArray2[n6 + n4] - 1) % 10 == 0;
                }
                int n37 = n34;
                n34 = (byte)(n34 + 1);
                n33 = byArray2[n6 + n37] - 1;
                while ((n3 & 1) != 0) {
                    if (n34 > n4) {
                        n33 *= 100;
                    } else {
                        int n38 = n34;
                        n34 = (byte)(n34 + 1);
                        n33 = n33 * 100 + (byArray2[n6 + n38] - 1);
                    }
                    --n3;
                }
            } else {
                if (by3 == 0 && by2 == 1) {
                    this.throwOverflow();
                }
                n5 = -1;
                by = (byte)((~by3 & 0xFFFFFF7F) - 65);
                n4 = by2 - 1;
                if (n4 != 20 || byArray2[n6 + n4] == 102) {
                    --n4;
                }
                n3 = n4 - 1;
                n2 = by - n4 + 1 << 1;
                if (n2 > 0) {
                    n2 = 0;
                    n3 = by;
                } else if (n2 < 0) {
                    bl = (101 - byArray2[n6 + n4]) % 10 == 0;
                }
                int n39 = n34;
                n34 = (byte)(n34 + 1);
                n33 = 101 - byArray2[n6 + n39];
                while ((n3 & 1) != 0) {
                    if (n34 > n4) {
                        n33 *= 100;
                    } else {
                        int n40 = n34;
                        n34 = (byte)(n34 + 1);
                        n33 = n33 * 100 + (101 - byArray2[n6 + n40]);
                    }
                    --n3;
                }
            }
            if (bl) {
                ++n2;
                n33 /= 10;
            }
            int n41 = n4 - 1;
            while (n3 != 0) {
                int n42;
                if (n5 == 1) {
                    if (bl) {
                        n36 = (byArray2[n6 + n34 - 1] - 1) % 10 * 1000 + (byArray2[n6 + n34] - 1) * 10 + (byArray2[n6 + n34 + 1] - 1) / 10 + n33 * 10000;
                        n34 = (byte)(n34 + 2);
                    } else if (n34 < n41) {
                        n36 = (byArray2[n6 + n34] - 1) * 100 + (byArray2[n6 + n34 + 1] - 1) + n33 * 10000;
                        n34 = (byte)(n34 + 2);
                    } else {
                        n36 = 0;
                        if (n34 <= n4) {
                            n42 = 0;
                            while (n34 <= n4) {
                                int n43 = n34;
                                n34 = (byte)(n34 + 1);
                                n36 = n36 * 100 + (byArray2[n6 + n43] - 1);
                                ++n42;
                            }
                            while (n42 < 2) {
                                n36 *= 100;
                                ++n42;
                            }
                        }
                        n36 += n33 * 10000;
                    }
                } else if (bl) {
                    n36 = (101 - byArray2[n6 + n34 - 1]) % 10 * 1000 + (101 - byArray2[n6 + n34]) * 10 + (101 - byArray2[n6 + n34 + 1]) / 10 + n33 * 10000;
                    n34 = (byte)(n34 + 2);
                } else if (n34 < n41) {
                    n36 = (101 - byArray2[n6 + n34]) * 100 + (101 - byArray2[n6 + n34 + 1]) + n33 * 10000;
                    n34 = (byte)(n34 + 2);
                } else {
                    n36 = 0;
                    if (n34 <= n4) {
                        n42 = 0;
                        while (n34 <= n4) {
                            int n44 = n34;
                            n34 = (byte)(n34 + 1);
                            n36 = n36 * 100 + (101 - byArray2[n6 + n44]);
                            ++n42;
                        }
                        while (n42 < 2) {
                            n36 *= 100;
                            ++n42;
                        }
                    }
                    n36 += n33 * 10000;
                }
                switch (n35) {
                    case 26: {
                        n33 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n32 = n36;
                        break;
                    }
                    case 25: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n31 = n36;
                        break;
                    }
                    case 24: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n30 = n36;
                        break;
                    }
                    case 23: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n29 = n36;
                        break;
                    }
                    case 22: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n28 = n36;
                        break;
                    }
                    case 21: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n27 = n36;
                        break;
                    }
                    case 20: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n26 = n36;
                        break;
                    }
                    case 19: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n25 = n36;
                        break;
                    }
                    case 18: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n24 = n36;
                        break;
                    }
                    case 17: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n23 = n36;
                        break;
                    }
                    case 16: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n22 = n36;
                        break;
                    }
                    case 15: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n21 = n36;
                        break;
                    }
                    case 14: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n20 = n36;
                        break;
                    }
                    case 13: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n19 = n36;
                        break;
                    }
                    case 12: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n18 = n36;
                        break;
                    }
                    case 11: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n17 = n36;
                        break;
                    }
                    case 10: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n16 = n36;
                        break;
                    }
                    case 9: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n15 = n36;
                        break;
                    }
                    case 8: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n14 = n36;
                        break;
                    }
                    case 7: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n13 = n36;
                        break;
                    }
                    case 6: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n12 = n36;
                        break;
                    }
                    case 5: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n11 = n36;
                        break;
                    }
                    case 4: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n11 * 10000;
                        n11 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n10 = n36;
                        break;
                    }
                    case 3: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n11 * 10000;
                        n11 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n10 * 10000;
                        n10 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n9 = n36;
                        break;
                    }
                    case 2: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n11 * 10000;
                        n11 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n10 * 10000;
                        n10 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n9 * 10000;
                        n9 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n8 = n36;
                        break;
                    }
                    case 1: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n11 * 10000;
                        n11 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n10 * 10000;
                        n10 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n9 * 10000;
                        n9 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n8 * 10000;
                        n8 = n36 & 0xFFFF;
                        if ((n36 >>= 16) == 0) break;
                        n35 = (byte)(n35 - 1);
                        n7 = n36;
                        break;
                    }
                    case 0: {
                        n33 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n32 * 10000;
                        n32 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n31 * 10000;
                        n31 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n30 * 10000;
                        n30 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n29 * 10000;
                        n29 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n28 * 10000;
                        n28 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n27 * 10000;
                        n27 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n26 * 10000;
                        n26 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n25 * 10000;
                        n25 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n24 * 10000;
                        n24 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n23 * 10000;
                        n23 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n22 * 10000;
                        n22 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n21 * 10000;
                        n21 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n20 * 10000;
                        n20 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n19 * 10000;
                        n19 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n18 * 10000;
                        n18 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n17 * 10000;
                        n17 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n16 * 10000;
                        n16 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n15 * 10000;
                        n15 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n14 * 10000;
                        n14 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n13 * 10000;
                        n13 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n12 * 10000;
                        n12 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n11 * 10000;
                        n11 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n10 * 10000;
                        n10 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n9 * 10000;
                        n9 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n8 * 10000;
                        n8 = n36 & 0xFFFF;
                        n36 = (n36 >> 16) + n7 * 10000;
                        n7 = n36 & 0xFFFF;
                    }
                }
                n3 -= 2;
            }
            switch (n35) {
                default: {
                    byte by4 = (byte)(n7 >> 8 & 0xFF);
                    if (by4 == 0) {
                        int n45 = 53;
                        byArray = new byte[n45];
                        byArray[51] = (byte)(n33 >> 8 & 0xFF);
                        byArray[52] = (byte)(n33 & 0xFF);
                        byArray[49] = (byte)(n32 >> 8 & 0xFF);
                        byArray[50] = (byte)(n32 & 0xFF);
                        byArray[47] = (byte)(n31 >> 8 & 0xFF);
                        byArray[48] = (byte)(n31 & 0xFF);
                        byArray[45] = (byte)(n30 >> 8 & 0xFF);
                        byArray[46] = (byte)(n30 & 0xFF);
                        byArray[43] = (byte)(n29 >> 8 & 0xFF);
                        byArray[44] = (byte)(n29 & 0xFF);
                        byArray[41] = (byte)(n28 >> 8 & 0xFF);
                        byArray[42] = (byte)(n28 & 0xFF);
                        byArray[39] = (byte)(n27 >> 8 & 0xFF);
                        byArray[40] = (byte)(n27 & 0xFF);
                        byArray[37] = (byte)(n26 >> 8 & 0xFF);
                        byArray[38] = (byte)(n26 & 0xFF);
                        byArray[35] = (byte)(n25 >> 8 & 0xFF);
                        byArray[36] = (byte)(n25 & 0xFF);
                        byArray[33] = (byte)(n24 >> 8 & 0xFF);
                        byArray[34] = (byte)(n24 & 0xFF);
                        byArray[31] = (byte)(n23 >> 8 & 0xFF);
                        byArray[32] = (byte)(n23 & 0xFF);
                        byArray[29] = (byte)(n22 >> 8 & 0xFF);
                        byArray[30] = (byte)(n22 & 0xFF);
                        byArray[27] = (byte)(n21 >> 8 & 0xFF);
                        byArray[28] = (byte)(n21 & 0xFF);
                        byArray[25] = (byte)(n20 >> 8 & 0xFF);
                        byArray[26] = (byte)(n20 & 0xFF);
                        byArray[23] = (byte)(n19 >> 8 & 0xFF);
                        byArray[24] = (byte)(n19 & 0xFF);
                        byArray[21] = (byte)(n18 >> 8 & 0xFF);
                        byArray[22] = (byte)(n18 & 0xFF);
                        byArray[19] = (byte)(n17 >> 8 & 0xFF);
                        byArray[20] = (byte)(n17 & 0xFF);
                        byArray[17] = (byte)(n16 >> 8 & 0xFF);
                        byArray[18] = (byte)(n16 & 0xFF);
                        byArray[15] = (byte)(n15 >> 8 & 0xFF);
                        byArray[16] = (byte)(n15 & 0xFF);
                        byArray[13] = (byte)(n14 >> 8 & 0xFF);
                        byArray[14] = (byte)(n14 & 0xFF);
                        byArray[11] = (byte)(n13 >> 8 & 0xFF);
                        byArray[12] = (byte)(n13 & 0xFF);
                        byArray[9] = (byte)(n12 >> 8 & 0xFF);
                        byArray[10] = (byte)(n12 & 0xFF);
                        byArray[7] = (byte)(n11 >> 8 & 0xFF);
                        byArray[8] = (byte)(n11 & 0xFF);
                        byArray[5] = (byte)(n10 >> 8 & 0xFF);
                        byArray[6] = (byte)(n10 & 0xFF);
                        byArray[3] = (byte)(n9 >> 8 & 0xFF);
                        byArray[4] = (byte)(n9 & 0xFF);
                        byArray[1] = (byte)(n8 >> 8 & 0xFF);
                        byArray[2] = (byte)(n8 & 0xFF);
                        byArray[0] = (byte)(n7 & 0xFF);
                        break;
                    }
                    int n46 = 54;
                    byArray = new byte[n46];
                    byArray[52] = (byte)(n33 >> 8 & 0xFF);
                    byArray[53] = (byte)(n33 & 0xFF);
                    byArray[50] = (byte)(n32 >> 8 & 0xFF);
                    byArray[51] = (byte)(n32 & 0xFF);
                    byArray[48] = (byte)(n31 >> 8 & 0xFF);
                    byArray[49] = (byte)(n31 & 0xFF);
                    byArray[46] = (byte)(n30 >> 8 & 0xFF);
                    byArray[47] = (byte)(n30 & 0xFF);
                    byArray[44] = (byte)(n29 >> 8 & 0xFF);
                    byArray[45] = (byte)(n29 & 0xFF);
                    byArray[42] = (byte)(n28 >> 8 & 0xFF);
                    byArray[43] = (byte)(n28 & 0xFF);
                    byArray[40] = (byte)(n27 >> 8 & 0xFF);
                    byArray[41] = (byte)(n27 & 0xFF);
                    byArray[38] = (byte)(n26 >> 8 & 0xFF);
                    byArray[39] = (byte)(n26 & 0xFF);
                    byArray[36] = (byte)(n25 >> 8 & 0xFF);
                    byArray[37] = (byte)(n25 & 0xFF);
                    byArray[34] = (byte)(n24 >> 8 & 0xFF);
                    byArray[35] = (byte)(n24 & 0xFF);
                    byArray[32] = (byte)(n23 >> 8 & 0xFF);
                    byArray[33] = (byte)(n23 & 0xFF);
                    byArray[30] = (byte)(n22 >> 8 & 0xFF);
                    byArray[31] = (byte)(n22 & 0xFF);
                    byArray[28] = (byte)(n21 >> 8 & 0xFF);
                    byArray[29] = (byte)(n21 & 0xFF);
                    byArray[26] = (byte)(n20 >> 8 & 0xFF);
                    byArray[27] = (byte)(n20 & 0xFF);
                    byArray[24] = (byte)(n19 >> 8 & 0xFF);
                    byArray[25] = (byte)(n19 & 0xFF);
                    byArray[22] = (byte)(n18 >> 8 & 0xFF);
                    byArray[23] = (byte)(n18 & 0xFF);
                    byArray[20] = (byte)(n17 >> 8 & 0xFF);
                    byArray[21] = (byte)(n17 & 0xFF);
                    byArray[18] = (byte)(n16 >> 8 & 0xFF);
                    byArray[19] = (byte)(n16 & 0xFF);
                    byArray[16] = (byte)(n15 >> 8 & 0xFF);
                    byArray[17] = (byte)(n15 & 0xFF);
                    byArray[14] = (byte)(n14 >> 8 & 0xFF);
                    byArray[15] = (byte)(n14 & 0xFF);
                    byArray[12] = (byte)(n13 >> 8 & 0xFF);
                    byArray[13] = (byte)(n13 & 0xFF);
                    byArray[10] = (byte)(n12 >> 8 & 0xFF);
                    byArray[11] = (byte)(n12 & 0xFF);
                    byArray[8] = (byte)(n11 >> 8 & 0xFF);
                    byArray[9] = (byte)(n11 & 0xFF);
                    byArray[6] = (byte)(n10 >> 8 & 0xFF);
                    byArray[7] = (byte)(n10 & 0xFF);
                    byArray[4] = (byte)(n9 >> 8 & 0xFF);
                    byArray[5] = (byte)(n9 & 0xFF);
                    byArray[2] = (byte)(n8 >> 8 & 0xFF);
                    byArray[3] = (byte)(n8 & 0xFF);
                    byArray[0] = by4;
                    byArray[1] = (byte)(n7 & 0xFF);
                    break;
                }
                case 1: {
                    byte by5 = (byte)(n8 >> 8 & 0xFF);
                    if (by5 == 0) {
                        int n47 = 51;
                        byArray = new byte[n47];
                        byArray[49] = (byte)(n33 >> 8 & 0xFF);
                        byArray[50] = (byte)(n33 & 0xFF);
                        byArray[47] = (byte)(n32 >> 8 & 0xFF);
                        byArray[48] = (byte)(n32 & 0xFF);
                        byArray[45] = (byte)(n31 >> 8 & 0xFF);
                        byArray[46] = (byte)(n31 & 0xFF);
                        byArray[43] = (byte)(n30 >> 8 & 0xFF);
                        byArray[44] = (byte)(n30 & 0xFF);
                        byArray[41] = (byte)(n29 >> 8 & 0xFF);
                        byArray[42] = (byte)(n29 & 0xFF);
                        byArray[39] = (byte)(n28 >> 8 & 0xFF);
                        byArray[40] = (byte)(n28 & 0xFF);
                        byArray[37] = (byte)(n27 >> 8 & 0xFF);
                        byArray[38] = (byte)(n27 & 0xFF);
                        byArray[35] = (byte)(n26 >> 8 & 0xFF);
                        byArray[36] = (byte)(n26 & 0xFF);
                        byArray[33] = (byte)(n25 >> 8 & 0xFF);
                        byArray[34] = (byte)(n25 & 0xFF);
                        byArray[31] = (byte)(n24 >> 8 & 0xFF);
                        byArray[32] = (byte)(n24 & 0xFF);
                        byArray[29] = (byte)(n23 >> 8 & 0xFF);
                        byArray[30] = (byte)(n23 & 0xFF);
                        byArray[27] = (byte)(n22 >> 8 & 0xFF);
                        byArray[28] = (byte)(n22 & 0xFF);
                        byArray[25] = (byte)(n21 >> 8 & 0xFF);
                        byArray[26] = (byte)(n21 & 0xFF);
                        byArray[23] = (byte)(n20 >> 8 & 0xFF);
                        byArray[24] = (byte)(n20 & 0xFF);
                        byArray[21] = (byte)(n19 >> 8 & 0xFF);
                        byArray[22] = (byte)(n19 & 0xFF);
                        byArray[19] = (byte)(n18 >> 8 & 0xFF);
                        byArray[20] = (byte)(n18 & 0xFF);
                        byArray[17] = (byte)(n17 >> 8 & 0xFF);
                        byArray[18] = (byte)(n17 & 0xFF);
                        byArray[15] = (byte)(n16 >> 8 & 0xFF);
                        byArray[16] = (byte)(n16 & 0xFF);
                        byArray[13] = (byte)(n15 >> 8 & 0xFF);
                        byArray[14] = (byte)(n15 & 0xFF);
                        byArray[11] = (byte)(n14 >> 8 & 0xFF);
                        byArray[12] = (byte)(n14 & 0xFF);
                        byArray[9] = (byte)(n13 >> 8 & 0xFF);
                        byArray[10] = (byte)(n13 & 0xFF);
                        byArray[7] = (byte)(n12 >> 8 & 0xFF);
                        byArray[8] = (byte)(n12 & 0xFF);
                        byArray[5] = (byte)(n11 >> 8 & 0xFF);
                        byArray[6] = (byte)(n11 & 0xFF);
                        byArray[3] = (byte)(n10 >> 8 & 0xFF);
                        byArray[4] = (byte)(n10 & 0xFF);
                        byArray[1] = (byte)(n9 >> 8 & 0xFF);
                        byArray[2] = (byte)(n9 & 0xFF);
                        byArray[0] = (byte)(n8 & 0xFF);
                        break;
                    }
                    int n48 = 52;
                    byArray = new byte[n48];
                    byArray[50] = (byte)(n33 >> 8 & 0xFF);
                    byArray[51] = (byte)(n33 & 0xFF);
                    byArray[48] = (byte)(n32 >> 8 & 0xFF);
                    byArray[49] = (byte)(n32 & 0xFF);
                    byArray[46] = (byte)(n31 >> 8 & 0xFF);
                    byArray[47] = (byte)(n31 & 0xFF);
                    byArray[44] = (byte)(n30 >> 8 & 0xFF);
                    byArray[45] = (byte)(n30 & 0xFF);
                    byArray[42] = (byte)(n29 >> 8 & 0xFF);
                    byArray[43] = (byte)(n29 & 0xFF);
                    byArray[40] = (byte)(n28 >> 8 & 0xFF);
                    byArray[41] = (byte)(n28 & 0xFF);
                    byArray[38] = (byte)(n27 >> 8 & 0xFF);
                    byArray[39] = (byte)(n27 & 0xFF);
                    byArray[36] = (byte)(n26 >> 8 & 0xFF);
                    byArray[37] = (byte)(n26 & 0xFF);
                    byArray[34] = (byte)(n25 >> 8 & 0xFF);
                    byArray[35] = (byte)(n25 & 0xFF);
                    byArray[32] = (byte)(n24 >> 8 & 0xFF);
                    byArray[33] = (byte)(n24 & 0xFF);
                    byArray[30] = (byte)(n23 >> 8 & 0xFF);
                    byArray[31] = (byte)(n23 & 0xFF);
                    byArray[28] = (byte)(n22 >> 8 & 0xFF);
                    byArray[29] = (byte)(n22 & 0xFF);
                    byArray[26] = (byte)(n21 >> 8 & 0xFF);
                    byArray[27] = (byte)(n21 & 0xFF);
                    byArray[24] = (byte)(n20 >> 8 & 0xFF);
                    byArray[25] = (byte)(n20 & 0xFF);
                    byArray[22] = (byte)(n19 >> 8 & 0xFF);
                    byArray[23] = (byte)(n19 & 0xFF);
                    byArray[20] = (byte)(n18 >> 8 & 0xFF);
                    byArray[21] = (byte)(n18 & 0xFF);
                    byArray[18] = (byte)(n17 >> 8 & 0xFF);
                    byArray[19] = (byte)(n17 & 0xFF);
                    byArray[16] = (byte)(n16 >> 8 & 0xFF);
                    byArray[17] = (byte)(n16 & 0xFF);
                    byArray[14] = (byte)(n15 >> 8 & 0xFF);
                    byArray[15] = (byte)(n15 & 0xFF);
                    byArray[12] = (byte)(n14 >> 8 & 0xFF);
                    byArray[13] = (byte)(n14 & 0xFF);
                    byArray[10] = (byte)(n13 >> 8 & 0xFF);
                    byArray[11] = (byte)(n13 & 0xFF);
                    byArray[8] = (byte)(n12 >> 8 & 0xFF);
                    byArray[9] = (byte)(n12 & 0xFF);
                    byArray[6] = (byte)(n11 >> 8 & 0xFF);
                    byArray[7] = (byte)(n11 & 0xFF);
                    byArray[4] = (byte)(n10 >> 8 & 0xFF);
                    byArray[5] = (byte)(n10 & 0xFF);
                    byArray[2] = (byte)(n9 >> 8 & 0xFF);
                    byArray[3] = (byte)(n9 & 0xFF);
                    byArray[0] = by5;
                    byArray[1] = (byte)(n8 & 0xFF);
                    break;
                }
                case 2: {
                    byte by6 = (byte)(n9 >> 8 & 0xFF);
                    if (by6 == 0) {
                        int n49 = 49;
                        byArray = new byte[n49];
                        byArray[47] = (byte)(n33 >> 8 & 0xFF);
                        byArray[48] = (byte)(n33 & 0xFF);
                        byArray[45] = (byte)(n32 >> 8 & 0xFF);
                        byArray[46] = (byte)(n32 & 0xFF);
                        byArray[43] = (byte)(n31 >> 8 & 0xFF);
                        byArray[44] = (byte)(n31 & 0xFF);
                        byArray[41] = (byte)(n30 >> 8 & 0xFF);
                        byArray[42] = (byte)(n30 & 0xFF);
                        byArray[39] = (byte)(n29 >> 8 & 0xFF);
                        byArray[40] = (byte)(n29 & 0xFF);
                        byArray[37] = (byte)(n28 >> 8 & 0xFF);
                        byArray[38] = (byte)(n28 & 0xFF);
                        byArray[35] = (byte)(n27 >> 8 & 0xFF);
                        byArray[36] = (byte)(n27 & 0xFF);
                        byArray[33] = (byte)(n26 >> 8 & 0xFF);
                        byArray[34] = (byte)(n26 & 0xFF);
                        byArray[31] = (byte)(n25 >> 8 & 0xFF);
                        byArray[32] = (byte)(n25 & 0xFF);
                        byArray[29] = (byte)(n24 >> 8 & 0xFF);
                        byArray[30] = (byte)(n24 & 0xFF);
                        byArray[27] = (byte)(n23 >> 8 & 0xFF);
                        byArray[28] = (byte)(n23 & 0xFF);
                        byArray[25] = (byte)(n22 >> 8 & 0xFF);
                        byArray[26] = (byte)(n22 & 0xFF);
                        byArray[23] = (byte)(n21 >> 8 & 0xFF);
                        byArray[24] = (byte)(n21 & 0xFF);
                        byArray[21] = (byte)(n20 >> 8 & 0xFF);
                        byArray[22] = (byte)(n20 & 0xFF);
                        byArray[19] = (byte)(n19 >> 8 & 0xFF);
                        byArray[20] = (byte)(n19 & 0xFF);
                        byArray[17] = (byte)(n18 >> 8 & 0xFF);
                        byArray[18] = (byte)(n18 & 0xFF);
                        byArray[15] = (byte)(n17 >> 8 & 0xFF);
                        byArray[16] = (byte)(n17 & 0xFF);
                        byArray[13] = (byte)(n16 >> 8 & 0xFF);
                        byArray[14] = (byte)(n16 & 0xFF);
                        byArray[11] = (byte)(n15 >> 8 & 0xFF);
                        byArray[12] = (byte)(n15 & 0xFF);
                        byArray[9] = (byte)(n14 >> 8 & 0xFF);
                        byArray[10] = (byte)(n14 & 0xFF);
                        byArray[7] = (byte)(n13 >> 8 & 0xFF);
                        byArray[8] = (byte)(n13 & 0xFF);
                        byArray[5] = (byte)(n12 >> 8 & 0xFF);
                        byArray[6] = (byte)(n12 & 0xFF);
                        byArray[3] = (byte)(n11 >> 8 & 0xFF);
                        byArray[4] = (byte)(n11 & 0xFF);
                        byArray[1] = (byte)(n10 >> 8 & 0xFF);
                        byArray[2] = (byte)(n10 & 0xFF);
                        byArray[0] = (byte)(n9 & 0xFF);
                        break;
                    }
                    int n50 = 50;
                    byArray = new byte[n50];
                    byArray[48] = (byte)(n33 >> 8 & 0xFF);
                    byArray[49] = (byte)(n33 & 0xFF);
                    byArray[46] = (byte)(n32 >> 8 & 0xFF);
                    byArray[47] = (byte)(n32 & 0xFF);
                    byArray[44] = (byte)(n31 >> 8 & 0xFF);
                    byArray[45] = (byte)(n31 & 0xFF);
                    byArray[42] = (byte)(n30 >> 8 & 0xFF);
                    byArray[43] = (byte)(n30 & 0xFF);
                    byArray[40] = (byte)(n29 >> 8 & 0xFF);
                    byArray[41] = (byte)(n29 & 0xFF);
                    byArray[38] = (byte)(n28 >> 8 & 0xFF);
                    byArray[39] = (byte)(n28 & 0xFF);
                    byArray[36] = (byte)(n27 >> 8 & 0xFF);
                    byArray[37] = (byte)(n27 & 0xFF);
                    byArray[34] = (byte)(n26 >> 8 & 0xFF);
                    byArray[35] = (byte)(n26 & 0xFF);
                    byArray[32] = (byte)(n25 >> 8 & 0xFF);
                    byArray[33] = (byte)(n25 & 0xFF);
                    byArray[30] = (byte)(n24 >> 8 & 0xFF);
                    byArray[31] = (byte)(n24 & 0xFF);
                    byArray[28] = (byte)(n23 >> 8 & 0xFF);
                    byArray[29] = (byte)(n23 & 0xFF);
                    byArray[26] = (byte)(n22 >> 8 & 0xFF);
                    byArray[27] = (byte)(n22 & 0xFF);
                    byArray[24] = (byte)(n21 >> 8 & 0xFF);
                    byArray[25] = (byte)(n21 & 0xFF);
                    byArray[22] = (byte)(n20 >> 8 & 0xFF);
                    byArray[23] = (byte)(n20 & 0xFF);
                    byArray[20] = (byte)(n19 >> 8 & 0xFF);
                    byArray[21] = (byte)(n19 & 0xFF);
                    byArray[18] = (byte)(n18 >> 8 & 0xFF);
                    byArray[19] = (byte)(n18 & 0xFF);
                    byArray[16] = (byte)(n17 >> 8 & 0xFF);
                    byArray[17] = (byte)(n17 & 0xFF);
                    byArray[14] = (byte)(n16 >> 8 & 0xFF);
                    byArray[15] = (byte)(n16 & 0xFF);
                    byArray[12] = (byte)(n15 >> 8 & 0xFF);
                    byArray[13] = (byte)(n15 & 0xFF);
                    byArray[10] = (byte)(n14 >> 8 & 0xFF);
                    byArray[11] = (byte)(n14 & 0xFF);
                    byArray[8] = (byte)(n13 >> 8 & 0xFF);
                    byArray[9] = (byte)(n13 & 0xFF);
                    byArray[6] = (byte)(n12 >> 8 & 0xFF);
                    byArray[7] = (byte)(n12 & 0xFF);
                    byArray[4] = (byte)(n11 >> 8 & 0xFF);
                    byArray[5] = (byte)(n11 & 0xFF);
                    byArray[2] = (byte)(n10 >> 8 & 0xFF);
                    byArray[3] = (byte)(n10 & 0xFF);
                    byArray[0] = by6;
                    byArray[1] = (byte)(n9 & 0xFF);
                    break;
                }
                case 3: {
                    byte by7 = (byte)(n10 >> 8 & 0xFF);
                    if (by7 == 0) {
                        int n51 = 47;
                        byArray = new byte[n51];
                        byArray[45] = (byte)(n33 >> 8 & 0xFF);
                        byArray[46] = (byte)(n33 & 0xFF);
                        byArray[43] = (byte)(n32 >> 8 & 0xFF);
                        byArray[44] = (byte)(n32 & 0xFF);
                        byArray[41] = (byte)(n31 >> 8 & 0xFF);
                        byArray[42] = (byte)(n31 & 0xFF);
                        byArray[39] = (byte)(n30 >> 8 & 0xFF);
                        byArray[40] = (byte)(n30 & 0xFF);
                        byArray[37] = (byte)(n29 >> 8 & 0xFF);
                        byArray[38] = (byte)(n29 & 0xFF);
                        byArray[35] = (byte)(n28 >> 8 & 0xFF);
                        byArray[36] = (byte)(n28 & 0xFF);
                        byArray[33] = (byte)(n27 >> 8 & 0xFF);
                        byArray[34] = (byte)(n27 & 0xFF);
                        byArray[31] = (byte)(n26 >> 8 & 0xFF);
                        byArray[32] = (byte)(n26 & 0xFF);
                        byArray[29] = (byte)(n25 >> 8 & 0xFF);
                        byArray[30] = (byte)(n25 & 0xFF);
                        byArray[27] = (byte)(n24 >> 8 & 0xFF);
                        byArray[28] = (byte)(n24 & 0xFF);
                        byArray[25] = (byte)(n23 >> 8 & 0xFF);
                        byArray[26] = (byte)(n23 & 0xFF);
                        byArray[23] = (byte)(n22 >> 8 & 0xFF);
                        byArray[24] = (byte)(n22 & 0xFF);
                        byArray[21] = (byte)(n21 >> 8 & 0xFF);
                        byArray[22] = (byte)(n21 & 0xFF);
                        byArray[19] = (byte)(n20 >> 8 & 0xFF);
                        byArray[20] = (byte)(n20 & 0xFF);
                        byArray[17] = (byte)(n19 >> 8 & 0xFF);
                        byArray[18] = (byte)(n19 & 0xFF);
                        byArray[15] = (byte)(n18 >> 8 & 0xFF);
                        byArray[16] = (byte)(n18 & 0xFF);
                        byArray[13] = (byte)(n17 >> 8 & 0xFF);
                        byArray[14] = (byte)(n17 & 0xFF);
                        byArray[11] = (byte)(n16 >> 8 & 0xFF);
                        byArray[12] = (byte)(n16 & 0xFF);
                        byArray[9] = (byte)(n15 >> 8 & 0xFF);
                        byArray[10] = (byte)(n15 & 0xFF);
                        byArray[7] = (byte)(n14 >> 8 & 0xFF);
                        byArray[8] = (byte)(n14 & 0xFF);
                        byArray[5] = (byte)(n13 >> 8 & 0xFF);
                        byArray[6] = (byte)(n13 & 0xFF);
                        byArray[3] = (byte)(n12 >> 8 & 0xFF);
                        byArray[4] = (byte)(n12 & 0xFF);
                        byArray[1] = (byte)(n11 >> 8 & 0xFF);
                        byArray[2] = (byte)(n11 & 0xFF);
                        byArray[0] = (byte)(n10 & 0xFF);
                        break;
                    }
                    int n52 = 48;
                    byArray = new byte[n52];
                    byArray[46] = (byte)(n33 >> 8 & 0xFF);
                    byArray[47] = (byte)(n33 & 0xFF);
                    byArray[44] = (byte)(n32 >> 8 & 0xFF);
                    byArray[45] = (byte)(n32 & 0xFF);
                    byArray[42] = (byte)(n31 >> 8 & 0xFF);
                    byArray[43] = (byte)(n31 & 0xFF);
                    byArray[40] = (byte)(n30 >> 8 & 0xFF);
                    byArray[41] = (byte)(n30 & 0xFF);
                    byArray[38] = (byte)(n29 >> 8 & 0xFF);
                    byArray[39] = (byte)(n29 & 0xFF);
                    byArray[36] = (byte)(n28 >> 8 & 0xFF);
                    byArray[37] = (byte)(n28 & 0xFF);
                    byArray[34] = (byte)(n27 >> 8 & 0xFF);
                    byArray[35] = (byte)(n27 & 0xFF);
                    byArray[32] = (byte)(n26 >> 8 & 0xFF);
                    byArray[33] = (byte)(n26 & 0xFF);
                    byArray[30] = (byte)(n25 >> 8 & 0xFF);
                    byArray[31] = (byte)(n25 & 0xFF);
                    byArray[28] = (byte)(n24 >> 8 & 0xFF);
                    byArray[29] = (byte)(n24 & 0xFF);
                    byArray[26] = (byte)(n23 >> 8 & 0xFF);
                    byArray[27] = (byte)(n23 & 0xFF);
                    byArray[24] = (byte)(n22 >> 8 & 0xFF);
                    byArray[25] = (byte)(n22 & 0xFF);
                    byArray[22] = (byte)(n21 >> 8 & 0xFF);
                    byArray[23] = (byte)(n21 & 0xFF);
                    byArray[20] = (byte)(n20 >> 8 & 0xFF);
                    byArray[21] = (byte)(n20 & 0xFF);
                    byArray[18] = (byte)(n19 >> 8 & 0xFF);
                    byArray[19] = (byte)(n19 & 0xFF);
                    byArray[16] = (byte)(n18 >> 8 & 0xFF);
                    byArray[17] = (byte)(n18 & 0xFF);
                    byArray[14] = (byte)(n17 >> 8 & 0xFF);
                    byArray[15] = (byte)(n17 & 0xFF);
                    byArray[12] = (byte)(n16 >> 8 & 0xFF);
                    byArray[13] = (byte)(n16 & 0xFF);
                    byArray[10] = (byte)(n15 >> 8 & 0xFF);
                    byArray[11] = (byte)(n15 & 0xFF);
                    byArray[8] = (byte)(n14 >> 8 & 0xFF);
                    byArray[9] = (byte)(n14 & 0xFF);
                    byArray[6] = (byte)(n13 >> 8 & 0xFF);
                    byArray[7] = (byte)(n13 & 0xFF);
                    byArray[4] = (byte)(n12 >> 8 & 0xFF);
                    byArray[5] = (byte)(n12 & 0xFF);
                    byArray[2] = (byte)(n11 >> 8 & 0xFF);
                    byArray[3] = (byte)(n11 & 0xFF);
                    byArray[0] = by7;
                    byArray[1] = (byte)(n10 & 0xFF);
                    break;
                }
                case 4: {
                    byte by8 = (byte)(n11 >> 8 & 0xFF);
                    if (by8 == 0) {
                        int n53 = 45;
                        byArray = new byte[n53];
                        byArray[43] = (byte)(n33 >> 8 & 0xFF);
                        byArray[44] = (byte)(n33 & 0xFF);
                        byArray[41] = (byte)(n32 >> 8 & 0xFF);
                        byArray[42] = (byte)(n32 & 0xFF);
                        byArray[39] = (byte)(n31 >> 8 & 0xFF);
                        byArray[40] = (byte)(n31 & 0xFF);
                        byArray[37] = (byte)(n30 >> 8 & 0xFF);
                        byArray[38] = (byte)(n30 & 0xFF);
                        byArray[35] = (byte)(n29 >> 8 & 0xFF);
                        byArray[36] = (byte)(n29 & 0xFF);
                        byArray[33] = (byte)(n28 >> 8 & 0xFF);
                        byArray[34] = (byte)(n28 & 0xFF);
                        byArray[31] = (byte)(n27 >> 8 & 0xFF);
                        byArray[32] = (byte)(n27 & 0xFF);
                        byArray[29] = (byte)(n26 >> 8 & 0xFF);
                        byArray[30] = (byte)(n26 & 0xFF);
                        byArray[27] = (byte)(n25 >> 8 & 0xFF);
                        byArray[28] = (byte)(n25 & 0xFF);
                        byArray[25] = (byte)(n24 >> 8 & 0xFF);
                        byArray[26] = (byte)(n24 & 0xFF);
                        byArray[23] = (byte)(n23 >> 8 & 0xFF);
                        byArray[24] = (byte)(n23 & 0xFF);
                        byArray[21] = (byte)(n22 >> 8 & 0xFF);
                        byArray[22] = (byte)(n22 & 0xFF);
                        byArray[19] = (byte)(n21 >> 8 & 0xFF);
                        byArray[20] = (byte)(n21 & 0xFF);
                        byArray[17] = (byte)(n20 >> 8 & 0xFF);
                        byArray[18] = (byte)(n20 & 0xFF);
                        byArray[15] = (byte)(n19 >> 8 & 0xFF);
                        byArray[16] = (byte)(n19 & 0xFF);
                        byArray[13] = (byte)(n18 >> 8 & 0xFF);
                        byArray[14] = (byte)(n18 & 0xFF);
                        byArray[11] = (byte)(n17 >> 8 & 0xFF);
                        byArray[12] = (byte)(n17 & 0xFF);
                        byArray[9] = (byte)(n16 >> 8 & 0xFF);
                        byArray[10] = (byte)(n16 & 0xFF);
                        byArray[7] = (byte)(n15 >> 8 & 0xFF);
                        byArray[8] = (byte)(n15 & 0xFF);
                        byArray[5] = (byte)(n14 >> 8 & 0xFF);
                        byArray[6] = (byte)(n14 & 0xFF);
                        byArray[3] = (byte)(n13 >> 8 & 0xFF);
                        byArray[4] = (byte)(n13 & 0xFF);
                        byArray[1] = (byte)(n12 >> 8 & 0xFF);
                        byArray[2] = (byte)(n12 & 0xFF);
                        byArray[0] = (byte)(n11 & 0xFF);
                        break;
                    }
                    int n54 = 46;
                    byArray = new byte[n54];
                    byArray[44] = (byte)(n33 >> 8 & 0xFF);
                    byArray[45] = (byte)(n33 & 0xFF);
                    byArray[42] = (byte)(n32 >> 8 & 0xFF);
                    byArray[43] = (byte)(n32 & 0xFF);
                    byArray[40] = (byte)(n31 >> 8 & 0xFF);
                    byArray[41] = (byte)(n31 & 0xFF);
                    byArray[38] = (byte)(n30 >> 8 & 0xFF);
                    byArray[39] = (byte)(n30 & 0xFF);
                    byArray[36] = (byte)(n29 >> 8 & 0xFF);
                    byArray[37] = (byte)(n29 & 0xFF);
                    byArray[34] = (byte)(n28 >> 8 & 0xFF);
                    byArray[35] = (byte)(n28 & 0xFF);
                    byArray[32] = (byte)(n27 >> 8 & 0xFF);
                    byArray[33] = (byte)(n27 & 0xFF);
                    byArray[30] = (byte)(n26 >> 8 & 0xFF);
                    byArray[31] = (byte)(n26 & 0xFF);
                    byArray[28] = (byte)(n25 >> 8 & 0xFF);
                    byArray[29] = (byte)(n25 & 0xFF);
                    byArray[26] = (byte)(n24 >> 8 & 0xFF);
                    byArray[27] = (byte)(n24 & 0xFF);
                    byArray[24] = (byte)(n23 >> 8 & 0xFF);
                    byArray[25] = (byte)(n23 & 0xFF);
                    byArray[22] = (byte)(n22 >> 8 & 0xFF);
                    byArray[23] = (byte)(n22 & 0xFF);
                    byArray[20] = (byte)(n21 >> 8 & 0xFF);
                    byArray[21] = (byte)(n21 & 0xFF);
                    byArray[18] = (byte)(n20 >> 8 & 0xFF);
                    byArray[19] = (byte)(n20 & 0xFF);
                    byArray[16] = (byte)(n19 >> 8 & 0xFF);
                    byArray[17] = (byte)(n19 & 0xFF);
                    byArray[14] = (byte)(n18 >> 8 & 0xFF);
                    byArray[15] = (byte)(n18 & 0xFF);
                    byArray[12] = (byte)(n17 >> 8 & 0xFF);
                    byArray[13] = (byte)(n17 & 0xFF);
                    byArray[10] = (byte)(n16 >> 8 & 0xFF);
                    byArray[11] = (byte)(n16 & 0xFF);
                    byArray[8] = (byte)(n15 >> 8 & 0xFF);
                    byArray[9] = (byte)(n15 & 0xFF);
                    byArray[6] = (byte)(n14 >> 8 & 0xFF);
                    byArray[7] = (byte)(n14 & 0xFF);
                    byArray[4] = (byte)(n13 >> 8 & 0xFF);
                    byArray[5] = (byte)(n13 & 0xFF);
                    byArray[2] = (byte)(n12 >> 8 & 0xFF);
                    byArray[3] = (byte)(n12 & 0xFF);
                    byArray[0] = by8;
                    byArray[1] = (byte)(n11 & 0xFF);
                    break;
                }
                case 5: {
                    byte by9 = (byte)(n12 >> 8 & 0xFF);
                    if (by9 == 0) {
                        int n55 = 43;
                        byArray = new byte[n55];
                        byArray[41] = (byte)(n33 >> 8 & 0xFF);
                        byArray[42] = (byte)(n33 & 0xFF);
                        byArray[39] = (byte)(n32 >> 8 & 0xFF);
                        byArray[40] = (byte)(n32 & 0xFF);
                        byArray[37] = (byte)(n31 >> 8 & 0xFF);
                        byArray[38] = (byte)(n31 & 0xFF);
                        byArray[35] = (byte)(n30 >> 8 & 0xFF);
                        byArray[36] = (byte)(n30 & 0xFF);
                        byArray[33] = (byte)(n29 >> 8 & 0xFF);
                        byArray[34] = (byte)(n29 & 0xFF);
                        byArray[31] = (byte)(n28 >> 8 & 0xFF);
                        byArray[32] = (byte)(n28 & 0xFF);
                        byArray[29] = (byte)(n27 >> 8 & 0xFF);
                        byArray[30] = (byte)(n27 & 0xFF);
                        byArray[27] = (byte)(n26 >> 8 & 0xFF);
                        byArray[28] = (byte)(n26 & 0xFF);
                        byArray[25] = (byte)(n25 >> 8 & 0xFF);
                        byArray[26] = (byte)(n25 & 0xFF);
                        byArray[23] = (byte)(n24 >> 8 & 0xFF);
                        byArray[24] = (byte)(n24 & 0xFF);
                        byArray[21] = (byte)(n23 >> 8 & 0xFF);
                        byArray[22] = (byte)(n23 & 0xFF);
                        byArray[19] = (byte)(n22 >> 8 & 0xFF);
                        byArray[20] = (byte)(n22 & 0xFF);
                        byArray[17] = (byte)(n21 >> 8 & 0xFF);
                        byArray[18] = (byte)(n21 & 0xFF);
                        byArray[15] = (byte)(n20 >> 8 & 0xFF);
                        byArray[16] = (byte)(n20 & 0xFF);
                        byArray[13] = (byte)(n19 >> 8 & 0xFF);
                        byArray[14] = (byte)(n19 & 0xFF);
                        byArray[11] = (byte)(n18 >> 8 & 0xFF);
                        byArray[12] = (byte)(n18 & 0xFF);
                        byArray[9] = (byte)(n17 >> 8 & 0xFF);
                        byArray[10] = (byte)(n17 & 0xFF);
                        byArray[7] = (byte)(n16 >> 8 & 0xFF);
                        byArray[8] = (byte)(n16 & 0xFF);
                        byArray[5] = (byte)(n15 >> 8 & 0xFF);
                        byArray[6] = (byte)(n15 & 0xFF);
                        byArray[3] = (byte)(n14 >> 8 & 0xFF);
                        byArray[4] = (byte)(n14 & 0xFF);
                        byArray[1] = (byte)(n13 >> 8 & 0xFF);
                        byArray[2] = (byte)(n13 & 0xFF);
                        byArray[0] = (byte)(n12 & 0xFF);
                        break;
                    }
                    int n56 = 44;
                    byArray = new byte[n56];
                    byArray[42] = (byte)(n33 >> 8 & 0xFF);
                    byArray[43] = (byte)(n33 & 0xFF);
                    byArray[40] = (byte)(n32 >> 8 & 0xFF);
                    byArray[41] = (byte)(n32 & 0xFF);
                    byArray[38] = (byte)(n31 >> 8 & 0xFF);
                    byArray[39] = (byte)(n31 & 0xFF);
                    byArray[36] = (byte)(n30 >> 8 & 0xFF);
                    byArray[37] = (byte)(n30 & 0xFF);
                    byArray[34] = (byte)(n29 >> 8 & 0xFF);
                    byArray[35] = (byte)(n29 & 0xFF);
                    byArray[32] = (byte)(n28 >> 8 & 0xFF);
                    byArray[33] = (byte)(n28 & 0xFF);
                    byArray[30] = (byte)(n27 >> 8 & 0xFF);
                    byArray[31] = (byte)(n27 & 0xFF);
                    byArray[28] = (byte)(n26 >> 8 & 0xFF);
                    byArray[29] = (byte)(n26 & 0xFF);
                    byArray[26] = (byte)(n25 >> 8 & 0xFF);
                    byArray[27] = (byte)(n25 & 0xFF);
                    byArray[24] = (byte)(n24 >> 8 & 0xFF);
                    byArray[25] = (byte)(n24 & 0xFF);
                    byArray[22] = (byte)(n23 >> 8 & 0xFF);
                    byArray[23] = (byte)(n23 & 0xFF);
                    byArray[20] = (byte)(n22 >> 8 & 0xFF);
                    byArray[21] = (byte)(n22 & 0xFF);
                    byArray[18] = (byte)(n21 >> 8 & 0xFF);
                    byArray[19] = (byte)(n21 & 0xFF);
                    byArray[16] = (byte)(n20 >> 8 & 0xFF);
                    byArray[17] = (byte)(n20 & 0xFF);
                    byArray[14] = (byte)(n19 >> 8 & 0xFF);
                    byArray[15] = (byte)(n19 & 0xFF);
                    byArray[12] = (byte)(n18 >> 8 & 0xFF);
                    byArray[13] = (byte)(n18 & 0xFF);
                    byArray[10] = (byte)(n17 >> 8 & 0xFF);
                    byArray[11] = (byte)(n17 & 0xFF);
                    byArray[8] = (byte)(n16 >> 8 & 0xFF);
                    byArray[9] = (byte)(n16 & 0xFF);
                    byArray[6] = (byte)(n15 >> 8 & 0xFF);
                    byArray[7] = (byte)(n15 & 0xFF);
                    byArray[4] = (byte)(n14 >> 8 & 0xFF);
                    byArray[5] = (byte)(n14 & 0xFF);
                    byArray[2] = (byte)(n13 >> 8 & 0xFF);
                    byArray[3] = (byte)(n13 & 0xFF);
                    byArray[0] = by9;
                    byArray[1] = (byte)(n12 & 0xFF);
                    break;
                }
                case 6: {
                    byte by10 = (byte)(n13 >> 8 & 0xFF);
                    if (by10 == 0) {
                        int n57 = 41;
                        byArray = new byte[n57];
                        byArray[39] = (byte)(n33 >> 8 & 0xFF);
                        byArray[40] = (byte)(n33 & 0xFF);
                        byArray[37] = (byte)(n32 >> 8 & 0xFF);
                        byArray[38] = (byte)(n32 & 0xFF);
                        byArray[35] = (byte)(n31 >> 8 & 0xFF);
                        byArray[36] = (byte)(n31 & 0xFF);
                        byArray[33] = (byte)(n30 >> 8 & 0xFF);
                        byArray[34] = (byte)(n30 & 0xFF);
                        byArray[31] = (byte)(n29 >> 8 & 0xFF);
                        byArray[32] = (byte)(n29 & 0xFF);
                        byArray[29] = (byte)(n28 >> 8 & 0xFF);
                        byArray[30] = (byte)(n28 & 0xFF);
                        byArray[27] = (byte)(n27 >> 8 & 0xFF);
                        byArray[28] = (byte)(n27 & 0xFF);
                        byArray[25] = (byte)(n26 >> 8 & 0xFF);
                        byArray[26] = (byte)(n26 & 0xFF);
                        byArray[23] = (byte)(n25 >> 8 & 0xFF);
                        byArray[24] = (byte)(n25 & 0xFF);
                        byArray[21] = (byte)(n24 >> 8 & 0xFF);
                        byArray[22] = (byte)(n24 & 0xFF);
                        byArray[19] = (byte)(n23 >> 8 & 0xFF);
                        byArray[20] = (byte)(n23 & 0xFF);
                        byArray[17] = (byte)(n22 >> 8 & 0xFF);
                        byArray[18] = (byte)(n22 & 0xFF);
                        byArray[15] = (byte)(n21 >> 8 & 0xFF);
                        byArray[16] = (byte)(n21 & 0xFF);
                        byArray[13] = (byte)(n20 >> 8 & 0xFF);
                        byArray[14] = (byte)(n20 & 0xFF);
                        byArray[11] = (byte)(n19 >> 8 & 0xFF);
                        byArray[12] = (byte)(n19 & 0xFF);
                        byArray[9] = (byte)(n18 >> 8 & 0xFF);
                        byArray[10] = (byte)(n18 & 0xFF);
                        byArray[7] = (byte)(n17 >> 8 & 0xFF);
                        byArray[8] = (byte)(n17 & 0xFF);
                        byArray[5] = (byte)(n16 >> 8 & 0xFF);
                        byArray[6] = (byte)(n16 & 0xFF);
                        byArray[3] = (byte)(n15 >> 8 & 0xFF);
                        byArray[4] = (byte)(n15 & 0xFF);
                        byArray[1] = (byte)(n14 >> 8 & 0xFF);
                        byArray[2] = (byte)(n14 & 0xFF);
                        byArray[0] = (byte)(n13 & 0xFF);
                        break;
                    }
                    int n58 = 42;
                    byArray = new byte[n58];
                    byArray[40] = (byte)(n33 >> 8 & 0xFF);
                    byArray[41] = (byte)(n33 & 0xFF);
                    byArray[38] = (byte)(n32 >> 8 & 0xFF);
                    byArray[39] = (byte)(n32 & 0xFF);
                    byArray[36] = (byte)(n31 >> 8 & 0xFF);
                    byArray[37] = (byte)(n31 & 0xFF);
                    byArray[34] = (byte)(n30 >> 8 & 0xFF);
                    byArray[35] = (byte)(n30 & 0xFF);
                    byArray[32] = (byte)(n29 >> 8 & 0xFF);
                    byArray[33] = (byte)(n29 & 0xFF);
                    byArray[30] = (byte)(n28 >> 8 & 0xFF);
                    byArray[31] = (byte)(n28 & 0xFF);
                    byArray[28] = (byte)(n27 >> 8 & 0xFF);
                    byArray[29] = (byte)(n27 & 0xFF);
                    byArray[26] = (byte)(n26 >> 8 & 0xFF);
                    byArray[27] = (byte)(n26 & 0xFF);
                    byArray[24] = (byte)(n25 >> 8 & 0xFF);
                    byArray[25] = (byte)(n25 & 0xFF);
                    byArray[22] = (byte)(n24 >> 8 & 0xFF);
                    byArray[23] = (byte)(n24 & 0xFF);
                    byArray[20] = (byte)(n23 >> 8 & 0xFF);
                    byArray[21] = (byte)(n23 & 0xFF);
                    byArray[18] = (byte)(n22 >> 8 & 0xFF);
                    byArray[19] = (byte)(n22 & 0xFF);
                    byArray[16] = (byte)(n21 >> 8 & 0xFF);
                    byArray[17] = (byte)(n21 & 0xFF);
                    byArray[14] = (byte)(n20 >> 8 & 0xFF);
                    byArray[15] = (byte)(n20 & 0xFF);
                    byArray[12] = (byte)(n19 >> 8 & 0xFF);
                    byArray[13] = (byte)(n19 & 0xFF);
                    byArray[10] = (byte)(n18 >> 8 & 0xFF);
                    byArray[11] = (byte)(n18 & 0xFF);
                    byArray[8] = (byte)(n17 >> 8 & 0xFF);
                    byArray[9] = (byte)(n17 & 0xFF);
                    byArray[6] = (byte)(n16 >> 8 & 0xFF);
                    byArray[7] = (byte)(n16 & 0xFF);
                    byArray[4] = (byte)(n15 >> 8 & 0xFF);
                    byArray[5] = (byte)(n15 & 0xFF);
                    byArray[2] = (byte)(n14 >> 8 & 0xFF);
                    byArray[3] = (byte)(n14 & 0xFF);
                    byArray[0] = by10;
                    byArray[1] = (byte)(n13 & 0xFF);
                    break;
                }
                case 7: {
                    byte by11 = (byte)(n14 >> 8 & 0xFF);
                    if (by11 == 0) {
                        int n59 = 39;
                        byArray = new byte[n59];
                        byArray[37] = (byte)(n33 >> 8 & 0xFF);
                        byArray[38] = (byte)(n33 & 0xFF);
                        byArray[35] = (byte)(n32 >> 8 & 0xFF);
                        byArray[36] = (byte)(n32 & 0xFF);
                        byArray[33] = (byte)(n31 >> 8 & 0xFF);
                        byArray[34] = (byte)(n31 & 0xFF);
                        byArray[31] = (byte)(n30 >> 8 & 0xFF);
                        byArray[32] = (byte)(n30 & 0xFF);
                        byArray[29] = (byte)(n29 >> 8 & 0xFF);
                        byArray[30] = (byte)(n29 & 0xFF);
                        byArray[27] = (byte)(n28 >> 8 & 0xFF);
                        byArray[28] = (byte)(n28 & 0xFF);
                        byArray[25] = (byte)(n27 >> 8 & 0xFF);
                        byArray[26] = (byte)(n27 & 0xFF);
                        byArray[23] = (byte)(n26 >> 8 & 0xFF);
                        byArray[24] = (byte)(n26 & 0xFF);
                        byArray[21] = (byte)(n25 >> 8 & 0xFF);
                        byArray[22] = (byte)(n25 & 0xFF);
                        byArray[19] = (byte)(n24 >> 8 & 0xFF);
                        byArray[20] = (byte)(n24 & 0xFF);
                        byArray[17] = (byte)(n23 >> 8 & 0xFF);
                        byArray[18] = (byte)(n23 & 0xFF);
                        byArray[15] = (byte)(n22 >> 8 & 0xFF);
                        byArray[16] = (byte)(n22 & 0xFF);
                        byArray[13] = (byte)(n21 >> 8 & 0xFF);
                        byArray[14] = (byte)(n21 & 0xFF);
                        byArray[11] = (byte)(n20 >> 8 & 0xFF);
                        byArray[12] = (byte)(n20 & 0xFF);
                        byArray[9] = (byte)(n19 >> 8 & 0xFF);
                        byArray[10] = (byte)(n19 & 0xFF);
                        byArray[7] = (byte)(n18 >> 8 & 0xFF);
                        byArray[8] = (byte)(n18 & 0xFF);
                        byArray[5] = (byte)(n17 >> 8 & 0xFF);
                        byArray[6] = (byte)(n17 & 0xFF);
                        byArray[3] = (byte)(n16 >> 8 & 0xFF);
                        byArray[4] = (byte)(n16 & 0xFF);
                        byArray[1] = (byte)(n15 >> 8 & 0xFF);
                        byArray[2] = (byte)(n15 & 0xFF);
                        byArray[0] = (byte)(n14 & 0xFF);
                        break;
                    }
                    int n60 = 40;
                    byArray = new byte[n60];
                    byArray[38] = (byte)(n33 >> 8 & 0xFF);
                    byArray[39] = (byte)(n33 & 0xFF);
                    byArray[36] = (byte)(n32 >> 8 & 0xFF);
                    byArray[37] = (byte)(n32 & 0xFF);
                    byArray[34] = (byte)(n31 >> 8 & 0xFF);
                    byArray[35] = (byte)(n31 & 0xFF);
                    byArray[32] = (byte)(n30 >> 8 & 0xFF);
                    byArray[33] = (byte)(n30 & 0xFF);
                    byArray[30] = (byte)(n29 >> 8 & 0xFF);
                    byArray[31] = (byte)(n29 & 0xFF);
                    byArray[28] = (byte)(n28 >> 8 & 0xFF);
                    byArray[29] = (byte)(n28 & 0xFF);
                    byArray[26] = (byte)(n27 >> 8 & 0xFF);
                    byArray[27] = (byte)(n27 & 0xFF);
                    byArray[24] = (byte)(n26 >> 8 & 0xFF);
                    byArray[25] = (byte)(n26 & 0xFF);
                    byArray[22] = (byte)(n25 >> 8 & 0xFF);
                    byArray[23] = (byte)(n25 & 0xFF);
                    byArray[20] = (byte)(n24 >> 8 & 0xFF);
                    byArray[21] = (byte)(n24 & 0xFF);
                    byArray[18] = (byte)(n23 >> 8 & 0xFF);
                    byArray[19] = (byte)(n23 & 0xFF);
                    byArray[16] = (byte)(n22 >> 8 & 0xFF);
                    byArray[17] = (byte)(n22 & 0xFF);
                    byArray[14] = (byte)(n21 >> 8 & 0xFF);
                    byArray[15] = (byte)(n21 & 0xFF);
                    byArray[12] = (byte)(n20 >> 8 & 0xFF);
                    byArray[13] = (byte)(n20 & 0xFF);
                    byArray[10] = (byte)(n19 >> 8 & 0xFF);
                    byArray[11] = (byte)(n19 & 0xFF);
                    byArray[8] = (byte)(n18 >> 8 & 0xFF);
                    byArray[9] = (byte)(n18 & 0xFF);
                    byArray[6] = (byte)(n17 >> 8 & 0xFF);
                    byArray[7] = (byte)(n17 & 0xFF);
                    byArray[4] = (byte)(n16 >> 8 & 0xFF);
                    byArray[5] = (byte)(n16 & 0xFF);
                    byArray[2] = (byte)(n15 >> 8 & 0xFF);
                    byArray[3] = (byte)(n15 & 0xFF);
                    byArray[0] = by11;
                    byArray[1] = (byte)(n14 & 0xFF);
                    break;
                }
                case 8: {
                    byte by12 = (byte)(n15 >> 8 & 0xFF);
                    if (by12 == 0) {
                        int n61 = 37;
                        byArray = new byte[n61];
                        byArray[35] = (byte)(n33 >> 8 & 0xFF);
                        byArray[36] = (byte)(n33 & 0xFF);
                        byArray[33] = (byte)(n32 >> 8 & 0xFF);
                        byArray[34] = (byte)(n32 & 0xFF);
                        byArray[31] = (byte)(n31 >> 8 & 0xFF);
                        byArray[32] = (byte)(n31 & 0xFF);
                        byArray[29] = (byte)(n30 >> 8 & 0xFF);
                        byArray[30] = (byte)(n30 & 0xFF);
                        byArray[27] = (byte)(n29 >> 8 & 0xFF);
                        byArray[28] = (byte)(n29 & 0xFF);
                        byArray[25] = (byte)(n28 >> 8 & 0xFF);
                        byArray[26] = (byte)(n28 & 0xFF);
                        byArray[23] = (byte)(n27 >> 8 & 0xFF);
                        byArray[24] = (byte)(n27 & 0xFF);
                        byArray[21] = (byte)(n26 >> 8 & 0xFF);
                        byArray[22] = (byte)(n26 & 0xFF);
                        byArray[19] = (byte)(n25 >> 8 & 0xFF);
                        byArray[20] = (byte)(n25 & 0xFF);
                        byArray[17] = (byte)(n24 >> 8 & 0xFF);
                        byArray[18] = (byte)(n24 & 0xFF);
                        byArray[15] = (byte)(n23 >> 8 & 0xFF);
                        byArray[16] = (byte)(n23 & 0xFF);
                        byArray[13] = (byte)(n22 >> 8 & 0xFF);
                        byArray[14] = (byte)(n22 & 0xFF);
                        byArray[11] = (byte)(n21 >> 8 & 0xFF);
                        byArray[12] = (byte)(n21 & 0xFF);
                        byArray[9] = (byte)(n20 >> 8 & 0xFF);
                        byArray[10] = (byte)(n20 & 0xFF);
                        byArray[7] = (byte)(n19 >> 8 & 0xFF);
                        byArray[8] = (byte)(n19 & 0xFF);
                        byArray[5] = (byte)(n18 >> 8 & 0xFF);
                        byArray[6] = (byte)(n18 & 0xFF);
                        byArray[3] = (byte)(n17 >> 8 & 0xFF);
                        byArray[4] = (byte)(n17 & 0xFF);
                        byArray[1] = (byte)(n16 >> 8 & 0xFF);
                        byArray[2] = (byte)(n16 & 0xFF);
                        byArray[0] = (byte)(n15 & 0xFF);
                        break;
                    }
                    int n62 = 38;
                    byArray = new byte[n62];
                    byArray[36] = (byte)(n33 >> 8 & 0xFF);
                    byArray[37] = (byte)(n33 & 0xFF);
                    byArray[34] = (byte)(n32 >> 8 & 0xFF);
                    byArray[35] = (byte)(n32 & 0xFF);
                    byArray[32] = (byte)(n31 >> 8 & 0xFF);
                    byArray[33] = (byte)(n31 & 0xFF);
                    byArray[30] = (byte)(n30 >> 8 & 0xFF);
                    byArray[31] = (byte)(n30 & 0xFF);
                    byArray[28] = (byte)(n29 >> 8 & 0xFF);
                    byArray[29] = (byte)(n29 & 0xFF);
                    byArray[26] = (byte)(n28 >> 8 & 0xFF);
                    byArray[27] = (byte)(n28 & 0xFF);
                    byArray[24] = (byte)(n27 >> 8 & 0xFF);
                    byArray[25] = (byte)(n27 & 0xFF);
                    byArray[22] = (byte)(n26 >> 8 & 0xFF);
                    byArray[23] = (byte)(n26 & 0xFF);
                    byArray[20] = (byte)(n25 >> 8 & 0xFF);
                    byArray[21] = (byte)(n25 & 0xFF);
                    byArray[18] = (byte)(n24 >> 8 & 0xFF);
                    byArray[19] = (byte)(n24 & 0xFF);
                    byArray[16] = (byte)(n23 >> 8 & 0xFF);
                    byArray[17] = (byte)(n23 & 0xFF);
                    byArray[14] = (byte)(n22 >> 8 & 0xFF);
                    byArray[15] = (byte)(n22 & 0xFF);
                    byArray[12] = (byte)(n21 >> 8 & 0xFF);
                    byArray[13] = (byte)(n21 & 0xFF);
                    byArray[10] = (byte)(n20 >> 8 & 0xFF);
                    byArray[11] = (byte)(n20 & 0xFF);
                    byArray[8] = (byte)(n19 >> 8 & 0xFF);
                    byArray[9] = (byte)(n19 & 0xFF);
                    byArray[6] = (byte)(n18 >> 8 & 0xFF);
                    byArray[7] = (byte)(n18 & 0xFF);
                    byArray[4] = (byte)(n17 >> 8 & 0xFF);
                    byArray[5] = (byte)(n17 & 0xFF);
                    byArray[2] = (byte)(n16 >> 8 & 0xFF);
                    byArray[3] = (byte)(n16 & 0xFF);
                    byArray[0] = by12;
                    byArray[1] = (byte)(n15 & 0xFF);
                    break;
                }
                case 9: {
                    byte by13 = (byte)(n16 >> 8 & 0xFF);
                    if (by13 == 0) {
                        int n63 = 35;
                        byArray = new byte[n63];
                        byArray[33] = (byte)(n33 >> 8 & 0xFF);
                        byArray[34] = (byte)(n33 & 0xFF);
                        byArray[31] = (byte)(n32 >> 8 & 0xFF);
                        byArray[32] = (byte)(n32 & 0xFF);
                        byArray[29] = (byte)(n31 >> 8 & 0xFF);
                        byArray[30] = (byte)(n31 & 0xFF);
                        byArray[27] = (byte)(n30 >> 8 & 0xFF);
                        byArray[28] = (byte)(n30 & 0xFF);
                        byArray[25] = (byte)(n29 >> 8 & 0xFF);
                        byArray[26] = (byte)(n29 & 0xFF);
                        byArray[23] = (byte)(n28 >> 8 & 0xFF);
                        byArray[24] = (byte)(n28 & 0xFF);
                        byArray[21] = (byte)(n27 >> 8 & 0xFF);
                        byArray[22] = (byte)(n27 & 0xFF);
                        byArray[19] = (byte)(n26 >> 8 & 0xFF);
                        byArray[20] = (byte)(n26 & 0xFF);
                        byArray[17] = (byte)(n25 >> 8 & 0xFF);
                        byArray[18] = (byte)(n25 & 0xFF);
                        byArray[15] = (byte)(n24 >> 8 & 0xFF);
                        byArray[16] = (byte)(n24 & 0xFF);
                        byArray[13] = (byte)(n23 >> 8 & 0xFF);
                        byArray[14] = (byte)(n23 & 0xFF);
                        byArray[11] = (byte)(n22 >> 8 & 0xFF);
                        byArray[12] = (byte)(n22 & 0xFF);
                        byArray[9] = (byte)(n21 >> 8 & 0xFF);
                        byArray[10] = (byte)(n21 & 0xFF);
                        byArray[7] = (byte)(n20 >> 8 & 0xFF);
                        byArray[8] = (byte)(n20 & 0xFF);
                        byArray[5] = (byte)(n19 >> 8 & 0xFF);
                        byArray[6] = (byte)(n19 & 0xFF);
                        byArray[3] = (byte)(n18 >> 8 & 0xFF);
                        byArray[4] = (byte)(n18 & 0xFF);
                        byArray[1] = (byte)(n17 >> 8 & 0xFF);
                        byArray[2] = (byte)(n17 & 0xFF);
                        byArray[0] = (byte)(n16 & 0xFF);
                        break;
                    }
                    int n64 = 36;
                    byArray = new byte[n64];
                    byArray[34] = (byte)(n33 >> 8 & 0xFF);
                    byArray[35] = (byte)(n33 & 0xFF);
                    byArray[32] = (byte)(n32 >> 8 & 0xFF);
                    byArray[33] = (byte)(n32 & 0xFF);
                    byArray[30] = (byte)(n31 >> 8 & 0xFF);
                    byArray[31] = (byte)(n31 & 0xFF);
                    byArray[28] = (byte)(n30 >> 8 & 0xFF);
                    byArray[29] = (byte)(n30 & 0xFF);
                    byArray[26] = (byte)(n29 >> 8 & 0xFF);
                    byArray[27] = (byte)(n29 & 0xFF);
                    byArray[24] = (byte)(n28 >> 8 & 0xFF);
                    byArray[25] = (byte)(n28 & 0xFF);
                    byArray[22] = (byte)(n27 >> 8 & 0xFF);
                    byArray[23] = (byte)(n27 & 0xFF);
                    byArray[20] = (byte)(n26 >> 8 & 0xFF);
                    byArray[21] = (byte)(n26 & 0xFF);
                    byArray[18] = (byte)(n25 >> 8 & 0xFF);
                    byArray[19] = (byte)(n25 & 0xFF);
                    byArray[16] = (byte)(n24 >> 8 & 0xFF);
                    byArray[17] = (byte)(n24 & 0xFF);
                    byArray[14] = (byte)(n23 >> 8 & 0xFF);
                    byArray[15] = (byte)(n23 & 0xFF);
                    byArray[12] = (byte)(n22 >> 8 & 0xFF);
                    byArray[13] = (byte)(n22 & 0xFF);
                    byArray[10] = (byte)(n21 >> 8 & 0xFF);
                    byArray[11] = (byte)(n21 & 0xFF);
                    byArray[8] = (byte)(n20 >> 8 & 0xFF);
                    byArray[9] = (byte)(n20 & 0xFF);
                    byArray[6] = (byte)(n19 >> 8 & 0xFF);
                    byArray[7] = (byte)(n19 & 0xFF);
                    byArray[4] = (byte)(n18 >> 8 & 0xFF);
                    byArray[5] = (byte)(n18 & 0xFF);
                    byArray[2] = (byte)(n17 >> 8 & 0xFF);
                    byArray[3] = (byte)(n17 & 0xFF);
                    byArray[0] = by13;
                    byArray[1] = (byte)(n16 & 0xFF);
                    break;
                }
                case 10: {
                    byte by14 = (byte)(n17 >> 8 & 0xFF);
                    if (by14 == 0) {
                        int n65 = 33;
                        byArray = new byte[n65];
                        byArray[31] = (byte)(n33 >> 8 & 0xFF);
                        byArray[32] = (byte)(n33 & 0xFF);
                        byArray[29] = (byte)(n32 >> 8 & 0xFF);
                        byArray[30] = (byte)(n32 & 0xFF);
                        byArray[27] = (byte)(n31 >> 8 & 0xFF);
                        byArray[28] = (byte)(n31 & 0xFF);
                        byArray[25] = (byte)(n30 >> 8 & 0xFF);
                        byArray[26] = (byte)(n30 & 0xFF);
                        byArray[23] = (byte)(n29 >> 8 & 0xFF);
                        byArray[24] = (byte)(n29 & 0xFF);
                        byArray[21] = (byte)(n28 >> 8 & 0xFF);
                        byArray[22] = (byte)(n28 & 0xFF);
                        byArray[19] = (byte)(n27 >> 8 & 0xFF);
                        byArray[20] = (byte)(n27 & 0xFF);
                        byArray[17] = (byte)(n26 >> 8 & 0xFF);
                        byArray[18] = (byte)(n26 & 0xFF);
                        byArray[15] = (byte)(n25 >> 8 & 0xFF);
                        byArray[16] = (byte)(n25 & 0xFF);
                        byArray[13] = (byte)(n24 >> 8 & 0xFF);
                        byArray[14] = (byte)(n24 & 0xFF);
                        byArray[11] = (byte)(n23 >> 8 & 0xFF);
                        byArray[12] = (byte)(n23 & 0xFF);
                        byArray[9] = (byte)(n22 >> 8 & 0xFF);
                        byArray[10] = (byte)(n22 & 0xFF);
                        byArray[7] = (byte)(n21 >> 8 & 0xFF);
                        byArray[8] = (byte)(n21 & 0xFF);
                        byArray[5] = (byte)(n20 >> 8 & 0xFF);
                        byArray[6] = (byte)(n20 & 0xFF);
                        byArray[3] = (byte)(n19 >> 8 & 0xFF);
                        byArray[4] = (byte)(n19 & 0xFF);
                        byArray[1] = (byte)(n18 >> 8 & 0xFF);
                        byArray[2] = (byte)(n18 & 0xFF);
                        byArray[0] = (byte)(n17 & 0xFF);
                        break;
                    }
                    int n66 = 34;
                    byArray = new byte[n66];
                    byArray[32] = (byte)(n33 >> 8 & 0xFF);
                    byArray[33] = (byte)(n33 & 0xFF);
                    byArray[30] = (byte)(n32 >> 8 & 0xFF);
                    byArray[31] = (byte)(n32 & 0xFF);
                    byArray[28] = (byte)(n31 >> 8 & 0xFF);
                    byArray[29] = (byte)(n31 & 0xFF);
                    byArray[26] = (byte)(n30 >> 8 & 0xFF);
                    byArray[27] = (byte)(n30 & 0xFF);
                    byArray[24] = (byte)(n29 >> 8 & 0xFF);
                    byArray[25] = (byte)(n29 & 0xFF);
                    byArray[22] = (byte)(n28 >> 8 & 0xFF);
                    byArray[23] = (byte)(n28 & 0xFF);
                    byArray[20] = (byte)(n27 >> 8 & 0xFF);
                    byArray[21] = (byte)(n27 & 0xFF);
                    byArray[18] = (byte)(n26 >> 8 & 0xFF);
                    byArray[19] = (byte)(n26 & 0xFF);
                    byArray[16] = (byte)(n25 >> 8 & 0xFF);
                    byArray[17] = (byte)(n25 & 0xFF);
                    byArray[14] = (byte)(n24 >> 8 & 0xFF);
                    byArray[15] = (byte)(n24 & 0xFF);
                    byArray[12] = (byte)(n23 >> 8 & 0xFF);
                    byArray[13] = (byte)(n23 & 0xFF);
                    byArray[10] = (byte)(n22 >> 8 & 0xFF);
                    byArray[11] = (byte)(n22 & 0xFF);
                    byArray[8] = (byte)(n21 >> 8 & 0xFF);
                    byArray[9] = (byte)(n21 & 0xFF);
                    byArray[6] = (byte)(n20 >> 8 & 0xFF);
                    byArray[7] = (byte)(n20 & 0xFF);
                    byArray[4] = (byte)(n19 >> 8 & 0xFF);
                    byArray[5] = (byte)(n19 & 0xFF);
                    byArray[2] = (byte)(n18 >> 8 & 0xFF);
                    byArray[3] = (byte)(n18 & 0xFF);
                    byArray[0] = by14;
                    byArray[1] = (byte)(n17 & 0xFF);
                    break;
                }
                case 11: {
                    byte by15 = (byte)(n18 >> 8 & 0xFF);
                    if (by15 == 0) {
                        int n67 = 31;
                        byArray = new byte[n67];
                        byArray[29] = (byte)(n33 >> 8 & 0xFF);
                        byArray[30] = (byte)(n33 & 0xFF);
                        byArray[27] = (byte)(n32 >> 8 & 0xFF);
                        byArray[28] = (byte)(n32 & 0xFF);
                        byArray[25] = (byte)(n31 >> 8 & 0xFF);
                        byArray[26] = (byte)(n31 & 0xFF);
                        byArray[23] = (byte)(n30 >> 8 & 0xFF);
                        byArray[24] = (byte)(n30 & 0xFF);
                        byArray[21] = (byte)(n29 >> 8 & 0xFF);
                        byArray[22] = (byte)(n29 & 0xFF);
                        byArray[19] = (byte)(n28 >> 8 & 0xFF);
                        byArray[20] = (byte)(n28 & 0xFF);
                        byArray[17] = (byte)(n27 >> 8 & 0xFF);
                        byArray[18] = (byte)(n27 & 0xFF);
                        byArray[15] = (byte)(n26 >> 8 & 0xFF);
                        byArray[16] = (byte)(n26 & 0xFF);
                        byArray[13] = (byte)(n25 >> 8 & 0xFF);
                        byArray[14] = (byte)(n25 & 0xFF);
                        byArray[11] = (byte)(n24 >> 8 & 0xFF);
                        byArray[12] = (byte)(n24 & 0xFF);
                        byArray[9] = (byte)(n23 >> 8 & 0xFF);
                        byArray[10] = (byte)(n23 & 0xFF);
                        byArray[7] = (byte)(n22 >> 8 & 0xFF);
                        byArray[8] = (byte)(n22 & 0xFF);
                        byArray[5] = (byte)(n21 >> 8 & 0xFF);
                        byArray[6] = (byte)(n21 & 0xFF);
                        byArray[3] = (byte)(n20 >> 8 & 0xFF);
                        byArray[4] = (byte)(n20 & 0xFF);
                        byArray[1] = (byte)(n19 >> 8 & 0xFF);
                        byArray[2] = (byte)(n19 & 0xFF);
                        byArray[0] = (byte)(n18 & 0xFF);
                        break;
                    }
                    int n68 = 32;
                    byArray = new byte[n68];
                    byArray[30] = (byte)(n33 >> 8 & 0xFF);
                    byArray[31] = (byte)(n33 & 0xFF);
                    byArray[28] = (byte)(n32 >> 8 & 0xFF);
                    byArray[29] = (byte)(n32 & 0xFF);
                    byArray[26] = (byte)(n31 >> 8 & 0xFF);
                    byArray[27] = (byte)(n31 & 0xFF);
                    byArray[24] = (byte)(n30 >> 8 & 0xFF);
                    byArray[25] = (byte)(n30 & 0xFF);
                    byArray[22] = (byte)(n29 >> 8 & 0xFF);
                    byArray[23] = (byte)(n29 & 0xFF);
                    byArray[20] = (byte)(n28 >> 8 & 0xFF);
                    byArray[21] = (byte)(n28 & 0xFF);
                    byArray[18] = (byte)(n27 >> 8 & 0xFF);
                    byArray[19] = (byte)(n27 & 0xFF);
                    byArray[16] = (byte)(n26 >> 8 & 0xFF);
                    byArray[17] = (byte)(n26 & 0xFF);
                    byArray[14] = (byte)(n25 >> 8 & 0xFF);
                    byArray[15] = (byte)(n25 & 0xFF);
                    byArray[12] = (byte)(n24 >> 8 & 0xFF);
                    byArray[13] = (byte)(n24 & 0xFF);
                    byArray[10] = (byte)(n23 >> 8 & 0xFF);
                    byArray[11] = (byte)(n23 & 0xFF);
                    byArray[8] = (byte)(n22 >> 8 & 0xFF);
                    byArray[9] = (byte)(n22 & 0xFF);
                    byArray[6] = (byte)(n21 >> 8 & 0xFF);
                    byArray[7] = (byte)(n21 & 0xFF);
                    byArray[4] = (byte)(n20 >> 8 & 0xFF);
                    byArray[5] = (byte)(n20 & 0xFF);
                    byArray[2] = (byte)(n19 >> 8 & 0xFF);
                    byArray[3] = (byte)(n19 & 0xFF);
                    byArray[0] = by15;
                    byArray[1] = (byte)(n18 & 0xFF);
                    break;
                }
                case 12: {
                    byte by16 = (byte)(n19 >> 8 & 0xFF);
                    if (by16 == 0) {
                        int n69 = 29;
                        byArray = new byte[n69];
                        byArray[27] = (byte)(n33 >> 8 & 0xFF);
                        byArray[28] = (byte)(n33 & 0xFF);
                        byArray[25] = (byte)(n32 >> 8 & 0xFF);
                        byArray[26] = (byte)(n32 & 0xFF);
                        byArray[23] = (byte)(n31 >> 8 & 0xFF);
                        byArray[24] = (byte)(n31 & 0xFF);
                        byArray[21] = (byte)(n30 >> 8 & 0xFF);
                        byArray[22] = (byte)(n30 & 0xFF);
                        byArray[19] = (byte)(n29 >> 8 & 0xFF);
                        byArray[20] = (byte)(n29 & 0xFF);
                        byArray[17] = (byte)(n28 >> 8 & 0xFF);
                        byArray[18] = (byte)(n28 & 0xFF);
                        byArray[15] = (byte)(n27 >> 8 & 0xFF);
                        byArray[16] = (byte)(n27 & 0xFF);
                        byArray[13] = (byte)(n26 >> 8 & 0xFF);
                        byArray[14] = (byte)(n26 & 0xFF);
                        byArray[11] = (byte)(n25 >> 8 & 0xFF);
                        byArray[12] = (byte)(n25 & 0xFF);
                        byArray[9] = (byte)(n24 >> 8 & 0xFF);
                        byArray[10] = (byte)(n24 & 0xFF);
                        byArray[7] = (byte)(n23 >> 8 & 0xFF);
                        byArray[8] = (byte)(n23 & 0xFF);
                        byArray[5] = (byte)(n22 >> 8 & 0xFF);
                        byArray[6] = (byte)(n22 & 0xFF);
                        byArray[3] = (byte)(n21 >> 8 & 0xFF);
                        byArray[4] = (byte)(n21 & 0xFF);
                        byArray[1] = (byte)(n20 >> 8 & 0xFF);
                        byArray[2] = (byte)(n20 & 0xFF);
                        byArray[0] = (byte)(n19 & 0xFF);
                        break;
                    }
                    int n70 = 30;
                    byArray = new byte[n70];
                    byArray[28] = (byte)(n33 >> 8 & 0xFF);
                    byArray[29] = (byte)(n33 & 0xFF);
                    byArray[26] = (byte)(n32 >> 8 & 0xFF);
                    byArray[27] = (byte)(n32 & 0xFF);
                    byArray[24] = (byte)(n31 >> 8 & 0xFF);
                    byArray[25] = (byte)(n31 & 0xFF);
                    byArray[22] = (byte)(n30 >> 8 & 0xFF);
                    byArray[23] = (byte)(n30 & 0xFF);
                    byArray[20] = (byte)(n29 >> 8 & 0xFF);
                    byArray[21] = (byte)(n29 & 0xFF);
                    byArray[18] = (byte)(n28 >> 8 & 0xFF);
                    byArray[19] = (byte)(n28 & 0xFF);
                    byArray[16] = (byte)(n27 >> 8 & 0xFF);
                    byArray[17] = (byte)(n27 & 0xFF);
                    byArray[14] = (byte)(n26 >> 8 & 0xFF);
                    byArray[15] = (byte)(n26 & 0xFF);
                    byArray[12] = (byte)(n25 >> 8 & 0xFF);
                    byArray[13] = (byte)(n25 & 0xFF);
                    byArray[10] = (byte)(n24 >> 8 & 0xFF);
                    byArray[11] = (byte)(n24 & 0xFF);
                    byArray[8] = (byte)(n23 >> 8 & 0xFF);
                    byArray[9] = (byte)(n23 & 0xFF);
                    byArray[6] = (byte)(n22 >> 8 & 0xFF);
                    byArray[7] = (byte)(n22 & 0xFF);
                    byArray[4] = (byte)(n21 >> 8 & 0xFF);
                    byArray[5] = (byte)(n21 & 0xFF);
                    byArray[2] = (byte)(n20 >> 8 & 0xFF);
                    byArray[3] = (byte)(n20 & 0xFF);
                    byArray[0] = by16;
                    byArray[1] = (byte)(n19 & 0xFF);
                    break;
                }
                case 13: {
                    byte by17 = (byte)(n20 >> 8 & 0xFF);
                    if (by17 == 0) {
                        int n71 = 27;
                        byArray = new byte[n71];
                        byArray[25] = (byte)(n33 >> 8 & 0xFF);
                        byArray[26] = (byte)(n33 & 0xFF);
                        byArray[23] = (byte)(n32 >> 8 & 0xFF);
                        byArray[24] = (byte)(n32 & 0xFF);
                        byArray[21] = (byte)(n31 >> 8 & 0xFF);
                        byArray[22] = (byte)(n31 & 0xFF);
                        byArray[19] = (byte)(n30 >> 8 & 0xFF);
                        byArray[20] = (byte)(n30 & 0xFF);
                        byArray[17] = (byte)(n29 >> 8 & 0xFF);
                        byArray[18] = (byte)(n29 & 0xFF);
                        byArray[15] = (byte)(n28 >> 8 & 0xFF);
                        byArray[16] = (byte)(n28 & 0xFF);
                        byArray[13] = (byte)(n27 >> 8 & 0xFF);
                        byArray[14] = (byte)(n27 & 0xFF);
                        byArray[11] = (byte)(n26 >> 8 & 0xFF);
                        byArray[12] = (byte)(n26 & 0xFF);
                        byArray[9] = (byte)(n25 >> 8 & 0xFF);
                        byArray[10] = (byte)(n25 & 0xFF);
                        byArray[7] = (byte)(n24 >> 8 & 0xFF);
                        byArray[8] = (byte)(n24 & 0xFF);
                        byArray[5] = (byte)(n23 >> 8 & 0xFF);
                        byArray[6] = (byte)(n23 & 0xFF);
                        byArray[3] = (byte)(n22 >> 8 & 0xFF);
                        byArray[4] = (byte)(n22 & 0xFF);
                        byArray[1] = (byte)(n21 >> 8 & 0xFF);
                        byArray[2] = (byte)(n21 & 0xFF);
                        byArray[0] = (byte)(n20 & 0xFF);
                        break;
                    }
                    int n72 = 28;
                    byArray = new byte[n72];
                    byArray[26] = (byte)(n33 >> 8 & 0xFF);
                    byArray[27] = (byte)(n33 & 0xFF);
                    byArray[24] = (byte)(n32 >> 8 & 0xFF);
                    byArray[25] = (byte)(n32 & 0xFF);
                    byArray[22] = (byte)(n31 >> 8 & 0xFF);
                    byArray[23] = (byte)(n31 & 0xFF);
                    byArray[20] = (byte)(n30 >> 8 & 0xFF);
                    byArray[21] = (byte)(n30 & 0xFF);
                    byArray[18] = (byte)(n29 >> 8 & 0xFF);
                    byArray[19] = (byte)(n29 & 0xFF);
                    byArray[16] = (byte)(n28 >> 8 & 0xFF);
                    byArray[17] = (byte)(n28 & 0xFF);
                    byArray[14] = (byte)(n27 >> 8 & 0xFF);
                    byArray[15] = (byte)(n27 & 0xFF);
                    byArray[12] = (byte)(n26 >> 8 & 0xFF);
                    byArray[13] = (byte)(n26 & 0xFF);
                    byArray[10] = (byte)(n25 >> 8 & 0xFF);
                    byArray[11] = (byte)(n25 & 0xFF);
                    byArray[8] = (byte)(n24 >> 8 & 0xFF);
                    byArray[9] = (byte)(n24 & 0xFF);
                    byArray[6] = (byte)(n23 >> 8 & 0xFF);
                    byArray[7] = (byte)(n23 & 0xFF);
                    byArray[4] = (byte)(n22 >> 8 & 0xFF);
                    byArray[5] = (byte)(n22 & 0xFF);
                    byArray[2] = (byte)(n21 >> 8 & 0xFF);
                    byArray[3] = (byte)(n21 & 0xFF);
                    byArray[0] = by17;
                    byArray[1] = (byte)(n20 & 0xFF);
                    break;
                }
                case 14: {
                    byte by18 = (byte)(n21 >> 8 & 0xFF);
                    if (by18 == 0) {
                        int n73 = 25;
                        byArray = new byte[n73];
                        byArray[23] = (byte)(n33 >> 8 & 0xFF);
                        byArray[24] = (byte)(n33 & 0xFF);
                        byArray[21] = (byte)(n32 >> 8 & 0xFF);
                        byArray[22] = (byte)(n32 & 0xFF);
                        byArray[19] = (byte)(n31 >> 8 & 0xFF);
                        byArray[20] = (byte)(n31 & 0xFF);
                        byArray[17] = (byte)(n30 >> 8 & 0xFF);
                        byArray[18] = (byte)(n30 & 0xFF);
                        byArray[15] = (byte)(n29 >> 8 & 0xFF);
                        byArray[16] = (byte)(n29 & 0xFF);
                        byArray[13] = (byte)(n28 >> 8 & 0xFF);
                        byArray[14] = (byte)(n28 & 0xFF);
                        byArray[11] = (byte)(n27 >> 8 & 0xFF);
                        byArray[12] = (byte)(n27 & 0xFF);
                        byArray[9] = (byte)(n26 >> 8 & 0xFF);
                        byArray[10] = (byte)(n26 & 0xFF);
                        byArray[7] = (byte)(n25 >> 8 & 0xFF);
                        byArray[8] = (byte)(n25 & 0xFF);
                        byArray[5] = (byte)(n24 >> 8 & 0xFF);
                        byArray[6] = (byte)(n24 & 0xFF);
                        byArray[3] = (byte)(n23 >> 8 & 0xFF);
                        byArray[4] = (byte)(n23 & 0xFF);
                        byArray[1] = (byte)(n22 >> 8 & 0xFF);
                        byArray[2] = (byte)(n22 & 0xFF);
                        byArray[0] = (byte)(n21 & 0xFF);
                        break;
                    }
                    int n74 = 26;
                    byArray = new byte[n74];
                    byArray[24] = (byte)(n33 >> 8 & 0xFF);
                    byArray[25] = (byte)(n33 & 0xFF);
                    byArray[22] = (byte)(n32 >> 8 & 0xFF);
                    byArray[23] = (byte)(n32 & 0xFF);
                    byArray[20] = (byte)(n31 >> 8 & 0xFF);
                    byArray[21] = (byte)(n31 & 0xFF);
                    byArray[18] = (byte)(n30 >> 8 & 0xFF);
                    byArray[19] = (byte)(n30 & 0xFF);
                    byArray[16] = (byte)(n29 >> 8 & 0xFF);
                    byArray[17] = (byte)(n29 & 0xFF);
                    byArray[14] = (byte)(n28 >> 8 & 0xFF);
                    byArray[15] = (byte)(n28 & 0xFF);
                    byArray[12] = (byte)(n27 >> 8 & 0xFF);
                    byArray[13] = (byte)(n27 & 0xFF);
                    byArray[10] = (byte)(n26 >> 8 & 0xFF);
                    byArray[11] = (byte)(n26 & 0xFF);
                    byArray[8] = (byte)(n25 >> 8 & 0xFF);
                    byArray[9] = (byte)(n25 & 0xFF);
                    byArray[6] = (byte)(n24 >> 8 & 0xFF);
                    byArray[7] = (byte)(n24 & 0xFF);
                    byArray[4] = (byte)(n23 >> 8 & 0xFF);
                    byArray[5] = (byte)(n23 & 0xFF);
                    byArray[2] = (byte)(n22 >> 8 & 0xFF);
                    byArray[3] = (byte)(n22 & 0xFF);
                    byArray[0] = by18;
                    byArray[1] = (byte)(n21 & 0xFF);
                    break;
                }
                case 15: {
                    byte by19 = (byte)(n22 >> 8 & 0xFF);
                    if (by19 == 0) {
                        int n75 = 23;
                        byArray = new byte[n75];
                        byArray[21] = (byte)(n33 >> 8 & 0xFF);
                        byArray[22] = (byte)(n33 & 0xFF);
                        byArray[19] = (byte)(n32 >> 8 & 0xFF);
                        byArray[20] = (byte)(n32 & 0xFF);
                        byArray[17] = (byte)(n31 >> 8 & 0xFF);
                        byArray[18] = (byte)(n31 & 0xFF);
                        byArray[15] = (byte)(n30 >> 8 & 0xFF);
                        byArray[16] = (byte)(n30 & 0xFF);
                        byArray[13] = (byte)(n29 >> 8 & 0xFF);
                        byArray[14] = (byte)(n29 & 0xFF);
                        byArray[11] = (byte)(n28 >> 8 & 0xFF);
                        byArray[12] = (byte)(n28 & 0xFF);
                        byArray[9] = (byte)(n27 >> 8 & 0xFF);
                        byArray[10] = (byte)(n27 & 0xFF);
                        byArray[7] = (byte)(n26 >> 8 & 0xFF);
                        byArray[8] = (byte)(n26 & 0xFF);
                        byArray[5] = (byte)(n25 >> 8 & 0xFF);
                        byArray[6] = (byte)(n25 & 0xFF);
                        byArray[3] = (byte)(n24 >> 8 & 0xFF);
                        byArray[4] = (byte)(n24 & 0xFF);
                        byArray[1] = (byte)(n23 >> 8 & 0xFF);
                        byArray[2] = (byte)(n23 & 0xFF);
                        byArray[0] = (byte)(n22 & 0xFF);
                        break;
                    }
                    int n76 = 24;
                    byArray = new byte[n76];
                    byArray[22] = (byte)(n33 >> 8 & 0xFF);
                    byArray[23] = (byte)(n33 & 0xFF);
                    byArray[20] = (byte)(n32 >> 8 & 0xFF);
                    byArray[21] = (byte)(n32 & 0xFF);
                    byArray[18] = (byte)(n31 >> 8 & 0xFF);
                    byArray[19] = (byte)(n31 & 0xFF);
                    byArray[16] = (byte)(n30 >> 8 & 0xFF);
                    byArray[17] = (byte)(n30 & 0xFF);
                    byArray[14] = (byte)(n29 >> 8 & 0xFF);
                    byArray[15] = (byte)(n29 & 0xFF);
                    byArray[12] = (byte)(n28 >> 8 & 0xFF);
                    byArray[13] = (byte)(n28 & 0xFF);
                    byArray[10] = (byte)(n27 >> 8 & 0xFF);
                    byArray[11] = (byte)(n27 & 0xFF);
                    byArray[8] = (byte)(n26 >> 8 & 0xFF);
                    byArray[9] = (byte)(n26 & 0xFF);
                    byArray[6] = (byte)(n25 >> 8 & 0xFF);
                    byArray[7] = (byte)(n25 & 0xFF);
                    byArray[4] = (byte)(n24 >> 8 & 0xFF);
                    byArray[5] = (byte)(n24 & 0xFF);
                    byArray[2] = (byte)(n23 >> 8 & 0xFF);
                    byArray[3] = (byte)(n23 & 0xFF);
                    byArray[0] = by19;
                    byArray[1] = (byte)(n22 & 0xFF);
                    break;
                }
                case 16: {
                    byte by20 = (byte)(n23 >> 8 & 0xFF);
                    if (by20 == 0) {
                        int n77 = 21;
                        byArray = new byte[n77];
                        byArray[19] = (byte)(n33 >> 8 & 0xFF);
                        byArray[20] = (byte)(n33 & 0xFF);
                        byArray[17] = (byte)(n32 >> 8 & 0xFF);
                        byArray[18] = (byte)(n32 & 0xFF);
                        byArray[15] = (byte)(n31 >> 8 & 0xFF);
                        byArray[16] = (byte)(n31 & 0xFF);
                        byArray[13] = (byte)(n30 >> 8 & 0xFF);
                        byArray[14] = (byte)(n30 & 0xFF);
                        byArray[11] = (byte)(n29 >> 8 & 0xFF);
                        byArray[12] = (byte)(n29 & 0xFF);
                        byArray[9] = (byte)(n28 >> 8 & 0xFF);
                        byArray[10] = (byte)(n28 & 0xFF);
                        byArray[7] = (byte)(n27 >> 8 & 0xFF);
                        byArray[8] = (byte)(n27 & 0xFF);
                        byArray[5] = (byte)(n26 >> 8 & 0xFF);
                        byArray[6] = (byte)(n26 & 0xFF);
                        byArray[3] = (byte)(n25 >> 8 & 0xFF);
                        byArray[4] = (byte)(n25 & 0xFF);
                        byArray[1] = (byte)(n24 >> 8 & 0xFF);
                        byArray[2] = (byte)(n24 & 0xFF);
                        byArray[0] = (byte)(n23 & 0xFF);
                        break;
                    }
                    int n78 = 22;
                    byArray = new byte[n78];
                    byArray[20] = (byte)(n33 >> 8 & 0xFF);
                    byArray[21] = (byte)(n33 & 0xFF);
                    byArray[18] = (byte)(n32 >> 8 & 0xFF);
                    byArray[19] = (byte)(n32 & 0xFF);
                    byArray[16] = (byte)(n31 >> 8 & 0xFF);
                    byArray[17] = (byte)(n31 & 0xFF);
                    byArray[14] = (byte)(n30 >> 8 & 0xFF);
                    byArray[15] = (byte)(n30 & 0xFF);
                    byArray[12] = (byte)(n29 >> 8 & 0xFF);
                    byArray[13] = (byte)(n29 & 0xFF);
                    byArray[10] = (byte)(n28 >> 8 & 0xFF);
                    byArray[11] = (byte)(n28 & 0xFF);
                    byArray[8] = (byte)(n27 >> 8 & 0xFF);
                    byArray[9] = (byte)(n27 & 0xFF);
                    byArray[6] = (byte)(n26 >> 8 & 0xFF);
                    byArray[7] = (byte)(n26 & 0xFF);
                    byArray[4] = (byte)(n25 >> 8 & 0xFF);
                    byArray[5] = (byte)(n25 & 0xFF);
                    byArray[2] = (byte)(n24 >> 8 & 0xFF);
                    byArray[3] = (byte)(n24 & 0xFF);
                    byArray[0] = by20;
                    byArray[1] = (byte)(n23 & 0xFF);
                    break;
                }
                case 17: {
                    byte by21 = (byte)(n24 >> 8 & 0xFF);
                    if (by21 == 0) {
                        int n79 = 19;
                        byArray = new byte[n79];
                        byArray[17] = (byte)(n33 >> 8 & 0xFF);
                        byArray[18] = (byte)(n33 & 0xFF);
                        byArray[15] = (byte)(n32 >> 8 & 0xFF);
                        byArray[16] = (byte)(n32 & 0xFF);
                        byArray[13] = (byte)(n31 >> 8 & 0xFF);
                        byArray[14] = (byte)(n31 & 0xFF);
                        byArray[11] = (byte)(n30 >> 8 & 0xFF);
                        byArray[12] = (byte)(n30 & 0xFF);
                        byArray[9] = (byte)(n29 >> 8 & 0xFF);
                        byArray[10] = (byte)(n29 & 0xFF);
                        byArray[7] = (byte)(n28 >> 8 & 0xFF);
                        byArray[8] = (byte)(n28 & 0xFF);
                        byArray[5] = (byte)(n27 >> 8 & 0xFF);
                        byArray[6] = (byte)(n27 & 0xFF);
                        byArray[3] = (byte)(n26 >> 8 & 0xFF);
                        byArray[4] = (byte)(n26 & 0xFF);
                        byArray[1] = (byte)(n25 >> 8 & 0xFF);
                        byArray[2] = (byte)(n25 & 0xFF);
                        byArray[0] = (byte)(n24 & 0xFF);
                        break;
                    }
                    int n80 = 20;
                    byArray = new byte[n80];
                    byArray[18] = (byte)(n33 >> 8 & 0xFF);
                    byArray[19] = (byte)(n33 & 0xFF);
                    byArray[16] = (byte)(n32 >> 8 & 0xFF);
                    byArray[17] = (byte)(n32 & 0xFF);
                    byArray[14] = (byte)(n31 >> 8 & 0xFF);
                    byArray[15] = (byte)(n31 & 0xFF);
                    byArray[12] = (byte)(n30 >> 8 & 0xFF);
                    byArray[13] = (byte)(n30 & 0xFF);
                    byArray[10] = (byte)(n29 >> 8 & 0xFF);
                    byArray[11] = (byte)(n29 & 0xFF);
                    byArray[8] = (byte)(n28 >> 8 & 0xFF);
                    byArray[9] = (byte)(n28 & 0xFF);
                    byArray[6] = (byte)(n27 >> 8 & 0xFF);
                    byArray[7] = (byte)(n27 & 0xFF);
                    byArray[4] = (byte)(n26 >> 8 & 0xFF);
                    byArray[5] = (byte)(n26 & 0xFF);
                    byArray[2] = (byte)(n25 >> 8 & 0xFF);
                    byArray[3] = (byte)(n25 & 0xFF);
                    byArray[0] = by21;
                    byArray[1] = (byte)(n24 & 0xFF);
                    break;
                }
                case 18: {
                    byte by22 = (byte)(n25 >> 8 & 0xFF);
                    if (by22 == 0) {
                        int n81 = 17;
                        byArray = new byte[n81];
                        byArray[15] = (byte)(n33 >> 8 & 0xFF);
                        byArray[16] = (byte)(n33 & 0xFF);
                        byArray[13] = (byte)(n32 >> 8 & 0xFF);
                        byArray[14] = (byte)(n32 & 0xFF);
                        byArray[11] = (byte)(n31 >> 8 & 0xFF);
                        byArray[12] = (byte)(n31 & 0xFF);
                        byArray[9] = (byte)(n30 >> 8 & 0xFF);
                        byArray[10] = (byte)(n30 & 0xFF);
                        byArray[7] = (byte)(n29 >> 8 & 0xFF);
                        byArray[8] = (byte)(n29 & 0xFF);
                        byArray[5] = (byte)(n28 >> 8 & 0xFF);
                        byArray[6] = (byte)(n28 & 0xFF);
                        byArray[3] = (byte)(n27 >> 8 & 0xFF);
                        byArray[4] = (byte)(n27 & 0xFF);
                        byArray[1] = (byte)(n26 >> 8 & 0xFF);
                        byArray[2] = (byte)(n26 & 0xFF);
                        byArray[0] = (byte)(n25 & 0xFF);
                        break;
                    }
                    int n82 = 18;
                    byArray = new byte[n82];
                    byArray[16] = (byte)(n33 >> 8 & 0xFF);
                    byArray[17] = (byte)(n33 & 0xFF);
                    byArray[14] = (byte)(n32 >> 8 & 0xFF);
                    byArray[15] = (byte)(n32 & 0xFF);
                    byArray[12] = (byte)(n31 >> 8 & 0xFF);
                    byArray[13] = (byte)(n31 & 0xFF);
                    byArray[10] = (byte)(n30 >> 8 & 0xFF);
                    byArray[11] = (byte)(n30 & 0xFF);
                    byArray[8] = (byte)(n29 >> 8 & 0xFF);
                    byArray[9] = (byte)(n29 & 0xFF);
                    byArray[6] = (byte)(n28 >> 8 & 0xFF);
                    byArray[7] = (byte)(n28 & 0xFF);
                    byArray[4] = (byte)(n27 >> 8 & 0xFF);
                    byArray[5] = (byte)(n27 & 0xFF);
                    byArray[2] = (byte)(n26 >> 8 & 0xFF);
                    byArray[3] = (byte)(n26 & 0xFF);
                    byArray[0] = by22;
                    byArray[1] = (byte)(n25 & 0xFF);
                    break;
                }
                case 19: {
                    byte by23 = (byte)(n26 >> 8 & 0xFF);
                    if (by23 == 0) {
                        int n83 = 15;
                        byArray = new byte[n83];
                        byArray[13] = (byte)(n33 >> 8 & 0xFF);
                        byArray[14] = (byte)(n33 & 0xFF);
                        byArray[11] = (byte)(n32 >> 8 & 0xFF);
                        byArray[12] = (byte)(n32 & 0xFF);
                        byArray[9] = (byte)(n31 >> 8 & 0xFF);
                        byArray[10] = (byte)(n31 & 0xFF);
                        byArray[7] = (byte)(n30 >> 8 & 0xFF);
                        byArray[8] = (byte)(n30 & 0xFF);
                        byArray[5] = (byte)(n29 >> 8 & 0xFF);
                        byArray[6] = (byte)(n29 & 0xFF);
                        byArray[3] = (byte)(n28 >> 8 & 0xFF);
                        byArray[4] = (byte)(n28 & 0xFF);
                        byArray[1] = (byte)(n27 >> 8 & 0xFF);
                        byArray[2] = (byte)(n27 & 0xFF);
                        byArray[0] = (byte)(n26 & 0xFF);
                        break;
                    }
                    int n84 = 16;
                    byArray = new byte[n84];
                    byArray[14] = (byte)(n33 >> 8 & 0xFF);
                    byArray[15] = (byte)(n33 & 0xFF);
                    byArray[12] = (byte)(n32 >> 8 & 0xFF);
                    byArray[13] = (byte)(n32 & 0xFF);
                    byArray[10] = (byte)(n31 >> 8 & 0xFF);
                    byArray[11] = (byte)(n31 & 0xFF);
                    byArray[8] = (byte)(n30 >> 8 & 0xFF);
                    byArray[9] = (byte)(n30 & 0xFF);
                    byArray[6] = (byte)(n29 >> 8 & 0xFF);
                    byArray[7] = (byte)(n29 & 0xFF);
                    byArray[4] = (byte)(n28 >> 8 & 0xFF);
                    byArray[5] = (byte)(n28 & 0xFF);
                    byArray[2] = (byte)(n27 >> 8 & 0xFF);
                    byArray[3] = (byte)(n27 & 0xFF);
                    byArray[0] = by23;
                    byArray[1] = (byte)(n26 & 0xFF);
                    break;
                }
                case 20: {
                    byte by24 = (byte)(n27 >> 8 & 0xFF);
                    if (by24 == 0) {
                        int n85 = 13;
                        byArray = new byte[n85];
                        byArray[11] = (byte)(n33 >> 8 & 0xFF);
                        byArray[12] = (byte)(n33 & 0xFF);
                        byArray[9] = (byte)(n32 >> 8 & 0xFF);
                        byArray[10] = (byte)(n32 & 0xFF);
                        byArray[7] = (byte)(n31 >> 8 & 0xFF);
                        byArray[8] = (byte)(n31 & 0xFF);
                        byArray[5] = (byte)(n30 >> 8 & 0xFF);
                        byArray[6] = (byte)(n30 & 0xFF);
                        byArray[3] = (byte)(n29 >> 8 & 0xFF);
                        byArray[4] = (byte)(n29 & 0xFF);
                        byArray[1] = (byte)(n28 >> 8 & 0xFF);
                        byArray[2] = (byte)(n28 & 0xFF);
                        byArray[0] = (byte)(n27 & 0xFF);
                        break;
                    }
                    int n86 = 14;
                    byArray = new byte[n86];
                    byArray[12] = (byte)(n33 >> 8 & 0xFF);
                    byArray[13] = (byte)(n33 & 0xFF);
                    byArray[10] = (byte)(n32 >> 8 & 0xFF);
                    byArray[11] = (byte)(n32 & 0xFF);
                    byArray[8] = (byte)(n31 >> 8 & 0xFF);
                    byArray[9] = (byte)(n31 & 0xFF);
                    byArray[6] = (byte)(n30 >> 8 & 0xFF);
                    byArray[7] = (byte)(n30 & 0xFF);
                    byArray[4] = (byte)(n29 >> 8 & 0xFF);
                    byArray[5] = (byte)(n29 & 0xFF);
                    byArray[2] = (byte)(n28 >> 8 & 0xFF);
                    byArray[3] = (byte)(n28 & 0xFF);
                    byArray[0] = by24;
                    byArray[1] = (byte)(n27 & 0xFF);
                    break;
                }
                case 21: {
                    byte by25 = (byte)(n28 >> 8 & 0xFF);
                    if (by25 == 0) {
                        int n87 = 11;
                        byArray = new byte[n87];
                        byArray[9] = (byte)(n33 >> 8 & 0xFF);
                        byArray[10] = (byte)(n33 & 0xFF);
                        byArray[7] = (byte)(n32 >> 8 & 0xFF);
                        byArray[8] = (byte)(n32 & 0xFF);
                        byArray[5] = (byte)(n31 >> 8 & 0xFF);
                        byArray[6] = (byte)(n31 & 0xFF);
                        byArray[3] = (byte)(n30 >> 8 & 0xFF);
                        byArray[4] = (byte)(n30 & 0xFF);
                        byArray[1] = (byte)(n29 >> 8 & 0xFF);
                        byArray[2] = (byte)(n29 & 0xFF);
                        byArray[0] = (byte)(n28 & 0xFF);
                        break;
                    }
                    int n88 = 12;
                    byArray = new byte[n88];
                    byArray[10] = (byte)(n33 >> 8 & 0xFF);
                    byArray[11] = (byte)(n33 & 0xFF);
                    byArray[8] = (byte)(n32 >> 8 & 0xFF);
                    byArray[9] = (byte)(n32 & 0xFF);
                    byArray[6] = (byte)(n31 >> 8 & 0xFF);
                    byArray[7] = (byte)(n31 & 0xFF);
                    byArray[4] = (byte)(n30 >> 8 & 0xFF);
                    byArray[5] = (byte)(n30 & 0xFF);
                    byArray[2] = (byte)(n29 >> 8 & 0xFF);
                    byArray[3] = (byte)(n29 & 0xFF);
                    byArray[0] = by25;
                    byArray[1] = (byte)(n28 & 0xFF);
                    break;
                }
                case 22: {
                    byte by26 = (byte)(n29 >> 8 & 0xFF);
                    if (by26 == 0) {
                        int n89 = 9;
                        byArray = new byte[n89];
                        byArray[7] = (byte)(n33 >> 8 & 0xFF);
                        byArray[8] = (byte)(n33 & 0xFF);
                        byArray[5] = (byte)(n32 >> 8 & 0xFF);
                        byArray[6] = (byte)(n32 & 0xFF);
                        byArray[3] = (byte)(n31 >> 8 & 0xFF);
                        byArray[4] = (byte)(n31 & 0xFF);
                        byArray[1] = (byte)(n30 >> 8 & 0xFF);
                        byArray[2] = (byte)(n30 & 0xFF);
                        byArray[0] = (byte)(n29 & 0xFF);
                        break;
                    }
                    int n90 = 10;
                    byArray = new byte[n90];
                    byArray[8] = (byte)(n33 >> 8 & 0xFF);
                    byArray[9] = (byte)(n33 & 0xFF);
                    byArray[6] = (byte)(n32 >> 8 & 0xFF);
                    byArray[7] = (byte)(n32 & 0xFF);
                    byArray[4] = (byte)(n31 >> 8 & 0xFF);
                    byArray[5] = (byte)(n31 & 0xFF);
                    byArray[2] = (byte)(n30 >> 8 & 0xFF);
                    byArray[3] = (byte)(n30 & 0xFF);
                    byArray[0] = by26;
                    byArray[1] = (byte)(n29 & 0xFF);
                    break;
                }
                case 23: {
                    byte by27 = (byte)(n30 >> 8 & 0xFF);
                    if (by27 == 0) {
                        int n91 = 7;
                        byArray = new byte[n91];
                        byArray[5] = (byte)(n33 >> 8 & 0xFF);
                        byArray[6] = (byte)(n33 & 0xFF);
                        byArray[3] = (byte)(n32 >> 8 & 0xFF);
                        byArray[4] = (byte)(n32 & 0xFF);
                        byArray[1] = (byte)(n31 >> 8 & 0xFF);
                        byArray[2] = (byte)(n31 & 0xFF);
                        byArray[0] = (byte)(n30 & 0xFF);
                        break;
                    }
                    int n92 = 8;
                    byArray = new byte[n92];
                    byArray[6] = (byte)(n33 >> 8 & 0xFF);
                    byArray[7] = (byte)(n33 & 0xFF);
                    byArray[4] = (byte)(n32 >> 8 & 0xFF);
                    byArray[5] = (byte)(n32 & 0xFF);
                    byArray[2] = (byte)(n31 >> 8 & 0xFF);
                    byArray[3] = (byte)(n31 & 0xFF);
                    byArray[0] = by27;
                    byArray[1] = (byte)(n30 & 0xFF);
                    break;
                }
                case 24: {
                    byte by28 = (byte)(n31 >> 8 & 0xFF);
                    if (by28 == 0) {
                        int n93 = 5;
                        byArray = new byte[n93];
                        byArray[3] = (byte)(n33 >> 8 & 0xFF);
                        byArray[4] = (byte)(n33 & 0xFF);
                        byArray[1] = (byte)(n32 >> 8 & 0xFF);
                        byArray[2] = (byte)(n32 & 0xFF);
                        byArray[0] = (byte)(n31 & 0xFF);
                        break;
                    }
                    int n94 = 6;
                    byArray = new byte[n94];
                    byArray[4] = (byte)(n33 >> 8 & 0xFF);
                    byArray[5] = (byte)(n33 & 0xFF);
                    byArray[2] = (byte)(n32 >> 8 & 0xFF);
                    byArray[3] = (byte)(n32 & 0xFF);
                    byArray[0] = by28;
                    byArray[1] = (byte)(n31 & 0xFF);
                    break;
                }
                case 25: {
                    byte by29 = (byte)(n32 >> 8 & 0xFF);
                    if (by29 == 0) {
                        int n95 = 3;
                        byArray = new byte[n95];
                        byArray[1] = (byte)(n33 >> 8 & 0xFF);
                        byArray[2] = (byte)(n33 & 0xFF);
                        byArray[0] = (byte)(n32 & 0xFF);
                        break;
                    }
                    int n96 = 4;
                    byArray = new byte[n96];
                    byArray[2] = (byte)(n33 >> 8 & 0xFF);
                    byArray[3] = (byte)(n33 & 0xFF);
                    byArray[0] = by29;
                    byArray[1] = (byte)(n32 & 0xFF);
                    break;
                }
                case 26: {
                    byte by30 = (byte)(n33 >> 8 & 0xFF);
                    if (by30 == 0) {
                        int n97 = 1;
                        byArray = new byte[n97];
                        byArray[0] = (byte)(n33 & 0xFF);
                        break;
                    }
                    int n98 = 2;
                    byArray = new byte[n98];
                    byArray[0] = by30;
                    byArray[1] = (byte)(n33 & 0xFF);
                }
            }
            BigInteger bigInteger = new BigInteger(n5, byArray);
            bigDecimal = new BigDecimal(bigInteger, -n2);
        }
        return bigDecimal;
    }

    BigDecimal getBigDecimaln(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2;
            byte[] byArray;
            int n3;
            int n4;
            int n5;
            byte by;
            int n6;
            int n7;
            byte[] byArray2 = this.rowSpaceByte;
            int n8 = this.columnIndex + this.byteLength * n + 1;
            byte by2 = byArray2[n8 - 1];
            for (n7 = 0; n7 < 27; ++n7) {
                this.digs[n7] = 0;
            }
            n7 = 0;
            int n9 = 1;
            int n10 = 26;
            int n11 = 0;
            byte by3 = byArray2[n8];
            boolean bl = false;
            if ((by3 & 0xFFFFFF80) != 0) {
                if (by3 == -128 && by2 == 1) {
                    return BIGDEC_ZERO;
                }
                if (by2 == 2 && by3 == -1 && byArray2[n8 + 1] == 101) {
                    this.throwOverflow();
                }
                n6 = 1;
                by = (byte)((by3 & 0xFFFFFF7F) - 65);
                n5 = by2 - 1;
                n4 = n5 - 1;
                n3 = by - n5 + 1 << 1;
                if (n3 > 0) {
                    n3 = 0;
                    n4 = by;
                } else if (n3 < 0) {
                    bl = (byArray2[n8 + n5] - 1) % 10 == 0;
                }
                int n12 = n9;
                n9 = (byte)(n9 + 1);
                n7 = byArray2[n8 + n12] - 1;
                while ((n4 & 1) != 0) {
                    if (n9 > n5) {
                        n7 *= 100;
                    } else {
                        int n13 = n9;
                        n9 = (byte)(n9 + 1);
                        n7 = n7 * 100 + (byArray2[n8 + n13] - 1);
                    }
                    --n4;
                }
            } else {
                if (by3 == 0 && by2 == 1) {
                    this.throwOverflow();
                }
                n6 = -1;
                by = (byte)((~by3 & 0xFFFFFF7F) - 65);
                n5 = by2 - 1;
                if (n5 != 20 || byArray2[n8 + n5] == 102) {
                    --n5;
                }
                n4 = n5 - 1;
                n3 = by - n5 + 1 << 1;
                if (n3 > 0) {
                    n3 = 0;
                    n4 = by;
                } else if (n3 < 0) {
                    bl = (101 - byArray2[n8 + n5]) % 10 == 0;
                }
                int n14 = n9;
                n9 = (byte)(n9 + 1);
                n7 = 101 - byArray2[n8 + n14];
                while ((n4 & 1) != 0) {
                    if (n9 > n5) {
                        n7 *= 100;
                    } else {
                        int n15 = n9;
                        n9 = (byte)(n9 + 1);
                        n7 = n7 * 100 + (101 - byArray2[n8 + n15]);
                    }
                    --n4;
                }
            }
            if (bl) {
                ++n3;
                n7 /= 10;
            }
            int n16 = n5 - 1;
            while (n4 != 0) {
                int n17;
                if (n6 == 1) {
                    if (bl) {
                        n11 = (byArray2[n8 + n9 - 1] - 1) % 10 * 1000 + (byArray2[n8 + n9] - 1) * 10 + (byArray2[n8 + n9 + 1] - 1) / 10 + n7 * 10000;
                        n9 = (byte)(n9 + 2);
                    } else if (n9 < n16) {
                        n11 = (byArray2[n8 + n9] - 1) * 100 + (byArray2[n8 + n9 + 1] - 1) + n7 * 10000;
                        n9 = (byte)(n9 + 2);
                    } else {
                        n11 = 0;
                        if (n9 <= n5) {
                            n17 = 0;
                            while (n9 <= n5) {
                                int n18 = n9;
                                n9 = (byte)(n9 + 1);
                                n11 = n11 * 100 + (byArray2[n8 + n18] - 1);
                                ++n17;
                            }
                            while (n17 < 2) {
                                n11 *= 100;
                                ++n17;
                            }
                        }
                        n11 += n7 * 10000;
                    }
                } else if (bl) {
                    n11 = (101 - byArray2[n8 + n9 - 1]) % 10 * 1000 + (101 - byArray2[n8 + n9]) * 10 + (101 - byArray2[n8 + n9 + 1]) / 10 + n7 * 10000;
                    n9 = (byte)(n9 + 2);
                } else if (n9 < n16) {
                    n11 = (101 - byArray2[n8 + n9]) * 100 + (101 - byArray2[n8 + n9 + 1]) + n7 * 10000;
                    n9 = (byte)(n9 + 2);
                } else {
                    n11 = 0;
                    if (n9 <= n5) {
                        n17 = 0;
                        while (n9 <= n5) {
                            int n19 = n9;
                            n9 = (byte)(n9 + 1);
                            n11 = n11 * 100 + (101 - byArray2[n8 + n19]);
                            ++n17;
                        }
                        while (n17 < 2) {
                            n11 *= 100;
                            ++n17;
                        }
                    }
                    n11 += n7 * 10000;
                }
                n7 = n11 & 0xFFFF;
                for (n17 = 25; n17 >= n10; --n17) {
                    n11 = (n11 >> 16) + this.digs[n17] * 10000;
                    this.digs[n17] = n11 & 0xFFFF;
                }
                if (n11 != 0) {
                    n10 = (byte)(n10 - 1);
                    this.digs[n10] = n11;
                }
                n4 -= 2;
            }
            this.digs[26] = n7;
            byte by4 = (byte)(this.digs[n10] >> 8 & 0xFF);
            if (by4 == 0) {
                int n20 = 53 - (n10 << 1);
                byArray = new byte[n20];
                for (n2 = 26; n2 > n10; --n2) {
                    int n21 = n2 - n10 << 1;
                    byArray[n21 - 1] = (byte)(this.digs[n2] >> 8 & 0xFF);
                    byArray[n21] = (byte)(this.digs[n2] & 0xFF);
                }
                byArray[0] = (byte)(this.digs[n10] & 0xFF);
            } else {
                int n22 = 54 - (n10 << 1);
                byArray = new byte[n22];
                for (n2 = 26; n2 > n10; --n2) {
                    int n23 = n2 - n10 << 1;
                    byArray[n23] = (byte)(this.digs[n2] >> 8 & 0xFF);
                    byArray[n23 + 1] = (byte)(this.digs[n2] & 0xFF);
                }
                byArray[0] = by4;
                byArray[1] = (byte)(this.digs[n10] & 0xFF);
            }
            BigInteger bigInteger = new BigInteger(n6, byArray);
            bigDecimal = new BigDecimal(bigInteger, -n3);
        }
        return bigDecimal;
    }

    BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        return this.getBigDecimal(n).setScale(n2, 6);
    }

    String getString(int n) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            byte[] byArray = this.rowSpaceByte;
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = byArray[n2 - 1];
            byte[] byArray2 = new byte[by];
            System.arraycopy(byArray, n2, byArray2, 0, by);
            NUMBER nUMBER = new NUMBER(byArray2);
            String string2 = oracle.sql.NUMBER.toString(byArray2);
            int n3 = string2.length();
            if (string2.startsWith("0.") || string2.startsWith("-0.")) {
                --n3;
            }
            if (n3 > 38) {
                string2 = nUMBER.toText(-44, null);
                int n4 = string2.indexOf(69);
                int n5 = string2.indexOf(43);
                if (n4 == -1) {
                    n4 = string2.indexOf(101);
                }
                int n6 = n4 - 1;
                while (string2.charAt(n6) == '0') {
                    --n6;
                }
                String string3 = string2.substring(0, n6 + 1);
                String string4 = null;
                string4 = n5 > 0 ? string2.substring(n5 + 1) : string2.substring(n4 + 1);
                return (string3 + "E" + string4).trim();
            }
            return nUMBER.toText(38, null).trim();
        }
        return string;
    }

    NUMBER getNUMBER(int n) throws SQLException {
        NUMBER nUMBER = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = this.rowSpaceByte[n2 - 1];
            byte[] byArray = new byte[by];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, by);
            nUMBER = new NUMBER(byArray);
        }
        return nUMBER;
    }

    Object getObject(int n) throws SQLException {
        Number number = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            if (this.external_type == 0) {
                number = this.stmt.connection.m_j2ee13Compliant && this.precision != 0 && this.scale == -127 ? new Double(this.getDouble(n)) : this.getBigDecimal(n);
            } else {
                switch (this.external_type) {
                    case -7: {
                        return new Boolean(this.getBoolean(n));
                    }
                    case -6: {
                        return new Byte(this.getByte(n));
                    }
                    case 5: {
                        return new Short(this.getShort(n));
                    }
                    case 4: {
                        return new Integer(this.getInt(n));
                    }
                    case -5: {
                        return new Long(this.getLong(n));
                    }
                    case 6: 
                    case 8: {
                        return new Double(this.getDouble(n));
                    }
                    case 7: {
                        return new Float(this.getFloat(n));
                    }
                    case 2: 
                    case 3: {
                        return this.getBigDecimal(n);
                    }
                }
                DatabaseError.throwSqlException(4);
                return null;
            }
        }
        return number;
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getNUMBER(n);
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n + 1;
            byte by = this.rowSpaceByte[n2 - 1];
            byArray = new byte[by];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, by);
        }
        return byArray;
    }

    void throwOverflow() throws SQLException {
        DatabaseError.throwSqlException(26);
    }
}

