CREATE OR REPLACE PACKAGE plpdf_toolkit_test is

-- Encrypt40
procedure Encrypt40_test;

-- Encrypt128
procedure Encrypt128_test;

-- AESEncrypt128
procedure AESEncrypt128_test;

-- PublicKeyEncrypt40
procedure PublicKeyEncrypt40_test;

-- PublicKeyEncrypt128
procedure PublicKeyEncrypt128_test;

-- Decrypt
procedure Decrypt_test;

-- ExtractText
procedure ExtractText_test;

-- Merge
procedure Merge_test;

-- MergeX
procedure MergeX_test;

-- MergeX, plpdf_tk_merge_inputs table
procedure MergeX_tr_test;

-- MergeEncrypt128
procedure MergeEncrypt128_test;

-- ReplaceUrl
procedure ReplaceUrl_test;

-- JPGStamp
procedure JPGStamp_test;

-- JPGWaterMark
procedure JPGWaterMark_test;

-- MetadataFromXML
procedure MetadataFromXML_test;

-- MetadataFromPars
procedure MetadataFromPars_test;

-- MetadaToXML
procedure MetadaToXML_test;

-- MetadaToRecord
procedure MetadaToRecord_test;

-- TextStamp
procedure TextStamp_test;

-- TextStampTTF
procedure TextStampTTF_test;

-- TextWaterMark
procedure TextWaterMark_test;

-- PDFWatermark
procedure PDFWatermark_test;

-- ExportFDF
procedure ExportFDF_test;

-- ExportXFDF
procedure ExportXFDF_test;

-- ImportFDF
procedure ImportFDF_test;

-- ImportXFDF
procedure ImportXFDF_test;

-- ExtractPages
procedure ExtractPages_test;

-- GetNumberOfPages
procedure GetNumberOfPages_test;

-- JPGCompress
procedure JPGCompress_test;

-- Rebuild
procedure Rebuild_test;

  -- Readonly
procedure Readonly_test;

-- getPDFACompliant
procedure getPDFACompliant_test;

-- Create_XFDF
procedure create_xfdf_test;

-- Parse_XFDF
procedure parse_xfdf_test;

end;
/

CREATE OR REPLACE PACKAGE BODY plpdf_toolkit_test is
/**
create table store_blob_tk
(
    id number primary key,
    blob_file blob,
    filename varchar2(255),
    description varchar2(2000),
    crd date default sysdate
);
*/

-- Encrypt40
procedure Encrypt40_test
  is
  l_blob_10 blob;
  l_blob_101 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_101,TRUE);

  l_blob_101 := plpdf_toolkit.encrypt40(
    p_inputfile => l_blob_10,
    p_opassword => 'apple',
    p_upassword => null,
    p_canextractcontent => false,
    p_canmodify => true,
    p_canmodifyannotations => true,
    p_canprint => false
    );

  delete from store_blob_tk where id = 101;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (101,l_blob_101,'Encrypt40.pdf','id:10 plpdf-toolkit-install-v200.pdf Encrypt40');
  commit;
end;

-- Encrypt128
procedure Encrypt128_test
  is
  l_blob_10 blob;
  l_blob_102 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_102,TRUE);

  l_blob_102 := plpdf_toolkit.encrypt128(
    p_inputfile => l_blob_10,
    p_opassword => 'pear12345',
    p_upassword => null,
    p_canAssemble => false,
    p_canextractcontent => false,
    p_canextractforaccessibility => false,
    p_canfillinform => false,
    p_canmodify => false,
    p_canmodifyannotations => false,
    p_canprint => false,
    p_canmodifyprintresolution => false
    );

  delete from store_blob_tk where id = 102;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (102,l_blob_102,'Encrypt128.pdf','id:10 plpdf-toolkit-install-v200.pdf Encrypt128');
  commit;
end;

-- AESEncrypt128
procedure AESEncrypt128_test
  is
  l_blob_10 blob;
  l_blob_103 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_103,TRUE);

  l_blob_103 := plpdf_toolkit.AESencrypt128(
    p_inputfile => l_blob_10,
    p_opassword => 'pear12345',
    p_upassword => null,
    p_canAssemble => false,
    p_canextractcontent => false,
    p_canextractforaccessibility => false,
    p_canfillinform => false,
    p_canmodify => false,
    p_canmodifyannotations => false,
    p_canprint => false,
    p_canmodifyprintresolution => false
    );

  delete from store_blob_tk where id = 103;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (103,l_blob_103,'AESEncrypt128.pdf','id:10 plpdf-toolkit-install-v200.pdf AESEncrypt128');
  commit;
end;

-- PublicKeyEncrypt40
procedure PublicKeyEncrypt40_test
  is
  l_blob_10 blob;
  l_blob_104 blob;
  l_blob_certfile blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  select t.blob_file
    into l_blob_certfile
  from store_blob_tk t
  where t.filename = 'test.cer';

  dbms_lob.createtemporary(l_blob_104,TRUE);

  l_blob_104 := plpdf_toolkit.PublicKeyEncrypt40(
    p_inputfile => l_blob_10,
    p_certfile => l_blob_certfile,
    p_canextractcontent => false,
    p_canmodify => false,
    p_canmodifyannotations => false,
    p_canprint => false
    );

  delete from store_blob_tk where id = 104;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (104,l_blob_104,'PublicKeyEncrypt40.pdf','id:10 plpdf-toolkit-install-v200.pdf PublicKeyEncrypt40');
  commit;
end;

-- PublicKeyEncrypt128
procedure PublicKeyEncrypt128_test
  is
  l_blob_10 blob;
  l_blob_105 blob;
  l_blob_certfile blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  select t.blob_file
    into l_blob_certfile
  from store_blob_tk t
  where t.filename = 'test.cer';

  dbms_lob.createtemporary(l_blob_105,TRUE);

  l_blob_105 := plpdf_toolkit.PublicKeyEncrypt128(
    p_inputfile => l_blob_10,
    p_certfile => l_blob_certfile,
    p_canAssemble => false,
    p_canextractcontent => false,
    p_canextractforaccessibility => false,
    p_canfillinform => false,
    p_canmodify => false,
    p_canmodifyannotations => false,
    p_canprint => false,
    p_canmodifyprintresolution => false
    );

  delete from store_blob_tk where id = 105;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (105,l_blob_105,'PublicKeyEncrypt128.pdf','id:10 plpdf-toolkit-install-v200.pdf PublicKeyEncrypt128');
  commit;
end;

-- Decrypt
procedure Decrypt_test
  is
  l_blob_encrypt blob;
  l_blob_106 blob;
begin
  select t.blob_file
    into l_blob_encrypt
  from store_blob_tk t
  where t.filename = 'AESEncrypt128.pdf';

  dbms_lob.createtemporary(l_blob_106,TRUE);

  l_blob_106 := plpdf_toolkit.decrypt(
    p_inputfile => l_blob_encrypt,
    p_password => 'pear12345'
    );

  delete from store_blob_tk where id = 106;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (106,l_blob_106,'AESEncrypt128_decrypt.pdf','AESEncrypt128.pdf Decrypt');
  commit;
end;

-- ExtractText
procedure ExtractText_test
    is
  l_blob_10 blob;
  l_blob_108 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_108,TRUE);

  l_blob_108 := plpdf_toolkit.ExtractText(
   p_password => null,
   p_encoding => 'UTF-8',
   p_startPage => 1,
   p_endPage => 1,
   p_inputfile => l_blob_10
  );

  delete from store_blob_tk where id = 108;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (108,l_blob_108,'ExtractText.txt','id:10 plpdf-toolkit-install-v200.pdf ExtractText');
  commit;
end;

-- Merge
procedure Merge_test
  is
  l_blob_10 blob;
  l_blob_20 blob;
  l_blob_109 blob;
begin
   select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  dbms_lob.createtemporary(l_blob_109,TRUE);

  l_blob_109 := plpdf_toolkit.Merge(
    p_inputfile1 => l_blob_10,
    p_inputfile2 => l_blob_20
    );

  delete from store_blob_tk where id = 109;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (109,l_blob_109,'Merge.pdf','id:10 + id:20 Merge');
  commit;
end;

-- MergeX
procedure MergeX_test
  is
  l_blob_20 blob;
  l_blob_21 blob;
  l_blob_110 blob;
  l_arr plpdf_toolkit.t_merge_inputs;
  l_color plpdf_toolkit.t_color;
begin
   select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  select t.blob_file
    into l_blob_21
  from store_blob_tk t
  where t.filename = '1326903170_res.pdf';

  dbms_lob.createtemporary(l_blob_110,TRUE);

  l_arr(1).inputfile := l_blob_20;
  l_arr(1).overwrite_rect_x := 10;
  l_arr(1).overwrite_rect_y := 20;
  l_arr(1).overwrite_rect_w := 30;
  l_arr(1).overwrite_rect_h := 40;
  l_arr(1).overwrite_rect_color.r:= 0;
  l_arr(1).overwrite_rect_color.g:= 255;
  l_arr(1).overwrite_rect_color.r:= 0;

  l_arr(2).inputfile := l_blob_21;
  l_arr(2).overwrite_rect_x := 50;
  l_arr(2).overwrite_rect_y := 60;
  l_arr(2).overwrite_rect_w := 70;
  l_arr(2).overwrite_rect_h := 80;
  l_arr(2).overwrite_rect_color.r:= 0;
  l_arr(2).overwrite_rect_color.g:= 0;
  l_arr(2).overwrite_rect_color.r:= 255;

  l_arr(3) := l_arr(2);
  l_arr(4) := l_arr(1);
  l_arr(5) := l_arr(1);
  l_arr(6) := l_arr(2);
  --l_arr(7) := l_arr(2);
  -- l_arr(8) := l_arr(2);
  -- l_arr(9) := l_arr(2);
  --l_arr(10) := l_arr(2);

  -- Turquoise 64,224,208
  l_color.r := 64;
  l_color.g := 224;
  l_color.b := 208;

  l_blob_110 := plpdf_toolkit.MergeX(
    p_inputfiles => l_arr,
    p_x => -1, -- -1:center, -2:right
    p_y => 20, -- -1:center, -2: bottom
    p_font => plpdf_toolkit.helvetica_bold ,
    p_fontSize => 12,
    p_color => l_color,
    p_startNumber => 1,
    p_beginNumber => 1,
    p_nbAlias => 'nb',
    p_cpAlias => 'cp',
    p_format => 'cp / nb'
    );

  delete from store_blob_tk where id = 110;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (110,l_blob_110,'MergeX.pdf','id:20 + id:21 MergeX');
  commit;
end;

-- MergeX, plpdf_tk_merge_inputs table
procedure MergeX_tr_test
  is
  l_blob_111 blob;
  l_tr_id number := 1;
  l_color plpdf_toolkit.t_color;
begin
  dbms_lob.createtemporary(l_blob_111,TRUE);

  -- Turquoise 64,224,208
  l_color.r := 64;
  l_color.g := 224;
  l_color.b := 208;

  l_blob_111 := plpdf_toolkit.MergeX(
    p_tr_id => l_tr_id,
    p_x => -1, -- -1:center, -2:right
    p_y => 20, -- -1:center, -2: bottom
    p_font => plpdf_toolkit.helvetica_bold ,
    p_fontSize => 12,
    p_color => l_color,
    p_startNumber => 1,
    p_beginNumber => 1,
    p_nbAlias => 'nb',
    p_cpAlias => 'cp',
    p_format => 'cp / nb'
    );

  delete from store_blob_tk where id = 111;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (111,l_blob_111,'MergeX_tr_id.pdf','tr_id: 1 MergeX (transaction id)');
  commit;
end;

-- MergeEncrypt128
procedure MergeEncrypt128_test
  is
  l_blob_10 blob;
  l_blob_20 blob;
  l_blob_150 blob;
begin
     select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  dbms_lob.createtemporary(l_blob_150,TRUE);

  l_blob_150 := plpdf_toolkit.mergeencrypt128(
    p_inputfile1 => l_blob_10,
    p_inputfile2 => l_blob_20,
    p_opassword => 'pear12345',
    p_upassword => null,
    p_canAssemble => false,
    p_canextractcontent => false,
    p_canextractforaccessibility => false,
    p_canfillinform => false,
    p_canmodify => false,
    p_canmodifyannotations => false,
    p_canprint => false,
    p_canmodifyprintresolution => false
    );

  delete from store_blob_tk where id = 150;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (150,l_blob_150,'MergeEncrypt128.pdf','id:10+20 Encrypt128');
  commit;
end;

-- ReplaceUrl
procedure ReplaceUrl_test
  is
  l_blob_30 blob;
  l_blob_112 blob;
begin
  select t.blob_file
    into l_blob_30
  from store_blob_tk t
  where t.filename = 'link.pdf';

  dbms_lob.createtemporary(l_blob_112,TRUE);

  l_blob_112 := plpdf_toolkit.ReplaceUrl(
    p_inputfile => l_blob_30,
    p_oldURI => 'http://www.yahoo.com/',
    p_newURI => 'http://www.plpdf.com/'
    );

  delete from store_blob_tk where id = 112;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (112,l_blob_112,'ReplaceUrl.pdf','id:30 link.pdf ReplaceUrl');
  commit;
end;

-- JPGStamp
procedure JPGStamp_test
  is
  l_blob_20 blob;
  l_blob_22 blob;
  l_blob_113 blob;
begin
  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  select t.blob_file
    into l_blob_22
  from store_blob_tk t
  where t.filename = 'image1.jpg';

  dbms_lob.createtemporary(l_blob_113,TRUE);

  l_blob_113 := plpdf_toolkit.JPGStamp(
    p_inputfile => l_blob_20,
    p_imagefile => l_blob_22,
    p_x => -1,
    p_y => -1,
    p_width => 200,
    p_height => 200
    );

  delete from store_blob_tk where id = 113;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (113,l_blob_113,'JPGStamp.pdf','id:20 + id:22 JPGStamp');
  commit;
end;

-- JPGWaterMark
procedure JPGWaterMark_test
  is
  l_blob_20 blob;
  l_blob_22 blob;
  l_blob_114 blob;
begin
  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  select t.blob_file
    into l_blob_22
  from store_blob_tk t
  where t.filename = 'image1.jpg';

  dbms_lob.createtemporary(l_blob_114,TRUE);

  l_blob_114 := plpdf_toolkit.JPGWaterMark(
    p_inputfile => l_blob_20,
    p_imagefile => l_blob_22,
    p_x => -1,
    p_y => -1,
    p_width => 200,
    p_height => 200
    );

  delete from store_blob_tk where id = 114;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (114,l_blob_114,'JPGWaterMark.pdf','id:20 + id:22 JPGWaterMark');
  commit;
end;

-- MetadataFromXML
procedure MetadataFromXML_test
  is
  l_blob_10 blob;
  l_blob_xml blob;
  l_blob_115 blob;
  l_xml sys.xmltype;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_115,TRUE);
  dbms_lob.createtemporary(l_blob_xml,TRUE);

  l_xml := sys.xmltype.createXML(
'<pdf-metadata>
<title>PLPDF Toolkit Metadata title</title>
<author>PLPDF Toolkit author</author>
<subject>PLPDF Toolkit subject</subject>
<creator>PLPDF Toolkit creator</creator>
<keywords>Oracle PDF kw</keywords>
<producer>PLPDF Toolkit producer</producer>
<createtime>20080903183019</createtime>
<modificationdate>20080903183019</modificationdate>
</pdf-metadata>'
    );

  l_blob_xml := l_xml.getBlobVal(nls_charset_id('UTF8'));

  l_blob_115 := plpdf_toolkit.MetadataFromXML(
    p_inputfile => l_blob_10,
    p_xmlfile => l_blob_xml
    );

  delete from store_blob_tk where id = 115;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (115,l_blob_115,'MetadataFromXML.pdf','id:10 plpdf-toolkit-install-v200.pdf MetadataFromXML');
  commit;
end;

-- MetadataFromPars
procedure MetadataFromPars_test
  is
  l_blob_10 blob;
  l_blob_116 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_116,TRUE);

  l_blob_116 := plpdf_toolkit.MetadataFromPars(
    p_inputfile => l_blob_10,
    p_title => 'PLPDF Toolkit Metadata title par',
    p_author => 'PLPDF Toolkit author par',
    p_subject => 'PLPDF Toolkit subject par',
    p_creator => 'PLPDF Toolkit creator par',
    p_keywords => 'Oracle PDF kw par',
    p_producer => 'PLPDF Toolkit producer par',
    p_createtime => to_date('20080101','YYYYMMDD'),
    p_modificationdate => sysdate
    );

  delete from store_blob_tk where id = 116;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (116,l_blob_116,'MetadataFromPars.pdf','id:10 plpdf-toolkit-install-v200.pdf MetadataFromPars');
  commit;
end;

-- MetadaToXML
procedure MetadaToXML_test
  is
  l_blob_10 blob;
  l_blob_117 blob;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  dbms_lob.createtemporary(l_blob_117,TRUE);

  l_blob_117 := plpdf_toolkit.MetadataToXML(
    p_inputfile => l_blob_10
    );

  delete from store_blob_tk where id = 117;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (117,l_blob_117,'MetadaToXML.xml','id:10 plpdf-toolkit-install-v200.pdf MetadaToXML');
  commit;
end;

-- MetadaToRecord
procedure MetadaToRecord_test
  is
  l_blob_10 blob;
  l_metadata plpdf_toolkit.t_metadata;
begin
  select t.blob_file
    into l_blob_10
  from store_blob_tk t
  where t.filename = 'plpdf-toolkit-install-v200.pdf';

  l_metadata := plpdf_toolkit.MetadataToRecord(
    p_inputfile => l_blob_10
    );

  dbms_output.put_line(l_metadata.Title);
  dbms_output.put_line(l_metadata.Author);
  dbms_output.put_line(l_metadata.Subject);
  dbms_output.put_line(l_metadata.Creator);
  dbms_output.put_line(l_metadata.Keywords);
  dbms_output.put_line(l_metadata.Producer);
  dbms_output.put_line(l_metadata.CreationDate);
  dbms_output.put_line(l_metadata.ModDate);
end;


-- TextStamp
procedure TextStamp_test
  is
  l_blob_20 blob;
  l_blob_118 blob;
  l_color plpdf_toolkit.t_color;
begin
  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  dbms_lob.createtemporary(l_blob_118,TRUE);

  -- Turquoise 64,224,208
  l_color.r := 64;
  l_color.g := 224;
  l_color.b := 208;

  l_blob_118 := plpdf_toolkit.TextStamp(
    p_inputfile => l_blob_20,
    p_message => 'PLPDF Text',
    p_x => 200,
    p_y => 400,
    p_font => plpdf_toolkit.helvetica_bold,
    p_fontSize => 40,
    p_color => l_color,
    p_startPage => 20,
    p_endPage => 0,
    p_rotation => 90
    );

  delete from store_blob_tk where id = 118;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (118,l_blob_118,'TextStamp.pdf','id:20 00_ReadMe.pdf TextStamp');
  commit;
end;

-- TextStampTTF
procedure TextStampTTF_test
  is
  l_blob_20 blob;
  l_blob_font blob;
  l_blob_119 blob;
  l_color plpdf_toolkit.t_color;
begin
  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  select t.blob_file
    into l_blob_font
  from store_blob_tk t
  where t.filename = 'Alcohole.ttf';

  dbms_lob.createtemporary(l_blob_119,TRUE);

  -- Red 64,0,0
  l_color.r := 255;
  l_color.g := 0;
  l_color.b := 0;

  l_blob_119 := plpdf_toolkit.TextStampTTF(
    p_inputfile => l_blob_20,
    p_message => 'PLPDF Text',
    p_x => -1,
    p_y => -1,
    p_font => l_blob_font,
    p_fontSize => 50,
    p_color => l_color,
    p_startPage => 1,
    p_endPage => 1,
    p_rotation => 45
    );

  delete from store_blob_tk where id = 119;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (119,l_blob_119,'TextStampTTF.pdf','id:20 00_ReadMe.pdf TextStampTTF');
  commit;
end;

-- TextWaterMark
procedure TextWaterMark_test
  is
  l_blob_20 blob;
  l_blob_120 blob;
  l_color plpdf_toolkit.t_color;
begin
  select t.blob_file
    into l_blob_20
  from store_blob_tk t
  where t.filename = '00_ReadMe.pdf';

  dbms_lob.createtemporary(l_blob_120,TRUE);

  -- Yellow_green 154,205,50
  l_color.r := 154;
  l_color.g := 205;
  l_color.b := 50;

  l_blob_120 := plpdf_toolkit.TextWaterMark(
    p_inputfile => l_blob_20,
    p_message => 'PLPDF Text wm',
    p_x => 200,
    p_y => 400,
    p_font => plpdf_toolkit.helvetica_bold,
    p_fontSize => 40,
    p_color => l_color,
    p_rotation => 0
    );

  delete from store_blob_tk where id = 120;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (120,l_blob_120,'TextWaterMark.pdf','id:20 00_ReadMe.pdf TextWaterMark');
  commit;
end;

-- PDFWatermark
procedure PDFWatermark_test
  is
  l_blob_40 blob;
  l_blob_41 blob;
  l_blob_121 blob;
begin
  select t.blob_file
    into l_blob_40
  from store_blob_tk t
  where t.filename = 'plpdf_toolkit_v200-user_guide.pdf';

  select t.blob_file
    into l_blob_41
  from store_blob_tk t
  where t.filename = '1-5.pdf';

  dbms_lob.createtemporary(l_blob_121,TRUE);

  l_blob_121 := plpdf_toolkit.PDFWatermark(
    p_inputfile => l_blob_40,
    p_overlayinputfile => l_blob_41
    );

  delete from store_blob_tk where id = 121;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (121,l_blob_121,'PDFWatermark.pdf','id:40 + id:41 PDFWatermark');
  commit;
end;

--ExportFDF
procedure ExportFDF_test
  is
  l_blob_50 blob;
  l_blob_122 blob;
begin
  select t.blob_file
    into l_blob_50
  from store_blob_tk t
  where t.filename = 'SimpleRegistrationForm_2.pdf';


  dbms_lob.createtemporary(l_blob_122,TRUE);

  l_blob_122 := plpdf_toolkit.ExportFDF(
  p_inputfile => l_blob_50
  );

  delete from store_blob_tk where id = 122;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (122,l_blob_122,'ExportFDF.fdf','id:50 SimpleRegistrationForm_2.pdf ExportFDF');
  commit;
end;

--ExportXFDF
procedure ExportXFDF_test
  is
  l_blob_50 blob;
  l_blob_123 blob;
begin
  select t.blob_file
    into l_blob_50
  from store_blob_tk t
  where t.filename = 'SimpleRegistrationForm_2.pdf';


  dbms_lob.createtemporary(l_blob_123,TRUE);

  l_blob_123 := plpdf_toolkit.ExportXFDF(
  p_inputfile => l_blob_50,
  p_exportnull => false
  );

  delete from store_blob_tk where id = 123;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (123,l_blob_123,'ExportXFDF.xfdf','id:50 SimpleRegistrationForm_2.pdf ExportXFDF');
  commit;
end;

--ImportFDF
procedure ImportFDF_test
  is
  l_blob_60 blob;
  l_blob_fdf blob;
  l_blob_124 blob;
begin
  select t.blob_file
    into l_blob_60
  from store_blob_tk t
  where t.filename = 'SimpleRegistrationForm.pdf';

  select t.blob_file
    into l_blob_fdf
  from store_blob_tk t
  where t.filename = 'import_fdf.fdf';

  dbms_lob.createtemporary(l_blob_124,TRUE);

  l_blob_124 := plpdf_toolkit.ImportFDF(
  p_inputfile => l_blob_60,
  p_fdffile => l_blob_fdf
  );

  delete from store_blob_tk where id = 124;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (124,l_blob_124,'ImportFDF.pdf','id:60 SimpleRegistrationForm.pdf ImportFDF');
  commit;
end;

--ImportXFDF
procedure ImportXFDF_test
  is
  l_blob_60 blob;
  l_blob_125 blob;
  l_blob_xfdf blob;
begin
  select t.blob_file
    into l_blob_60
  from store_blob_tk t
  where t.filename = 'SimpleRegistrationForm.pdf';

  select t.blob_file
    into l_blob_xfdf
  from store_blob_tk t
  where t.filename = 'import_xfdf.xfdf';

  dbms_lob.createtemporary(l_blob_125,TRUE);

  l_blob_125 := plpdf_toolkit.ImportXFDF(
  p_inputfile => l_blob_60,
  p_xfdffile => l_blob_xfdf
  );

  delete from store_blob_tk where id = 125;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (125,l_blob_125,'ImportXFDF.pdf','id:60 SimpleRegistrationForm.pdf ImportXFDF');
  commit;
end;

-- ExtractPages
procedure ExtractPages_test
  is
  l_blob_40 blob;
  l_blob_126 blob;
begin
  select t.blob_file
    into l_blob_40
  from store_blob_tk t
  where t.filename = 'plpdf_toolkit_v200-user_guide.pdf';

  dbms_lob.createtemporary(l_blob_126,TRUE);

  l_blob_126 := plpdf_toolkit.ExtractPages(
    p_inputfile => l_blob_40,
    p_startPage => 4,
    p_endPage => 10
    );

  delete from store_blob_tk where id = 126;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (126,l_blob_126,'ExtractPages.pdf','id:40 plpdf_toolkit_v200-user_guide.pdf ExtractPages');
  commit;
end;

-- GetNumberOfPages
procedure GetNumberOfPages_test
  is
  l_blob_40 blob;
  l_number number;
begin
  select t.blob_file
    into l_blob_40
  from store_blob_tk t
  where t.filename = 'plpdf_toolkit_v200-user_guide.pdf';

  l_number := plpdf_toolkit.GetNumberOfPages(
    p_inputfile => l_blob_40
    );

  dbms_output.put_line(l_number);
end;

-- JPGCompress
procedure JPGCompress_test
  is
  l_blob_jpg blob;
  l_blob_127 blob;
begin
  select t.blob_file
    into l_blob_jpg
  from store_blob_tk t
  where t.filename = 'JPGStamp.pdf';

  dbms_lob.createtemporary(l_blob_127,TRUE);

  l_blob_127 := plpdf_toolkit.JPGCompress(
    p_inputfile => l_blob_jpg,
    p_compress => 0.1
    );

  delete from store_blob_tk where id = 127;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (127,l_blob_127,'JPGCompress.pdf','JPGStamp.pdf JPGCompress');
  commit;
end;


-- Rebuild
procedure Rebuild_test
  is
  l_blob_40 blob;
  l_blob_130 blob;
begin
  select t.blob_file
    into l_blob_40
  from store_blob_tk t
  where t.filename = 'plpdf_toolkit_v200-user_guide.pdf';

  dbms_lob.createtemporary(l_blob_130,TRUE);

  l_blob_130 := plpdf_toolkit.Rebuild(
    p_inputfile => l_blob_40
    );

  delete from store_blob_tk where id = 130;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (130,l_blob_130,'Rebuild.pdf','id:40 plpdf_toolkit_v200-user_guide.pdf Rebuild');
  commit;
end;

  -- Readonly
procedure Readonly_test
  is
  l_blob_125 blob;
  l_blob_140 blob;
begin
  select t.blob_file
    into l_blob_125
  from store_blob_tk t
  where t.filename = 'ImportXFDF.pdf';

  dbms_lob.createtemporary(l_blob_140,TRUE);

  l_blob_140 := plpdf_toolkit.setFieldsReadonly(
    p_inputfile => l_blob_125
    );

  delete from store_blob_tk where id = 140;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (140,l_blob_140,'Readonly.pdf','id:125 ImportXFDF.pdf Readonly');
  commit;

end;

-- getPDFACompliant
procedure getPDFACompliant_test
  is
  l_blob_80 blob;
  l_comp varchar2(2 char);
begin
  select t.blob_file
    into l_blob_80
  from store_blob_tk t
  where t.filename = 'PDFa.pdf';

  l_comp := plpdf_toolkit.getPDFACompliant(
    p_inputfile => l_blob_80
    );

  dbms_output.put_line(l_comp);
end;

-- Create_XFDF
procedure create_xfdf_test
  is
  l_blob_131 blob;
  l_nodes plpdf_xfdf.t_xml_inputs;
begin
  l_nodes('CAR') := 'Ford';
  l_nodes('MOTORBIKE') := 'Suzuki';
  l_nodes('BIKE') := 'KTM';
  l_nodes('BOAT') := 'Bayliner';

  dbms_lob.createtemporary(l_blob_131,TRUE);

  l_blob_131 := plpdf_xfdf.create_xfdf(
    p_xml_inputs => l_nodes,
    p_id => sys_guid()
    );

  delete from store_blob_tk where id = 131;
  insert into store_blob_tk
    (id,blob_file,filename,description)
    values
    (131,l_blob_131,'Create_XFDF.xfdf','Create_XFDF');
  commit;
end;

-- Parse_XFDF
procedure parse_xfdf_test
  is
  l_blob_xfdf blob;
  l_clob clob;
  l_varchar varchar2(32767);
  l_start pls_integer := 1;
  l_buffer pls_integer := 32767;
  l_nodes plpdf_xfdf.t_xml_inputs;
  l_node plx_sc.normalv2;
begin
  select t.blob_file
    into l_blob_xfdf
  from store_blob_tk t
  where t.filename = 'Create_XFDF.xfdf';

  dbms_lob.createtemporary(l_clob, true);

  for i in 1..ceil(dbms_lob.getlength(l_blob_xfdf) / l_buffer)
    loop
      l_varchar := utl_raw.cast_to_varchar2(dbms_lob.substr(l_blob_xfdf, l_buffer, l_start));
      dbms_lob.writeappend(l_clob, length(l_varchar), l_varchar);
      l_start := l_start + l_buffer;
    end loop;

    l_nodes := plpdf_xfdf.parse_xfdf(l_clob);

    l_node := l_nodes.first;
    while l_node is not null loop
      dbms_output.put_line('l_nodes(' || l_node || ') = ' || l_nodes(l_node));
      l_node := l_nodes.next(l_node);
    end loop;
end;

end;
/
