-- Load files into the test table 
declare
l_blob blob;

-- Load from file
procedure load_from_file(
    p_dir varchar2,
    p_filename varchar2,
    p_id number
) is
    l_file_ptr bfile;   
    l_file blob;
    l_id number;    
begin
    l_id := p_id;
    insert into store_blob_tk
    values ( l_id, empty_blob(), p_filename, p_filename, sysdate() )
    returning blob_file into l_file;
    
    l_file_ptr := bfilename(p_dir, p_filename); 
    dbms_lob.fileopen(l_file_ptr); 
    dbms_lob.loadfromfile(l_file, l_file_ptr, dbms_lob.getlength(l_file_ptr)); 
    commit; 
    dbms_lob.close(l_file_ptr);
end;

begin
	delete from store_blob_tk where 1=1;
	load_from_file('TOOLKIT_TESTFILES', 'plpdf-toolkit-install-v200.pdf',10);
	load_from_file('TOOLKIT_TESTFILES', '00_ReadMe.pdf',20);
	load_from_file('TOOLKIT_TESTFILES', '1326903170_res.pdf',21);
	load_from_file('TOOLKIT_TESTFILES', 'link.pdf',30);
	load_from_file('TOOLKIT_TESTFILES', 'image1.jpg',22);
	load_from_file('TOOLKIT_TESTFILES', 'Alcohole.ttf',23);
	load_from_file('TOOLKIT_TESTFILES', 'plpdf_toolkit_v200-user_guide.pdf',40);
	load_from_file('TOOLKIT_TESTFILES', '1-5.pdf',41);
	load_from_file('TOOLKIT_TESTFILES', 'SimpleRegistrationForm_2.pdf',50);
	load_from_file('TOOLKIT_TESTFILES', 'SimpleRegistrationForm.pdf',60);
	load_from_file('TOOLKIT_TESTFILES', 'import_fdf.fdf',61);
	load_from_file('TOOLKIT_TESTFILES', 'import_xfdf.xfdf',62);
	commit;

	delete from plpdf_tk_merge_inputs where tr_id = 1;

	select blob_file into l_blob from store_blob_tk where filename = '00_ReadMe.pdf';
	insert into plpdf_tk_merge_inputs (
	tr_id, order_num, inputfile, overwrite_rect_x, overwrite_rect_y,
	overwrite_rect_w, overwrite_rect_h, overwrite_rect_color_red, overwrite_rect_color_green, overwrite_rect_color_blue
	)
	values (1, 1234, l_blob, 1, 1, 200, 200, 255, 0, 0);

	select blob_file into l_blob from store_blob_tk where filename = '1326903170_res.pdf';
	insert into plpdf_tk_merge_inputs (
	tr_id, order_num, inputfile, overwrite_rect_x, overwrite_rect_y,
	overwrite_rect_w, overwrite_rect_h, overwrite_rect_color_red, overwrite_rect_color_green, overwrite_rect_color_blue
	)
	values (1, 4567, l_blob, 10, 10, 150, 100, 0, 255, 0);

	select blob_file into l_blob from store_blob_tk where filename = 'SignHere.pdf';
	insert into plpdf_tk_merge_inputs (
	tr_id, order_num, inputfile, overwrite_rect_x, overwrite_rect_y,
	overwrite_rect_w, overwrite_rect_h, overwrite_rect_color_red, overwrite_rect_color_green, overwrite_rect_color_blue
	)
	values (1, 8912, l_blob, 120, 200, 280, 90, 0, 0, 255);

	commit;
end;
/