create or replace package plx_sc
authid current_user is
--v5.9
--
  /* XML Simple Composer */
  --types
  subtype maxv2 is varchar2(32767 char);
  subtype normalv2 is varchar2(255 char);
  --v2.0.0
  type t_attr is record (
    name normalv2,
    value maxv2
    );
  --type type_attrs is table of maxv2 index by normalv2;
  type type_attrs is table of t_attr;
  type t_attrs is table of t_attr;
  --
  type type_xdoc is record(
    clobvar   clob,
    buffervar maxv2
    );
  type type_pck is table of type_xdoc index by pls_integer;

  -- variables
  v_newline varchar2(2 char) := chr(13) || chr(10);
  v_pck            type_pck;
  v_doc_index      pls_integer := 0;
  v_xml_version    normalv2 := '1.0';
  v_xml_encoding   normalv2 := 'UTF-8';
  v_xml_standalone normalv2 := null;

  -- constants
  c_ns_sep constant varchar2(1 char) := ':';
  c_xmlns  constant normalv2 := 'xmlns';
  --
  --v4.9.0
  c_preserve constant plx_sc.normalv2 := 'preserve';
  -- procedures
  procedure setNewLine(p_nl varchar2);
  --
  procedure setdefXmlVersion(p_version varchar2);
  --
  procedure setdefXmlEncoding(p_encoding varchar2);
  --
  procedure setdefXmlStandalone(p_standalone varchar2);
  --
  function getheadertext(p_version    varchar2,
                         p_encoding   varchar2,
                         p_standalone varchar2) return varchar2;
  --
  procedure addAttribute(p_attrs in out nocopy type_attrs,
                         p_name  varchar2,
                         p_value varchar2);
  --
  procedure addAttributewNS(p_attrs     in out nocopy type_attrs,
                            p_namespace varchar2,
                            p_name      varchar2,
                            p_value     varchar2);
  --
  procedure addNameSpace(p_attrs in out nocopy type_attrs,
                         p_name  varchar2 default null,
                         p_value varchar2);
  /**************************************************************/
  -- CLOB as XML container
  procedure addtext(p_doc in out nocopy clob, p_text varchar2);
  --
  procedure addline(p_doc in out nocopy clob, p_text varchar2);
  --
  procedure startDocument(p_doc in out nocopy clob);
  --
  procedure startDocumentwHeader(p_doc        in out nocopy clob,
                                 p_version    varchar2 default null,
                                 p_encoding   varchar2 default null,
                                 p_standalone varchar2 default null);
  --
  procedure endDocument(p_doc in out nocopy clob);
  --
  procedure startElement(p_doc   in out nocopy clob,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy clob,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_doc   in out nocopy clob,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy clob,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --startElement
  procedure endElement(p_doc in out nocopy clob, p_tag varchar2);
  --
  procedure endElementwNS(p_doc       in out nocopy clob,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_doc in out nocopy clob, p_chars varchar2);
  --
  function getXML(p_doc in out nocopy clob) return sys.xmltype;
  --
  procedure getXMLBLOB(p_doc     in out nocopy clob,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_doc     in out nocopy clob,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  --
  /**************************************************************/
  -- XDOC as XML container
  procedure addtext(p_doc in out nocopy type_xdoc, p_text varchar2);
  --
  --v3.6.0
  procedure addXdoc(p_doc in out nocopy type_xdoc, p_text in out nocopy type_xdoc);
  --
  procedure addline(p_doc in out nocopy type_xdoc, p_text varchar2);
  --
  procedure startDocument(p_doc in out nocopy type_xdoc);
  --
  procedure startDocumentwHeader(p_doc        in out nocopy type_xdoc,
                                 p_version    varchar2 default null,
                                 p_encoding   varchar2 default null,
                                 p_standalone varchar2 default null);
  --
  procedure endDocument(p_doc in out nocopy type_xdoc);
  --
  procedure startElement(p_doc   in out nocopy type_xdoc,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy type_xdoc,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_doc   in out nocopy type_xdoc,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_doc       in out nocopy type_xdoc,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --
  procedure endElement(p_doc in out nocopy type_xdoc, p_tag varchar2);
  --
  procedure endElementwNS(p_doc       in out nocopy type_xdoc,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_doc in out nocopy type_xdoc, p_chars varchar2);
  --
  function getXML(p_doc in out nocopy type_xdoc) return sys.xmltype;
  --
  procedure getXMLBLOB(p_doc     in out nocopy type_xdoc,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_doc     in out nocopy type_xdoc,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  --
  /**************************************************************/
  -- PCK package as XML container
  procedure InitPackage;
  --
  procedure addtext(p_id pls_integer, p_text varchar2);
  --
  procedure addline(p_id pls_integer, p_text varchar2);
  --
  function startDocument return pls_integer;
  --
  function startDocumentwHeader(p_version    varchar2 default null,
                                p_encoding   varchar2 default null,
                                p_standalone varchar2 default null)
    return pls_integer;
  --
  procedure endDocument(p_id pls_integer);
  --
  procedure startElement(p_id    pls_integer,
                         p_tag   varchar2,
                         p_attrs type_attrs,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_id        pls_integer,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_attrs     type_attrs,
                            p_close     boolean default false);
  --
  procedure startElement(p_id    pls_integer,
                         p_tag   varchar2,
                         p_close boolean default false);
  --
  procedure startElementwNS(p_id        pls_integer,
                            p_namespace varchar2,
                            p_tag       varchar2,
                            p_close     boolean default false);
  --
  procedure endElement(p_id pls_integer, p_tag varchar2);
  --
  procedure endElementwNS(p_id        pls_integer,
                          p_namespace varchar2,
                          p_tag       varchar2);
  --
  procedure characters(p_id pls_integer, p_chars varchar2);
  --
  function getXML(p_id pls_integer) return sys.xmltype;
  --
  procedure getXMLBLOB(p_id      pls_integer,
                       p_blob    out nocopy blob,
                       p_charset varchar2 default 'UTF8');
  --
  procedure getBLOB(p_id      pls_integer,
                    p_blob    out nocopy blob,
                    p_charset varchar2 default 'UTF8');
  /**************************************************************/
  -- utils
  function str2cp(p_str varchar2) return varchar2;
  --
  function replacetags(p_str varchar2) return varchar2;
  --
  function xmlascii(p_str varchar2) return varchar2;
  --
  function num2char(p_number number,
                    p_digits number default null,
                    p_round  boolean default false) return varchar2;
  -- xsd:dateTime: [-]CCYY-MM-DDThh:mm:ss[Z|(+|-)hh:mm]
  function date2dateTime2char(p_date date) return varchar2;
  -- xsd:long
  function num2long2char(p_number number) return varchar2;
  --
end plx_sc;
/

create or replace package body plx_sc wrapped 
a000000
b2
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
4bd8 d26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/
