create or replace package plpdf_toolkit_par is
---------------------------------------------------------------------------------------------------
function setcertkey
  return varchar2;
---------------------------------------------------------------------------------------------------
/*
Default value for encoding.
Encoding is independent from Certification Key!
*/
function GetDefaultEncoding
  return varchar2;
---------------------------------------------------------------------------------------------------
/*
Default value for unit of measure.
UOM is independent from Certification Key!
*/
function GetDefaultUOM 
  return varchar2;
---------------------------------------------------------------------------------------------------
end;
/
create or replace package body plpdf_toolkit_par is
---------------------------------------------------------------------------------------------------
/*
Certification Key
Restriction: If CertKey is 'TRIAL' then sometime raises exception with this message:
"Random message: Certification key is TRIAL. (it's not error)"
*/
function setcertkey
  return varchar2 is
begin
  return 'TRIAL';
end;
---------------------------------------------------------------------------------------------------
/*
Default value for encoding.
Encoding is independent from Certification Key!
Allowable values (case-sensitive):
  cp1250
  cp1251
  cp1252
  cp1253
  cp1254
  cp1255
  cp1257
  cp1258
  cp874
  iso-8859-1
  iso-8859-11
  iso-8859-15
  iso-8859-16
  iso-8859-2
  iso-8859-4
  iso-8859-5
  iso-8859-7
  iso-8859-9
  koi8-r
  koi8-u
*/
function GetDefaultEncoding return varchar2 is
begin
  -- default value: cp1252
  return 'cp1252';
end;
---------------------------------------------------------------------------------------------------
/*
Default value for unit of measure.
UOM is independent from Certification Key!
*/
function GetDefaultUOM return varchar2 is
begin
  return 'pt';
end;
---------------------------------------------------------------------------------------------------
end;
/
