/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.xmp.xml;

import com.plpdf.xmp.XMPMetadata;
import com.plpdf.xmp.schema.PDFAExtensionSchema;
import com.plpdf.xmp.schema.XMPSchema;
import com.plpdf.xmp.schema.XMPSchemaFactory;
import com.plpdf.xmp.type.AbstractField;
import com.plpdf.xmp.type.AbstractStructuredType;
import com.plpdf.xmp.type.ArrayProperty;
import com.plpdf.xmp.type.Cardinality;
import com.plpdf.xmp.type.DefinedStructuredType;
import com.plpdf.xmp.type.PDFAFieldType;
import com.plpdf.xmp.type.PDFAPropertyType;
import com.plpdf.xmp.type.PDFASchemaType;
import com.plpdf.xmp.type.PDFATypeType;
import com.plpdf.xmp.type.PropertiesDescription;
import com.plpdf.xmp.type.PropertyType;
import com.plpdf.xmp.type.StructuredType;
import com.plpdf.xmp.type.TypeMapping;
import com.plpdf.xmp.type.Types;
import com.plpdf.xmp.xml.XmpParsingException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PdfaExtensionHelper {
    private PdfaExtensionHelper() {
    }

    public static void validateNaming(XMPMetadata meta, Element description) throws XmpParsingException {
        NamedNodeMap nnm = description.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Attr attr = (Attr)nnm.item(i);
            PdfaExtensionHelper.checkNamespaceDeclaration(attr, PDFAExtensionSchema.class);
            PdfaExtensionHelper.checkNamespaceDeclaration(attr, PDFAFieldType.class);
            PdfaExtensionHelper.checkNamespaceDeclaration(attr, PDFAPropertyType.class);
            PdfaExtensionHelper.checkNamespaceDeclaration(attr, PDFASchemaType.class);
            PdfaExtensionHelper.checkNamespaceDeclaration(attr, PDFATypeType.class);
            ++i;
        }
    }

    private static void checkNamespaceDeclaration(Attr attr, Class<? extends AbstractStructuredType> clz) throws XmpParsingException {
        String prefix = attr.getLocalName();
        String namespace = attr.getValue();
        String cprefix = clz.getAnnotation(StructuredType.class).preferedPrefix();
        String cnamespace = clz.getAnnotation(StructuredType.class).namespace();
        if (cprefix.equals(prefix) && !cnamespace.equals(namespace)) {
            throw new XmpParsingException(XmpParsingException.ErrorType.InvalidPdfaSchema, "Invalid PDF/A namespace definition");
        }
        if (cnamespace.equals(namespace) && !cprefix.equals(prefix)) {
            throw new XmpParsingException(XmpParsingException.ErrorType.InvalidPdfaSchema, "Invalid PDF/A namespace definition");
        }
    }

    public static void populateSchemaMapping(XMPMetadata meta) throws XmpParsingException {
        List<XMPSchema> schems = meta.getAllSchemas();
        TypeMapping tm = meta.getTypeMapping();
        StructuredType stPdfaExt = PDFAExtensionSchema.class.getAnnotation(StructuredType.class);
        for (XMPSchema xmpSchema : schems) {
            if (!xmpSchema.getNamespace().equals(stPdfaExt.namespace())) continue;
            if (!xmpSchema.getPrefix().equals(stPdfaExt.preferedPrefix())) {
                throw new XmpParsingException(XmpParsingException.ErrorType.InvalidPrefix, "Found invalid prefix for PDF/A extension, found '" + xmpSchema.getPrefix() + "', should be '" + stPdfaExt.preferedPrefix() + "'");
            }
            PDFAExtensionSchema pes = (PDFAExtensionSchema)xmpSchema;
            ArrayProperty sp = pes.getSchemasProperty();
            for (AbstractField af : sp.getAllProperties()) {
                if (!(af instanceof PDFASchemaType)) continue;
                PDFASchemaType st = (PDFASchemaType)af;
                String namespaceUri = st.getNamespaceURI();
                String prefix = st.getPrefixValue();
                ArrayProperty properties = st.getProperty();
                ArrayProperty valueTypes = st.getValueType();
                XMPSchemaFactory xsf = tm.getSchemaFactory(namespaceUri);
                if (xsf == null) {
                    tm.addNewNameSpace(namespaceUri, prefix);
                    xsf = tm.getSchemaFactory(namespaceUri);
                }
                if (valueTypes != null) {
                    for (AbstractField af2 : valueTypes.getAllProperties()) {
                        if (!(af2 instanceof PDFATypeType)) continue;
                        PDFATypeType type = (PDFATypeType)af2;
                        String ttype = type.getType();
                        String tns = type.getNamespaceURI();
                        String tprefix = type.getPrefixValue();
                        String tdescription = type.getDescription();
                        ArrayProperty fields = type.getFields();
                        if (ttype == null || tns == null || tprefix == null || tdescription == null) {
                            throw new XmpParsingException(XmpParsingException.ErrorType.RequiredProperty, "Missing field in type definition");
                        }
                        DefinedStructuredType structuredType = new DefinedStructuredType(meta, tns, tprefix, null);
                        if (fields != null) {
                            List<AbstractField> definedFields = fields.getAllProperties();
                            for (AbstractField abstractField : definedFields) {
                                if (!(abstractField instanceof PDFAFieldType)) continue;
                                PDFAFieldType field = (PDFAFieldType)abstractField;
                                String fName = field.getName();
                                String fDescription = field.getDescription();
                                String fValueType = field.getValueType();
                                if (fName == null || fDescription == null || fValueType == null) {
                                    throw new XmpParsingException(XmpParsingException.ErrorType.RequiredProperty, "Missing field in field definition");
                                }
                                try {
                                    Types fValue = Types.valueOf(fValueType);
                                    structuredType.addProperty(fName, TypeMapping.createPropertyType(fValue, Cardinality.Simple));
                                }
                                catch (IllegalArgumentException e) {
                                    throw new XmpParsingException(XmpParsingException.ErrorType.NoValueType, "Type not defined : " + fValueType, e);
                                }
                            }
                        }
                        PropertiesDescription pm = new PropertiesDescription();
                        for (Map.Entry entry : structuredType.getDefinedProperties().entrySet()) {
                            pm.addNewProperty((String)entry.getKey(), (PropertyType)entry.getValue());
                        }
                        tm.addToDefinedStructuredTypes(ttype, tns, pm);
                    }
                }
                for (AbstractField af2 : properties.getAllProperties()) {
                    if (!(af2 instanceof PDFAPropertyType)) continue;
                    PDFAPropertyType property = (PDFAPropertyType)af2;
                    String pname = property.getName();
                    String ptype = property.getValueType();
                    String pdescription = property.getDescription();
                    String pCategory = property.getCategory();
                    if (pname == null || ptype == null || pdescription == null || pCategory == null) {
                        throw new XmpParsingException(XmpParsingException.ErrorType.RequiredProperty, "Missing field in property definition");
                    }
                    PropertyType pt = PdfaExtensionHelper.transformValueType(tm, ptype);
                    if (pt.type() == null) {
                        throw new XmpParsingException(XmpParsingException.ErrorType.NoValueType, "Type not defined : " + ptype);
                    }
                    if (pt.type().isSimple() || pt.type().isStructured() || pt.type() == Types.DefinedType) {
                        xsf.getPropertyDefinition().addNewProperty(pname, pt);
                        continue;
                    }
                    throw new XmpParsingException(XmpParsingException.ErrorType.NoValueType, "Type not defined : " + ptype);
                }
            }
        }
    }

    private static PropertyType transformValueType(TypeMapping tm, String valueType) throws XmpParsingException {
        Types type;
        Cardinality card;
        block10: {
            if ("Lang Alt".equals(valueType)) {
                return TypeMapping.createPropertyType(Types.LangAlt, Cardinality.Simple);
            }
            int pos = valueType.indexOf(32);
            card = Cardinality.Simple;
            if (pos > 0) {
                String scard = valueType.substring(0, pos);
                if ("seq".equals(scard)) {
                    card = Cardinality.Seq;
                } else if ("bag".equals(scard)) {
                    card = Cardinality.Bag;
                } else if ("alt".equals(scard)) {
                    card = Cardinality.Alt;
                } else {
                    return null;
                }
            }
            String vt = valueType.substring(pos + 1);
            type = null;
            try {
                type = pos < 0 ? Types.valueOf(valueType) : Types.valueOf(vt);
            }
            catch (IllegalArgumentException e) {
                if (!tm.isDefinedType(vt)) break block10;
                type = Types.DefinedType;
            }
        }
        return TypeMapping.createPropertyType(type, card);
    }
}

