/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.xmp.xml;

import com.plpdf.xmp.xml.XmpParsingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomHelper {
    private DomHelper() {
    }

    public static Element getUniqueElementChild(Element description) throws XmpParsingException {
        NodeList nl = description.getChildNodes();
        int pos = -1;
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                if (pos >= 0) {
                    throw new XmpParsingException(XmpParsingException.ErrorType.Undefined, "Found two child elements in " + description);
                }
                pos = i;
            }
            ++i;
        }
        return (Element)nl.item(pos);
    }

    public static Element getFirstChildElement(Element description) throws XmpParsingException {
        NodeList nl = description.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                return (Element)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getElementChildren(Element description) throws XmpParsingException {
        NodeList nl = description.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                ret.add((Element)nl.item(i));
            }
            ++i;
        }
        return ret;
    }

    public static QName getQName(Element element) {
        return new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix());
    }

    public static boolean isRdfDescription(Element element) {
        return "rdf".equals(element.getPrefix()) && "Description".equals(element.getLocalName());
    }

    public static boolean isParseTypeResource(Element element) {
        Attr parseType = element.getAttributeNodeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
        return parseType != null && "Resource".equals(parseType.getValue());
    }
}

