/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.xmp.type;

import com.plpdf.xmp.XMPMetadata;
import com.plpdf.xmp.schema.AdobePDFSchema;
import com.plpdf.xmp.schema.DublinCoreSchema;
import com.plpdf.xmp.schema.PDFAExtensionSchema;
import com.plpdf.xmp.schema.PDFAIdentificationSchema;
import com.plpdf.xmp.schema.PhotoshopSchema;
import com.plpdf.xmp.schema.XMPBasicJobTicketSchema;
import com.plpdf.xmp.schema.XMPBasicSchema;
import com.plpdf.xmp.schema.XMPMediaManagementSchema;
import com.plpdf.xmp.schema.XMPRightsManagementSchema;
import com.plpdf.xmp.schema.XMPSchema;
import com.plpdf.xmp.schema.XMPSchemaFactory;
import com.plpdf.xmp.schema.XmpSchemaException;
import com.plpdf.xmp.type.AbstractSimpleProperty;
import com.plpdf.xmp.type.AbstractStructuredType;
import com.plpdf.xmp.type.AgentNameType;
import com.plpdf.xmp.type.ArrayProperty;
import com.plpdf.xmp.type.BadFieldValueException;
import com.plpdf.xmp.type.BooleanType;
import com.plpdf.xmp.type.Cardinality;
import com.plpdf.xmp.type.ChoiceType;
import com.plpdf.xmp.type.DateType;
import com.plpdf.xmp.type.DefinedStructuredType;
import com.plpdf.xmp.type.GUIDType;
import com.plpdf.xmp.type.IntegerType;
import com.plpdf.xmp.type.LocaleType;
import com.plpdf.xmp.type.MIMEType;
import com.plpdf.xmp.type.PartType;
import com.plpdf.xmp.type.ProperNameType;
import com.plpdf.xmp.type.PropertiesDescription;
import com.plpdf.xmp.type.PropertyType;
import com.plpdf.xmp.type.RealType;
import com.plpdf.xmp.type.RenditionClassType;
import com.plpdf.xmp.type.StructuredType;
import com.plpdf.xmp.type.TextType;
import com.plpdf.xmp.type.Types;
import com.plpdf.xmp.type.URIType;
import com.plpdf.xmp.type.URLType;
import com.plpdf.xmp.type.XPathType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMapping {
    private Map<Types, PropertiesDescription> structuredMappings;
    private Map<String, Types> structuredNamespaces;
    private Map<String, String> definedStructuredNamespaces;
    private Map<String, PropertiesDescription> definedStructuredMappings;
    private XMPMetadata metadata;
    private Map<String, XMPSchemaFactory> schemaMap;
    private static Class<?>[] simplePropertyConstParams = new Class[]{XMPMetadata.class, String.class, String.class, String.class, Object.class};

    public TypeMapping(XMPMetadata metadata) {
        this.metadata = metadata;
        this.initialize();
    }

    private void initialize() {
        this.structuredMappings = new HashMap<Types, PropertiesDescription>();
        this.structuredNamespaces = new HashMap<String, Types>();
        Types[] typesArray = Types.values();
        int n = typesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Types type = typesArray[n2];
            if (type.isStructured()) {
                Class<AbstractStructuredType> clz = type.getImplementingClass().asSubclass(AbstractStructuredType.class);
                StructuredType st = clz.getAnnotation(StructuredType.class);
                String ns = st.namespace();
                PropertiesDescription pm = this.initializePropMapping(clz);
                this.structuredNamespaces.put(ns, type);
                this.structuredMappings.put(type, pm);
            }
            ++n2;
        }
        this.definedStructuredNamespaces = new HashMap<String, String>();
        this.definedStructuredMappings = new HashMap<String, PropertiesDescription>();
        this.schemaMap = new HashMap<String, XMPSchemaFactory>();
        this.addNameSpace(XMPBasicSchema.class);
        this.addNameSpace(DublinCoreSchema.class);
        this.addNameSpace(PDFAExtensionSchema.class);
        this.addNameSpace(XMPMediaManagementSchema.class);
        this.addNameSpace(AdobePDFSchema.class);
        this.addNameSpace(PDFAIdentificationSchema.class);
        this.addNameSpace(XMPRightsManagementSchema.class);
        this.addNameSpace(PhotoshopSchema.class);
        this.addNameSpace(XMPBasicJobTicketSchema.class);
    }

    public void addToDefinedStructuredTypes(String typeName, String ns, PropertiesDescription pm) {
        this.definedStructuredNamespaces.put(ns, typeName);
        this.definedStructuredMappings.put(typeName, pm);
    }

    public PropertiesDescription getDefinedDescriptionByNamespace(String namespace) {
        String dt = this.definedStructuredNamespaces.get(namespace);
        return this.definedStructuredMappings.get(dt);
    }

    public AbstractStructuredType instanciateStructuredType(Types type, String propertyName) throws BadFieldValueException {
        try {
            Class<AbstractStructuredType> propertyTypeClass = type.getImplementingClass().asSubclass(AbstractStructuredType.class);
            Constructor<AbstractStructuredType> construct = propertyTypeClass.getConstructor(XMPMetadata.class);
            AbstractStructuredType tmp = construct.newInstance(this.metadata);
            tmp.setPropertyName(propertyName);
            return tmp;
        }
        catch (InvocationTargetException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
        catch (IllegalArgumentException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
        catch (InstantiationException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
        catch (IllegalAccessException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
        catch (SecurityException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
        catch (NoSuchMethodException e) {
            throw new BadFieldValueException("Failed to instanciate structured type : " + (Object)((Object)type), e);
        }
    }

    public AbstractStructuredType instanciateDefinedType(String propertyName, String namespace) {
        return new DefinedStructuredType(this.metadata, namespace, null, propertyName);
    }

    public AbstractSimpleProperty instanciateSimpleProperty(String nsuri, String prefix, String name, Object value, Types type) {
        Object[] params = new Object[]{this.metadata, nsuri, prefix, name, value};
        try {
            Class<AbstractSimpleProperty> clz = type.getImplementingClass().asSubclass(AbstractSimpleProperty.class);
            Constructor<AbstractSimpleProperty> cons = clz.getConstructor(simplePropertyConstParams);
            return cons.newInstance(params);
        }
        catch (NoSuchMethodError e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to instanciate property", e);
        }
    }

    public AbstractSimpleProperty instanciateSimpleField(Class<?> clz, String nsuri, String prefix, String propertyName, Object value) {
        PropertiesDescription pm = this.initializePropMapping(clz);
        PropertyType simpleType = pm.getPropertyType(propertyName);
        Types type = simpleType.type();
        return this.instanciateSimpleProperty(nsuri, prefix, propertyName, value, type);
    }

    public boolean isStructuredTypeNamespace(String namespace) {
        return this.structuredNamespaces.containsKey(namespace);
    }

    public boolean isDefinedTypeNamespace(String namespace) {
        return this.definedStructuredNamespaces.containsKey(namespace);
    }

    public boolean isDefinedType(String name) {
        return this.definedStructuredMappings.containsKey(name);
    }

    private void addNameSpace(Class<? extends XMPSchema> classSchem) {
        StructuredType st = classSchem.getAnnotation(StructuredType.class);
        String ns = st.namespace();
        this.schemaMap.put(ns, new XMPSchemaFactory(ns, classSchem, this.initializePropMapping(classSchem)));
    }

    public void addNewNameSpace(String ns, String prefered) {
        PropertiesDescription mapping = new PropertiesDescription();
        this.schemaMap.put(ns, new XMPSchemaFactory(ns, XMPSchema.class, mapping));
    }

    public PropertiesDescription getStructuredPropMapping(Types type) {
        return this.structuredMappings.get((Object)type);
    }

    public XMPSchema getAssociatedSchemaObject(XMPMetadata metadata, String namespace, String prefix) throws XmpSchemaException {
        if (this.schemaMap.containsKey(namespace)) {
            XMPSchemaFactory factory = this.schemaMap.get(namespace);
            return factory.createXMPSchema(metadata, prefix);
        }
        XMPSchemaFactory factory = this.getSchemaFactory(namespace);
        return factory != null ? factory.createXMPSchema(metadata, prefix) : null;
    }

    public XMPSchemaFactory getSchemaFactory(String namespace) {
        return this.schemaMap.get(namespace);
    }

    public boolean isDefinedSchema(String namespace) {
        return this.schemaMap.containsKey(namespace);
    }

    public boolean isDefinedNamespace(String namespace) {
        return this.isDefinedSchema(namespace) || this.isStructuredTypeNamespace(namespace) || this.isDefinedTypeNamespace(namespace);
    }

    public PropertyType getSpecifiedPropertyType(QName name) throws BadFieldValueException {
        XMPSchemaFactory factory = this.getSchemaFactory(name.getNamespaceURI());
        if (factory != null) {
            return factory.getPropertyType(name.getLocalPart());
        }
        Types st = this.structuredNamespaces.get(name.getNamespaceURI());
        if (st != null) {
            return TypeMapping.createPropertyType(st, Cardinality.Simple);
        }
        String dt = this.definedStructuredNamespaces.get(name.getNamespaceURI());
        if (dt == null) {
            throw new BadFieldValueException("No descriptor found for " + name);
        }
        return TypeMapping.createPropertyType(Types.DefinedType, Cardinality.Simple);
    }

    public PropertiesDescription initializePropMapping(Class<?> classSchem) {
        PropertiesDescription propMap = new PropertiesDescription();
        Field[] fields = classSchem.getFields();
        String propName = null;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(PropertyType.class)) {
                try {
                    propName = (String)field.get(propName);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("couldn't read one type declaration, please check accessibility and declaration of fields annoted in " + classSchem.getName(), e);
                }
                PropertyType propType = field.getAnnotation(PropertyType.class);
                propMap.addNewProperty(propName, propType);
            }
            ++n2;
        }
        return propMap;
    }

    public BooleanType createBoolean(String namespaceURI, String prefix, String propertyName, boolean value) {
        return new BooleanType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public DateType createDate(String namespaceURI, String prefix, String propertyName, Calendar value) {
        return new DateType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public IntegerType createInteger(String namespaceURI, String prefix, String propertyName, int value) {
        return new IntegerType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public RealType createReal(String namespaceURI, String prefix, String propertyName, float value) {
        return new RealType(this.metadata, namespaceURI, prefix, propertyName, Float.valueOf(value));
    }

    public TextType createText(String namespaceURI, String prefix, String propertyName, String value) {
        return new TextType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public ProperNameType createProperName(String namespaceURI, String prefix, String propertyName, String value) {
        return new ProperNameType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public URIType createURI(String namespaceURI, String prefix, String propertyName, String value) {
        return new URIType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public URLType createURL(String namespaceURI, String prefix, String propertyName, String value) {
        return new URLType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public RenditionClassType createRenditionClass(String namespaceURI, String prefix, String propertyName, String value) {
        return new RenditionClassType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public PartType createPart(String namespaceURI, String prefix, String propertyName, String value) {
        return new PartType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public MIMEType createMIMEType(String namespaceURI, String prefix, String propertyName, String value) {
        return new MIMEType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public LocaleType createLocale(String namespaceURI, String prefix, String propertyName, String value) {
        return new LocaleType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public GUIDType createGUID(String namespaceURI, String prefix, String propertyName, String value) {
        return new GUIDType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public ChoiceType createChoice(String namespaceURI, String prefix, String propertyName, String value) {
        return new ChoiceType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public AgentNameType createAgentName(String namespaceURI, String prefix, String propertyName, String value) {
        return new AgentNameType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public XPathType createXPath(String namespaceURI, String prefix, String propertyName, String value) {
        return new XPathType(this.metadata, namespaceURI, prefix, propertyName, value);
    }

    public ArrayProperty createArrayProperty(String namespace, String prefix, String propertyName, Cardinality type) {
        return new ArrayProperty(this.metadata, namespace, prefix, propertyName, type);
    }

    public static PropertyType createPropertyType(final Types type, final Cardinality card) {
        return new PropertyType(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public Types type() {
                return type;
            }

            @Override
            public Cardinality card() {
                return card;
            }
        };
    }
}

