/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.xmp.type;

import com.plpdf.xmp.DateConverter;
import com.plpdf.xmp.XMPMetadata;
import com.plpdf.xmp.type.AbstractSimpleProperty;
import java.io.IOException;
import java.util.Calendar;

public class DateType
extends AbstractSimpleProperty {
    private Calendar dateValue;

    public DateType(XMPMetadata metadata, String namespaceURI, String prefix, String propertyName, Object value) {
        super(metadata, namespaceURI, prefix, propertyName, value);
    }

    private void setValueFromCalendar(Calendar value) {
        this.dateValue = value;
    }

    public Calendar getValue() {
        return this.dateValue;
    }

    private boolean isGoodType(Object value) {
        if (value instanceof Calendar) {
            return true;
        }
        if (value instanceof String) {
            try {
                DateConverter.toCalendar((String)value);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public void setValue(Object value) {
        if (!this.isGoodType(value)) {
            throw new IllegalArgumentException("Value given is not allowed for the Date type : " + value.getClass());
        }
        if (value instanceof String) {
            this.setValueFromString((String)value);
        } else {
            this.setValueFromCalendar((Calendar)value);
        }
    }

    public String getStringValue() {
        return DateConverter.toISO8601(this.dateValue);
    }

    private void setValueFromString(String value) {
        try {
            this.setValueFromCalendar(DateConverter.toCalendar(value));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

