/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.xmp.type;

import com.plpdf.xmp.XMPMetadata;
import com.plpdf.xmp.type.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractField {
    private XMPMetadata metadata;
    private String propertyName;
    private Map<String, Attribute> attributes;

    public AbstractField(XMPMetadata metadata, String propertyName) {
        this.metadata = metadata;
        this.propertyName = propertyName;
        this.attributes = new HashMap<String, Attribute>();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final void setPropertyName(String value) {
        this.propertyName = value;
    }

    public final void setAttribute(Attribute value) {
        if (this.attributes.containsKey(value.getName())) {
            this.attributes.remove(value.getName());
        }
        if (value.getNamespace() == null) {
            this.attributes.put(value.getName(), value);
        } else {
            this.attributes.put(value.getName(), value);
        }
    }

    public final boolean containsAttribute(String qualifiedName) {
        return this.attributes.containsKey(qualifiedName);
    }

    public final Attribute getAttribute(String qualifiedName) {
        return this.attributes.get(qualifiedName);
    }

    public final List<Attribute> getAllAttributes() {
        return new ArrayList<Attribute>(this.attributes.values());
    }

    public final void removeAttribute(String qualifiedName) {
        if (this.containsAttribute(qualifiedName)) {
            this.attributes.remove(qualifiedName);
        }
    }

    public final XMPMetadata getMetadata() {
        return this.metadata;
    }

    public abstract String getNamespace();

    public abstract String getPrefix();
}

