/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util.operator.pagedrawer;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.graphics.SMGraphicsState;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.Matrix;
import com.plpdf.util.PDFOperator;
import com.plpdf.util.operator.OperatorProcessor;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<OMBase> arguments) throws Exception {
        PageDrawer drawer = (PageDrawer)this.context;
        SMPage page = drawer.getPage();
        OMName objectName = (OMName)arguments.get(0);
        Map<String, SMXObject> xobjects = drawer.getResources().getXObjects();
        SMXObject xobject = xobjects.get(objectName.getName());
        if (xobject != null) {
            if (xobject instanceof SMXObjectImage) {
                SMXObjectImage image = (SMXObjectImage)xobject;
                try {
                    BufferedImage awtImage;
                    if (image.getImageMask()) {
                        image.setStencilColor(drawer.getGraphicsState().getNonStrokingColor());
                    }
                    if ((awtImage = image.getRGBImage()) == null) {
                        return;
                    }
                    int imageWidth = awtImage.getWidth();
                    int imageHeight = awtImage.getHeight();
                    double pageHeight = drawer.getPageSize().getHeight();
                    Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
                    float yScaling = ctm.getYScale();
                    float angle = (float)Math.acos(ctm.getValue(0, 0) / ctm.getXScale());
                    if (ctm.getValue(0, 1) < 0.0f && ctm.getValue(1, 0) > 0.0f) {
                        angle *= -1.0f;
                    }
                    ctm.setValue(2, 1, (float)(pageHeight - (double)ctm.getYPosition() - Math.cos(angle) * (double)yScaling));
                    ctm.setValue(2, 0, (float)((double)ctm.getXPosition() - Math.sin(angle) * (double)yScaling));
                    ctm.setValue(0, 1, -1.0f * ctm.getValue(0, 1));
                    ctm.setValue(1, 0, -1.0f * ctm.getValue(1, 0));
                    AffineTransform ctmAT = ctm.createAffineTransform();
                    ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
                    drawer.drawImage(awtImage, ctmAT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (xobject instanceof SMXObjectForm) {
                this.context.getGraphicsStack().push((SMGraphicsState)this.context.getGraphicsState().clone());
                SMXObjectForm form = (SMXObjectForm)xobject;
                OMStream formContentstream = form.getOMStream();
                SMResources pdResources = form.getResources();
                Matrix matrix = form.getMatrix();
                if (matrix != null) {
                    Matrix xobjectCTM = matrix.multiply(this.context.getGraphicsState().getCurrentTransformationMatrix());
                    this.context.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
                }
                this.getContext().processSubStream(page, pdResources, formContentstream);
                this.context.setGraphicsState(this.context.getGraphicsStack().pop());
            }
        }
    }
}

