/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util.operator.pagedrawer;

import com.plpdf.om.OMBase;
import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.graphics.xobject.SMInlinedImage;
import com.plpdf.util.ImageParameters;
import com.plpdf.util.Matrix;
import com.plpdf.util.PDFOperator;
import com.plpdf.util.operator.OperatorProcessor;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginInlineImage
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<OMBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        SMPage page = drawer.getPage();
        ImageParameters params = operator.getImageParameters();
        SMInlinedImage image = new SMInlinedImage();
        image.setImageParameters(params);
        image.setImageData(operator.getImageData());
        BufferedImage awtImage = image.createImage(this.context.getColorSpaces());
        if (awtImage == null) {
            return;
        }
        int imageWidth = awtImage.getWidth();
        int imageHeight = awtImage.getHeight();
        double pageHeight = drawer.getPageSize().getHeight();
        Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
        int pageRotation = page.findRotation();
        AffineTransform ctmAT = ctm.createAffineTransform();
        ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.setFromAffineTransform(ctmAT);
        double angle = Math.atan(ctmAT.getShearX() / ctmAT.getScaleX());
        Matrix translationMatrix = null;
        if (pageRotation == 0 || pageRotation == 180) {
            translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getXScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition()) - Math.cos(angle) * (double)ctm.getYScale()));
        } else if (pageRotation == 90 || pageRotation == 270) {
            translationMatrix = Matrix.getTranslatingInstance((float)(Math.sin(angle) * (double)ctm.getYScale()), (float)(pageHeight - (double)(2.0f * ctm.getYPosition())));
        }
        rotationMatrix = rotationMatrix.multiply(translationMatrix);
        rotationMatrix.setValue(0, 1, -1.0f * rotationMatrix.getValue(0, 1));
        rotationMatrix.setValue(1, 0, -1.0f * rotationMatrix.getValue(1, 0));
        AffineTransform at = new AffineTransform(rotationMatrix.getValue(0, 0), rotationMatrix.getValue(0, 1), rotationMatrix.getValue(1, 0), rotationMatrix.getValue(1, 1), rotationMatrix.getValue(2, 0), rotationMatrix.getValue(2, 1));
        drawer.drawImage(awtImage, at);
    }
}

