/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util.operator;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMString;
import com.plpdf.util.Matrix;
import com.plpdf.util.PDFOperator;
import com.plpdf.util.operator.OperatorProcessor;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowTextGlyph
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<OMBase> arguments) throws Exception {
        OMArray array = (OMArray)arguments.get(0);
        int arraySize = array.size();
        float fontsize = this.context.getGraphicsState().getTextState().getFontSize();
        float horizontalScaling = this.context.getGraphicsState().getTextState().getHorizontalScalingPercent() / 100.0f;
        int i = 0;
        while (i < arraySize) {
            OMBase next = array.get(i);
            if (next instanceof OMNumber) {
                float adjustment = ((OMNumber)next).floatValue();
                Matrix adjMatrix = new Matrix();
                adjustment = -(adjustment / 1000.0f) * horizontalScaling * fontsize;
                adjMatrix.setValue(2, 0, adjustment);
                this.context.setTextMatrix(adjMatrix.multiply(this.context.getTextMatrix(), adjMatrix));
            } else if (next instanceof OMString) {
                this.context.processEncodedText(((OMString)next).getBytes());
            } else {
                throw new IOException("Unknown type in array for TJ operation:" + next);
            }
            ++i;
        }
    }
}

