/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util.operator;

import com.plpdf.om.OMBase;
import com.plpdf.smmodel.graphics.color.SMCalRGB;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.smmodel.graphics.color.SMDeviceGray;
import com.plpdf.smmodel.graphics.color.SMDeviceN;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.graphics.color.SMICCBased;
import com.plpdf.smmodel.graphics.color.SMIndexed;
import com.plpdf.smmodel.graphics.color.SMLab;
import com.plpdf.smmodel.graphics.color.SMPattern;
import com.plpdf.smmodel.graphics.color.SMSeparation;
import com.plpdf.util.PDFOperator;
import com.plpdf.util.operator.OperatorProcessor;
import com.plpdf.util.operator.SetStrokingCMYKColor;
import com.plpdf.util.operator.SetStrokingCalRGBColor;
import com.plpdf.util.operator.SetStrokingDeviceN;
import com.plpdf.util.operator.SetStrokingGrayColor;
import com.plpdf.util.operator.SetStrokingICCBasedColor;
import com.plpdf.util.operator.SetStrokingIndexed;
import com.plpdf.util.operator.SetStrokingLabColor;
import com.plpdf.util.operator.SetStrokingPattern;
import com.plpdf.util.operator.SetStrokingRGBColor;
import com.plpdf.util.operator.SetStrokingSeparation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStrokingColor
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<OMBase> arguments) throws Exception {
        SMColorSpace colorSpace = this.context.getGraphicsState().getStrokingColor().getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof SMDeviceGray) {
                newOperator = new SetStrokingGrayColor();
            } else if (colorSpace instanceof SMDeviceRGB) {
                newOperator = new SetStrokingRGBColor();
            } else if (colorSpace instanceof SMDeviceCMYK) {
                newOperator = new SetStrokingCMYKColor();
            } else if (colorSpace instanceof SMICCBased) {
                newOperator = new SetStrokingICCBasedColor();
            } else if (colorSpace instanceof SMCalRGB) {
                newOperator = new SetStrokingCalRGBColor();
            } else if (colorSpace instanceof SMSeparation) {
                newOperator = new SetStrokingSeparation();
            } else if (colorSpace instanceof SMDeviceN) {
                newOperator = new SetStrokingDeviceN();
            } else if (colorSpace instanceof SMPattern) {
                newOperator = new SetStrokingPattern();
            } else if (colorSpace instanceof SMIndexed) {
                newOperator = new SetStrokingIndexed();
            } else if (colorSpace instanceof SMLab) {
                newOperator = new SetStrokingLabColor();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, arguments);
            }
        }
    }
}

