/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util.operator;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import com.plpdf.smmodel.graphics.color.SMColorState;
import com.plpdf.smmodel.graphics.color.SMDeviceCMYK;
import com.plpdf.util.PDFOperator;
import com.plpdf.util.operator.OperatorProcessor;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNonStrokingColorSpace
extends OperatorProcessor {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    @Override
    public void process(PDFOperator operator, List<OMBase> arguments) throws IOException {
        OMName name = (OMName)arguments.get(0);
        SMColorSpace cs = SMColorSpaceFactory.createColorSpace(name, this.context.getColorSpaces(), this.context.getResources().getPatterns());
        SMColorState colorInstance = this.context.getGraphicsState().getNonStrokingColor();
        colorInstance.setColorSpace(cs);
        int numComponents = cs.getNumberOfComponents();
        float[] values = EMPTY_FLOAT_ARRAY;
        if (numComponents >= 0) {
            values = new float[numComponents];
            int i = 0;
            while (i < numComponents) {
                values[i] = 0.0f;
                ++i;
            }
            if (cs instanceof SMDeviceCMYK) {
                values[3] = 1.0f;
            }
        }
        colorInstance.setColorSpaceValue(values);
    }
}

