/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMPageable;
import com.plpdf.smmodel.common.SMRectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class RenderUtil {
    private static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);

    private RenderUtil() {
    }

    private static void print(SMDocument document, PrinterJob job, boolean silent) throws PrinterException {
        if (job == null) {
            throw new PrinterException("The given printer job is null.");
        }
        job.setPageable(new SMPageable(document, job));
        if (silent || job.printDialog()) {
            job.print();
        }
    }

    public static void silentPrint(SMDocument document, PrinterJob printJob) throws PrinterException {
        RenderUtil.print(document, printJob, true);
    }

    public static void print(SMDocument document, PrinterJob printJob) throws PrinterException {
        RenderUtil.print(document, printJob, false);
    }

    public static void print(SMDocument document) throws PrinterException {
        RenderUtil.print(document, PrinterJob.getPrinterJob());
    }

    public static void silentPrint(SMDocument document) throws PrinterException {
        RenderUtil.silentPrint(document, PrinterJob.getPrinterJob());
    }

    public static BufferedImage convertToImage(SMPage page) throws Exception {
        return RenderUtil.convertToImage(page, 8, 144);
    }

    public static BufferedImage convertToImage(SMPage page, int imageType, int resolution) throws Exception {
        SMRectangle cropBox = page.findCropBox();
        float widthPt = cropBox.getWidth();
        float heightPt = cropBox.getHeight();
        float scale = (float)resolution / 72.0f;
        int widthPx = Math.round(widthPt * scale);
        int heightPx = Math.round(heightPt * scale);
        BufferedImage retval = null;
        int rotationAngle = page.findRotation();
        if (rotationAngle < 0) {
            rotationAngle += 360;
        } else if (rotationAngle >= 360) {
            rotationAngle -= 360;
        }
        retval = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, imageType) : new BufferedImage(widthPx, heightPx, imageType);
        Graphics2D graphics2D = (Graphics2D)retval.getGraphics();
        RenderUtil.renderPage(page, graphics2D, retval.getWidth(), retval.getHeight(), scale, scale);
        graphics2D.dispose();
        return retval;
    }

    private static void renderPage(SMPage page, Graphics2D graphics, int width, int height, float scaleX, float scaleY) throws Exception {
        graphics.setBackground(TRANSPARENT_WHITE);
        graphics.clearRect(0, 0, width, height);
        int rotationAngle = page.findRotation();
        if (rotationAngle != 0) {
            int translateX = 0;
            int translateY = 0;
            switch (rotationAngle) {
                case 90: {
                    translateX = width;
                    break;
                }
                case 270: {
                    translateY = height;
                    break;
                }
                case 180: {
                    translateX = width;
                    translateY = height;
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
        graphics.scale(scaleX, scaleY);
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(graphics, page, page.findCropBox().createDimension());
        drawer.dispose();
    }
}

