/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import java.io.IOException;
import java.util.List;

public class PageExtractor {
    protected SMDocument sourceDocument;
    protected int startPage = 1;
    protected int endPage = 0;

    public PageExtractor(SMDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
        this.endPage = sourceDocument.getNumberOfPages();
    }

    public PageExtractor(SMDocument sourceDocument, int startPage, int endPage) {
        this(sourceDocument);
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public SMDocument extract() throws IOException {
        SMDocument extractedDocument = new SMDocument();
        extractedDocument.setDocumentInformation(this.sourceDocument.getDocumentInformation());
        extractedDocument.getDocumentCatalog().setViewerPreferences(this.sourceDocument.getDocumentCatalog().getViewerPreferences());
        List pages = this.sourceDocument.getDocumentCatalog().getAllPages();
        int pageCounter = 1;
        for (SMPage page : pages) {
            if (pageCounter >= this.startPage && pageCounter <= this.endPage) {
                SMPage imported = extractedDocument.importPage(page);
                imported.setCropBox(page.findCropBox());
                imported.setMediaBox(page.findMediaBox());
                imported.setResources(page.findResources());
                imported.setRotation(page.findRotation());
            }
            ++pageCounter;
        }
        return extractedDocument;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }
}

