/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.util.PDFTextStripper;
import com.plpdf.util.TextPosition;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFTextStripperByArea
extends PDFTextStripper {
    private List<String> regions = new ArrayList<String>();
    private Map<String, Rectangle2D> regionArea = new HashMap<String, Rectangle2D>();
    private Map<String, Vector<ArrayList<TextPosition>>> regionCharacterList = new HashMap<String, Vector<ArrayList<TextPosition>>>();
    private Map<String, StringWriter> regionText = new HashMap<String, StringWriter>();

    public PDFTextStripperByArea() throws IOException, PlpdfException {
        this.setPageSeparator("");
    }

    public PDFTextStripperByArea(Properties props) throws IOException, PlpdfException {
        super(props);
        this.setPageSeparator("");
    }

    public PDFTextStripperByArea(String encoding) throws IOException, PlpdfException {
        super(encoding);
        this.setPageSeparator("");
    }

    public void addRegion(String regionName, Rectangle2D rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(SMPage page) throws Exception {
        Iterator<String> regionIter = this.regions.iterator();
        while (regionIter.hasNext()) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            String regionName = regionIter.next();
            Vector regionCharactersByArticle = new Vector();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        SMStream contentStream = page.getContents();
        if (contentStream != null) {
            OMStream contents = contentStream.getStream();
            this.processPage(page, page.findResources(), contents);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        for (String region : this.regionArea.keySet()) {
            Rectangle2D rect = this.regionArea.get(region);
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = this.regionCharacterList.get(region);
            super.processTextPosition(text);
        }
    }

    @Override
    protected void writePage() throws IOException {
        for (String region : this.regionArea.keySet()) {
            this.charactersByArticle = this.regionCharacterList.get(region);
            this.output = this.regionText.get(region);
            super.writePage();
        }
    }
}

