/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.InvalidPasswordException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.exceptions.WrappedIOException;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMOutlineItem;
import com.plpdf.smmodel.interactive.pagenavigation.SMThreadBead;
import com.plpdf.util.PDFStreamEngine;
import com.plpdf.util.PositionWrapper;
import com.plpdf.util.ResourceLoader;
import com.plpdf.util.TextNormalize;
import com.plpdf.util.TextPosition;
import com.plpdf.util.TextPositionComparator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFTextStripper
extends PDFStreamEngine {
    private static final String thisClassName;
    private static float DEFAULT_INDENT_THRESHOLD;
    private static float DEFAULT_DROP_THRESHOLD;
    protected final String systemLineSeparator;
    private String lineSeparator;
    private String pageSeparator;
    private String wordSeparator;
    private String paragraphStart;
    private String paragraphEnd;
    private String pageStart;
    private String pageEnd;
    private String articleStart;
    private String articleEnd;
    private int currentPageNo;
    private int startPage;
    private int endPage;
    private SMOutlineItem startBookmark;
    private int startBookmarkPageNumber;
    private SMOutlineItem endBookmark;
    private int endBookmarkPageNumber;
    private boolean suppressDuplicateOverlappingText;
    private boolean shouldSeparateByBeads;
    private boolean sortByPosition;
    private boolean addMoreFormatting;
    private float indentThreshold;
    private float dropThreshold;
    private float spacingTolerance;
    private float averageCharTolerance;
    private List<SMThreadBead> pageArticles;
    protected Vector<List<TextPosition>> charactersByArticle;
    private Map<String, TreeMap<Float, TreeSet<Float>>> characterListMapping;
    protected String outputEncoding;
    protected SMDocument document;
    protected Writer output;
    private TextNormalize normalize;
    private boolean inParagraph;
    private static final float ENDOFLASTTEXTX_RESET_VALUE = -1.0f;
    private static final float MAXYFORLINE_RESET_VALUE = -3.4028235E38f;
    private static final float EXPECTEDSTARTOFNEXTWORDX_RESET_VALUE = -3.4028235E38f;
    private static final float MAXHEIGHTFORLINE_RESET_VALUE = -1.0f;
    private static final float MINYTOPFORLINE_RESET_VALUE = Float.MAX_VALUE;
    private static final float LASTWORDSPACING_RESET_VALUE = -1.0f;
    private static final String[] LIST_ITEM_EXPRESSIONS;
    private List<Pattern> listOfPatterns;

    static {
        float f2;
        thisClassName = PDFTextStripper.class.getSimpleName().toLowerCase();
        DEFAULT_INDENT_THRESHOLD = 2.0f;
        DEFAULT_DROP_THRESHOLD = 2.5f;
        String prop = String.valueOf(thisClassName) + ".indent";
        String s = System.getProperty(prop);
        if (s != null && s.length() > 0) {
            try {
                DEFAULT_INDENT_THRESHOLD = f2 = Float.parseFloat(s);
            }
            catch (NumberFormatException f2) {
                // empty catch block
            }
        }
        if ((s = System.getProperty(prop = String.valueOf(thisClassName) + ".drop")) != null && s.length() > 0) {
            try {
                DEFAULT_DROP_THRESHOLD = f2 = Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LIST_ITEM_EXPRESSIONS = new String[]{"\\.", "\\d+\\.", "\\[\\d+\\]", "\\d+\\)", "[A-Z]\\.", "[a-z]\\.", "[A-Z]\\)", "[a-z]\\)", "[IVXL]+\\.", "[ivxl]+\\."};
    }

    public PDFTextStripper() throws IOException, PlpdfException {
        super(ResourceLoader.loadProperties("com/plpdf/res/PDFTextStripper.properties", true));
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, TreeMap<Float, TreeSet<Float>>>();
        this.normalize = null;
        this.listOfPatterns = null;
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFTextStripper(Properties props) throws IOException, PlpdfException {
        super(props);
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, TreeMap<Float, TreeSet<Float>>>();
        this.normalize = null;
        this.listOfPatterns = null;
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFTextStripper(String encoding) throws IOException, PlpdfException {
        super(ResourceLoader.loadProperties("com/plpdf/res/PDFTextStripper.properties", true));
        this.lineSeparator = this.systemLineSeparator = System.getProperty("line.separator");
        this.pageSeparator = this.systemLineSeparator;
        this.wordSeparator = " ";
        this.paragraphStart = "";
        this.paragraphEnd = "";
        this.pageStart = "";
        this.pageEnd = this.pageSeparator;
        this.articleStart = "";
        this.articleEnd = "";
        this.currentPageNo = 0;
        this.startPage = 1;
        this.endPage = Integer.MAX_VALUE;
        this.startBookmark = null;
        this.startBookmarkPageNumber = -1;
        this.endBookmark = null;
        this.endBookmarkPageNumber = -1;
        this.suppressDuplicateOverlappingText = true;
        this.shouldSeparateByBeads = true;
        this.sortByPosition = false;
        this.addMoreFormatting = false;
        this.indentThreshold = DEFAULT_INDENT_THRESHOLD;
        this.dropThreshold = DEFAULT_DROP_THRESHOLD;
        this.spacingTolerance = 0.5f;
        this.averageCharTolerance = 0.3f;
        this.pageArticles = null;
        this.charactersByArticle = new Vector();
        this.characterListMapping = new HashMap<String, TreeMap<Float, TreeSet<Float>>>();
        this.normalize = null;
        this.listOfPatterns = null;
        this.outputEncoding = encoding;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public String getText(SMDocument doc) throws Exception {
        StringWriter outputStream = new StringWriter();
        this.writeText(doc, (Writer)outputStream);
        return outputStream.toString();
    }

    public String getText(OMDocument doc) throws Exception {
        return this.getText(new SMDocument(doc));
    }

    public void writeText(OMDocument doc, Writer outputStream) throws Exception {
        this.writeText(new SMDocument(doc), outputStream);
    }

    @Override
    public void resetEngine() {
        super.resetEngine();
        this.currentPageNo = 0;
    }

    public void writeText(SMDocument doc, Writer outputStream) throws Exception {
        this.resetEngine();
        this.document = doc;
        this.output = outputStream;
        if (this.getAddMoreFormatting()) {
            this.paragraphEnd = this.lineSeparator;
            this.pageStart = this.lineSeparator;
            this.articleStart = this.lineSeparator;
            this.articleEnd = this.lineSeparator;
        }
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new WrappedIOException("Error decrypting document, details: ", e);
            }
            catch (InvalidPasswordException e) {
                throw new WrappedIOException("Error: document is encrypted", e);
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    public void writeFormXObjectText(SMDocument doc, Writer outputStream) throws Exception {
        this.resetEngine();
        this.document = doc;
        this.output = outputStream;
        if (this.getAddMoreFormatting()) {
            this.paragraphEnd = this.lineSeparator;
            this.pageStart = this.lineSeparator;
            this.articleStart = this.lineSeparator;
            this.articleEnd = this.lineSeparator;
        }
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new WrappedIOException("Error decrypting document, details: ", e);
            }
            catch (InvalidPasswordException e) {
                throw new WrappedIOException("Error: document is encrypted", e);
            }
        }
        this.processFormXObjects(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    protected void processPages(List<OMObjectable> pages) throws Exception {
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getOMObject() == this.endBookmark.getOMObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        for (SMPage sMPage : pages) {
            SMStream contentStream = sMPage.getContents();
            ++this.currentPageNo;
            if (contentStream == null) continue;
            OMStream contents = contentStream.getStream();
            this.processPage(sMPage, sMPage.findResources(), contents);
        }
    }

    protected void processFormXObjects(List<OMObjectable> pages) throws Exception {
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getOMObject() == this.endBookmark.getOMObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        for (SMPage sMPage : pages) {
            SMResources resources = sMPage.getResources();
            ++this.currentPageNo;
            Map<String, SMXObject> xobjects = resources.getXObjects();
            if (xobjects == null) continue;
            for (String key : xobjects.keySet()) {
                SMStream contentStream;
                SMXObject xobject = xobjects.get(key);
                OMDictionary omObject = (OMDictionary)xobject.getOMObject();
                String subtype = omObject.getNameAsString("Subtype");
                if (subtype == null || !subtype.equals("Form") || (contentStream = xobject.getSMStream()) == null) continue;
                OMStream contents = contentStream.getStream();
                this.processPage(sMPage, xobject.getResources(), contents);
            }
        }
    }

    private int getPageNumber(SMOutlineItem bookmark, List<OMObjectable> allPages) throws IOException {
        int pageNumber = -1;
        SMPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected void startDocument(SMDocument pdf) throws IOException {
    }

    protected void endDocument(SMDocument pdf) throws IOException {
    }

    protected void processPage(SMPage page, SMResources resources, OMStream content) throws Exception {
        if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
            this.startPage(page);
            this.pageArticles = page.getThreadBeads();
            int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
            if (!this.shouldSeparateByBeads) {
                numberOfArticleSections = 1;
            }
            int originalSize = this.charactersByArticle.size();
            this.charactersByArticle.setSize(numberOfArticleSections);
            int i = 0;
            while (i < numberOfArticleSections) {
                if (numberOfArticleSections < originalSize) {
                    this.charactersByArticle.get(i).clear();
                } else {
                    this.charactersByArticle.set(i, new ArrayList());
                }
                ++i;
            }
            this.characterListMapping.clear();
            this.processStream(page, resources, content);
            this.writePage();
            this.endPage(page);
        }
    }

    protected void startArticle() throws IOException {
        this.startArticle(true);
    }

    protected void startArticle(boolean isltr) throws IOException {
        this.output.write(this.getArticleStart());
    }

    protected void endArticle() throws IOException {
        this.output.write(this.getArticleEnd());
    }

    protected void startPage(SMPage page) throws IOException {
    }

    protected void endPage(SMPage page) throws IOException {
    }

    protected void writePage() throws IOException {
        float maxYForLine = -3.4028235E38f;
        float minYTopForLine = Float.MAX_VALUE;
        float endOfLastTextX = -1.0f;
        float lastWordSpacing = -1.0f;
        float maxHeightForLine = -1.0f;
        PositionWrapper lastPosition = null;
        PositionWrapper lastLineStartPosition = null;
        boolean startOfPage = true;
        boolean startOfArticle = true;
        if (this.charactersByArticle.size() > 0) {
            this.writePageStart();
        }
        int i = 0;
        while (i < this.charactersByArticle.size()) {
            List<TextPosition> textList = this.charactersByArticle.get(i);
            if (this.getSortByPosition()) {
                TextPositionComparator comparator = new TextPositionComparator();
                Collections.sort(textList, comparator);
            }
            Iterator<TextPosition> textIter = textList.iterator();
            int ltrCnt = 0;
            int rtlCnt = 0;
            while (textIter.hasNext()) {
                TextPosition position = textIter.next();
                String stringValue = position.getCharacter();
                int a = 0;
                while (a < stringValue.length()) {
                    byte dir = Character.getDirectionality(stringValue.charAt(a));
                    if (dir == 0 || dir == 14 || dir == 15) {
                        ++ltrCnt;
                    } else if (dir == 1 || dir == 2 || dir == 16 || dir == 17) {
                        ++rtlCnt;
                    }
                    ++a;
                }
            }
            boolean isRtlDominant = rtlCnt > ltrCnt;
            this.startArticle(!isRtlDominant);
            startOfArticle = true;
            boolean hasRtl = rtlCnt > 0;
            ArrayList<TextPosition> line = new ArrayList<TextPosition>();
            textIter = textList.iterator();
            float previousAveCharWidth = -1.0f;
            while (textIter.hasNext()) {
                float positionHeight;
                float positionWidth;
                float positionY;
                float positionX;
                TextPosition position = textIter.next();
                PositionWrapper current = new PositionWrapper(position);
                String characterValue = position.getCharacter();
                if (lastPosition != null && (position.getFont() != lastPosition.getTextPosition().getFont() || position.getFontSize() != lastPosition.getTextPosition().getFontSize())) {
                    previousAveCharWidth = -1.0f;
                }
                if (this.getSortByPosition()) {
                    positionX = position.getXDirAdj();
                    positionY = position.getYDirAdj();
                    positionWidth = position.getWidthDirAdj();
                    positionHeight = position.getHeightDir();
                } else {
                    positionX = position.getX();
                    positionY = position.getY();
                    positionWidth = position.getWidth();
                    positionHeight = position.getHeight();
                }
                int wordCharCount = position.getIndividualWidths().length;
                float wordSpacing = position.getWidthOfSpace();
                float deltaSpace = 0.0f;
                deltaSpace = wordSpacing == 0.0f || wordSpacing == Float.NaN ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * this.getSpacingTolerance() : (wordSpacing + lastWordSpacing) / 2.0f * this.getSpacingTolerance());
                float averageCharWidth = -1.0f;
                averageCharWidth = previousAveCharWidth < 0.0f ? positionWidth / (float)wordCharCount : (previousAveCharWidth + positionWidth / (float)wordCharCount) / 2.0f;
                float deltaCharWidth = averageCharWidth * this.getAverageCharTolerance();
                float expectedStartOfNextWordX = -3.4028235E38f;
                if (endOfLastTextX != -1.0f) {
                    expectedStartOfNextWordX = deltaCharWidth > deltaSpace ? endOfLastTextX + deltaSpace : endOfLastTextX + deltaCharWidth;
                }
                if (lastPosition != null) {
                    if (startOfArticle) {
                        lastPosition.setArticleStart();
                        startOfArticle = false;
                    }
                    if (!this.overlap(positionY, positionHeight, maxYForLine, maxHeightForLine)) {
                        this.writeLine(this.normalize(line, isRtlDominant, hasRtl), isRtlDominant);
                        line.clear();
                        lastLineStartPosition = this.handleLineSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine);
                        endOfLastTextX = -1.0f;
                        expectedStartOfNextWordX = -3.4028235E38f;
                        maxYForLine = -3.4028235E38f;
                        maxHeightForLine = -1.0f;
                        minYTopForLine = Float.MAX_VALUE;
                    }
                    if (expectedStartOfNextWordX != -3.4028235E38f && expectedStartOfNextWordX < positionX && lastPosition.getTextPosition().getCharacter() != null && !lastPosition.getTextPosition().getCharacter().endsWith(" ")) {
                        line.add(WordSeparator.getSeparator());
                    }
                }
                if (positionY >= maxYForLine) {
                    maxYForLine = positionY;
                }
                endOfLastTextX = positionX + positionWidth;
                if (characterValue != null) {
                    if (startOfPage && lastPosition == null) {
                        this.writeParagraphStart();
                    }
                    line.add(position);
                }
                maxHeightForLine = Math.max(maxHeightForLine, positionHeight);
                minYTopForLine = Math.min(minYTopForLine, positionY - positionHeight);
                lastPosition = current;
                if (startOfPage) {
                    lastPosition.setParagraphStart();
                    lastPosition.setLineStart();
                    lastLineStartPosition = lastPosition;
                    startOfPage = false;
                }
                lastWordSpacing = wordSpacing;
                previousAveCharWidth = averageCharWidth;
            }
            if (line.size() > 0) {
                this.writeLine(this.normalize(line, isRtlDominant, hasRtl), isRtlDominant);
                this.writeParagraphEnd();
            }
            this.endArticle();
            ++i;
        }
        this.writePageEnd();
    }

    private boolean overlap(float y1, float height1, float y2, float height2) {
        return this.within(y1, y2, 0.1f) || y2 <= y1 && y2 >= y1 - height1 || y1 <= y2 && y1 >= y2 - height2;
    }

    protected void writePageSeperator() throws IOException {
        this.output.write(this.getPageSeparator());
        this.output.flush();
    }

    protected void writeLineSeparator() throws IOException {
        this.output.write(this.getLineSeparator());
    }

    protected void writeWordSeparator() throws IOException {
        this.output.write(this.getWordSeparator());
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        this.output.write(text.getCharacter());
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        this.writeString(text);
    }

    protected void writeString(String text) throws IOException {
        this.output.write(text);
    }

    private boolean within(float first, float second, float variance) {
        return second < first + variance && second > first - variance;
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            TreeMap<Float, TreeSet<Float>> sameTextCharacters = this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new TreeMap();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            SortedMap<Float, TreeSet<Float>> xMatches = sameTextCharacters.subMap(Float.valueOf(textX - tolerance), Float.valueOf(textX + tolerance));
            for (TreeSet<Float> xMatch : xMatches.values()) {
                SortedSet<Float> yMatches = xMatch.subSet(Float.valueOf(textY - tolerance), Float.valueOf(textY + tolerance));
                if (yMatches.isEmpty()) continue;
                suppressCharacter = true;
                break;
            }
            if (!suppressCharacter) {
                TreeSet<Float> ySet = sameTextCharacters.get(Float.valueOf(textX));
                if (ySet == null) {
                    ySet = new TreeSet();
                    sameTextCharacters.put(Float.valueOf(textX), ySet);
                }
                ySet.add(Float.valueOf(textY));
                showCharacter = true;
            }
        }
        if (showCharacter) {
            int foundArticleDivisionIndex = -1;
            int notFoundButFirstLeftAndAboveArticleDivisionIndex = -1;
            int notFoundButFirstLeftArticleDivisionIndex = -1;
            int notFoundButFirstAboveArticleDivisionIndex = -1;
            float x = text.getX();
            float y = text.getY();
            if (this.shouldSeparateByBeads) {
                int i = 0;
                while (i < this.pageArticles.size() && foundArticleDivisionIndex == -1) {
                    SMThreadBead bead = this.pageArticles.get(i);
                    if (bead != null) {
                        SMRectangle rect = bead.getRectangle();
                        if (rect.contains(x, y)) {
                            foundArticleDivisionIndex = i * 2 + 1;
                        } else if ((x < rect.getLowerLeftX() || y < rect.getUpperRightY()) && notFoundButFirstLeftAndAboveArticleDivisionIndex == -1) {
                            notFoundButFirstLeftAndAboveArticleDivisionIndex = i * 2;
                        } else if (x < rect.getLowerLeftX() && notFoundButFirstLeftArticleDivisionIndex == -1) {
                            notFoundButFirstLeftArticleDivisionIndex = i * 2;
                        } else if (y < rect.getUpperRightY() && notFoundButFirstAboveArticleDivisionIndex == -1) {
                            notFoundButFirstAboveArticleDivisionIndex = i * 2;
                        }
                    } else {
                        foundArticleDivisionIndex = 0;
                    }
                    ++i;
                }
            } else {
                foundArticleDivisionIndex = 0;
            }
            int articleDivisionIndex = -1;
            articleDivisionIndex = foundArticleDivisionIndex != -1 ? foundArticleDivisionIndex : (notFoundButFirstLeftAndAboveArticleDivisionIndex != -1 ? notFoundButFirstLeftAndAboveArticleDivisionIndex : (notFoundButFirstLeftArticleDivisionIndex != -1 ? notFoundButFirstLeftArticleDivisionIndex : (notFoundButFirstAboveArticleDivisionIndex != -1 ? notFoundButFirstAboveArticleDivisionIndex : this.charactersByArticle.size() - 1)));
            List<TextPosition> textList = this.charactersByArticle.get(articleDivisionIndex);
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains(text)) {
                    previousTextPosition.mergeDiacritic(text, this.normalize);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition, this.normalize);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
        }
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String separator) {
        this.wordSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    protected int getCurrentPageNo() {
        return this.currentPageNo;
    }

    protected Writer getOutput() {
        return this.output;
    }

    protected Vector<List<TextPosition>> getCharactersByArticle() {
        return this.charactersByArticle;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingTextValue) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingTextValue;
    }

    public boolean getSeparateByBeads() {
        return this.shouldSeparateByBeads;
    }

    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
        this.shouldSeparateByBeads = aShouldSeparateByBeads;
    }

    public SMOutlineItem getEndBookmark() {
        return this.endBookmark;
    }

    public void setEndBookmark(SMOutlineItem aEndBookmark) {
        this.endBookmark = aEndBookmark;
    }

    public SMOutlineItem getStartBookmark() {
        return this.startBookmark;
    }

    public void setStartBookmark(SMOutlineItem aStartBookmark) {
        this.startBookmark = aStartBookmark;
    }

    public boolean getAddMoreFormatting() {
        return this.addMoreFormatting;
    }

    public void setAddMoreFormatting(boolean newAddMoreFormatting) {
        this.addMoreFormatting = newAddMoreFormatting;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean newSortByPosition) {
        this.sortByPosition = newSortByPosition;
    }

    public float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(float spacingToleranceValue) {
        this.spacingTolerance = spacingToleranceValue;
    }

    public float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(float averageCharToleranceValue) {
        this.averageCharTolerance = averageCharToleranceValue;
    }

    public float getIndentThreshold() {
        return this.indentThreshold;
    }

    public void setIndentThreshold(float indentThresholdValue) {
        this.indentThreshold = indentThresholdValue;
    }

    public float getDropThreshold() {
        return this.dropThreshold;
    }

    public void setDropThreshold(float dropThresholdValue) {
        this.dropThreshold = dropThresholdValue;
    }

    public String getParagraphStart() {
        return this.paragraphStart;
    }

    public void setParagraphStart(String s) {
        this.paragraphStart = s;
    }

    public String getParagraphEnd() {
        return this.paragraphEnd;
    }

    public void setParagraphEnd(String s) {
        this.paragraphEnd = s;
    }

    public String getPageStart() {
        return this.pageStart;
    }

    public void setPageStart(String pageStartValue) {
        this.pageStart = pageStartValue;
    }

    public String getPageEnd() {
        return this.pageEnd;
    }

    public void setPageEnd(String pageEndValue) {
        this.pageEnd = pageEndValue;
    }

    public String getArticleStart() {
        return this.articleStart;
    }

    public void setArticleStart(String articleStartValue) {
        this.articleStart = articleStartValue;
    }

    public String getArticleEnd() {
        return this.articleEnd;
    }

    public void setArticleEnd(String articleEndValue) {
        this.articleEnd = articleEndValue;
    }

    @Override
    public String inspectFontEncoding(String str) {
        if (!this.sortByPosition || str == null || str.length() < 2) {
            return str;
        }
        int i = 0;
        while (i < str.length()) {
            if (Character.getDirectionality(str.charAt(i)) != 2) {
                return str;
            }
            ++i;
        }
        StringBuilder reversed = new StringBuilder(str.length());
        int i2 = str.length() - 1;
        while (i2 >= 0) {
            reversed.append(str.charAt(i2));
            --i2;
        }
        return reversed.toString();
    }

    protected PositionWrapper handleLineSeparation(PositionWrapper current, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine) throws IOException {
        current.setLineStart();
        this.isParagraphSeparation(current, lastPosition, lastLineStartPosition, maxHeightForLine);
        lastLineStartPosition = current;
        if (current.isParagraphStart()) {
            if (lastPosition.isArticleStart()) {
                this.writeParagraphStart();
            } else {
                this.writeLineSeparator();
                this.writeParagraphSeparator();
            }
        } else {
            this.writeLineSeparator();
        }
        return lastLineStartPosition;
    }

    protected void isParagraphSeparation(PositionWrapper position, PositionWrapper lastPosition, PositionWrapper lastLineStartPosition, float maxHeightForLine) {
        boolean result = false;
        if (lastLineStartPosition == null) {
            result = true;
        } else {
            float yGap = Math.abs(position.getTextPosition().getYDirAdj() - lastPosition.getTextPosition().getYDirAdj());
            float xGap = position.getTextPosition().getXDirAdj() - lastLineStartPosition.getTextPosition().getXDirAdj();
            if (yGap > this.getDropThreshold() * maxHeightForLine) {
                result = true;
            } else if (xGap > this.getIndentThreshold() * position.getTextPosition().getWidthOfSpace()) {
                if (!lastLineStartPosition.isParagraphStart()) {
                    result = true;
                } else {
                    position.setHangingIndent();
                }
            } else if (xGap < -position.getTextPosition().getWidthOfSpace()) {
                if (!lastLineStartPosition.isParagraphStart()) {
                    result = true;
                }
            } else if ((double)Math.abs(xGap) < 0.25 * (double)position.getTextPosition().getWidth()) {
                Pattern currentPattern;
                Pattern liPattern;
                if (lastLineStartPosition.isHangingIndent()) {
                    position.setHangingIndent();
                } else if (lastLineStartPosition.isParagraphStart() && (liPattern = this.matchListItemPattern(lastLineStartPosition)) != null && liPattern == (currentPattern = this.matchListItemPattern(position))) {
                    result = true;
                }
            }
        }
        if (result) {
            position.setParagraphStart();
        }
    }

    protected void writeParagraphSeparator() throws IOException {
        this.writeParagraphEnd();
        this.writeParagraphStart();
    }

    protected void writeParagraphStart() throws IOException {
        if (this.inParagraph) {
            this.writeParagraphEnd();
            this.inParagraph = false;
        }
        this.output.write(this.getParagraphStart());
        this.inParagraph = true;
    }

    protected void writeParagraphEnd() throws IOException {
        this.output.write(this.getParagraphEnd());
        this.inParagraph = false;
    }

    protected void writePageStart() throws IOException {
        this.output.write(this.getPageStart());
    }

    protected void writePageEnd() throws IOException {
        this.output.write(this.getPageEnd());
    }

    protected Pattern matchListItemPattern(PositionWrapper pw) {
        TextPosition tp = pw.getTextPosition();
        String txt = tp.getCharacter();
        return PDFTextStripper.matchPattern(txt, this.getListItemPatterns());
    }

    protected void setListItemPatterns(List<Pattern> patterns) {
        this.listOfPatterns = patterns;
    }

    protected List<Pattern> getListItemPatterns() {
        if (this.listOfPatterns == null) {
            this.listOfPatterns = new ArrayList<Pattern>();
            String[] stringArray = LIST_ITEM_EXPRESSIONS;
            int n = LIST_ITEM_EXPRESSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String expression = stringArray[n2];
                Pattern p = Pattern.compile(expression);
                this.listOfPatterns.add(p);
                ++n2;
            }
        }
        return this.listOfPatterns;
    }

    protected static final Pattern matchPattern(String string, List<Pattern> patterns) {
        Pattern matchedPattern = null;
        for (Pattern p : patterns) {
            if (!p.matcher(string).matches()) continue;
            return p;
        }
        return matchedPattern;
    }

    private void writeLine(List<WordWithTextPositions> line, boolean isRtlDominant) throws IOException {
        int numberOfStrings = line.size();
        int i = 0;
        while (i < numberOfStrings) {
            WordWithTextPositions word = line.get(i);
            this.writeString(word.getText(), word.getTextPositions());
            if (i < numberOfStrings - 1) {
                this.writeWordSeparator();
            }
            ++i;
        }
    }

    private List<WordWithTextPositions> normalize(List<TextPosition> line, boolean isRtlDominant, boolean hasRtl) {
        LinkedList<WordWithTextPositions> normalized = new LinkedList<WordWithTextPositions>();
        StringBuilder lineBuilder = new StringBuilder();
        ArrayList<TextPosition> wordPositions = new ArrayList<TextPosition>();
        if (isRtlDominant) {
            int numberOfPositions = line.size();
            int i = numberOfPositions - 1;
            while (i >= 0) {
                lineBuilder = this.normalizeAdd(normalized, lineBuilder, wordPositions, line.get(i));
                --i;
            }
        } else {
            for (TextPosition text : line) {
                lineBuilder = this.normalizeAdd(normalized, lineBuilder, wordPositions, text);
            }
        }
        if (lineBuilder.length() > 0) {
            normalized.add(this.createWord(lineBuilder.toString(), wordPositions));
        }
        return normalized;
    }

    private WordWithTextPositions createWord(String word, List<TextPosition> wordPositions) {
        return new WordWithTextPositions(this.normalize.normalizePres(word), wordPositions);
    }

    private StringBuilder normalizeAdd(LinkedList<WordWithTextPositions> normalized, StringBuilder lineBuilder, List<TextPosition> wordPositions, TextPosition text) {
        if (text instanceof WordSeparator) {
            normalized.add(this.createWord(lineBuilder.toString(), wordPositions));
            lineBuilder = new StringBuilder();
            wordPositions.clear();
        } else {
            lineBuilder.append(text.getCharacter());
            wordPositions.add(text);
        }
        return lineBuilder;
    }

    private static final class WordSeparator
    extends TextPosition {
        private static final WordSeparator separator = new WordSeparator();

        private WordSeparator() {
        }

        public static final WordSeparator getSeparator() {
            return separator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WordWithTextPositions {
        protected String text;
        protected List<TextPosition> textPositions;

        public WordWithTextPositions(String word, List<TextPosition> positions) {
            this.text = word;
            this.textPositions = positions;
        }

        public String getText() {
            return this.text;
        }

        public List<TextPosition> getTextPositions() {
            return this.textPositions;
        }
    }
}

