/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.smmodel.SMDocumentNameDictionary;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMPageNode;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMNumberTreeNode;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMMarkInfo;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureTreeRoot;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMDocumentOutline;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMOutlineItem;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMFieldFactory;
import com.plpdf.util.PDFCloneUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMergerUtility {
    private static final String CLASS_NAME = PDFMergerUtility.class.getName();
    private static final String STRUCTURETYPE_DOCUMENT = "Document";
    private List<InputStream> sources = new ArrayList<InputStream>();
    private String destinationFileName;
    private OutputStream destinationStream;
    private int nextFieldNum = 1;

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public void setDestinationStream(OutputStream destStream) {
        this.destinationStream = destStream;
    }

    public void addSource(String source) {
        try {
            this.sources.add(new FileInputStream(new File(source)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(File source) {
        try {
            this.sources.add(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(InputStream source) {
        this.sources.add(source);
    }

    public void addSources(List<InputStream> sourcesList) {
        this.sources.addAll(sourcesList);
    }

    /*
     * Unable to fully structure code
     */
    public void mergeDocuments() throws Exception {
        destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            tobeclosed = new Vector<SMDocument>();
            try {
                sit = this.sources.iterator();
                sourceFile = sit.next();
                destination = SMDocument.load(sourceFile);
                while (sit.hasNext()) {
                    sourceFile = sit.next();
                    source = SMDocument.load(sourceFile);
                    tobeclosed.add(source);
                    this.appendDocument(destination, source);
                }
                if (this.destinationStream == null) {
                    destination.save(this.destinationFileName);
                }
                destination.save(this.destinationStream);
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
                ** for (doc : tobeclosed)
            }
lbl-1000:
            // 1 sources

            {
                doc.close();
                continue;
            }
        }
lbl26:
        // 3 sources

    }

    public void appendDocument(SMDocument destination, SMDocument source) throws IOException, PlpdfException {
        if (destination.isEncrypted()) {
            throw new PlpdfException(CLASS_NAME, "DestinationPDFEncrypted");
        }
        if (source.isEncrypted()) {
            throw new PlpdfException(CLASS_NAME, "SourcePDFEncrypted");
        }
        PDFMergerUtility.PagesRotateIntoPage(source);
        PDFMergerUtility.PagesRotateIntoPage(destination);
        SMDocumentInformation destInfo = destination.getDocumentInformation();
        SMDocumentInformation srcInfo = source.getDocumentInformation();
        destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
        SMDocumentCatalog destCatalog = destination.getDocumentCatalog();
        SMDocumentCatalog srcCatalog = source.getDocumentCatalog();
        float destVersion = destination.getDocument().getVersion();
        float srcVersion = source.getDocument().getVersion();
        if (destVersion < srcVersion) {
            destination.getDocument().setVersion(srcVersion);
        }
        OMDictionary srcPages = (OMDictionary)srcCatalog.getOMDictionary().getDictionaryObject(OMName.PAGES);
        OMDictionary srcResources = (OMDictionary)srcPages.getDictionaryObject(OMName.RESOURCES);
        OMDictionary destPages = (OMDictionary)destCatalog.getOMDictionary().getDictionaryObject(OMName.PAGES);
        OMDictionary destResources = (OMDictionary)destPages.getDictionaryObject(OMName.RESOURCES);
        if (srcResources != null) {
            if (destResources != null) {
                destResources.mergeInto(srcResources);
            } else {
                destPages.setItem(OMName.RESOURCES, (OMBase)srcResources);
            }
        }
        PDFCloneUtility cloner = new PDFCloneUtility(destination);
        try {
            SMAcroForm destAcroForm = destCatalog.getAcroForm();
            SMAcroForm srcAcroForm = srcCatalog.getAcroForm();
            if (destAcroForm == null) {
                cloner.cloneForNewDocument(srcAcroForm);
                destCatalog.setAcroForm(srcAcroForm);
            } else if (srcAcroForm != null) {
                this.mergeAcroForm(cloner, destAcroForm, srcAcroForm);
            }
        }
        catch (Exception e) {
            throw (IOException)e;
        }
        OMArray destThreads = (OMArray)destCatalog.getOMDictionary().getDictionaryObject(OMName.THREADS);
        OMArray srcThreads = (OMArray)cloner.cloneForNewDocument(destCatalog.getOMDictionary().getDictionaryObject(OMName.THREADS));
        if (destThreads == null) {
            destCatalog.getOMDictionary().setItem(OMName.THREADS, (OMBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        SMDocumentNameDictionary destNames = destCatalog.getNames();
        SMDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getOMDictionary().setItem(OMName.NAMES, cloner.cloneForNewDocument(srcNames));
            } else {
                cloner.cloneMerge(srcNames, destNames);
            }
        }
        SMDocumentOutline destOutline = destCatalog.getDocumentOutline();
        SMDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null) {
                SMDocumentOutline cloned = new SMDocumentOutline((OMDictionary)cloner.cloneForNewDocument(srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                SMOutlineItem first = srcOutline.getFirstChild();
                if (first != null) {
                    SMOutlineItem clonedFirst = new SMOutlineItem((OMDictionary)cloner.cloneForNewDocument(first));
                    destOutline.appendChild(clonedFirst);
                }
            }
        }
        String destPageMode = destCatalog.getPageMode();
        String srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        OMDictionary destLabels = (OMDictionary)destCatalog.getOMDictionary().getDictionaryObject(OMName.PAGE_LABELS);
        OMDictionary srcLabels = (OMDictionary)srcCatalog.getOMDictionary().getDictionaryObject(OMName.PAGE_LABELS);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            OMArray destNums = null;
            if (destLabels == null) {
                destLabels = new OMDictionary();
                destNums = new OMArray();
                destLabels.setItem(OMName.NUMS, (OMBase)destNums);
                destCatalog.getOMDictionary().setItem(OMName.PAGE_LABELS, (OMBase)destLabels);
            } else {
                destNums = (OMArray)destLabels.getDictionaryObject(OMName.NUMS);
            }
            OMArray srcNums = (OMArray)srcLabels.getDictionaryObject(OMName.NUMS);
            if (srcNums != null) {
                int i = 0;
                while (i < srcNums.size()) {
                    OMNumber labelIndex = (OMNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(OMInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(cloner.cloneForNewDocument(srcNums.getObject(i + 1)));
                    i += 2;
                }
            }
        }
        OMStream destMetadata = (OMStream)destCatalog.getOMDictionary().getDictionaryObject(OMName.METADATA);
        OMStream srcMetadata = (OMStream)srcCatalog.getOMDictionary().getDictionaryObject(OMName.METADATA);
        if (destMetadata == null && srcMetadata != null) {
            SMStream newStream = new SMStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            destCatalog.getOMDictionary().setItem(OMName.METADATA, (OMObjectable)newStream);
        }
        boolean mergeStructTree = false;
        int destParentTreeNextKey = -1;
        OMDictionary destParentTreeDict = null;
        OMDictionary srcParentTreeDict = null;
        OMArray destNumbersArray = null;
        OMArray srcNumbersArray = null;
        SMMarkInfo destMark = destCatalog.getMarkInfo();
        SMStructureTreeRoot destStructTree = destCatalog.getStructureTreeRoot();
        SMMarkInfo srcMark = srcCatalog.getMarkInfo();
        SMStructureTreeRoot srcStructTree = srcCatalog.getStructureTreeRoot();
        if (destStructTree != null) {
            SMNumberTreeNode destParentTree = destStructTree.getParentTree();
            destParentTreeNextKey = destStructTree.getParentTreeNextKey();
            if (destParentTree != null && (destNumbersArray = (OMArray)(destParentTreeDict = destParentTree.getOMDictionary()).getDictionaryObject(OMName.NUMS)) != null) {
                SMNumberTreeNode srcParentTree;
                if (destParentTreeNextKey < 0) {
                    destParentTreeNextKey = destNumbersArray.size() / 2;
                }
                if (destParentTreeNextKey > 0 && srcStructTree != null && (srcParentTree = srcStructTree.getParentTree()) != null && (srcNumbersArray = (OMArray)(srcParentTreeDict = srcParentTree.getOMDictionary()).getDictionaryObject(OMName.NUMS)) != null) {
                    mergeStructTree = true;
                }
            }
            if (destMark != null && destMark.isMarked() && !mergeStructTree) {
                destMark.setMarked(false);
            }
            if (!mergeStructTree) {
                destCatalog.setStructureTreeRoot(null);
            }
        }
        List pages = srcCatalog.getAllPages();
        Iterator pageIter = pages.iterator();
        HashMap<OMDictionary, OMDictionary> objMapping = new HashMap<OMDictionary, OMDictionary>();
        while (pageIter.hasNext()) {
            SMPage page = (SMPage)pageIter.next();
            SMPage newPage = new SMPage((OMDictionary)cloner.cloneForNewDocument(page.getOMDictionary()));
            newPage.setCropBox(page.findCropBox());
            newPage.setMediaBox(page.findMediaBox());
            newPage.setRotation(page.findRotation());
            newPage.setAnnotations(page.getAnnotations());
            List<SMAnnotation> Annots = newPage.getAnnotations();
            int i = 0;
            while (i < Annots.size()) {
                Annots.get(i).setPage(newPage);
                ++i;
            }
            if (mergeStructTree) {
                this.updateStructParentEntries(newPage, destParentTreeNextKey);
                objMapping.put(page.getOMDictionary(), newPage.getOMDictionary());
                List<SMAnnotation> oldAnnots = page.getAnnotations();
                List<SMAnnotation> newAnnots = newPage.getAnnotations();
                int i2 = 0;
                while (i2 < oldAnnots.size()) {
                    objMapping.put(oldAnnots.get(i2).getDictionary(), newAnnots.get(i2).getDictionary());
                    ++i2;
                }
            }
            destination.addPage(newPage);
        }
    }

    private void mergeAcroForm(PDFCloneUtility cloner, SMAcroForm destAcroForm, SMAcroForm srcAcroForm) throws IOException {
        List<SMField> destFields = destAcroForm.getFields();
        List<SMField> srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            if (destFields == null) {
                destFields = new OMArrayList<SMField>();
                destAcroForm.setFields(destFields);
            }
            for (SMField srcField : srcFields) {
                SMField destField = SMFieldFactory.createField(destAcroForm, (OMDictionary)cloner.cloneForNewDocument(srcField.getDictionary()));
                if (destAcroForm.getField(destField.getFullyQualifiedName()) != null) {
                    destField.setPartialName("dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(destField);
            }
        }
    }

    private void updatePageReferences(OMDictionary parentTreeEntry, HashMap<OMDictionary, OMDictionary> objMapping) {
        OMBase kSubEntry;
        OMBase obj;
        OMBase page = parentTreeEntry.getDictionaryObject(OMName.PG);
        if (page instanceof OMDictionary && objMapping.containsKey(page)) {
            parentTreeEntry.setItem(OMName.PG, (OMBase)objMapping.get(page));
        }
        if ((obj = parentTreeEntry.getDictionaryObject(OMName.OBJ)) instanceof OMDictionary && objMapping.containsKey(obj)) {
            parentTreeEntry.setItem(OMName.OBJ, (OMBase)objMapping.get(obj));
        }
        if ((kSubEntry = parentTreeEntry.getDictionaryObject(OMName.K)) instanceof OMArray) {
            this.updatePageReferences((OMArray)kSubEntry, objMapping);
        } else if (kSubEntry instanceof OMDictionary) {
            this.updatePageReferences((OMDictionary)kSubEntry, objMapping);
        }
    }

    private void updatePageReferences(OMArray parentTreeEntry, HashMap<OMDictionary, OMDictionary> objMapping) {
        int i = 0;
        while (i < parentTreeEntry.size()) {
            OMBase subEntry = parentTreeEntry.getObject(i);
            if (subEntry instanceof OMArray) {
                this.updatePageReferences((OMArray)subEntry, objMapping);
            } else if (subEntry instanceof OMDictionary) {
                this.updatePageReferences((OMDictionary)subEntry, objMapping);
            }
            ++i;
        }
    }

    private void updateParentEntry(OMArray kArray, OMDictionary newParent) {
        int i = 0;
        while (i < kArray.size()) {
            OMDictionary dictEntry;
            OMBase subEntry = kArray.getObject(i);
            if (subEntry instanceof OMDictionary && (dictEntry = (OMDictionary)subEntry).getDictionaryObject(OMName.P) != null) {
                dictEntry.setItem(OMName.P, (OMBase)newParent);
            }
            ++i;
        }
    }

    private void updateStructParentEntries(SMPage page, int structParentOffset) throws IOException {
        page.setStructParents(page.getStructParents() + structParentOffset);
        List<SMAnnotation> annots = page.getAnnotations();
        ArrayList<SMAnnotation> newannots = new ArrayList<SMAnnotation>();
        for (SMAnnotation annot : annots) {
            annot.setStructParent(annot.getStructParent() + structParentOffset);
            newannots.add(annot);
        }
        page.setAnnotations(newannots);
    }

    public static void PagesRotateIntoPage(SMDocument document) throws IOException, PlpdfException {
        SMDocumentCatalog smdc = document.getDocumentCatalog();
        try {
            int rotate = smdc.getPages().getRotation();
            smdc.getPages().setRotation(0);
            List pages = smdc.getAllPages();
            for (SMPage page : pages) {
                if (page.getRotation() != null) continue;
                page.setRotation(rotate);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void mergeDocuments(SMDocument document1, SMDocument document2, OutputStream outputfile) throws Exception {
        this.appendDocument(document1, document2);
        document1.save(outputfile);
        document1.close();
    }

    public static void MediaboxIntoPage(SMDocument document) throws IOException, PlpdfException {
        SMDocumentCatalog dc = document.getDocumentCatalog();
        try {
            List pages = dc.getAllPages();
            for (SMPage page : pages) {
                SMPageNode parent;
                SMRectangle mb = page.getMediaBox();
                if (mb != null || (parent = page.getParent()) == null) continue;
                mb = parent.findMediaBox();
                page.setMediaBox(mb);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

