/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.documentinterchange.markedcontent.SMMarkedContent;
import com.plpdf.smmodel.graphics.xobject.SMXObject;
import com.plpdf.util.PDFStreamEngine;
import com.plpdf.util.ResourceLoader;
import com.plpdf.util.TextNormalize;
import com.plpdf.util.TextPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMarkedContentExtractor
extends PDFStreamEngine {
    private boolean suppressDuplicateOverlappingText = true;
    private List<SMMarkedContent> markedContents = new ArrayList<SMMarkedContent>();
    private Stack<SMMarkedContent> currentMarkedContents = new Stack();
    private Map<String, List<TextPosition>> characterListMapping = new HashMap<String, List<TextPosition>>();
    protected String outputEncoding;
    private TextNormalize normalize = null;

    public PDFMarkedContentExtractor() throws IOException, PlpdfException {
        super(ResourceLoader.loadProperties("com/plpdf/res/PDFMarkedContentExtractor.properties", true));
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFMarkedContentExtractor(Properties props) throws IOException, PlpdfException {
        super(props);
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFMarkedContentExtractor(String encoding) throws IOException, PlpdfException {
        super(ResourceLoader.loadProperties("com/plpdf/res/PDFMarkedContentExtractor.properties", true));
        this.outputEncoding = encoding;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    private boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    public void beginMarkedContentSequence(OMName tag, OMDictionary properties) {
        SMMarkedContent markedContent = SMMarkedContent.create(tag, properties);
        if (this.currentMarkedContents.isEmpty()) {
            this.markedContents.add(markedContent);
        } else {
            SMMarkedContent currentMarkedContent = this.currentMarkedContents.peek();
            if (currentMarkedContent != null) {
                currentMarkedContent.addMarkedContent(markedContent);
            }
        }
        this.currentMarkedContents.push(markedContent);
    }

    public void endMarkedContentSequence() {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.pop();
        }
    }

    public void xobject(SMXObject xobject) {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.peek().addXObject(xobject);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            List<TextPosition> sameTextCharacters = this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            int i = 0;
            while (i < sameTextCharacters.size()) {
                TextPosition character = sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter != null && this.within(charX, textX, tolerance) && this.within(charY, textY, tolerance)) {
                    suppressCharacter = true;
                    break;
                }
                ++i;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            ArrayList<TextPosition> textList = new ArrayList<TextPosition>();
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = (TextPosition)textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains(text)) {
                    previousTextPosition.mergeDiacritic(text, this.normalize);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition, this.normalize);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
            if (!this.currentMarkedContents.isEmpty()) {
                this.currentMarkedContents.peek().addText(text);
            }
        }
    }

    public List<SMMarkedContent> getMarkedContents() {
        return this.markedContents;
    }
}

