/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.PlpdfException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PDFKey {
    private static final String CLASS_NAME = PDFKey.class.getName();

    public static void toVal(String pdfkey) throws PlpdfException {
        String h = pdfkey.substring(0, 32).toUpperCase();
        String s = pdfkey.substring(32);
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PlpdfException(nsae);
        }
        m.update(s.getBytes(), 0, s.length());
        byte[] messageDigest = m.digest();
        StringBuffer s16 = new StringBuffer();
        int i = 0;
        while (i < messageDigest.length) {
            s16.append(PDFKey.pad(Integer.toHexString(0xFF & messageDigest[i])));
            ++i;
        }
        if (!s16.toString().equalsIgnoreCase(h)) {
            throw new PlpdfException(CLASS_NAME, "InvalidKey");
        }
    }

    private static String pad(String str) {
        int len = str.length();
        if (len == 0) {
            return "00";
        }
        if (len == 1) {
            return "0" + str;
        }
        if (len == 2) {
            return str;
        }
        return "00";
    }
}

