/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.util.ImageIOUtil;
import com.plpdf.util.PDFStreamEngine;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;

public class PDFImageWriter
extends PDFStreamEngine {
    public PDFImageWriter() {
    }

    public PDFImageWriter(Properties props) throws IOException, PlpdfException {
        super(props);
    }

    public boolean writeImage(SMDocument document, String imageType, String password, int startPage, int endPage, String outputPrefix) throws Exception {
        int resolution;
        try {
            resolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            resolution = 96;
        }
        return this.writeImage(document, imageType, password, startPage, endPage, outputPrefix, 8, resolution);
    }

    public boolean writeImage(SMDocument document, String imageFormat, String password, int startPage, int endPage, String outputPrefix, int imageType, int resolution) throws Exception {
        boolean bSuccess = true;
        List pages = document.getDocumentCatalog().getAllPages();
        int pagesSize = pages.size();
        int i = startPage - 1;
        while (i < endPage && i < pagesSize) {
            SMPage page = (SMPage)pages.get(i);
            BufferedImage image = page.convertToImage(imageType, resolution);
            String fileName = String.valueOf(outputPrefix) + (i + 1);
            bSuccess &= ImageIOUtil.writeImage(image, imageFormat, fileName, imageType, resolution);
            ++i;
        }
        return bSuccess;
    }

    public boolean writeImage(SMDocument document, String imageType, String password, int startPage, int endPage, OutputStream outputfile) throws Exception {
        boolean bSuccess = true;
        if (document.isEncrypted()) {
            document.decrypt(password);
        }
        List pages = document.getDocumentCatalog().getAllPages();
        int i = startPage - 1;
        while (i < endPage && i < pages.size()) {
            ImageInputStream output = null;
            ImageWriter imageWriter = null;
            try {
                SMPage page = (SMPage)pages.get(i);
                BufferedImage image = page.convertToImage();
                output = ImageIO.createImageOutputStream(outputfile);
                boolean foundWriter = false;
                Iterator<ImageWriter> writerIter = ImageIO.getImageWritersByFormatName(imageType);
                while (writerIter.hasNext() && !foundWriter) {
                    try {
                        try {
                            imageWriter = writerIter.next();
                            ImageWriteParam writerParams = imageWriter.getDefaultWriteParam();
                            if (writerParams.canWriteCompressed()) {
                                writerParams.setCompressionMode(2);
                                writerParams.setCompressionQuality(1.0f);
                            }
                            imageWriter.setOutput(output);
                            imageWriter.write(null, new IIOImage(image, null, null), writerParams);
                            foundWriter = true;
                        }
                        catch (IIOException iIOException) {
                            if (imageWriter == null) continue;
                            imageWriter.dispose();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (imageWriter != null) {
                            imageWriter.dispose();
                        }
                        throw throwable;
                    }
                    if (imageWriter == null) continue;
                    imageWriter.dispose();
                }
                if (!foundWriter) {
                    bSuccess = false;
                    throw new PlpdfException(this.getClass().getName(), "NoWriter");
                }
            }
            finally {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
            ++i;
        }
        return bSuccess;
    }
}

